<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Print SP-MPT - <?php echo e($spSipt->nomor_surat); ?></title>
    <style>
        @page {
            size: A4;
            margin: 0;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Times New Roman', Times, serif;
            font-size: 10pt;
            line-height: 1.5;
            color: #000;
        }

        .page {
            width: 210mm;
            min-height: 297mm;
            padding: 15mm 20mm;
            margin: 0 auto;
            background: white;
            page-break-after: always;
        }

        .page:last-child {
            page-break-after: auto;
        }

        /* Page 1 - Cover */
        .cover-page {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            border: 3px double #000;
            padding: 30mm 20mm;
            position: relative;
        }

        .cover-content {
            text-align: center;
            width: 100%;
        }

        .logo-container {
            margin-bottom: 40px;
        }

        .logo-container img {
            width: 40%;
        }

        .cover-title {
            font-size: 20pt;
            font-weight: bold;
            text-align: center;
            margin-top: 60px;
            line-height: 1.8;
        }

        /* Page 2 & 3 - Surat Pernyataan */
        .header {
            text-align: center;
            margin-bottom: 30px;
        }

        .header-logo {
            width: 80px;
            height: 90px;
            margin: 0 auto 10px;
        }

        .document-title {
            text-align: center;
            font-size: 14pt;
            font-weight: bold;
            text-decoration: underline;
            margin-bottom: 5px;
        }

        .document-number {
            text-align: center;
            margin-bottom: 25px;
        }

        .content {
            text-align: justify;
            line-height: 1.4;
        }

        .content p {
            margin-bottom: 8px;
        }

        .content p strong {
            font-weight: bold;
        }

        .person-data {
            margin-left: 40px;
            margin-bottom: 10px;
        }

        .person-data table {
            width: 100%;
        }

        .person-data td {
            padding: 1px 0;
            vertical-align: top;
            line-height: 1.3;
        }

        .person-data td:first-child {
            width: 160px;
        }

        .person-data td:nth-child(2) {
            width: 15px;
            text-align: center;
        }

        .person-data td:nth-child(3) {
            word-wrap: break-word;
        }

        .land-data {
            margin-left: 60px;
            margin-bottom: 10px;
        }

        .land-data table {
            width: 100%;
        }

        .land-data td {
            padding: 1px 0;
            vertical-align: top;
            line-height: 1.3;
        }

        .land-data td:first-child {
            width: 140px;
        }

        .land-data td:nth-child(2) {
            width: 15px;
            text-align: center;
        }

        .land-data td:nth-child(3) {
            word-wrap: break-word;
        }

        .guarantee-list {
            margin-left: 60px;
            margin-bottom: 8px;
        }

        .guarantee-list ol {
            list-style-type: lower-alpha;
            padding-left: 20px;
            margin: 0;
        }

        .guarantee-list li {
            margin-bottom: 3px;
            text-align: justify;
            line-height: 1.3;
        }

        .signature-section {
            margin-top: 20px;
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
        }

        .signature-box {
            text-align: center;
            width: 200px;
        }

        .signature-title {
            margin-bottom: 50px;
            font-weight: bold;
            font-size: 10pt;
        }

        .signature-name {
            font-weight: bold;
            text-decoration: underline;
            margin-bottom: 5px;
        }

        .witness-section {
            margin-top: 15px;
        }

        .witness-box {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }

        .witness-item {
            text-align: center;
            width: 200px;
        }

        .witness-item p {
            margin-bottom: 3px;
            font-size: 9.5pt;
        }

        .camat-section {
            margin-top: 15px;
            text-align: justify;
            margin-bottom: 15px;
        }

        .camat-signature {
            text-align: right;
            width: 250px;
            float: right;
        }

        .camat-date {
            margin-bottom: 3px;
            font-size: 10pt;
        }

        .camat-title {
            margin-bottom: 50px;
            font-size: 10pt;
        }

        .camat-name {
            font-weight: bold;
            text-decoration: underline;
            margin-bottom: 3px;
            font-size: 10pt;
        }

        .camat-signature div {
            font-size: 10pt;
        }

        .materai {
            position: absolute;
            bottom: 20mm;
            left: 20mm;
            font-weight: bold;
        }

        /* Sket Gambar (di halaman 3) */
        .sket-header {
            text-align: center;
            font-size: 14pt;
            font-weight: bold;
            margin-bottom: 15px;
            margin-top: 0;
        }

        .map-container {
            border: 2px solid #000;
            height: 400px;
            position: relative;
            margin-bottom: 0;
        }

        .compass {
            position: absolute;
            top: 20px;
            right: 30px;
            width: 80px;
            height: 80px;
        }

        .compass img {
            width: 100%;
            height: 100%;
        }

        .map-area {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 60%;
            height: 50%;
            background: #f0f0f0;
        }

        .map-area img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }

        .boundary-info {
            border: 2px solid #000;
            border-top: none;
            display: flex;
        }

        .boundary-table {
            flex: 1;
            border-right: 2px solid #000;
        }

        .boundary-table table {
            width: 100%;
            border-collapse: collapse;
        }

        .boundary-table td {
            padding: 5px 10px;
            border-bottom: 1px solid #000;
            font-size: 9pt;
        }

        .boundary-table td:first-child {
            width: 70px;
            font-weight: bold;
        }

        .boundary-table td:nth-child(2) {
            width: 15px;
            text-align: center;
        }

        .boundary-table td:nth-child(3) {
            word-wrap: break-word;
        }

        .coordinate-section {
            margin-top: 10px;
            border-top: 1px solid #000;
            padding-top: 10px;
        }

        .coordinate-section h4 {
            font-weight: bold;
            margin-bottom: 10px;
            padding-left: 10px;
        }

        .coordinate-table td {
            padding: 2px 10px;
            font-size: 8pt;
        }

        .coordinate-table td:first-child {
            width: 55px;
            font-weight: bold;
        }

        .coordinate-table td:nth-child(2) {
            width: 10px;
            text-align: center;
        }

        .coordinate-table td:nth-child(3) {
            font-size: 8pt;
            word-wrap: break-word;
        }

        .boundary-signature {
            flex: 1;
            padding: 20px;
            text-align: center;
        }

        @media print {
            body {
                margin: 0;
            }
            .page {
                margin: 0;
                border: initial;
                page-break-after: always;
            }
        }
    </style>
</head>
<body>
    <!-- Page 1: Cover -->
    <div class="page">
        <div class="cover-page">
            <div class="cover-content">
                <div class="logo-container">
                    <img src="<?php echo e(asset('images/logo-berau.png')); ?>" alt="Logo Kabupaten Berau">
                </div>

                <div class="cover-title">
                    SURAT PERNYATAAN<br>
                    MELEPASKAN PENGUASAAN ATAS TANAH<br><br>
                    Nomor : <?php echo e($spSipt->nomor_surat ?? '................................'); ?><br>
                    Tahun : <?php echo e(date('Y')); ?>

                </div>
            </div>
        </div>
    </div>

    <!-- Page 2: Surat Pernyataan Part 1 -->
    <div class="page">
        <div class="document-title">SURAT PERNYATAAN MELEPASKAN PENGUASAAN ATAS TANAH</div>
        <div class="document-number">Nomor : <?php echo e($spSipt->nomor_surat ?? '........................................'); ?></div>

        <div class="content">
            <p style="margin-bottom: 8px;">Yang bertanda tangan dibawah ini :</p>

            <p style="margin-top: 8px; margin-bottom: 5px;"><strong>I.</strong></p>
            <div class="person-data">
                <table>
                    <tr>
                        <td>Nama</td>
                        <td>:</td>
                        <td><?php echo e($spSipt->pemohon_nama); ?></td>
                    </tr>
                    <tr>
                        <td>Tempat/Tanggal Lahir</td>
                        <td>:</td>
                        <td><?php echo e($spSipt->pemohon_tempat_lahir ?? '..........'); ?>, <?php echo e($spSipt->pemohon_tanggal_lahir ? \Carbon\Carbon::parse($spSipt->pemohon_tanggal_lahir)->format('d/m/Y') : '..........'); ?></td>
                    </tr>
                    <tr>
                        <td>Nomor KTP</td>
                        <td>:</td>
                        <td><?php echo e($spSipt->pemohon_nik); ?></td>
                    </tr>
                    <tr>
                        <td>Pekerjaan</td>
                        <td>:</td>
                        <td><?php echo e($spSipt->pemohon_pekerjaan ?? '..........'); ?></td>
                    </tr>
                    <tr>
                        <td>Alamat</td>
                        <td>:</td>
                        <td><?php echo e($spSipt->pemohon_alamat); ?></td>
                    </tr>
                </table>
            </div>

            <p style="margin-bottom: 8px;">Dalam hal ini bertindak untuk dan atas nama diri sendiri, selanjutnya disebut sebagai <strong>PIHAK PERTAMA</strong> yang melepaskan</p>

            <p style="margin-top: 8px; margin-bottom: 5px;"><strong>II.</strong></p>
            <div class="person-data">
                <table>
                    <tr>
                        <td>Nama</td>
                        <td>:</td>
                        <td><?php echo e($spSipt->terlapor_nama ?? '..........'); ?></td>
                    </tr>
                    <tr>
                        <td>Tempat/Tanggal Lahir</td>
                        <td>:</td>
                        <td><?php echo e($spSipt->terlapor_tempat_lahir ?? '..........'); ?>, <?php echo e($spSipt->terlapor_tanggal_lahir ? \Carbon\Carbon::parse($spSipt->terlapor_tanggal_lahir)->format('d/m/Y') : '..........'); ?></td>
                    </tr>
                    <tr>
                        <td>Nomor KTP</td>
                        <td>:</td>
                        <td><?php echo e($spSipt->terlapor_nik ?? '..........'); ?></td>
                    </tr>
                    <tr>
                        <td>Pekerjaan</td>
                        <td>:</td>
                        <td><?php echo e($spSipt->terlapor_pekerjaan ?? '..........'); ?></td>
                    </tr>
                    <tr>
                        <td>Alamat</td>
                        <td>:</td>
                        <td><?php echo e($spSipt->terlapor_alamat ?? '..........'); ?></td>
                    </tr>
                </table>
            </div>

            <p style="margin-bottom: 8px;">Dalam hal ini bertindak untuk meyatakan dan atas nama diri sendiri selanjutnya disebut sebagai <strong>PIHAK KEDUA</strong> yang menerima pelepasan.</p>

            <p style="margin-top: 8px; margin-bottom: 5px;"><strong>PIHAK PERTAMA</strong> dengan ini menyatakan dihadapan <?php echo e($spSipt->ketua_rt ?? '................................'); ?> dengan disaksikan oleh :</p>

            <div style="margin-left: 20px; margin-bottom: 10px;">
                <p style="margin-bottom: 2px;">a. Ketua RT. <?php echo e($spSipt->nama_rt ?? '........................................'); ?></p>
                <p style="margin-bottom: 2px;">b. Kepala Kampung : <?php echo e($spSipt->dataKampung->nama_kampung ?? '........................................'); ?></p>
            </div>

            <p style="margin-bottom: 5px;">Hal-hal sebagai berikut :</p>

            <p style="margin-top: 8px; margin-bottom: 5px;"><strong>1.</strong> <strong>PIHAK PERTAMA</strong> dengan ini melepaskan penguasaan atas tanah tersebut kepada <strong>PIHAK KEDUA</strong> yang terletak di :</p>

            <div class="land-data">
                <table>
                    <tr>
                        <td>a. Lokasi Tanah/RT</td>
                        <td>:</td>
                        <td><?php echo e($spSipt->lokasi_tanah_rt ?? '..........'); ?></td>
                    </tr>
                    <tr>
                        <td>b. Kampung</td>
                        <td>:</td>
                        <td><?php echo e($spSipt->dataKampung->nama_kampung ?? '..........'); ?></td>
                    </tr>
                    <tr>
                        <td>c. Kecamatan</td>
                        <td>:</td>
                        <td><?php echo e($spSipt->kecamatan->nama_kecamatan ?? '..........'); ?></td>
                    </tr>
                    <tr>
                        <td>d. Ukuran Tanah</td>
                        <td>:</td>
                        <td>± <?php echo e($spSipt->luas_terukur ?? '...........'); ?> m²</td>
                    </tr>
                    <tr>
                        <td>e. Batas-Batas Tanah</td>
                        <td>:</td>
                        <td></td>
                    </tr>
                    <tr>
                        <td style="padding-left: 20px;">- Utara</td>
                        <td>:</td>
                        <td><?php echo e($spSipt->batas_utara ?? '..........'); ?></td>
                    </tr>
                    <tr>
                        <td style="padding-left: 20px;">- Timur</td>
                        <td>:</td>
                        <td><?php echo e($spSipt->batas_timur ?? '..........'); ?></td>
                    </tr>
                    <tr>
                        <td style="padding-left: 20px;">- Selatan</td>
                        <td>:</td>
                        <td><?php echo e($spSipt->batas_selatan ?? '..........'); ?></td>
                    </tr>
                    <tr>
                        <td style="padding-left: 20px;">- Barat</td>
                        <td>:</td>
                        <td><?php echo e($spSipt->batas_barat ?? '..........'); ?></td>
                    </tr>
                </table>
            </div>

            <p style="text-align: justify; margin-top: 8px;">Sehingga dengan demikian tanah tersebut menjadi tanah yang langsung dikuasai oleh <strong>PIHAK PERTAMA</strong> dan dilepaskan penguasaan atas tanah ini dilakukan semata-mata untuk kepentingan <strong>PIHAK KEDUA</strong>, dengan demikian <strong>PIHAK KEDUA</strong> dapat mengajukan permohonan sesuatu hak atas tanah yang akan di daftarkan atas namanya.</p>
        </div>
    </div>

    <!-- Page 3: Surat Pernyataan Part 2 -->
    <div class="page">
        <div class="content" style="margin-top: 0;">
            <p style="margin-bottom: 5px;"><strong>2.</strong> Bidang Tanah diperoleh <strong>PIHAK PERTAMA</strong> berdasarkan :</p>

            <div style="margin-left: 40px; margin-bottom: 10px;">
                <p style="margin-bottom: 2px;">a. Bukti Kwitansi Pembelian, Tanggal <?php echo e($spSipt->tanggal_sertifikat ? \Carbon\Carbon::parse($spSipt->tanggal_sertifikat)->format('d/m/Y') : '…………………'); ?></p>
                <p style="margin-bottom: 2px;">b. Surat Keterangan Penguasaan dan Pemilikan Bangunan/Tanaman Diatas Tanah Negara Nomor : <?php echo e($spSipt->nomor_tanggal_surat_penguasaan_tanah ?? '…………………'); ?></p>
                <p style="margin-bottom: 2px;">c. Sket Tanah keseluruhan/global</p>
            </div>

            <p style="margin-bottom: 5px;"><strong>3.</strong> Bidang tanah dipergunakan <strong>PIHAK PERTAMA</strong> untuk <?php echo e($spSipt->peruntukan_bidang_tanah ?? 'Perkebunan'); ?></p>

            <p style="margin-bottom: 5px;"><strong>4.</strong> Uang ganti kerugian/santunan untuk melepaskan penguasaan atas tanah pada angka 1 (satu) tersebut diatas telah dilepaskan dan ditetapkan oleh kedua belah pihak, <strong>PIHAK PERTAMA</strong> dan <strong>PIHAK KEDUA</strong> sebesar <?php echo e(App\Http\Controllers\SpSiptController::formatRupiah($spSipt->uang_ganti_kerugian) ?: '………………'); ?> ( <?php echo e($spSipt->uang_ganti_kerugian ? ucfirst(App\Http\Controllers\SpSiptController::terbilang($spSipt->uang_ganti_kerugian)) . ' Rupiah' : '………………………………………'); ?> ), dan telah diterima oleh <strong>PIHAK PERTAMA</strong>. Surat Pernyataan ini berlaku pula sebagai "Kwitansi tanda terima pembayaran" termasuk juga penyerahan tanah tersebut dalam keadaan Kosong, dalam artian tidak dihuni atau digarap oleh siapapun.</p>
            <p style="margin-bottom: 5px;"><strong>5.</strong> <strong>PIHAK PERTAMA</strong> menjamin kepada <strong>PIHAK KEDUA</strong> bahwa :</p>

            <div class="guarantee-list">
                <ol>
                    <li>Tidak ada yang berhak dan berwenang untuk melakukan pelepasan penguasaan atas tanah tersebut kecuali <strong>PIHAK PERTAMA</strong> ;</li>
                    <li>Tanah tersebut tidak dalam keadaan sitaan dan tidak juga tersangkut dalam suatu sengketa atau perkara di Pengadilan ;</li>
                    <li>Tanah tersebut tidak dijaminkan atau di bebankan dengan hak dan tanggung dengan cara apapun juga kepada pihak lain ;</li>
                    <li>Tanah tersebut belum pernah diserahkan dengan cara apapun juga kepada pihak lain ;</li>
                    <li>Tanah tersebut tidak ada masalah dengan Batas ;</li>
                    <li>Tidak ada pihak lain yang turut mempunyai atas tanah tersebut ;</li>
                </ol>
            </div>

            <p style="margin-bottom: 5px;"><strong>6.</strong> <strong>PIHAK PERTAMA</strong> menjamin kepada <strong>PIHAK KEDUA</strong> baik sekarang maupun dikemudian hari bahwa <strong>PIHAK KEDUA</strong> tidak akan mendapatkan tuntutan atau gugatan dari siapapun juga mengenai Tanah tersebut dari segala tuntutan maupun gugatan adalah sepenuhnya menjadi tanggung jawab <strong>PIHAK PERTAMA</strong>, dan Pemerintah bebas dari segala tuntutan yang diajukan pihak siapapun juga.</p>

            <p style="margin-bottom: 5px;"><strong>7.</strong> Semua pajak termasuk PBB dan lain-lain kewajiban yang berkenaan dengan tanah tersebut, sepenuhnya menjadi tanggung jawab <strong>PIHAK PERTAMA</strong>, sampai dengan hari ini dan tanggal dibuatnya Surat Pernyataan ini.</p>

            <p style="margin-bottom: 10px;"><strong>8.</strong> <strong>PIHAK PERTAMA</strong> meyerahkan semua surat-surat yang berhubungan dengan pemilikan tanah tersebut kepada <strong>PIHAK KEDUA</strong> dan dengan demikian surat-surat tersebut tidak berlaku lagi bagi kepentingan <strong>PIHAK PERTAMA</strong>.</p>

            <div class="signature-section">
                <div class="signature-box">
                    <div class="signature-title">PIHAK KEDUA<br>Yang Menerima Pelepasan</div>
                    <div class="signature-name"><?php echo e($spSipt->terlapor_nama ?? '________________________________________'); ?></div>
                </div>

                <div class="signature-box">
                    <div class="signature-title">PIHAK PERTAMA<br>Yang Melepaskan</div>
                    <div class="signature-name"><?php echo e($spSipt->pemohon_nama ?? '_________________________________________'); ?></div>
                </div>
            </div>

            <div style="clear: both;"></div>

            <div class="witness-section">
                <p style="margin-bottom: 5px;"><strong>Para Saksi :</strong></p>
                <div class="witness-box">
                    <div class="witness-item">
                        <p>1. Ketua RT. <?php echo e($spSipt->nama_rt ?? '................................'); ?></p>
                        <br><br>

                    </div>

                    <div class="witness-item">
                        <p>2. Kepala Kampung <?php echo e($spSipt->dataKampung->nama_kepala_kampung ?? ''); ?></p>
                        <br><br>

                    </div>
                </div>
            </div>

            <div class="camat-section">
                <p style="margin-bottom: 5px;">Saya Camat <?php echo e($spSipt->kecamatan->nama_kecamatan ?? 'Biduk-Biduk'); ?> mengetahui dan telah menjelaskan isi surat pernyataan ini kepada <strong>PIHAK PERTAMA</strong> dan <strong>PIHAK KEDUA</strong> yang saya kenal, setelah nama kedua belah pihak menandatangani/membubuhkan Cap jempol diatas surat pernyataan ini dihadapan saya Camat <?php echo e($spSipt->kecamatan->nama_kecamatan ?? 'Biduk-Biduk'); ?> dan didaftarkan dalam daftar Nomor : <?php echo e($spSipt->nomor_surat ?? '................................'); ?></p>

                <div class="camat-signature">
                    <div class="camat-date"><?php echo e($spSipt->lokasi_kota ?? 'Berau'); ?>, <?php echo e(\Carbon\Carbon::now()->format('d F Y')); ?></div>
                    <div class="camat-title">Camat,</div>
                    <div class="camat-name"><?php echo e($spSipt->kecamatan->nama_camat ?? '........................................'); ?></div>
                    <div>NIP. <?php echo e($spSipt->kecamatan->nip ?? '........................................'); ?></div>
                </div>
            </div>

            <div style="clear: both;"></div>

            

            <!-- Sket Gambar di halaman 3 -->
            <div class="sket-header" style="margin-top: 80px;">SKET/GAMBAR KASAR TANAH</div>

        <div class="map-container">
            <div class="compass">
                <img src="<?php echo e(asset('images/mata angin.png')); ?>" alt="Kompas">
            </div>

            <div class="map-area">
                <?php if($spSipt->map_image_data || $spSipt->map_image): ?>
                    <?php if(strpos($spSipt->map_image_data ?? '', 'data:image') === 0): ?>
                        <img src="<?php echo e($spSipt->map_image_data); ?>" alt="Peta Tanah">
                    <?php elseif($spSipt->map_image): ?>
                        <img src="<?php echo e(Storage::url($spSipt->map_image)); ?>" alt="Peta Tanah">
                    <?php endif; ?>
                <?php else: ?>
                    <!-- Area kosong untuk peta -->
                <?php endif; ?>
            </div>
        </div>

        <div class="boundary-info">
            <div class="boundary-table">
                <table>
                    <tr>
                        <td>UTARA</td>
                        <td>:</td>
                        <td><?php echo e($spSipt->batas_utara ?? '.....................'); ?></td>
                    </tr>
                    <tr>
                        <td>TIMUR</td>
                        <td>:</td>
                        <td><?php echo e($spSipt->batas_timur ?? '.....................'); ?></td>
                    </tr>
                    <tr>
                        <td>SELATAN</td>
                        <td>:</td>
                        <td><?php echo e($spSipt->batas_selatan ?? '.....................'); ?></td>
                    </tr>
                    <tr>
                        <td>BARAT</td>
                        <td>:</td>
                        <td><?php echo e($spSipt->batas_barat ?? '.....................'); ?></td>
                    </tr>
                </table>

                <div class="coordinate-section">
                    <h4>Titik Koordinat UTM (Zone <?php echo e($spSipt->coordinates->first()->utm_zone ?? '50S'); ?>):</h4>
                    <table class="coordinate-table">
                        <?php if($spSipt->coordinates && count($spSipt->coordinates) > 0): ?>
                            <?php $__currentLoopData = $spSipt->coordinates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $coord): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>Titik - <?php echo e($index + 1); ?></td>
                                <td>:</td>
                                <td>Easting = <?php echo e(number_format($coord->easting, 2, ',', '.')); ?> m - Northing = <?php echo e(number_format($coord->northing, 2, ',', '.')); ?> m</td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="3" style="text-align: center; padding: 10px;">Tidak ada data koordinat</td>
                            </tr>
                        <?php endif; ?>
                    </table>
                </div>
            </div>

            <div class="boundary-signature">
                <p>Yang membuat Sket/Gambar Tanah</p>
                <br><br><br><br>
                <p style="font-weight: bold; text-decoration: underline;">
                    _______________________________
                </p>
                <p>NIP. ......................................</p>
            </div>
        </div>
    </div>

    <script>
        // Auto print when page loads
        window.onload = function() {
            window.print();
        }
    </script>
</body>
</html>
<?php /**PATH C:\laragon\www\webgis-biduk\resources\views/admin/sp-sipt/print.blade.php ENDPATH**/ ?>