<?php $__env->startSection('title', 'Daftar Surat Pernyataan Melepaskan Penguasaan Tanah (SP-MPT)'); ?>

<?php $__env->startSection('content'); ?>
<style>
.nav-tabs .nav-link {
    color: #495057 !important;
}

.nav-tabs .nav-link.active {
    color: #000 !important;
    background-color: #fff !important;
    border: 1px solid #dee2e6;
    border-bottom-color: transparent;
    font-weight: 600;
}
</style>
<div class="row">
    <div class="col-12">
        <!-- Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h2 class="h4 mb-1">Daftar Surat Pernyataan Melepaskan Penguasaan Tanah (SP-MPT)</h2>
                <p class="text-muted mb-0">
                    Kelola semua permohonan Surat Pernyataan Melepaskan Penguasaan Tanah
                </p>
            </div>
            <div class="d-flex align-items-center gap-3">
                <a href="<?php echo e(route('sp-sipt.create')); ?>" class="btn btn-primary px-4 py-2 shadow-sm">
                    <i class="fas fa-plus me-2"></i> Tambah Permohonan
                </a>
                <a href="<?php echo e(route('penerbitan-spmpt.index')); ?>" class="btn btn-outline-primary px-4 py-2 shadow-sm">
                    <i class="fas fa-file-alt me-2"></i> Penerbitan SP-MPT
                </a>
            </div>
        </div>



        <!-- Stats Cards -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card border-left-primary shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                    Total Pengajuan</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($statistics['total'] ?? 0); ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-file-alt fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-left-secondary shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-secondary text-uppercase mb-1">
                                    Draft</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($statistics['draft'] ?? 0); ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-edit fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-left-warning shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                    Belum Selesai</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($statistics['submitted'] ?? 0); ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-clock fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card border-left-success shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                    Selesai</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($statistics['approved'] ?? 0); ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

        <!-- Filter & Search -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Filter & Pencarian</h6>
            </div>
            <div class="card-body">
                <form method="GET" action="<?php echo e(route('sp-sipt.index')); ?>" class="row" id="filterForm">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="search">Pencarian</label>
                            <input type="text" class="form-control form-control-sm"
                                   id="search" name="search"
                                   placeholder="NIK, Nama, atau No. Registrasi"
                                   value="<?php echo e(request('search')); ?>">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="year">Tahun</label>
                            <select class="form-control form-control-sm" id="year" name="year">
                                <option value="<?php echo e(date('Y')); ?>" <?php echo e(request('year', date('Y')) == date('Y') ? 'selected' : ''); ?>>
                                    <?php echo e(date('Y')); ?>

                                </option>
                                <?php for($i = date('Y') - 1; $i >= date('Y') - 5; $i--): ?>
                                    <option value="<?php echo e($i); ?>" <?php echo e(request('year') == $i ? 'selected' : ''); ?>>
                                        <?php echo e($i); ?>

                                    </option>
                                <?php endfor; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select class="form-control form-control-sm" id="status" name="status">
                                <option value="">Semua Status</option>
                                <option value="draft" <?php echo e(request('status') == 'draft' ? 'selected' : ''); ?>>Draft</option>
                                <option value="submitted" <?php echo e(request('status') == 'submitted' ? 'selected' : ''); ?>>Belum Selesai</option>
                                <option value="in_review" <?php echo e(request('status') == 'in_review' ? 'selected' : ''); ?>>Sedang Ditinjau</option>
                                <option value="approved" <?php echo e(request('status') == 'approved' ? 'selected' : ''); ?>>Selesai</option>
                                <option value="rejected" <?php echo e(request('status') == 'rejected' ? 'selected' : ''); ?>>Ditolak</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="kelurahan">Kelurahan</label>
                            <input type="text" class="form-control form-control-sm"
                                   id="kelurahan" name="kelurahan"
                                   placeholder="Nama Kelurahan"
                                   value="<?php echo e(request('kelurahan')); ?>">
                        </div>
                    </div>
                    <div class="col-md-1">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div>
                                <button type="submit" class="btn btn-primary btn-sm">
                                    <i class="fas fa-search"></i>
                                </button>
                                <a href="<?php echo e(route('sp-sipt.index')); ?>" class="btn btn-secondary btn-sm ml-1">
                                    <i class="fas fa-times"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Data Table -->
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex justify-content-between align-items-center">
                <h6 class="m-0 font-weight-bold text-primary">Data Surat Pernyataan Melepaskan Penguasaan Tanah</h6>
                
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th width="15%">NIK/No. Registrasi</th>
                                <th width="20%">Pemohon</th>
                                <th width="15%">Tanggal Masuk</th>
                                <th width="15%">Status</th>
                                <th width="20%">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $spSipts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $spSipt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <div class="font-weight-bold text-primary"><?php echo e($spSipt->pemohon_nik); ?></div>
                                    <small class="text-muted"><?php echo e($spSipt->nomor_surat ?? 'XXX-XXX-XXX'); ?></small>
                                </td>
                                <td>
                                    <div class="font-weight-bold"><?php echo e($spSipt->pemohon_nama); ?></div>
                                    <small class="text-muted"><?php echo e($spSipt->created_at->format('d/m/Y')); ?></small>
                                </td>
                                <td>
                                    <small><?php echo e($spSipt->created_at->format('d/m/Y')); ?></small>
                                </td>
                                <td>
                                    <?php switch($spSipt->status):
                                        case ('draft'): ?>
                                            <span class="badge badge-secondary">
                                                <i class="fas fa-edit"></i> Draft
                                            </span>
                                            <?php break; ?>
                                        <?php case ('belum selesai'): ?>
                                            <span class="badge badge-warning">
                                                <i class="fas fa-clock"></i> Belum Selesai
                                            </span>
                                            <?php break; ?>

                                        <?php case ('selesai'): ?>
                                            <span class="badge badge-success">
                                                <i class="fas fa-check-circle"></i> Selesai
                                            </span>
                                            <?php break; ?>
                                        <?php default: ?>
                                            <span class="badge badge-secondary">
                                                <?php echo e(strtoupper($spSipt->status)); ?>

                                            </span>
                                    <?php endswitch; ?>
                                </td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="#"
                                        class="btn btn-sm btn-outline-primary view-detail"
                                        data-toggle="tooltip" title="Lihat Detail"
                                        data-id="<?php echo e($spSipt->id); ?>"
                                        data-name="<?php echo e($spSipt->pemohon_nama); ?>"
                                        data-nik="<?php echo e($spSipt->pemohon_nik); ?>"
                                        data-nomor-ba="<?php echo e($spSipt->nomor_surat); ?>"
                                        data-status="<?php echo e($spSipt->status); ?>">
                                            <i class="fas fa-eye"></i>
                                        </a>

                                        
                                        
                                        <?php if($spSipt->status !== 'selesai'): ?>
                                        <button type="button"
                                                class="btn btn-sm btn-outline-success update-status"
                                                data-toggle="tooltip" title="Tandai Selesai"
                                                data-id="<?php echo e($spSipt->id); ?>"
                                                data-status="selesai">
                                            <i class="fas fa-check"></i>
                                        </button>
                                        <a href="<?php echo e(route('sp-sipt.edit', $spSipt)); ?>"
                                           class="btn btn-sm btn-outline-warning"
                                           data-toggle="tooltip" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                         <button type="button"
                                                class="btn btn-sm btn-outline-danger"
                                                data-toggle="tooltip" title="Hapus"
                                                onclick="confirmDelete('<?php echo e($spSipt->pemohon_nama); ?>', '<?php echo e(route('sp-sipt.destroy', $spSipt)); ?>')">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                        <?php endif; ?>
                                        <?php if($spSipt->status === 'belum selesai'): ?>
                                        <button type="button"
                                                class="btn btn-sm btn-outline-warning update-status"
                                                data-toggle="tooltip" title="Tandai Belum Selesai"
                                                data-id="<?php echo e($spSipt->id); ?>"
                                                data-status="belum selesai">
                                            <i class="fas fa-times"></i>
                                        </button>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-inbox fa-3x mb-3"></i>
                                        <h5>Tidak ada data</h5>
                                        <p>Belum ada permohonan SP-MPT yang tersedia</p>
                                        <a href="<?php echo e(route('sp-sipt.create')); ?>" class="btn btn-primary">
                                            <i class="fas fa-plus"></i> Tambah Permohonan Pertama
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <?php if($spSipts->hasPages()): ?>
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="showing-info">
                        <small class="text-muted">
                            Menampilkan <?php echo e($spSipts->firstItem()); ?> - <?php echo e($spSipts->lastItem()); ?>

                            dari <?php echo e($spSipts->total()); ?> data
                        </small>
                    </div>
                    <?php echo e($spSipts->withQueryString()->links('pagination::bootstrap-4')); ?>

                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Konfirmasi Hapus</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Apakah Anda yakin ingin menghapus permohonan SP-MPT <strong id="deleteItemName"></strong>?</p>
                <p class="text-danger"><small>Tindakan ini tidak dapat dibatalkan dan akan menghapus semua dokumen terkait.</small></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                <form id="deleteForm" method="POST" style="display: inline;">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger">
                        <i class="fas fa-trash"></i> Hapus
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- Detail Modal dengan Tabs -->
<div class="modal fade" id="detailModal" tabindex="-1" role="dialog" aria-labelledby="detailModalTitle">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header" style="background: linear-gradient(135deg, #28a745 0%, #20c997 100%); color: white;">
                <div class="w-100">
                    <div class="text-center">
                        <div style="background: #28a745; color: white; padding: 4px 12px; border-radius: 15px; font-size: 11px; font-weight: bold; display: inline-block; margin-bottom: 10px;">
                            DOKUMEN RESMI
                        </div>
                    </div>
                    <h5 class="modal-title text-center mb-0" id="detailModalTitle"></h5>
                    <p class="text-center mb-0 mt-1" style="font-size: 13px; opacity: 0.9;" id="detailModalSubtitle"></p>
                </div>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Tutup detail">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body p-0" style="max-height: 80vh; overflow: hidden;">
                <!-- Content akan dimuat via JavaScript -->
            </div>

            <div class="modal-footer justify-content-center">
                <button type="button" class="btn btn-info btn-sm" style="border-radius: 15px; padding: 6px 15px;" onclick="printDocument()">
                    <i class="fas fa-print"></i> Cetak
                </button>

                <button type="button" class="btn btn-secondary btn-sm" style="border-radius: 15px; padding: 6px 15px;" data-dismiss="modal">
                    <i class="fas fa-times"></i> Tutup
                </button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>

function confirmDelete(itemName, deleteUrl) {
    $('#deleteItemName').text(itemName);
    $('#deleteForm').attr('action', deleteUrl);
    $('#deleteModal').modal('show');
}

// Initialize tooltips
$(function () {
    $('[data-toggle="tooltip"]').tooltip();
});
// Auto submit form on filter change
document.querySelectorAll('select[name="year"], select[name="status"]').forEach(function(element) {
    element.addEventListener('change', function() {
        document.getElementById('filterForm').submit();
    });
});

// Update status permohonan
$('.update-status').on('click', function() {
    const id = $(this).data('id');
    const status = $(this).data('status');
    const currentRow = $(this).closest('tr');
    const currentStatusBadge = currentRow.find('td:nth-child(4) .badge').text().trim();

    const statusText = status === 'approved' ? 'Selesai' : 'Belum Selesai';

    if ((status === 'approved' && currentStatusBadge.includes('Selesai')) ||
        (status === 'submitted' && currentStatusBadge.includes('Belum Selesai'))) {
        Swal.fire({
            icon: 'info',
            title: 'Informasi',
            text: 'Status sudah ' + statusText.toLowerCase() + '!',
            confirmButtonText: 'OK',
            confirmButtonColor: '#1cc88a',
        });
        return;
    }

    Swal.fire({
        title: 'Konfirmasi',
        text: 'Apakah Anda yakin ingin mengubah status permohonan menjadi ' + statusText + '?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#1cc88a',
        cancelButtonColor: '#e74a3b',
        confirmButtonText: 'Ya',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: '<?php echo e(route("sp-sipt.updateStatus", ":id")); ?>'.replace(':id', id),
                method: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    status: status
                },
                success: function(response) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Sukses!',
                        text: 'Status permohonan berhasil diperbarui.',
                        confirmButtonText: 'OK',
                        confirmButtonColor: '#1cc88a',
                    }).then(() => {
                        location.reload();
                    });
                },
                error: function(xhr) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: 'Gagal memperbarui status permohonan.',
                        confirmButtonText: 'OK',
                        confirmButtonColor: '#e74a3b',
                    });
                }
            });
        }
    });
});
// Search on enter key
document.querySelector('input[name="search"]').addEventListener('keypress', function(e) {
    if (e.key === 'Enter') {
        e.preventDefault();
        document.getElementById('filterForm').submit();
    }
});

// Success/Error Messages
<?php if(session('success')): ?>
    $(document).ready(function() {
        Swal.fire({
            icon: 'success',
            title: 'Sukses!',
            text: '<?php echo e(session('success')); ?>',
            confirmButtonText: 'OK',
            confirmButtonColor: '#1cc88a',
        });
    });
<?php endif; ?>

<?php if(session('error')): ?>
    $(document).ready(function() {
        Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: '<?php echo e(session('error')); ?>',
            confirmButtonText: 'OK',
            confirmButtonColor: '#e74a3b',
        });
    });
<?php endif; ?>

// View detail modal dengan proper loading management
$('.view-detail').on('click', function(e) {
    e.preventDefault();

    const id = $(this).data('id');
    const button = $(this);

    console.log('Loading detail for ID:', id);

    // Disable button dan show loading
    button.prop('disabled', true);

    // Show modal dengan loading
    $('#detailModal').modal('show');
    $('#detailModal').removeAttr('aria-hidden');

    // Set loading content
    const loadingHtml = `
        <div class="text-center p-5">
            <div class="spinner-border text-primary" role="status" style="width: 3rem; height: 3rem;">
                <span class="sr-only">Loading...</span>
            </div>
            <div class="mt-3">
                <h6 class="text-muted">Memuat data...</h6>
                <small class="text-muted">Mohon tunggu sebentar</small>
            </div>
        </div>
    `;
    $('#detailModal .modal-body').html(loadingHtml);

    // Set timeout untuk menghindari loading stuck
    const loadingTimeout = setTimeout(() => {
        showError('Timeout loading data. Silakan coba lagi.');
        button.prop('disabled', false);
    }, 15000);

    // Fetch data via AJAX
    $.ajax({
        url: `/sp-sipt/${id}/detail`,
        method: 'GET',
        timeout: 10000,
        success: function(response) {
            console.log('AJAX Success:', response);
            clearTimeout(loadingTimeout);

            if (response && response.success && response.data) {
                console.log('Populating modal with data');
                populateDetailModal(response.data);
            } else {
                console.log('Invalid response format:', response);
                showError('Format data tidak valid: ' + (response?.message || 'Data kosong'));
            }
        },
        error: function(xhr, status, error) {
            console.log('AJAX Error:', status, error, xhr);
            clearTimeout(loadingTimeout);

            let message = 'Terjadi kesalahan saat memuat data.';

            if (status === 'timeout') {
                message = 'Koneksi timeout. Silakan coba lagi.';
            } else if (xhr.status === 404) {
                message = 'Data tidak ditemukan.';
            } else if (xhr.status === 500) {
                message = 'Terjadi kesalahan server.';
            } else if (xhr.responseJSON && xhr.responseJSON.message) {
                message = xhr.responseJSON.message;
            } else if (error) {
                message = 'Error: ' + error;
            }

            showError(message);
        },
        complete: function() {
            console.log('AJAX Complete');
            button.prop('disabled', false);
        }
    });
});

// Populate detail modal dengan tabs untuk detail dan preview
function populateDetailModal(data) {
    try {
        console.log('Starting to populate modal with:', data);

        // Clear loading state terlebih dahulu
        $('#detailModal .modal-body').empty();

        // Validasi data
        if (!data || !data.pemohon) {
            throw new Error('Data pemohon tidak tersedia');
        }

        // Set modal title
        const titleText = `Surat Pernyataan Melepaskan Penguasaan Tanah - ${data.pemohon.nama} (${data.pemohon.nik})`;
        $('#detailModalTitle').text(titleText);
        $('#detailModalSubtitle').text(`No. BA: ${data.nomor_ba || 'Belum digenerate'}`);

        // Create tabbed content with detail and preview
        const modalContent = `
            <!-- Nav tabs -->
            <ul class="nav nav-tabs" id="detailTabs" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active" id="detail-tab" data-toggle="tab" href="#detail" role="tab">
                        <i class="fas fa-info-circle"></i> Detail Dokumen
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="preview-tab" data-toggle="tab" href="#preview" role="tab">
                        <i class="fas fa-eye"></i> Print Preview
                    </a>
                </li>
            </ul>

            <!-- Tab panes -->
            <div class="tab-content" id="detailTabContent">
                <!-- Detail Tab -->
                <div class="tab-pane fade show active" id="detail" role="tabpanel">
                    <div class="p-3">
                        <div style="background: #e8f5e8; border-left: 4px solid #28a745; padding: 12px; margin-bottom: 20px; font-size: 14px; border-radius: 0 4px 4px 0;">
                            <i class="fas fa-info-circle text-success"></i>
                            Dokumen Surat Pernyataan Melepaskan Penguasaan Tanah - ${data.pemohon.nama} (${data.pemohon.nik}) untuk keperluan administrasi pertanahan.
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="card border-0 shadow-sm mb-3">
                                    <div class="card-header bg-primary text-white py-2">
                                        <h6 class="mb-0"><i class="fas fa-info-circle"></i> Informasi Dokumen</h6>
                                    </div>
                                    <div class="card-body" id="documentInfo">
                                        <!-- Will be populated -->
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="card border-0 shadow-sm mb-3">
                                    <div class="card-header bg-success text-white py-2">
                                        <h6 class="mb-0"><i class="fas fa-user"></i> Data Pemohon</h6>
                                    </div>
                                    <div class="card-body" id="pemohonInfo">
                                        <!-- Will be populated -->
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="text-center py-4">
                            <div class="mb-3">
                                <i class="fas fa-file-contract text-success" style="font-size: 48px;"></i>
                            </div>
                            <h5 class="text-dark mb-2">Konten Dokumen SP-MPT</h5>
                            <p class="text-muted mb-3">Preview dokumen resmi - Siap untuk diunduh</p>
                            <div class="badge badge-success p-2">
                                <i class="fas fa-check-circle"></i> Dokumen Valid & Terverifikasi
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Preview Tab -->
                <div class="tab-pane fade" id="preview" role="tabpanel">
                    <div class="p-2">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h6 class="mb-0">Print Preview - SP-MPT</h6>
                            <div class="btn-group btn-group-sm">
                                <button type="button" class="btn btn-outline-secondary" onclick="zoomOut()">
                                    <i class="fas fa-search-minus"></i>
                                </button>
                                <button type="button" class="btn btn-outline-secondary" onclick="resetZoom()">
                                    <span id="zoomLevel">100%</span>
                                </button>
                                <button type="button" class="btn btn-outline-secondary" onclick="zoomIn()">
                                    <i class="fas fa-search-plus"></i>
                                </button>
                            </div>
                        </div>
                        <div id="printPreviewContainer" style="max-height: 500px; overflow-y: auto; border: 1px solid #ddd; background: #f8f9fa;">
                            <div id="printPreviewContent" style="transform-origin: top left; transition: transform 0.3s;">
                                <!-- Print preview akan dimuat di sini -->
                                <div class="text-center p-4">
                                    <div class="spinner-border text-primary" role="status">
                                        <span class="sr-only">Loading preview...</span>
                                    </div>
                                    <p class="mt-2 text-muted">Memuat preview...</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        `;

        // Set content ke modal
        $('#detailModal .modal-body').html(modalContent);

        // Populate document info
        populateDocumentInfo(data);
        populatePemohonInfo(data);

        // Store current data for actions
        window.currentSpSiptData = data;

        console.log('Modal populated successfully');

    } catch (error) {
        console.error('Error populating modal:', error);
        showError('Gagal menampilkan data: ' + error.message);
    }
}

// Function untuk populate document info
function populateDocumentInfo(data) {
    const documentInfoHtml = `
        <div class="row mb-2">
            <div class="col-5 text-muted small">Nama Dokumen:</div>
            <div class="col-7 font-weight-bold small">SP-MPT ${data.pemohon.nama}</div>
        </div>
        <div class="row mb-2">
            <div class="col-5 text-muted small">Nomor BA:</div>
            <div class="col-7 font-weight-bold small">${data.nomor_ba || 'Belum digenerate'}</div>
        </div>
        <div class="row mb-2">
            <div class="col-5 text-muted small">Tanggal:</div>
            <div class="col-7 font-weight-bold small">${data.created_at || 'Tidak tersedia'}</div>
        </div>
        <div class="row mb-2">
            <div class="col-5 text-muted small">Status:</div>
            <div class="col-7">
                <span class="badge badge-sm ${getBadgeClass(data.status_class)}">${data.status_label || 'Unknown'}</span>
            </div>
        </div>
        <div class="row mb-2">
            <div class="col-5 text-muted small">Koordinat:</div>
            <div class="col-7 font-weight-bold small">${data.coordinates_count || 0} titik</div>
        </div>
        <div class="row mb-2">
            <div class="col-5 text-muted small">Luas Terukur:</div>
            <div class="col-7 font-weight-bold small">${data.luas_terukur ? data.luas_terukur + ' m²' : 'Belum dihitung'}</div>
        </div>
    `;
    $('#documentInfo').html(documentInfoHtml);
}

// Function untuk populate pemohon info
function populatePemohonInfo(data) {
    const pemohonInfoHtml = `
        <div class="row mb-2">
            <div class="col-4 text-muted small">Pemohon:</div>
            <div class="col-8 font-weight-bold small">${data.pemohon.nama || 'Tidak tersedia'}</div>
        </div>
        <div class="row mb-2">
            <div class="col-4 text-muted small">NIK:</div>
            <div class="col-8 font-weight-bold small">${data.pemohon.nik || 'Tidak tersedia'}</div>
        </div>
        <div class="row mb-2">
            <div class="col-4 text-muted small">Alamat:</div>
            <div class="col-8 font-weight-bold small">${(data.pemohon.alamat || '').substring(0, 50)}${(data.pemohon.alamat || '').length > 50 ? '...' : ''}</div>
        </div>
        <div class="row mb-2">
            <div class="col-4 text-muted small">Lokasi:</div>
            <div class="col-8 font-weight-bold small">${(data.lokasi?.kampung || 'N/A')}, ${(data.lokasi?.kecamatan || 'N/A')}</div>
        </div>
        <div class="row mb-2">
            <div class="col-4 text-muted small">Terlapor:</div>
            <div class="col-8 font-weight-bold small">${data.terlapor?.nama || 'Tidak tersedia'}</div>
        </div>
        <div class="row mb-2">
            <div class="col-4 text-muted small">Dibuat oleh:</div>
            <div class="col-8 font-weight-bold small">${data.created_by || 'Unknown'}</div>
        </div>
        <div class="row mb-2">
            <div class="col-4 text-muted small">Dokumen:</div>
            <div class="col-8 font-weight-bold small">${(data.dokumen || []).length} file</div>
        </div>
    `;
    $('#pemohonInfo').html(pemohonInfoHtml);
}

// Load print preview when preview tab is clicked
$(document).on('shown.bs.tab', '#preview-tab', function () {
    if (!window.currentSpSiptData) return;

    console.log('Loading print preview...');

    // Show loading in preview
    $('#printPreviewContent').html(`
        <div class="text-center p-4">
            <div class="spinner-border text-primary" role="status">
                <span class="sr-only">Loading preview...</span>
            </div>
            <p class="mt-2 text-muted">Memuat preview...</p>
        </div>
    `);

    // Load preview via AJAX
    $.ajax({
        url: `/sp-sipt/${window.currentSpSiptData.id}/preview`,
        method: 'GET',
        success: function(response) {
            // Load the print template content
            $('#printPreviewContent').html(`
                <iframe
                    src="${window.currentSpSiptData.urls.print}?preview=1"
                    style="width: 100%; height: 600px; border: none; background: white;"
                    onload="this.style.height = this.contentWindow.document.body.scrollHeight + 'px'">
                </iframe>
            `);
        },
        error: function() {
            // Fallback: show simplified preview
            loadSimplifiedPreview();
        }
    });
});

// Function untuk load simplified preview
function loadSimplifiedPreview() {
    const data = window.currentSpSiptData;
    const previewHtml = `
        <div style="background: white; padding: 20px; font-family: 'Times New Roman', serif; font-size: 12px; max-width: 800px; margin: 0 auto;">
            <!-- Cover Page Preview -->
            <div style="text-align: center; border: 3px double #000; padding: 40px; margin-bottom: 20px;">
                <div style="margin-bottom: 30px;">
                    <img src="/images/logo-berau.png" alt="Logo" style="width: 120px; height: auto;">
                </div>
                <h2 style="font-size: 18pt; font-weight: bold; line-height: 1.5;">
                    SURAT PERNYATAAN<br>
                    MELEPASKAN PENGUASAAN ATAS TANAH
                </h2>
                <p style="margin-top: 30px;">
                    <strong>Nomor : ${data.nomor_ba || '.....................................................'}</strong><br>
                    <strong>Tahun : ${new Date().getFullYear()}</strong>
                </p>
            </div>

            <!-- Document Info Preview -->
            <div style="border: 1px solid #ddd; padding: 15px; margin-bottom: 20px;">
                <h4 style="text-align: center; text-decoration: underline; margin-bottom: 15px;">
                    SURAT PERNYATAAN MELEPASKAN PENGUASAAN ATAS TANAH
                </h4>
                <p style="text-align: center; margin-bottom: 20px;">
                    Nomor : ${data.nomor_ba || '.........................................................................'}
                </p>

                <p><strong>PIHAK PERTAMA:</strong></p>
                <table style="width: 100%; margin-bottom: 15px;">
                    <tr><td style="width: 150px;">Nama</td><td>: ${data.pemohon.nama}</td></tr>
                    <tr><td>NIK</td><td>: ${data.pemohon.nik}</td></tr>
                    <tr><td>Alamat</td><td>: ${data.pemohon.alamat || 'Tidak tersedia'}</td></tr>
                </table>

                <p><strong>PIHAK KEDUA:</strong></p>
                <table style="width: 100%; margin-bottom: 15px;">
                    <tr><td style="width: 150px;">Nama</td><td>: ${data.terlapor.nama || 'Tidak tersedia'}</td></tr>
                    <tr><td>NIK</td><td>: ${data.terlapor.nik || 'Tidak tersedia'}</td></tr>
                    <tr><td>Alamat</td><td>: ${data.terlapor.alamat || 'Tidak tersedia'}</td></tr>
                </table>

                <p><strong>DATA TANAH:</strong></p>
                <table style="width: 100%;">
                    <tr><td style="width: 150px;">Lokasi</td><td>: ${data.lokasi.kampung}, ${data.lokasi.kecamatan}</td></tr>
                    <tr><td>Luas Terukur</td><td>: ${data.luas_terukur ? data.luas_terukur + ' m²' : 'Belum dihitung'}</td></tr>
                    <tr><td>Koordinat</td><td>: ${data.coordinates_count} titik</td></tr>
                </table>
            </div>

            <!-- Map Preview -->
            <div style="border: 1px solid #ddd; padding: 10px; text-align: center;">
                <h5>SKET/GAMBAR KASAR TANAH</h5>
                <div style="border: 1px solid #ccc; height: 200px; background: #f8f9fa; display: flex; align-items: center; justify-content: center; margin: 10px 0;">
                    <p style="color: #666;">Preview Peta Tanah</p>
                </div>
                <div style="display: flex; justify-content: space-between; margin-top: 10px;">
                    <div style="flex: 1;">
                        <p><strong>Batas Tanah:</strong></p>
                        <p>Utara: ${data.lokasi?.batas_utara || 'Tidak tersedia'}</p>
                        <p>Timur: ${data.lokasi?.batas_timur || 'Tidak tersedia'}</p>
                        <p>Selatan: ${data.lokasi?.batas_selatan || 'Tidak tersedia'}</p>
                        <p>Barat: ${data.lokasi?.batas_barat || 'Tidak tersedia'}</p>
                    </div>
                    <div style="flex: 1; text-align: center;">
                        <p><strong>Yang membuat Sket/Gambar Tanah</strong></p>
                        <div style="height: 60px;"></div>
                        <p style="text-decoration: underline;">______________________</p>
                        <p>NIP. ...................................</p>
                    </div>
                </div>
            </div>

            <div style="text-align: center; margin-top: 20px; color: #666;">
                <small>* Ini adalah preview sederhana. Untuk melihat format lengkap, gunakan tombol Print atau Download PDF.</small>
            </div>
        </div>
    `;

    $('#printPreviewContent').html(previewHtml);
}

// Zoom functions for preview
let currentZoom = 1;

function zoomIn() {
    currentZoom = Math.min(currentZoom + 0.1, 2);
    updateZoom();
}

function zoomOut() {
    currentZoom = Math.max(currentZoom - 0.1, 0.5);
    updateZoom();
}

function resetZoom() {
    currentZoom = 1;
    updateZoom();
}

function updateZoom() {
    $('#printPreviewContent').css('transform', `scale(${currentZoom})`);
    $('#zoomLevel').text(Math.round(currentZoom * 100) + '%');
}

// Rest of the existing functions...
function showError(message) {
    const errorContent = `
        <div class="text-center py-5">
            <div class="mb-3">
                <i class="fas fa-exclamation-triangle text-danger" style="font-size: 48px;"></i>
            </div>
            <h5 class="text-danger mb-3">Terjadi Kesalahan</h5>
            <p class="text-muted mb-4">${message}</p>
            <button type="button" class="btn btn-outline-primary" onclick="location.reload()">
                <i class="fas fa-refresh"></i> Muat Ulang Halaman
            </button>
        </div>
    `;

    $('#detailModal .modal-body').html(errorContent);
}

function getBadgeClass(statusClass) {
    const classMap = {
        'text-success': 'badge-success',
        'text-danger': 'badge-danger',
        'text-warning': 'badge-warning',
        'text-info': 'badge-info',
        'text-secondary': 'badge-secondary'
    };
    return classMap[statusClass] || 'badge-secondary';
}

function printDocument() {
    if (window.currentSpSiptData && window.currentSpSiptData.urls) {
        window.open(window.currentSpSiptData.urls.print, '_blank');
    } else {
        Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: 'Data dokumen tidak tersedia untuk dicetak.',
        });
    }
}

function downloadDocument() {
    if (window.currentSpSiptData && window.currentSpSiptData.urls) {
        Swal.fire({
            title: 'Mengunduh...',
            text: 'Mohon tunggu, dokumen sedang diproses.',
            allowOutsideClick: false,
            showConfirmButton: false,
            willOpen: () => {
                Swal.showLoading();
            }
        });

        window.location.href = window.currentSpSiptData.urls.download;

        setTimeout(() => {
            Swal.close();
        }, 2000);
    } else {
        Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: 'Data dokumen tidak tersedia untuk diunduh.',
        });
    }
}

// Send email function
function sendEmail() {
    if (!window.currentSpSiptData) {
        Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: 'Data dokumen tidak tersedia.',
        });
        return;
    }

    Swal.fire({
        title: 'Kirim Email',
        html: `
            <div class="form-group text-left">
                <label for="email">Email Tujuan:</label>
                <input type="email" id="email" class="form-control" placeholder="contoh@email.com" required>
            </div>
            <div class="form-group text-left">
                <label for="subject">Subject:</label>
                <input type="text" id="subject" class="form-control" value="Dokumen SP-MPT ${window.currentSpSiptData.nomor_ba}">
            </div>
            <div class="form-group text-left">
                <label for="message">Pesan:</label>
                <textarea id="message" class="form-control" rows="3">Terlampir dokumen Surat Pernyataan Melepaskan Penguasaan Tanah.</textarea>
            </div>
        `,
        showCancelButton: true,
        confirmButtonText: 'Kirim Email',
        cancelButtonText: 'Batal',
        confirmButtonColor: '#28a745',
        preConfirm: () => {
            const email = document.getElementById('email').value;
            const subject = document.getElementById('subject').value;
            const message = document.getElementById('message').value;

            if (!email) {
                Swal.showValidationMessage('Email harus diisi');
                return false;
            }

            if (!isValidEmail(email)) {
                Swal.showValidationMessage('Format email tidak valid');
                return false;
            }

            return { email, subject, message };
        }
    }).then((result) => {
        if (result.isConfirmed) {
            const { email, subject, message } = result.value;

            Swal.fire({
                title: 'Mengirim Email...',
                allowOutsideClick: false,
                showConfirmButton: false,
                willOpen: () => {
                    Swal.showLoading();
                }
            });

            $.ajax({
                url: `/sp-sipt/${window.currentSpSiptData.id}/send-email`,
                method: 'POST',
                data: {
                    email: email,
                    subject: subject,
                    message: message,
                    _token: $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Berhasil!',
                            text: response.message,
                            confirmButtonColor: '#28a745'
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Gagal!',
                            text: response.message,
                        });
                    }
                },
                error: function(xhr) {
                    let message = 'Gagal mengirim email.';
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        message = xhr.responseJSON.message;
                    }
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: message,
                    });
                }
            });
        }
    });
}

// Update status function
function updateStatusInModal(newStatus) {
    if (!window.currentSpSiptData) return;

    const statusText = getStatusText(newStatus);

    Swal.fire({
        title: 'Konfirmasi',
        text: `Ubah status menjadi ${statusText}?`,
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Ya, Ubah',
        cancelButtonText: 'Batal',
        input: 'textarea',
        inputPlaceholder: 'Catatan (opsional)...'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: `/sp-sipt/${window.currentSpSiptData.id}/update-status-ajax`,
                method: 'POST',
                data: {
                    status: newStatus,
                    catatan: result.value,
                    _token: $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Berhasil!',
                            text: response.message,
                            confirmButtonColor: '#28a745'
                        }).then(() => {
                            location.reload();
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Gagal!',
                            text: response.message,
                        });
                    }
                },
                error: function(xhr) {
                    let message = 'Gagal mengubah status.';
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        message = xhr.responseJSON.message;
                    }
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: message,
                    });
                }
            });
        }
    });
}

// Helper functions
function isValidEmail(email) {
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    return emailRegex.test(email);
}

function getStatusText(status) {
    switch(status) {
        case 'draft': return 'Draft';
        case 'submitted': return 'Belum Selesai';
        case 'in_review': return 'Sedang Ditinjau';
        case 'approved': return 'Terverifikasi';
        case 'rejected': return 'Ditolak';
        default: return 'Unknown';
    }
}

// Modal event handlers untuk cleanup
$('#detailModal').on('hidden.bs.modal', function () {
    // Reset modal content dan data
    $(this).find('.modal-body').empty();
    $(this).find('#detailModalTitle').text('');
    $(this).find('#detailModalSubtitle').text('');
    window.currentSpSiptData = null;
    currentZoom = 1; // Reset zoom level

    console.log('Modal closed and cleaned up');
});

// Initialize CSRF token for AJAX
$.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
});

// Document ready
$(document).ready(function() {
    console.log('SP-MPT scripts with preview loaded successfully');
});

</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.border-left-primary {
    border-left: 0.25rem solid #4e73df !important;
}
.border-left-success {
    border-left: 0.25rem solid #1cc88a !important;
}
.border-left-info {
    border-left: 0.25rem solid #36b9cc !important;
}
.border-left-warning {
    border-left: 0.25rem solid #f6c23e !important;
}
.border-left-secondary {
    border-left: 0.25rem solid #858796 !important;
}
.border-left-danger {
    border-left: 0.25rem solid #e74a3b !important;
}

.table-hover tbody tr:hover {
    background-color: rgba(0,0,0,.02);
}

.btn-group .btn {
    margin: 0 1px;
}

.card {
    box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15) !important;
}

.text-gray-800 {
    color: #5a5c69 !important;
}

.text-gray-300 {
    color: #dddfeb !important;
}

@media print {
    .btn, .card-footer, #filterForm, .card-header .btn {
        display: none !important;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin-layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\webgis-biduk\resources\views/admin/sp-sipt/index.blade.php ENDPATH**/ ?>