@extends('admin-layouts.master')

@section('title', 'Detail Laporan Pendapatan')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('reports.revenue.index') }}">Laporan Pendapatan</a></li>
                        <li class="breadcrumb-item active">Detail</li>
                    </ol>
                </div>
                <h4 class="page-title">Detail Laporan Pendapatan</h4>
            </div>
        </div>
    </div>

    <!-- Header Actions -->
    <div class="row mb-3">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Periode: {{ $summary['period'] }}</h5>
                <div>
                    <a href="{{ route('reports.revenue.index', request()->query()) }}" class="btn btn-secondary me-2">
                        <i class="mdi mdi-arrow-left"></i> Kembali
                    </a>
                    <a href="{{ route('reports.revenue.print', request()->query()) }}" class="btn btn-success" target="_blank">
                        <i class="mdi mdi-printer"></i> Print PDF
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Summary Statistics -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6">
            <div class="card border-primary">
                <div class="card-body text-center">
                    <h4 class="text-primary">Rp {{ number_format($summary['total_revenue'], 0, ',', '.') }}</h4>
                    <p class="text-muted mb-0">Total Pendapatan</p>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card border-info">
                <div class="card-body text-center">
                    <h4 class="text-info">{{ $summary['total_invoices'] }}</h4>
                    <p class="text-muted mb-0">Total Invoice</p>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card border-success">
                <div class="card-body text-center">
                    <h4 class="text-success">Rp {{ number_format($summary['average_invoice_value'], 0, ',', '.') }}</h4>
                    <p class="text-muted mb-0">Rata-rata per Invoice</p>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card border-warning">
                <div class="card-body text-center">
                    <h4 class="text-warning">Rp {{ number_format($summary['total_tax'], 0, ',', '.') }}</h4>
                    <p class="text-muted mb-0">Total Pajak</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Revenue Breakdown -->
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h4 class="header-title">Breakdown Pendapatan</h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <tbody>
                                <tr>
                                    <td>Pendapatan Kamar</td>
                                    <td class="text-end">Rp {{ number_format($summary['total_room_revenue'], 0, ',', '.') }}</td>
                                </tr>
                                <tr>
                                    <td>Pendapatan Layanan</td>
                                    <td class="text-end">Rp {{ number_format($summary['total_service_revenue'], 0, ',', '.') }}</td>
                                </tr>
                                <tr>
                                    <td>Diskon</td>
                                    <td class="text-end text-danger">- Rp {{ number_format($summary['total_discount'], 0, ',', '.') }}</td>
                                </tr>
                                <tr>
                                    <td>Pajak (PPN)</td>
                                    <td class="text-end">Rp {{ number_format($summary['total_tax'], 0, ',', '.') }}</td>
                                </tr>
                                <tr class="table-active">
                                    <td><strong>Total Pendapatan</strong></td>
                                    <td class="text-end"><strong>Rp {{ number_format($summary['total_revenue'], 0, ',', '.') }}</strong></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h4 class="header-title">Status Pembayaran</h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <tbody>
                                <tr>
                                    <td><span class="badge bg-success me-2"></span>Lunas</td>
                                    <td class="text-end">Rp {{ number_format($summary['paid_amount'], 0, ',', '.') }}</td>
                                </tr>
                                <tr>
                                    <td><span class="badge bg-warning me-2"></span>Pending</td>
                                    <td class="text-end">Rp {{ number_format($summary['pending_amount'], 0, ',', '.') }}</td>
                                </tr>
                                <tr>
                                    <td><span class="badge bg-danger me-2"></span>Jatuh Tempo</td>
                                    <td class="text-end">Rp {{ number_format($summary['overdue_amount'], 0, ',', '.') }}</td>
                                </tr>
                                <tr class="table-active">
                                    <td><strong>Total</strong></td>
                                    <td class="text-end"><strong>Rp {{ number_format($summary['total_revenue'], 0, ',', '.') }}</strong></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Revenue by Room Type -->
    @if($revenueByRoomType->count() > 0)
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="header-title">Pendapatan per Tipe Kamar</h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-centered table-striped">
                            <thead>
                                <tr>
                                    <th>Tipe Kamar</th>
                                    <th class="text-center">Jumlah Booking</th>
                                    <th class="text-end">Total Pendapatan</th>
                                    <th class="text-end">Rata-rata per Booking</th>
                                    <th class="text-center">Persentase</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($revenueByRoomType as $roomType)
                                <tr>
                                    <td>{{ $roomType->room_type }}</td>
                                    <td class="text-center">{{ $roomType->booking_count }}</td>
                                    <td class="text-end">Rp {{ number_format($roomType->total_revenue, 0, ',', '.') }}</td>
                                    <td class="text-end">Rp {{ number_format($roomType->avg_revenue, 0, ',', '.') }}</td>
                                    <td class="text-center">
                                        {{ number_format(($summary['total_room_revenue'] > 0 ? ($roomType->total_revenue / $summary['total_room_revenue']) * 100 : 0), 1) }}%
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Daily Revenue Trend -->
    @if($dailyRevenue->count() > 0)
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="header-title">Trend Pendapatan Harian</h4>
                </div>
                <div class="card-body">
                    <div id="daily-revenue-chart"></div>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Room Type Revenue Chart -->
    @if($revenueByRoomType->count() > 0)
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h4 class="header-title">Distribusi Pendapatan per Tipe Kamar</h4>
                </div>
                <div class="card-body">
                    <div id="room-type-chart"></div>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h4 class="header-title">Perbandingan Pendapatan</h4>
                </div>
                <div class="card-body">
                    <div id="revenue-comparison-chart"></div>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Detailed Invoice List -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="header-title">Detail Invoice</h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-centered table-striped dt-responsive nowrap w-100" id="invoices-table">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>No. Invoice</th>
                                    <th>Tanggal</th>
                                    <th>Tamu</th>
                                    <th>Check-in</th>
                                    <th>Check-out</th>
                                    <th>Kamar</th>
                                    <th>Layanan</th>
                                    <th>Diskon</th>
                                    <th>Pajak</th>
                                    <th>Total</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($invoices as $index => $invoice)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $invoice->invoice_number }}</td>
                                    <td>{{ \Carbon\Carbon::parse($invoice->invoice_date)->format('d/m/Y') }}</td>
                                    <td>{{ $invoice->booking->guest->name ?? '-' }}</td>
                                    <td>{{ $invoice->booking->check_in_date ? \Carbon\Carbon::parse($invoice->booking->check_in_date)->format('d/m/Y') : '-' }}</td>
                                    <td>{{ $invoice->booking->check_out_date ? \Carbon\Carbon::parse($invoice->booking->check_out_date)->format('d/m/Y') : '-' }}</td>
                                    <td class="text-end">Rp {{ number_format($invoice->room_total, 0, ',', '.') }}</td>
                                    <td class="text-end">Rp {{ number_format($invoice->services_total, 0, ',', '.') }}</td>
                                    <td class="text-end">Rp {{ number_format($invoice->discount_amount, 0, ',', '.') }}</td>
                                    <td class="text-end">Rp {{ number_format($invoice->tax_amount, 0, ',', '.') }}</td>
                                    <td class="text-end"><strong>Rp {{ number_format($invoice->grand_total, 0, ',', '.') }}</strong></td>
                                    <td>
                                        @switch($invoice->status)
                                            @case('paid')
                                                <span class="badge bg-success">Lunas</span>
                                                @break
                                            @case('pending')
                                                <span class="badge bg-warning">Pending</span>
                                                @break
                                            @case('cancelled')
                                                <span class="badge bg-danger">Dibatalkan</span>
                                                @break
                                            @case('overdue')
                                                <span class="badge bg-dark">Jatuh Tempo</span>
                                                @break
                                            @default
                                                <span class="badge bg-secondary">{{ ucfirst($invoice->status) }}</span>
                                        @endswitch
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr class="table-dark">
                                    <th colspan="6" class="text-end">TOTAL:</th>
                                    <th class="text-end">Rp {{ number_format($invoices->sum('room_total'), 0, ',', '.') }}</th>
                                    <th class="text-end">Rp {{ number_format($invoices->sum('services_total'), 0, ',', '.') }}</th>
                                    <th class="text-end">Rp {{ number_format($invoices->sum('discount_amount'), 0, ',', '.') }}</th>
                                    <th class="text-end">Rp {{ number_format($invoices->sum('tax_amount'), 0, ',', '.') }}</th>
                                    <th class="text-end">Rp {{ number_format($invoices->sum('grand_total'), 0, ',', '.') }}</th>
                                    <th></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>

<script>
    $(document).ready(function() {
        $('#invoices-table').DataTable({
            "pageLength": 25,
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Indonesian.json"
            },
            "order": [[ 2, "desc" ]],
            "columnDefs": [
                { "orderable": false, "targets": [0] }
            ],
            "dom": 'Bfrtip',
            "buttons": [
                {
                    extend: 'excel',
                    text: '<i class="mdi mdi-file-excel"></i> Excel',
                    className: 'btn btn-success btn-sm'
                },
                {
                    extend: 'csv',
                    text: '<i class="mdi mdi-file-delimited"></i> CSV',
                    className: 'btn btn-info btn-sm'
                }
            ]
        });
    });

    @if($dailyRevenue->count() > 0)
    // Daily Revenue Chart
    var dailyRevenueOptions = {
        chart: {
            type: 'area',
            height: 350,
            toolbar: {
                show: false
            }
        },
        series: [{
            name: 'Pendapatan Harian',
            data: @json($dailyRevenue->pluck('daily_total')->toArray())
        }],
        xaxis: {
            categories: @json($dailyRevenue->map(function($item) {
                return \Carbon\Carbon::parse($item->invoice_date)->format('d/m');
            })->toArray()),
            title: {
                text: 'Tanggal'
            }
        },
        yaxis: {
            title: {
                text: 'Pendapatan (Rp)'
            },
            labels: {
                formatter: function(val) {
                    return 'Rp ' + val.toLocaleString('id-ID');
                }
            }
        },
        tooltip: {
            y: {
                formatter: function(val) {
                    return 'Rp ' + val.toLocaleString('id-ID');
                }
            }
        },
        fill: {
            type: 'gradient',
            gradient: {
                shadeIntensity: 1,
                opacityFrom: 0.7,
                opacityTo: 0.9,
                stops: [0, 100]
            }
        },
        stroke: {
            curve: 'smooth'
        },
        colors: ['#727cf5']
    };

    var dailyRevenueChart = new ApexCharts(document.querySelector("#daily-revenue-chart"), dailyRevenueOptions);
    dailyRevenueChart.render();
    @endif

    @if($revenueByRoomType->count() > 0)
    // Room Type Revenue Donut Chart
    var roomTypeOptions = {
        chart: {
            type: 'donut',
            height: 350
        },
        series: @json($revenueByRoomType->pluck('total_revenue')->map(fn($v) => (float) $v)->toArray()),

        labels: @json($revenueByRoomType->pluck('room_type')->toArray()),
        colors: ['#727cf5', '#0acf97', '#fa5c7c', '#ffbc00', '#6c757d'],
        legend: {
            position: 'bottom'
        },
        plotOptions: {
            pie: {
                donut: {
                    size: '70%'
                }
            }
        },
        tooltip: {
            y: {
                formatter: function(val) {
                    return 'Rp ' + val.toLocaleString('id-ID');
                }
            }
        }
    };

    var roomTypeChart = new ApexCharts(document.querySelector("#room-type-chart"), roomTypeOptions);
    roomTypeChart.render();

    // Revenue Comparison Bar Chart
    var comparisonOptions = {
        chart: {
            type: 'bar',
            height: 350
        },
        series: [{
            name: 'Pendapatan Kamar',
            data: [{{ $summary['total_room_revenue'] }}]
        }, {
            name: 'Pendapatan Layanan',
            data: [{{ $summary['total_service_revenue'] }}]
        }],
        xaxis: {
            categories: ['Total Pendapatan']
        },
        yaxis: {
            labels: {
                formatter: function(val) {
                    return 'Rp ' + val.toLocaleString('id-ID');
                }
            }
        },
        tooltip: {
            y: {
                formatter: function(val) {
                    return 'Rp ' + val.toLocaleString('id-ID');
                }
            }
        },
        colors: ['#727cf5', '#0acf97'],
        plotOptions: {
            bar: {
                horizontal: false,
                columnWidth: '55%',
            }
        },
        dataLabels: {
            enabled: false
        }
    };

    var comparisonChart = new ApexCharts(document.querySelector("#revenue-comparison-chart"), comparisonOptions);
    comparisonChart.render();
    @endif
</script>
@endpush

@push('styles')
<link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.bootstrap5.min.css">
@endpush
@endsection