<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>500 - Server Error | SIM HOTEL</title>
    
    <!-- Bootstrap 4 CSS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.2/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background-color: #f8f9fa;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #2d3748;
            line-height: 1.6;
        }

        /* Main Container */
        .error-container {
            background: #ffffff;
            border-radius: 16px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            padding: 3rem;
            max-width: 560px;
            width: 90%;
            text-align: center;
            border: 1px solid #e2e8f0;
            animation: slideInUp 0.6s ease-out;
            position: relative;
            overflow: hidden;
        }

        @keyframes slideInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Decorative Elements */
        .decoration {
            position: absolute;
            opacity: 0.05;
            pointer-events: none;
        }

        .decoration-1 {
            top: 20px;
            right: 30px;
            font-size: 2rem;
            animation: float 5s ease-in-out infinite;
        }

        .decoration-2 {
            bottom: 30px;
            left: 20px;
            font-size: 1.5rem;
            animation: float 5s ease-in-out infinite 2.5s;
        }

        @keyframes float {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-12px) rotate(8deg); }
        }

        /* Server Icon Animation */
        .server-container {
            margin-bottom: 2rem;
            position: relative;
        }

        .server-icon {
            font-size: 4rem;
            color: #e53e3e;
            margin-bottom: 1rem;
            animation: serverPulse 3s infinite;
            position: relative;
        }

        @keyframes serverPulse {
            0%, 100% {
                transform: scale(1);
                opacity: 1;
            }
            50% {
                transform: scale(1.08);
                opacity: 0.8;
            }
        }

        /* Server status indicators */
        .server-icon::before,
        .server-icon::after {
            content: '';
            position: absolute;
            width: 8px;
            height: 8px;
            background: #e53e3e;
            border-radius: 50%;
            animation: blink 2s infinite;
        }

        .server-icon::before {
            top: 20%;
            right: 15%;
            animation-delay: 0s;
        }

        .server-icon::after {
            top: 35%;
            right: 15%;
            animation-delay: 1s;
        }

        @keyframes blink {
            0%, 50% { opacity: 1; }
            51%, 100% { opacity: 0.3; }
        }

        /* Error waves effect */
        .error-waves {
            position: absolute;
            top: 50%;
            left: 50%;
            width: 100px;
            height: 100px;
            transform: translate(-50%, -50%);
        }

        .wave {
            position: absolute;
            border: 2px solid #e53e3e;
            border-radius: 50%;
            opacity: 0.4;
            animation: waves 3s infinite;
        }

        .wave:nth-child(1) { animation-delay: 0s; }
        .wave:nth-child(2) { animation-delay: 1s; }
        .wave:nth-child(3) { animation-delay: 2s; }

        @keyframes waves {
            0% {
                width: 20px;
                height: 20px;
                opacity: 0.8;
            }
            100% {
                width: 120px;
                height: 120px;
                opacity: 0;
            }
        }

        /* Typography */
        .error-code {
            font-size: 4.5rem;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 0.5rem;
            letter-spacing: -2px;
            position: relative;
        }

        .error-code .digit {
            display: inline-block;
            animation: glitch 2s infinite;
        }

        .error-code .digit:nth-child(1) { animation-delay: 0.1s; }
        .error-code .digit:nth-child(2) { animation-delay: 0.2s; }
        .error-code .digit:nth-child(3) { animation-delay: 0.3s; }

        @keyframes glitch {
            0%, 90%, 100% {
                transform: translateX(0);
            }
            20% {
                transform: translateX(-2px);
            }
            40% {
                transform: translateX(2px);
            }
            60% {
                transform: translateX(-1px);
            }
            80% {
                transform: translateX(1px);
            }
        }

        .error-title {
            font-size: 1.75rem;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 1rem;
        }

        .error-message {
            font-size: 1rem;
            color: #718096;
            margin-bottom: 2.5rem;
            line-height: 1.7;
        }

        /* Server Status */
        .server-status {
            background: linear-gradient(135deg, #fff5f5, #fed7d7);
            border-radius: 12px;
            padding: 1.5rem;
            margin-bottom: 2rem;
            border-left: 4px solid #e53e3e;
            text-align: left;
        }

        .server-status h6 {
            color: #c53030;
            font-weight: 600;
            margin-bottom: 1rem;
            font-size: 0.95rem;
        }

        .status-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
            gap: 1rem;
        }

        .status-item {
            background: white;
            padding: 0.75rem;
            border-radius: 8px;
            border: 1px solid #fed7d7;
            text-align: center;
        }

        .status-item i {
            font-size: 1.5rem;
            margin-bottom: 0.5rem;
            display: block;
        }

        .status-item.error i {
            color: #e53e3e;
            animation: shake 2s infinite;
        }

        .status-item.warning i {
            color: #f6ad55;
            animation: pulse 2s infinite;
        }

        .status-item.checking i {
            color: #4299e1;
            animation: spin 2s linear infinite;
        }

        @keyframes shake {
            0%, 100% { transform: translateX(0); }
            25% { transform: translateX(-2px); }
            75% { transform: translateX(2px); }
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }

        .status-text {
            font-size: 0.75rem;
            font-weight: 500;
            color: #4a5568;
        }

        /* Incident Details */
        .incident-details {
            background-color: #f7fafc;
            border-radius: 8px;
            padding: 1.25rem;
            margin-bottom: 2rem;
            text-align: left;
            border: 1px solid #e2e8f0;
        }

        .incident-details h6 {
            color: #2d3748;
            font-weight: 600;
            margin-bottom: 0.75rem;
            font-size: 0.9rem;
        }

        .incident-id {
            font-family: 'Courier New', monospace;
            background: #edf2f7;
            padding: 0.5rem;
            border-radius: 4px;
            font-size: 0.8rem;
            color: #4a5568;
            border: 1px solid #cbd5e0;
            margin-bottom: 0.75rem;
        }

        .incident-time {
            color: #718096;
            font-size: 0.8rem;
        }

        /* Action Buttons */
        .btn-group {
            display: flex;
            gap: 1rem;
            justify-content: center;
            flex-wrap: wrap;
            margin-bottom: 2rem;
        }

        .btn-custom {
            padding: 12px 24px;
            border-radius: 8px;
            font-weight: 500;
            text-decoration: none;
            transition: all 0.2s ease;
            font-size: 0.95rem;
            display: inline-flex;
            align-items: center;
            min-width: 140px;
            justify-content: center;
            position: relative;
        }

        .btn-primary-custom {
            background-color: #3182ce;
            color: white;
            border: 1px solid #3182ce;
        }

        .btn-primary-custom:hover {
            background-color: #2c5282;
            border-color: #2c5282;
            color: white;
            text-decoration: none;
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(49, 130, 206, 0.3);
        }

        .btn-secondary-custom {
            background-color: #ffffff;
            color: #4a5568;
            border: 1px solid #e2e8f0;
        }

        .btn-secondary-custom:hover {
            background-color: #f7fafc;
            border-color: #cbd5e0;
            color: #4a5568;
            text-decoration: none;
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }

        .btn-refresh {
            background-color: #38a169;
            color: white;
            border: 1px solid #38a169;
        }

        .btn-refresh:hover {
            background-color: #2f855a;
            border-color: #2f855a;
            color: white;
            text-decoration: none;
        }

        /* Hotel Branding */
        .hotel-brand {
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 1.5rem;
            color: #3182ce;
        }

        .hotel-brand i {
            font-size: 1.25rem;
            margin-right: 0.5rem;
        }

        .hotel-brand span {
            font-weight: 600;
            font-size: 1.1rem;
            letter-spacing: 0.5px;
        }

        /* Divider */
        .divider {
            width: 60px;
            height: 2px;
            background-color: #e2e8f0;
            margin: 1.5rem auto;
        }

        /* Auto-refresh indicator */
        .refresh-indicator {
            position: fixed;
            top: 20px;
            right: 20px;
            background: #3182ce;
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 50px;
            font-size: 0.8rem;
            display: none;
            align-items: center;
            gap: 0.5rem;
            z-index: 1000;
            animation: slideInRight 0.3s ease-out;
        }

        @keyframes slideInRight {
            from { transform: translateX(100%); }
            to { transform: translateX(0); }
        }

        .refresh-progress {
            width: 20px;
            height: 20px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-top-color: white;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .error-container {
                padding: 2rem 1.5rem;
                margin: 1rem;
            }

            .error-code {
                font-size: 3.5rem;
            }

            .error-title {
                font-size: 1.5rem;
            }

            .error-message {
                font-size: 0.95rem;
            }

            .btn-group {
                flex-direction: column;
                align-items: center;
            }

            .btn-custom {
                width: 100%;
                max-width: 220px;
            }

            .status-grid {
                grid-template-columns: 1fr;
            }

            .server-icon {
                font-size: 3rem;
            }

            .refresh-indicator {
                position: relative;
                top: auto;
                right: auto;
                margin: 1rem auto;
                display: flex;
            }
        }

        /* Focus States */
        .btn-custom:focus {
            outline: none;
            box-shadow: 0 0 0 3px rgba(49, 130, 206, 0.2);
        }

        /* Loading states */
        .btn-custom.loading {
            opacity: 0.8;
            pointer-events: none;
        }

        .btn-custom.loading::after {
            content: '';
            width: 16px;
            height: 16px;
            border: 2px solid currentColor;
            border-top-color: transparent;
            border-radius: 50%;
            animation: spin 0.8s linear infinite;
            margin-left: 8px;
        }
    </style>
</head>
<body>
    <!-- Auto-refresh Indicator -->
    <div class="refresh-indicator" id="refreshIndicator">
        <div class="refresh-progress"></div>
        <span>Checking server status...</span>
    </div>

    <!-- Main Error Container -->
    <div class="error-container">
        <!-- Decorative Elements -->
        <div class="decoration decoration-1">
            <i class="fas fa-exclamation-triangle"></i>
        </div>
        <div class="decoration decoration-2">
            <i class="fas fa-tools"></i>
        </div>

        <!-- Hotel Branding -->
        <div class="hotel-brand">
            <i class="fas fa-hotel"></i>
            <span>SIM HOTEL</span>
        </div>

        <div class="divider"></div>

        <!-- Server Icon with Error Waves -->
        <div class="server-container">
            <div class="error-waves">
                <div class="wave"></div>
                <div class="wave"></div>
                <div class="wave"></div>
            </div>
            <i class="fas fa-server server-icon"></i>
        </div>

        <!-- Error Content -->
        <div class="error-code">
            <span class="digit">5</span><span class="digit">0</span><span class="digit">0</span>
        </div>
        <h1 class="error-title">Server Error</h1>
        <p class="error-message">
            Maaf, terjadi kesalahan pada server. Tim teknis kami sedang bekerja untuk memperbaiki masalah ini.
            Silakan coba lagi dalam beberapa saat.
        </p>

        <!-- Server Status -->
        <div class="server-status">
            <h6><i class="fas fa-heartbeat mr-2"></i>Status Server</h6>
            <div class="status-grid">
                <div class="status-item error">
                    <i class="fas fa-times-circle"></i>
                    <div class="status-text">Application</div>
                </div>
                <div class="status-item checking">
                    <i class="fas fa-sync-alt"></i>
                    <div class="status-text">Database</div>
                </div>
                <div class="status-item warning">
                    <i class="fas fa-exclamation-triangle"></i>
                    <div class="status-text">Cache</div>
                </div>
            </div>
        </div>

        <!-- Incident Details -->
        <div class="incident-details">
            <h6><i class="fas fa-clipboard-list mr-2"></i>Detail Insiden</h6>
            <div class="incident-id" id="incidentId">
                Incident ID: #SH-<span id="errorId"></span>
            </div>
            <div class="incident-time" id="incidentTime">
                Waktu: <span id="errorTime"></span>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="btn-group">
            <a href="javascript:location.reload()" class="btn-custom btn-refresh" id="refreshBtn">
                <i class="fas fa-sync-alt mr-2"></i>
                Refresh Halaman
            </a>
            <a href="javascript:history.back()" class="btn-custom btn-secondary-custom" id="backBtn">
                <i class="fas fa-arrow-left mr-2"></i>
                Kembali
            </a>
            <a href="{{ route('home') }}" class="btn-custom btn-primary-custom" id="homeBtn">
                <i class="fas fa-home mr-2"></i>
                Dashboard
            </a>
        </div>

        <!-- Progress indicator for auto-refresh -->
        <div class="text-center">
            <small class="text-muted">
                <i class="fas fa-clock mr-1"></i>
                Halaman akan otomatis refresh dalam <span id="countdown">30</span> detik
            </small>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.2/js/bootstrap.bundle.min.js"></script>
    
    <script>
        $(document).ready(function() {
            // Generate unique error ID
            const errorId = 'ERR' + Date.now().toString().slice(-8);
            const errorTime = new Date().toLocaleString('id-ID');
            
            $('#errorId').text(errorId);
            $('#errorTime').text(errorTime);

            // Auto-refresh countdown
            let countdown = 30;
            const countdownInterval = setInterval(() => {
                countdown--;
                $('#countdown').text(countdown);
                
                if (countdown <= 10) {
                    $('#refreshIndicator').fadeIn(300);
                }
                
                if (countdown <= 0) {
                    clearInterval(countdownInterval);
                    location.reload();
                }
            }, 1000);

            // Manual refresh with loading state
            $('#refreshBtn').on('click', function(e) {
                e.preventDefault();
                const $btn = $(this);
                
                $btn.addClass('loading');
                $btn.html('<i class="fas fa-spinner fa-spin mr-2"></i>Refreshing...');
                
                // Clear the auto-refresh
                clearInterval(countdownInterval);
                
                // Show refresh indicator
                $('#refreshIndicator').fadeIn(300);
                
                setTimeout(() => {
                    location.reload();
                }, 1500);
            });

            // Simulate server status checks
            function updateServerStatus() {
                const statusItems = $('.status-item');
                
                statusItems.each(function(index) {
                    const $item = $(this);
                    
                    setTimeout(() => {
                        // Simulate random status updates
                        const statuses = ['error', 'warning', 'checking'];
                        const currentStatus = statuses[Math.floor(Math.random() * statuses.length)];
                        
                        $item.removeClass('error warning checking').addClass(currentStatus);
                        
                        const icons = {
                            'error': 'fas fa-times-circle',
                            'warning': 'fas fa-exclamation-triangle', 
                            'checking': 'fas fa-sync-alt'
                        };
                        
                        $item.find('i').attr('class', icons[currentStatus]);
                    }, index * 500);
                });
            }

            // Update status every 10 seconds
            setInterval(updateServerStatus, 10000);

            // Keyboard shortcuts
            $(document).keydown(function(e) {
                switch(e.which) {
                    case 82: // R key for Refresh
                        if (e.ctrlKey) {
                            e.preventDefault();
                            $('#refreshBtn')[0].click();
                        }
                        break;
                    case 27: // ESC key
                        $('#backBtn')[0].click();
                        break;
                    case 72: // H key for Home
                        $('#homeBtn')[0].click();
                        break;
                    case 116: // F5 key
                        clearInterval(countdownInterval);
                        break;
                }
            });

            // Track error in local storage for analytics
            const errorData = {
                id: errorId,
                timestamp: new Date().toISOString(),
                url: window.location.href,
                userAgent: navigator.userAgent
            };
            
            localStorage.setItem('lastServerError', JSON.stringify(errorData));

            // Dynamic greeting
            const hour = new Date().getHours();
            let greeting = "";
            if (hour < 12) greeting = "Selamat pagi! ";
            else if (hour < 15) greeting = "Selamat siang! ";
            else if (hour < 18) greeting = "Selamat sore! ";
            else greeting = "Selamat malam! ";

            // Update message
            const currentMessage = $('.error-message').text();
            $('.error-message').text(greeting + currentMessage);

            // Server icon interaction
            $('.server-icon').on('click', function() {
                $(this).css('animation', 'none');
                setTimeout(() => {
                    $(this).css('animation', 'serverPulse 3s infinite');
                    updateServerStatus();
                }, 100);
            });

            // Handle page visibility changes
            document.addEventListener('visibilitychange', function() {
                if (document.hidden) {
                    // Pause countdown when page is hidden
                    clearInterval(countdownInterval);
                } else {
                    // Resume or restart when page becomes visible
                    location.reload();
                }
            });

            // Prevent multiple button clicks
            $('.btn-custom').on('click', function() {
                const $this = $(this);
                $this.prop('disabled', true);
                setTimeout(() => {
                    $this.prop('disabled', false);
                }, 2000);
            });

            // Show error details on server icon double-click
            $('.server-icon').on('dblclick', function() {
                const details = `
                    Error Details:
                    - ID: ${errorId}
                    - Time: ${errorTime}
                    - URL: ${window.location.href}
                    - Browser: ${navigator.userAgent.split(' ')[0]}
                `;
                
                if (confirm('Copy error details to clipboard?')) {
                    navigator.clipboard.writeText(details).then(() => {
                        alert('Error details copied to clipboard!');
                    });
                }
            });

            // Smooth container hover effect
            $('.error-container').hover(
                function() { $(this).css('transform', 'scale(1.01)'); },
                function() { $(this).css('transform', 'scale(1)'); }
            );

            // Add subtle shake to glitch effect
            setInterval(() => {
                $('.error-code').css('transform', 'translateX(' + (Math.random() * 2 - 1) + 'px)');
                setTimeout(() => {
                    $('.error-code').css('transform', 'translateX(0)');
                }, 50);
            }, 3000);
        });

        // Browser error handling
        window.addEventListener('error', function(e) {
            console.log('Additional error occurred:', e.message);
        });

        // Handle browser back/forward
        window.addEventListener('popstate', function(e) {
            // Clear intervals when navigating away
            clearInterval(window.countdownInterval);
        });
    </script>
</body>
</html>