{{-- @extends('errors::minimal')

@section('title', __('Not Found'))
@section('code', '404')
@section('message', __('Not Found')) --}}
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>404 - Page Not Found | SIM HOTEL</title>
    
    <!-- Bootstrap 4 CSS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.2/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background-color: #f8f9fa;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #2d3748;
            line-height: 1.6;
        }

        /* Main Container */
        .error-container {
            background: #ffffff;
            border-radius: 16px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            padding: 3rem;
            max-width: 550px;
            width: 90%;
            text-align: center;
            border: 1px solid #e2e8f0;
            animation: slideInUp 0.6s ease-out;
            position: relative;
            overflow: hidden;
        }

        @keyframes slideInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Decorative Elements */
        .decoration {
            position: absolute;
            opacity: 0.05;
            pointer-events: none;
        }

        .decoration-1 {
            top: 20px;
            right: 30px;
            font-size: 2rem;
            animation: float 4s ease-in-out infinite;
        }

        .decoration-2 {
            bottom: 30px;
            left: 20px;
            font-size: 1.5rem;
            animation: float 4s ease-in-out infinite 2s;
        }

        @keyframes float {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-10px) rotate(5deg); }
        }

        /* Search Icon Animation */
        .search-container {
            margin-bottom: 2rem;
            position: relative;
        }

        .search-icon {
            font-size: 4rem;
            color: #3182ce;
            margin-bottom: 1rem;
            animation: searchPulse 3s infinite;
            position: relative;
        }

        @keyframes searchPulse {
            0%, 100% {
                transform: scale(1);
                opacity: 1;
            }
            50% {
                transform: scale(1.1);
                opacity: 0.8;
            }
        }

        /* Magnifying glass effect */
        .search-icon::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 80px;
            height: 80px;
            border: 2px solid #3182ce;
            border-radius: 50%;
            opacity: 0.3;
            animation: ripple 2s infinite;
            transform: translate(-50%, -50%);
        }

        @keyframes ripple {
            0% {
                transform: translate(-50%, -50%) scale(0.8);
                opacity: 0.6;
            }
            100% {
                transform: translate(-50%, -50%) scale(1.5);
                opacity: 0;
            }
        }

        /* Typography */
        .error-code {
            font-size: 5rem;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 0.5rem;
            letter-spacing: -3px;
            position: relative;
        }

        .error-code .digit {
            display: inline-block;
            animation: bounce 1s ease-in-out infinite;
        }

        .error-code .digit:nth-child(1) { animation-delay: 0.1s; }
        .error-code .digit:nth-child(2) { animation-delay: 0.2s; }
        .error-code .digit:nth-child(3) { animation-delay: 0.3s; }

        @keyframes bounce {
            0%, 20%, 50%, 80%, 100% {
                transform: translateY(0);
            }
            40% {
                transform: translateY(-10px);
            }
            60% {
                transform: translateY(-5px);
            }
        }

        .error-title {
            font-size: 1.75rem;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 1rem;
        }

        .error-message {
            font-size: 1rem;
            color: #718096;
            margin-bottom: 2.5rem;
            line-height: 1.7;
        }

        /* Interactive Search Box */
        .search-box {
            margin-bottom: 2rem;
            position: relative;
        }

        .search-input {
            width: 100%;
            padding: 12px 45px 12px 16px;
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            font-size: 1rem;
            transition: all 0.3s ease;
            background-color: #f7fafc;
        }

        .search-input:focus {
            outline: none;
            border-color: #3182ce;
            background-color: #ffffff;
            box-shadow: 0 0 0 3px rgba(49, 130, 206, 0.1);
        }

        .search-btn {
            position: absolute;
            right: 8px;
            top: 50%;
            transform: translateY(-50%);
            background: #3182ce;
            border: none;
            color: white;
            width: 32px;
            height: 32px;
            border-radius: 6px;
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .search-btn:hover {
            background: #2c5282;
            transform: translateY(-50%) scale(1.05);
        }

        /* Buttons */
        .btn-group {
            display: flex;
            gap: 1rem;
            justify-content: center;
            flex-wrap: wrap;
            margin-bottom: 2rem;
        }

        .btn-custom {
            padding: 12px 24px;
            border-radius: 8px;
            font-weight: 500;
            text-decoration: none;
            transition: all 0.2s ease;
            font-size: 0.95rem;
            display: inline-flex;
            align-items: center;
            min-width: 140px;
            justify-content: center;
            position: relative;
            overflow: hidden;
        }

        .btn-primary-custom {
            background-color: #3182ce;
            color: white;
            border: 1px solid #3182ce;
        }

        .btn-primary-custom:hover {
            background-color: #2c5282;
            border-color: #2c5282;
            color: white;
            text-decoration: none;
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(49, 130, 206, 0.3);
        }

        .btn-secondary-custom {
            background-color: #ffffff;
            color: #4a5568;
            border: 1px solid #e2e8f0;
        }

        .btn-secondary-custom:hover {
            background-color: #f7fafc;
            border-color: #cbd5e0;
            color: #4a5568;
            text-decoration: none;
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }

        /* Quick Links */
        .quick-links {
            background-color: #f7fafc;
            border-radius: 8px;
            padding: 1.5rem;
            text-align: left;
            margin-bottom: 1.5rem;
        }

        .quick-links h6 {
            color: #2d3748;
            font-weight: 600;
            margin-bottom: 1rem;
            font-size: 0.95rem;
        }

        .quick-links-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
            gap: 0.75rem;
        }

        .quick-link {
            display: flex;
            align-items: center;
            padding: 8px 12px;
            background: white;
            border-radius: 6px;
            color: #4a5568;
            text-decoration: none;
            transition: all 0.2s ease;
            font-size: 0.9rem;
            border: 1px solid #e2e8f0;
        }

        .quick-link:hover {
            color: #3182ce;
            text-decoration: none;
            background-color: #ebf8ff;
            border-color: #bee3f8;
            transform: translateY(-1px);
        }

        .quick-link i {
            margin-right: 8px;
            font-size: 0.8rem;
            opacity: 0.7;
        }

        /* Hotel Branding */
        .hotel-brand {
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 1.5rem;
            color: #3182ce;
        }

        .hotel-brand i {
            font-size: 1.25rem;
            margin-right: 0.5rem;
        }

        .hotel-brand span {
            font-weight: 600;
            font-size: 1.1rem;
            letter-spacing: 0.5px;
        }

        /* Divider */
        .divider {
            width: 60px;
            height: 2px;
            background-color: #e2e8f0;
            margin: 1.5rem auto;
        }

        /* Fun Element */
        .fun-text {
            font-size: 0.85rem;
            color: #a0aec0;
            margin-top: 1rem;
            opacity: 0;
            animation: fadeInDelay 1s ease-out 1.5s forwards;
        }

        @keyframes fadeInDelay {
            to { opacity: 1; }
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .error-container {
                padding: 2rem 1.5rem;
                margin: 1rem;
            }

            .error-code {
                font-size: 3.5rem;
            }

            .error-title {
                font-size: 1.5rem;
            }

            .error-message {
                font-size: 0.95rem;
            }

            .btn-group {
                flex-direction: column;
                align-items: center;
            }

            .btn-custom {
                width: 100%;
                max-width: 220px;
            }

            .search-icon {
                font-size: 3rem;
            }

            .quick-links-grid {
                grid-template-columns: 1fr;
            }
        }

        /* Subtle Interactions */
        .error-container:hover {
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.12);
        }

        /* Loading States */
        .btn-custom.loading {
            opacity: 0.8;
            pointer-events: none;
        }

        .btn-custom.loading::after {
            content: '';
            width: 16px;
            height: 16px;
            border: 2px solid currentColor;
            border-top-color: transparent;
            border-radius: 50%;
            animation: spin 0.8s linear infinite;
            margin-left: 8px;
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }

        /* Focus States */
        .btn-custom:focus,
        .quick-link:focus,
        .search-btn:focus {
            outline: none;
            box-shadow: 0 0 0 3px rgba(49, 130, 206, 0.2);
        }
    </style>
</head>
<body>
    <!-- Main Error Container -->
    <div class="error-container">
        <!-- Decorative Elements -->
        <div class="decoration decoration-1">
            <i class="fas fa-map-marker-alt"></i>
        </div>
        <div class="decoration decoration-2">
            <i class="fas fa-route"></i>
        </div>

        <!-- Hotel Branding -->
        <div class="hotel-brand">
            <i class="fas fa-hotel"></i>
            <span>SIM HOTEL</span>
        </div>

        <div class="divider"></div>

        <!-- Search Icon -->
        <div class="search-container">
            <i class="fas fa-search search-icon"></i>
        </div>

        <!-- Error Content -->
        <div class="error-code">
            <span class="digit">4</span><span class="digit">0</span><span class="digit">4</span>
        </div>
        <h1 class="error-title">Halaman Tidak Ditemukan</h1>
        <p class="error-message">
            Maaf, halaman yang Anda cari tidak dapat ditemukan. 
            Mungkin halaman telah dipindahkan atau URL salah.
        </p>

        <!-- Interactive Search -->
        <div class="search-box">
            <input type="text" class="search-input" placeholder="Cari halaman yang Anda butuhkan..." id="searchInput">
            <button class="search-btn" id="searchBtn">
                <i class="fas fa-search"></i>
            </button>
        </div>

        <!-- Quick Links -->
        <div class="quick-links">
            <h6><i class="fas fa-compass mr-2"></i>Halaman Populer</h6>
            <div class="quick-links-grid">
                <a href="{{ route('home') }}" class="quick-link">
                    <i class="fas fa-home"></i>
                    Dashboard
                </a>
               
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn-custom btn-secondary-custom" id="backBtn">
                <i class="fas fa-arrow-left mr-2"></i>
                Kembali
            </a>
            <a href="{{ route('home') }}" class="btn-custom btn-primary-custom" id="homeBtn">
                <i class="fas fa-home mr-2"></i>
                Dashboard
            </a>
        </div>

        <!-- Fun Text -->
        <div class="fun-text">
            <i class="fas fa-lightbulb mr-1"></i>
            Tip: Gunakan menu navigasi untuk menemukan halaman yang Anda butuhkan
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.2/js/bootstrap.bundle.min.js"></script>
    
    <script>
        $(document).ready(function() {
            // Search functionality
            const searchInput = $('#searchInput');
            const searchBtn = $('#searchBtn');

            // Popular searches/suggestions
            const suggestions = [
                { text: 'dashboard', url: '{{ route("home") }}' },

            ];

            // Search function
            function performSearch() {
                const query = searchInput.val().toLowerCase().trim();
                
                if (query === '') {
                    searchInput.focus();
                    return;
                }

                // Find matching suggestion
                const match = suggestions.find(s => 
                    s.text.toLowerCase().includes(query) || 
                    query.includes(s.text.toLowerCase())
                );

                if (match) {
                    // Add loading state
                    searchBtn.addClass('loading');
                    searchInput.prop('disabled', true);
                    
                    // Simulate search delay
                    setTimeout(() => {
                        window.location.href = match.url;
                    }, 800);
                } else {
                    // No match found - redirect to dashboard with search term
                    window.location.href = '{{ route("home") }}?search=' + encodeURIComponent(query);
                }
            }

            // Search events
            searchBtn.on('click', performSearch);
            searchInput.on('keypress', function(e) {
                if (e.which === 13) { // Enter key
                    performSearch();
                }
            });

            // Auto-focus search input after animation
            setTimeout(() => {
                searchInput.focus();
            }, 800);

            // Smooth button interactions
            $('.btn-custom').on('click', function() {
                const $btn = $(this);
                $btn.addClass('loading');
            });

            // Search icon interaction
            $('.search-icon').on('click', function() {
                searchInput.focus();
            });

            // Quick links tracking
            $('.quick-link').on('click', function() {
                const linkText = $(this).text().trim();
                console.log('Quick link clicked:', linkText);
            });

            // Keyboard navigation
            $(document).keydown(function(e) {
                switch(e.which) {
                    case 27: // ESC key
                        if (searchInput.is(':focus')) {
                            searchInput.blur();
                        } else {
                            $('#backBtn')[0].click();
                        }
                        break;
                    case 72: // H key for Home
                        if (!searchInput.is(':focus')) {
                            $('#homeBtn')[0].click();
                        }
                        break;
                    case 191: // '/' key for search
                        e.preventDefault();
                        searchInput.focus();
                        break;
                }
            });

            // Dynamic greeting
            const hour = new Date().getHours();
            let greeting = "";
            if (hour < 12) greeting = "Selamat pagi! ";
            else if (hour < 15) greeting = "Selamat siang! ";
            else if (hour < 18) greeting = "Selamat sore! ";
            else greeting = "Selamat malam! ";

            // Update message
            const currentMessage = $('.error-message').text();
            $('.error-message').text(greeting + currentMessage);

            // Add some Easter eggs
            let clickCount = 0;
            $('.error-code').on('click', function() {
                clickCount++;
                if (clickCount === 5) {
                    $(this).css('transform', 'rotate(360deg)');
                    setTimeout(() => {
                        $(this).css('transform', 'rotate(0deg)');
                        clickCount = 0;
                    }, 500);
                }
            });

            // Search input placeholder animation
            const placeholders = [
                'Cari halaman yang Anda butuhkan...',
                'Coba cari "dashboard" atau "booking"...',
                'Ketik untuk mencari...',
                'Apa yang Anda cari?'
            ];
            
            let placeholderIndex = 0;
            setInterval(() => {
                if (!searchInput.is(':focus') && searchInput.val() === '') {
                    placeholderIndex = (placeholderIndex + 1) % placeholders.length;
                    searchInput.attr('placeholder', placeholders[placeholderIndex]);
                }
            }, 3000);

            // Prevent form submission on search
            $('form').on('submit', function(e) {
                e.preventDefault();
                performSearch();
            });
        });

        // Page visibility handling
        document.addEventListener('visibilitychange', function() {
            if (!document.hidden) {
                // Reset any animations when page becomes visible
                $('.search-icon').removeClass('paused');
            }
        });

        // Error boundary
        window.addEventListener('error', function(e) {
            console.log('Error handled gracefully:', e.message);
        });
    </script>
</body>
</html>