{{-- @extends('errors::minimal')

@section('title', __('Forbidden'))
@section('code', '403')

@section('message')
Anda Tidak Mempunyai Hak Akses Ke Halaman ini.
@endsection --}}
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>403 - Access Forbidden | SIM HOTEL</title>
    
    <!-- Bootstrap 4 CSS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.2/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background-color: #f8f9fa;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #2d3748;
            line-height: 1.6;
        }

        /* Main Container */
        .error-container {
            background: #ffffff;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            padding: 3rem;
            max-width: 500px;
            width: 90%;
            text-align: center;
            border: 1px solid #e2e8f0;
            animation: fadeInUp 0.6s ease-out;
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Lock Icon */
        .lock-container {
            margin-bottom: 2rem;
        }

        .lock-icon {
            font-size: 4rem;
            color: #e53e3e;
            margin-bottom: 1rem;
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0%, 100% {
                opacity: 1;
                transform: scale(1);
            }
            50% {
                opacity: 0.8;
                transform: scale(1.05);
            }
        }

        /* Typography */
        .error-code {
            font-size: 4rem;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 0.5rem;
            letter-spacing: -2px;
        }

        .error-title {
            font-size: 1.75rem;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 1rem;
        }

        .error-message {
            font-size: 1rem;
            color: #718096;
            margin-bottom: 2.5rem;
            line-height: 1.7;
        }

        /* Buttons */
        .btn-group {
            display: flex;
            gap: 1rem;
            justify-content: center;
            flex-wrap: wrap;
            margin-bottom: 2rem;
        }

        .btn-custom {
            padding: 12px 24px;
            border-radius: 8px;
            font-weight: 500;
            text-decoration: none;
            transition: all 0.2s ease;
            font-size: 0.95rem;
            display: inline-flex;
            align-items: center;
            min-width: 120px;
            justify-content: center;
        }

        .btn-primary-custom {
            background-color: #3182ce;
            color: white;
            border: 1px solid #3182ce;
        }

        .btn-primary-custom:hover {
            background-color: #2c5282;
            border-color: #2c5282;
            color: white;
            text-decoration: none;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(49, 130, 206, 0.2);
        }

        .btn-secondary-custom {
            background-color: #ffffff;
            color: #4a5568;
            border: 1px solid #e2e8f0;
        }

        .btn-secondary-custom:hover {
            background-color: #f7fafc;
            border-color: #cbd5e0;
            color: #4a5568;
            text-decoration: none;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        /* Contact Info */
        .contact-info {
            background-color: #f7fafc;
            border-radius: 8px;
            padding: 1.5rem;
            border-left: 4px solid #3182ce;
            text-align: left;
        }

        .contact-info h6 {
            color: #2d3748;
            font-weight: 600;
            margin-bottom: 0.5rem;
            font-size: 0.95rem;
        }

        .contact-info p {
            color: #718096;
            margin-bottom: 0;
            font-size: 0.9rem;
        }

        /* Hotel Branding */
        .hotel-brand {
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 1.5rem;
            color: #3182ce;
        }

        .hotel-brand i {
            font-size: 1.25rem;
            margin-right: 0.5rem;
        }

        .hotel-brand span {
            font-weight: 600;
            font-size: 1.1rem;
            letter-spacing: 0.5px;
        }

        /* Divider */
        .divider {
            width: 50px;
            height: 2px;
            background-color: #e2e8f0;
            margin: 1.5rem auto;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .error-container {
                padding: 2rem 1.5rem;
                margin: 1rem;
            }

            .error-code {
                font-size: 3rem;
            }

            .error-title {
                font-size: 1.5rem;
            }

            .error-message {
                font-size: 0.95rem;
            }

            .btn-group {
                flex-direction: column;
                align-items: center;
            }

            .btn-custom {
                width: 100%;
                max-width: 200px;
            }

            .lock-icon {
                font-size: 3rem;
            }
        }

        /* Subtle Interactions */
        .error-container:hover {
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12);
        }

        .lock-icon:hover {
            color: #c53030;
            cursor: pointer;
        }

        /* Focus States */
        .btn-custom:focus {
            outline: none;
            box-shadow: 0 0 0 3px rgba(49, 130, 206, 0.2);
        }

        /* Loading States */
        .btn-custom.loading {
            opacity: 0.8;
            pointer-events: none;
        }

        .btn-custom.loading::after {
            content: '';
            width: 16px;
            height: 16px;
            border: 2px solid currentColor;
            border-top-color: transparent;
            border-radius: 50%;
            animation: spin 0.8s linear infinite;
            margin-left: 8px;
        }

        @keyframes spin {
            to {
                transform: rotate(360deg);
            }
        }

        /* Clean Animations */
        .fade-in {
            animation: fadeIn 0.4s ease-out;
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        /* Minimal Icons */
        .icon-minimal {
            opacity: 0.7;
            font-size: 0.9rem;
        }
    </style>
</head>
<body>
    <!-- Main Error Container -->
    <div class="error-container">
        <!-- Hotel Branding -->
        <div class="hotel-brand">
            <i class="fas fa-hotel"></i>
            <span>SIM HOTEL</span>
        </div>

        <div class="divider"></div>

        <!-- Lock Icon -->
        <div class="lock-container">
            <i class="fas fa-lock lock-icon"></i>
        </div>

        <!-- Error Content -->
        <div class="error-code">403</div>
        <h1 class="error-title">Akses Terlarang</h1>
        <p class="error-message">
            Anda tidak memiliki hak akses untuk mengunjungi halaman ini. 
            Silakan hubungi administrator atau kembali ke halaman sebelumnya.
        </p>

        <!-- Action Buttons -->
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn-custom btn-secondary-custom" id="backBtn">
                <i class="fas fa-arrow-left icon-minimal mr-2"></i>
                Kembali
            </a>
            <a href="{{ route('home') }}" class="btn-custom btn-primary-custom" id="homeBtn">
                <i class="fas fa-home icon-minimal mr-2"></i>
                Dashboard
            </a>
        </div>

        <!-- Contact Information -->
        <div class="contact-info">
            <h6><i class="fas fa-info-circle mr-2"></i>Butuh Bantuan?</h6>
            <p>Jika Anda merasa ini adalah kesalahan, silakan hubungi administrator sistem untuk mendapatkan akses yang sesuai.</p>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.2/js/bootstrap.bundle.min.js"></script>
    
    <script>
        $(document).ready(function() {
            // Smooth button interactions
            $('.btn-custom').on('click', function() {
                const $btn = $(this);
                $btn.addClass('loading');
                
                // Remove loading state after navigation
                setTimeout(function() {
                    $btn.removeClass('loading');
                }, 1000);
            });

            // Lock icon interaction
            $('.lock-icon').on('click', function() {
                $(this).css('transform', 'rotate(5deg)');
                setTimeout(() => {
                    $(this).css('transform', 'rotate(-5deg)');
                    setTimeout(() => {
                        $(this).css('transform', 'rotate(0deg)');
                    }, 100);
                }, 100);
            });

            // Keyboard navigation
            $(document).keydown(function(e) {
                switch(e.which) {
                    case 27: // ESC key
                        $('#backBtn')[0].click();
                        break;
                    case 72: // H key for Home
                        $('#homeBtn')[0].click();
                        break;
                    case 13: // Enter key
                        $('#homeBtn')[0].click();
                        break;
                }
            });

            // Add fade-in class to container
            setTimeout(function() {
                $('.error-container').addClass('fade-in');
            }, 100);

            // Dynamic greeting based on time
            const hour = new Date().getHours();
            let greeting = "";
            if (hour < 12) greeting = "Selamat pagi! ";
            else if (hour < 15) greeting = "Selamat siang! ";
            else if (hour < 18) greeting = "Selamat sore! ";
            else greeting = "Selamat malam! ";

            // Update message with greeting
            const currentMessage = $('.error-message').text();
            $('.error-message').text(greeting + currentMessage);

            // Simple focus management
            $('a, button').on('focus', function() {
                $(this).addClass('focused');
            }).on('blur', function() {
                $(this).removeClass('focused');
            });

            // Prevent double clicks
            $('.btn-custom').on('click', function() {
                const $this = $(this);
                $this.prop('disabled', true);
                setTimeout(function() {
                    $this.prop('disabled', false);
                }, 1000);
            });
        });

        // Simple page visibility handling
        document.addEventListener('visibilitychange', function() {
            if (!document.hidden) {
                // Refresh any dynamic content when page becomes visible
                $('.error-container').removeClass('fade-in').addClass('fade-in');
            }
        });

        // Error boundary for any JS errors
        window.addEventListener('error', function(e) {
            console.log('Error handled gracefully:', e.message);
        });
    </script>
</body>
</html>