<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>401 - Unauthorized | SIM HOTEL</title>
    
    <!-- Bootstrap 4 CSS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.2/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background-color: #f8f9fa;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #2d3748;
            line-height: 1.6;
        }

        /* Main Container */
        .error-container {
            background: #ffffff;
            border-radius: 16px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            padding: 3rem;
            max-width: 520px;
            width: 90%;
            text-align: center;
            border: 1px solid #e2e8f0;
            animation: slideInUp 0.6s ease-out;
            position: relative;
            overflow: hidden;
        }

        @keyframes slideInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Decorative Elements */
        .decoration {
            position: absolute;
            opacity: 0.05;
            pointer-events: none;
        }

        .decoration-1 {
            top: 20px;
            right: 30px;
            font-size: 2rem;
            animation: float 4s ease-in-out infinite;
        }

        .decoration-2 {
            bottom: 30px;
            left: 20px;
            font-size: 1.5rem;
            animation: float 4s ease-in-out infinite 2s;
        }

        @keyframes float {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-10px) rotate(5deg); }
        }

        /* Key Animation */
        .key-container {
            margin-bottom: 2rem;
            position: relative;
        }

        .key-icon {
            font-size: 4rem;
            color: #f56565;
            margin-bottom: 1rem;
            animation: keyShake 3s infinite;
            position: relative;
        }

        @keyframes keyShake {
            0%, 100% {
                transform: rotate(0deg);
            }
            25% {
                transform: rotate(-5deg);
            }
            75% {
                transform: rotate(5deg);
            }
        }

        /* Key ring effect */
        .key-icon::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 90px;
            height: 90px;
            border: 2px solid #f56565;
            border-radius: 50%;
            opacity: 0.3;
            animation: keyRing 2.5s infinite;
            transform: translate(-50%, -50%);
        }

        @keyframes keyRing {
            0% {
                transform: translate(-50%, -50%) scale(0.8);
                opacity: 0.6;
            }
            100% {
                transform: translate(-50%, -50%) scale(1.4);
                opacity: 0;
            }
        }

        /* Typography */
        .error-code {
            font-size: 4.5rem;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 0.5rem;
            letter-spacing: -2px;
            position: relative;
        }

        .error-code .digit {
            display: inline-block;
            animation: slideIn 0.6s ease-out forwards;
            opacity: 0;
            transform: translateX(-30px);
        }

        .error-code .digit:nth-child(1) { animation-delay: 0.2s; }
        .error-code .digit:nth-child(2) { animation-delay: 0.4s; }
        .error-code .digit:nth-child(3) { animation-delay: 0.6s; }

        @keyframes slideIn {
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }

        .error-title {
            font-size: 1.75rem;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 1rem;
        }

        .error-message {
            font-size: 1rem;
            color: #718096;
            margin-bottom: 2.5rem;
            line-height: 1.7;
        }

        /* Login Form */
        .login-section {
            background-color: #f7fafc;
            border-radius: 12px;
            padding: 1.5rem;
            margin-bottom: 2rem;
            border: 1px solid #e2e8f0;
        }

        .login-section h6 {
            color: #2d3748;
            font-weight: 600;
            margin-bottom: 1rem;
            font-size: 0.95rem;
        }

        .login-options {
            display: flex;
            gap: 0.75rem;
            justify-content: center;
            flex-wrap: wrap;
        }

        .login-btn {
            flex: 1;
            min-width: 120px;
            padding: 10px 16px;
            border-radius: 8px;
            border: 1px solid #e2e8f0;
            background: white;
            color: #4a5568;
            text-decoration: none;
            font-size: 0.9rem;
            font-weight: 500;
            transition: all 0.2s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            overflow: hidden;
        }

        .login-btn:hover {
            color: #3182ce;
            border-color: #bee3f8;
            background-color: #ebf8ff;
            text-decoration: none;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(49, 130, 206, 0.15);
        }

        .login-btn i {
            margin-right: 6px;
            font-size: 0.85rem;
        }

        .login-btn.primary {
            background-color: #3182ce;
            color: white;
            border-color: #3182ce;
        }

        .login-btn.primary:hover {
            background-color: #2c5282;
            border-color: #2c5282;
            color: white;
        }

        /* Session Info */
        .session-info {
            background: linear-gradient(135deg, #fff5f5, #fed7d7);
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 2rem;
            border-left: 4px solid #f56565;
        }

        .session-info h6 {
            color: #c53030;
            font-weight: 600;
            margin-bottom: 0.5rem;
            font-size: 0.9rem;
        }

        .session-info p {
            color: #742a2a;
            margin-bottom: 0;
            font-size: 0.85rem;
        }

        /* Action Buttons */
        .btn-group {
            display: flex;
            gap: 1rem;
            justify-content: center;
            flex-wrap: wrap;
            margin-bottom: 1.5rem;
        }

        .btn-custom {
            padding: 12px 24px;
            border-radius: 8px;
            font-weight: 500;
            text-decoration: none;
            transition: all 0.2s ease;
            font-size: 0.95rem;
            display: inline-flex;
            align-items: center;
            min-width: 140px;
            justify-content: center;
        }

        .btn-primary-custom {
            background-color: #3182ce;
            color: white;
            border: 1px solid #3182ce;
        }

        .btn-primary-custom:hover {
            background-color: #2c5282;
            border-color: #2c5282;
            color: white;
            text-decoration: none;
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(49, 130, 206, 0.3);
        }

        .btn-secondary-custom {
            background-color: #ffffff;
            color: #4a5568;
            border: 1px solid #e2e8f0;
        }

        .btn-secondary-custom:hover {
            background-color: #f7fafc;
            border-color: #cbd5e0;
            color: #4a5568;
            text-decoration: none;
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }

        /* Hotel Branding */
        .hotel-brand {
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 1.5rem;
            color: #3182ce;
        }

        .hotel-brand i {
            font-size: 1.25rem;
            margin-right: 0.5rem;
        }

        .hotel-brand span {
            font-weight: 600;
            font-size: 1.1rem;
            letter-spacing: 0.5px;
        }

        /* Divider */
        .divider {
            width: 60px;
            height: 2px;
            background-color: #e2e8f0;
            margin: 1.5rem auto;
        }

        /* Security Tips */
        .security-tips {
            text-align: left;
            background-color: #f0fff4;
            border-radius: 8px;
            padding: 1rem;
            border-left: 4px solid #48bb78;
            margin-top: 1.5rem;
        }

        .security-tips h6 {
            color: #2f855a;
            font-weight: 600;
            margin-bottom: 0.5rem;
            font-size: 0.9rem;
        }

        .security-tips ul {
            margin: 0;
            padding-left: 1.2rem;
            color: #276749;
            font-size: 0.85rem;
        }

        .security-tips li {
            margin-bottom: 0.25rem;
        }

        /* Loading Animation */
        .loading-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(255, 255, 255, 0.9);
            display: none;
            align-items: center;
            justify-content: center;
            border-radius: 16px;
        }

        .spinner {
            width: 40px;
            height: 40px;
            border: 3px solid #e2e8f0;
            border-top-color: #3182ce;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .error-container {
                padding: 2rem 1.5rem;
                margin: 1rem;
            }

            .error-code {
                font-size: 3.5rem;
            }

            .error-title {
                font-size: 1.5rem;
            }

            .error-message {
                font-size: 0.95rem;
            }

            .btn-group {
                flex-direction: column;
                align-items: center;
            }

            .btn-custom {
                width: 100%;
                max-width: 220px;
            }

            .login-options {
                flex-direction: column;
            }

            .login-btn {
                width: 100%;
            }

            .key-icon {
                font-size: 3rem;
            }
        }

        /* Focus States */
        .btn-custom:focus,
        .login-btn:focus {
            outline: none;
            box-shadow: 0 0 0 3px rgba(49, 130, 206, 0.2);
        }

        /* Pulse Effect */
        .pulse {
            animation: pulse 1.5s infinite;
        }

        @keyframes pulse {
            0% { opacity: 1; }
            50% { opacity: 0.7; }
            100% { opacity: 1; }
        }
    </style>
</head>
<body>
    <!-- Main Error Container -->
    <div class="error-container">
        <!-- Loading Overlay -->
        <div class="loading-overlay" id="loadingOverlay">
            <div class="spinner"></div>
        </div>

        <!-- Decorative Elements -->
        <div class="decoration decoration-1">
            <i class="fas fa-user-lock"></i>
        </div>
        <div class="decoration decoration-2">
            <i class="fas fa-shield-alt"></i>
        </div>

        <!-- Hotel Branding -->
        <div class="hotel-brand">
            <i class="fas fa-hotel"></i>
            <span>SIM HOTEL</span>
        </div>

        <div class="divider"></div>

        <!-- Key Icon -->
        <div class="key-container">
            <i class="fas fa-key key-icon"></i>
        </div>

        <!-- Error Content -->
        <div class="error-code">
            <span class="digit">4</span><span class="digit">0</span><span class="digit">1</span>
        </div>
        <h1 class="error-title">Akses Tidak Terotorisasi</h1>
        <p class="error-message">
            Sesi Anda telah berakhir atau Anda belum login. 
            Silakan login kembali untuk mengakses sistem.
        </p>

        <!-- Session Information -->
        <div class="session-info">
            <h6><i class="fas fa-clock mr-2"></i>Informasi Sesi</h6>
            <p>Sesi login Anda mungkin telah kedaluwarsa karena tidak aktif atau token keamanan tidak valid.</p>
        </div>

        <!-- Login Section -->
        <div class="login-section">
            <h6><i class="fas fa-sign-in-alt mr-2"></i>Login Ulang</h6>
            <div class="login-options">
                <a href="{{ route('login') }}" class="login-btn primary" id="loginBtn">
                    <i class="fas fa-user"></i>
                    Login
                </a>
                <a href="{{ route('password.request') }}" class="login-btn" id="forgotBtn">
                    <i class="fas fa-question-circle"></i>
                    Lupa Password?
                </a>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn-custom btn-secondary-custom" id="backBtn">
                <i class="fas fa-arrow-left mr-2"></i>
                Kembali
            </a>
            <a href="{{ route('home') }}" class="btn-custom btn-primary-custom" id="homeBtn">
                <i class="fas fa-home mr-2"></i>
                Halaman Utama
            </a>
        </div>

        <!-- Security Tips -->
        <div class="security-tips">
            <h6><i class="fas fa-shield-alt mr-2"></i>Tips Keamanan</h6>
            <ul>
                <li>Selalu logout ketika selesai menggunakan sistem</li>
                <li>Jangan tinggalkan komputer dalam keadaan login</li>
                <li>Gunakan password yang kuat dan unik</li>
                <li>Hubungi admin jika mengalami masalah login berulang</li>
            </ul>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.2/js/bootstrap.bundle.min.js"></script>
    
    <script>
        $(document).ready(function() {
            // Check if user is actually logged in (could be a mistake)
            function checkAuthStatus() {
                // This would normally check with your backend
                // For demo purposes, we'll simulate
                const isLoggedIn = false; // Replace with actual auth check
                
                if (isLoggedIn) {
                    $('.session-info').html(`
                        <h6><i class="fas fa-check-circle mr-2"></i>Sesi Aktif Ditemukan</h6>
                        <p>Anda mungkin sudah login. <a href="{{ route('home') }}">Klik di sini</a> untuk melanjutkan.</p>
                    `).removeClass().addClass('session-info').css({
                        'background': 'linear-gradient(135deg, #f0fff4, #c6f6d5)',
                        'border-left-color': '#48bb78'
                    });
                }
            }

            // Login button with loading state
            $('#loginBtn').on('click', function(e) {
                e.preventDefault();
                const $btn = $(this);
                const originalText = $btn.html();
                
                // Show loading state
                $btn.html('<i class="fas fa-spinner fa-spin mr-2"></i>Mengarahkan...');
                $btn.prop('disabled', true);
                $('#loadingOverlay').fadeIn(300);
                
                // Simulate redirect delay
                setTimeout(() => {
                    window.location.href = '{{ route("login") }}';
                }, 1000);
            });

            // Forgot password with feedback
            $('#forgotBtn').on('click', function(e) {
                e.preventDefault();
                const $btn = $(this);
                
                $btn.html('<i class="fas fa-spinner fa-spin mr-2"></i>Memuat...');
                
                setTimeout(() => {
                    window.location.href = '{{ route("password.request") }}';
                }, 500);
            });

            // Auto-retry login check
            let retryCount = 0;
            const maxRetries = 3;
            
            function autoRetryAuth() {
                if (retryCount < maxRetries) {
                    retryCount++;
                    console.log(`Auth check attempt ${retryCount}/${maxRetries}`);
                    
                    // Add retry indicator
                    if (retryCount === 1) {
                        $('.session-info').append('<div class="mt-2"><small class="text-muted pulse"><i class="fas fa-sync fa-spin mr-1"></i>Memeriksa status login...</small></div>');
                    }
                    
                    setTimeout(() => {
                        checkAuthStatus();
                        $('.session-info .pulse').remove();
                    }, 2000);
                }
            }

            // Key icon interaction
            $('.key-icon').on('click', function() {
                $(this).css('animation', 'none');
                setTimeout(() => {
                    $(this).css('animation', 'keyShake 3s infinite');
                }, 100);
                
                // Trigger auth recheck
                autoRetryAuth();
            });

            // Keyboard shortcuts
            $(document).keydown(function(e) {
                switch(e.which) {
                    case 13: // Enter key
                        $('#loginBtn')[0].click();
                        break;
                    case 27: // ESC key
                        $('#backBtn')[0].click();
                        break;
                    case 72: // H key for Home
                        $('#homeBtn')[0].click();
                        break;
                    case 76: // L key for Login
                        $('#loginBtn')[0].click();
                        break;
                }
            });

            // Dynamic greeting
            const hour = new Date().getHours();
            let greeting = "";
            if (hour < 12) greeting = "Selamat pagi! ";
            else if (hour < 15) greeting = "Selamat siang! ";
            else if (hour < 18) greeting = "Selamat sore! ";
            else greeting = "Selamat malam! ";

            // Update message
            const currentMessage = $('.error-message').text();
            $('.error-message').text(greeting + currentMessage);

            // Auto-focus on login button after animation
            setTimeout(() => {
                $('#loginBtn').focus();
            }, 1200);

            // Check for session storage to provide better UX
            const lastVisitedPage = sessionStorage.getItem('lastPage');
            if (lastVisitedPage && lastVisitedPage !== window.location.href) {
                $('.session-info').append(`
                    <div class="mt-2">
                        <small class="text-muted">
                            <i class="fas fa-history mr-1"></i>
                            Halaman terakhir: <strong>${lastVisitedPage}</strong>
                        </small>
                    </div>
                `);
            }

            // Store current attempt for analytics
            const sessionExpiry = new Date().toISOString();
            localStorage.setItem('lastAuthError', sessionExpiry);

            // Periodic session check (every 30 seconds)
            let sessionCheckInterval = setInterval(() => {
                checkAuthStatus();
            }, 30000);

            // Clear interval when page is hidden
            document.addEventListener('visibilitychange', () => {
                if (document.hidden) {
                    clearInterval(sessionCheckInterval);
                } else {
                    sessionCheckInterval = setInterval(checkAuthStatus, 30000);
                }
            });

            // Initial auth status check
            setTimeout(checkAuthStatus, 1000);

            // Prevent multiple rapid clicks
            $('.btn-custom, .login-btn').on('click', function() {
                const $this = $(this);
                $this.prop('disabled', true);
                setTimeout(() => {
                    $this.prop('disabled', false);
                }, 2000);
            });

            // Add smooth transitions
            $('.error-container').hover(
                function() { $(this).css('transform', 'scale(1.01)'); },
                function() { $(this).css('transform', 'scale(1)'); }
            );
        });

        // Page visibility handling
        document.addEventListener('visibilitychange', function() {
            if (!document.hidden) {
                // Refresh auth status when page becomes visible
                console.log('Page visible, checking auth status...');
            }
        });

        // Error boundary
        window.addEventListener('error', function(e) {
            console.log('Error handled gracefully:', e.message);
        });

        // Browser back/forward handling
        window.addEventListener('popstate', function(e) {
            // Refresh page to ensure proper auth state
            window.location.reload();
        });
    </script>
</body>
</html>