<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Login - Kecamatan Biduk-Biduk</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <!-- Bootstrap 4 CSS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.0/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">

    <style>
        :root {
            --primary-green: #1abc9c;
            --secondary-green: #16a085;
            --light-green: #2ecc71;
        }

        body {
            background: linear-gradient(135deg, var(--primary-green) 0%, var(--light-green) 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .login-container {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .login-card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
            padding: 40px 30px;
            width: 100%;
            max-width: 400px;
            position: relative;
            overflow: hidden;
        }

        .login-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 5px;
            background: linear-gradient(90deg, var(--primary-green), var(--light-green));
        }

        .logo-section {
            text-align: center;
            margin-bottom: 30px;
        }

        .logo {
            width: 60px;
            height: 60px;
            background: var(--primary-green);
            border-radius: 10px;
            margin: 0 auto 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 5px 15px rgba(26, 188, 156, 0.3);
        }

        .logo i {
            color: white;
            font-size: 24px;
        }

        .title {
            font-size: 18px;
            font-weight: 700;
            color: #2c3e50;
            margin-bottom: 5px;
            letter-spacing: 0.5px;
        }

        .subtitle {
            font-size: 14px;
            color: #7f8c8d;
            font-weight: 500;
        }

        .login-form {
            margin-top: 30px;
        }

        .form-label {
            font-size: 14px;
            font-weight: 600;
            color: #34495e;
            margin-bottom: 8px;
        }

        .form-control {
            border: 2px solid #ecf0f1;
            border-radius: 8px;
            padding: 12px 15px;
            font-size: 14px;
            transition: all 0.3s ease;
            background-color: #f8f9fa;
        }

        .form-control:focus {
            border-color: var(--primary-green);
            box-shadow: 0 0 0 0.2rem rgba(26, 188, 156, 0.15);
            background-color: white;
        }

        .form-group {
            margin-bottom: 20px;
            position: relative;
        }

        .input-icon {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: #bdc3c7;
            font-size: 16px;
        }

        .btn-submit {
            background: linear-gradient(135deg, var(--primary-green), var(--secondary-green));
            border: none;
            border-radius: 8px;
            padding: 12px;
            font-size: 16px;
            font-weight: 600;
            color: white;
            width: 100%;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(26, 188, 156, 0.3);
            background: linear-gradient(135deg, var(--secondary-green), var(--primary-green));
        }

        .btn-submit:active {
            transform: translateY(0);
        }

        .forgot-password {
            text-align: center;
            margin-top: 20px;
        }

        .forgot-password a {
            color: var(--primary-green);
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
        }

        .forgot-password a:hover {
            text-decoration: underline;
        }

        .menu-toggle {
            position: absolute;
            top: 20px;
            right: 20px;
            background: rgba(255, 255, 255, 0.2);
            border: none;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            color: white;
            font-size: 16px;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .menu-toggle:hover {
            background: rgba(255, 255, 255, 0.3);
        }

        @media (max-width: 576px) {
            .login-card {
                margin: 20px;
                padding: 30px 25px;
            }

            .title {
                font-size: 16px;
            }

            .subtitle {
                font-size: 13px;
            }
        }

        /* Loading animation */
        .btn-submit.loading {
            position: relative;
            color: transparent;
        }

        .btn-submit.loading::after {
            content: '';
            position: absolute;
            width: 20px;
            height: 20px;
            top: 50%;
            left: 50%;
            margin-left: -10px;
            margin-top: -10px;
            border: 2px solid transparent;
            border-top-color: white;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Alert styles */
        .alert {
            border-radius: 8px;
            border: none;
            margin-bottom: 20px;
        }

        .alert-danger {
            background-color: #fee;
            color: #c33;
        }

        :root{
  --green-main: #16a34a;     /* hijau utama */
  --green-dark: #15803d;
  --green-light: #22c55e;
  --warning: #fbbf24;
  --danger: #dc2626;
  --success: #16a34a;
}

.modal-green{
  border: none;
  border-radius: 16px;
  overflow: hidden;
  background: #fff;
  box-shadow: 0 15px 50px rgba(0,0,0,0.2);
}

.modal-green__header{
  background: var(--green-main);
  color: #fff;
  padding: 18px 24px;
}

.modal-green__footer{
  border-top: 1px solid #e5e7eb;
  background: #f9fafb;
  padding: 14px 20px;
}

.modal-green__icon{
  display: inline-flex;
  align-items: center;
  justify-content: center;
  width: 42px;
  height: 42px;
  border-radius: 10px;
  background: rgba(255,255,255,0.2);
  margin-right: 10px;
}

.sleek-input-group .input-group-text {
  background: #fff;
  border-right: 0;
}
.sleek-input {
  border-left: 0;
}
.sleek-input:focus {
  border-color: var(--green-light);
  box-shadow: 0 0 0 3px rgba(34,197,94,0.3);
}

.btn-cek {
  background: var(--green-main);
  border-color: var(--green-main);
  color: #fff;
  font-weight: 600;
  transition: 0.2s;
}
.btn-cek:hover {
  background: var(--green-dark);
  border-color: var(--green-dark);
}

.status-card {
  background: #f9fafb;
  border-radius: 12px;
  padding: 16px 18px;
  border: 1px solid #e5e7eb;
}
.status-dot {
  width: 14px; height: 14px; border-radius: 50%;
}
.pulse-success { background: var(--success); animation: pulse-green 1.5s infinite; }
.pulse-danger { background: var(--danger); animation: pulse-red 1.5s infinite; }
.pulse-warning { background: var(--warning); animation: pulse-yellow 1.5s infinite; }

@keyframes pulse-green {
  0% { box-shadow: 0 0 0 0 rgba(22,163,74,.5); }
  70% { box-shadow: 0 0 0 10px rgba(22,163,74,0); }
  100% { box-shadow: 0 0 0 0 rgba(22,163,74,0); }
}
@keyframes pulse-red {
  0% { box-shadow: 0 0 0 0 rgba(220,38,38,.5); }
  70% { box-shadow: 0 0 0 10px rgba(220,38,38,0); }
  100% { box-shadow: 0 0 0 0 rgba(220,38,38,0); }
}
@keyframes pulse-yellow {
  0% { box-shadow: 0 0 0 0 rgba(251,191,36,.5); }
  70% { box-shadow: 0 0 0 10px rgba(251,191,36,0); }
  100% { box-shadow: 0 0 0 0 rgba(251,191,36,0); }
}

.badge-status {
  display: inline-flex;
  align-items: center;
  padding: 8px 14px;
  font-weight: 600;
  border-radius: 20px;
}
.badge-status i { font-size: .95rem; margin-right: 4px; }

.badge-status.is-success { background: rgba(22,163,74,.1); color: var(--green-dark); border: 1px solid rgba(22,163,74,.2); }
.badge-status.is-danger  { background: rgba(220,38,38,.1); color: var(--danger); border: 1px solid rgba(220,38,38,.2); }
.badge-status.is-warning { background: rgba(251,191,36,.1); color: #92400e; border: 1px solid rgba(251,191,36,.2); }

.empty-state {
  text-align: center;
  border: 1px dashed #e5e7eb;
  border-radius: 12px;
  padding: 24px 16px;
}
.empty-state .spinner-border {
  color: var(--green-main);
  width: 2.5rem; height: 2.5rem;
}
.empty-state__icon {
  font-size: 44px; color: #9ca3af; margin-bottom: 10px;
}

/* Document Section Styles */
.doc-section {
  margin-top: 24px;
  background: linear-gradient(135deg, #f8fafb 0%, #ffffff 100%);
  border-radius: 12px;
  padding: 20px;
  border: 1px solid #e5e7eb;
}

.doc-section__header {
  display: flex;
  align-items: center;
  margin-bottom: 16px;
  padding-bottom: 12px;
  border-bottom: 2px solid var(--green-main);
}

.doc-section__header i {
  font-size: 24px;
  color: var(--green-main);
  margin-right: 10px;
}

.doc-section__title {
  font-size: 16px;
  font-weight: 700;
  color: #1f2937;
  margin: 0;
}

.doc-grid {
  display: grid;
  grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
  gap: 12px;
  margin-top: 16px;
}

.doc-card {
  background: #fff;
  border: 1px solid #e5e7eb;
  border-radius: 10px;
  padding: 14px;
  transition: all 0.3s ease;
  position: relative;
  overflow: hidden;
}

.doc-card::before {
  content: '';
  position: absolute;
  top: 0;
  left: 0;
  width: 4px;
  height: 100%;
  background: var(--green-main);
  transform: scaleY(0);
  transition: transform 0.3s ease;
}

.doc-card:hover {
  transform: translateY(-2px);
  box-shadow: 0 4px 12px rgba(22, 163, 74, 0.15);
  border-color: var(--green-light);
}

.doc-card:hover::before {
  transform: scaleY(1);
}

.doc-card__content {
  display: flex;
  align-items: center;
  gap: 12px;
}

.doc-card__icon {
  flex-shrink: 0;
  width: 42px;
  height: 42px;
  background: linear-gradient(135deg, rgba(22, 163, 74, 0.1), rgba(34, 197, 94, 0.1));
  border-radius: 8px;
  display: flex;
  align-items: center;
  justify-content: center;
  color: var(--green-main);
  font-size: 20px;
}

.doc-card__info {
  flex: 1;
  min-width: 0;
}

.doc-card__name {
  font-size: 13px;
  font-weight: 600;
  color: #374151;
  margin: 0 0 4px 0;
  line-height: 1.3;
}

.doc-card__size {
  font-size: 11px;
  color: #6b7280;
}

.doc-card__action {
  flex-shrink: 0;
}

.btn-download-mini {
  background: var(--green-main);
  border: none;
  color: #fff;
  width: 32px;
  height: 32px;
  border-radius: 8px;
  display: flex;
  align-items: center;
  justify-content: center;
  cursor: pointer;
  transition: all 0.3s ease;
  font-size: 14px;
}

.btn-download-mini:hover {
  background: var(--green-dark);
  transform: scale(1.1);
}

.btn-download-mini:active {
  transform: scale(0.95);
}

@media (max-width: 768px) {
  .doc-grid {
    grid-template-columns: 1fr;
  }
}
    </style>
</head>
<body>
    <div class="login-container">
        <!-- Menu Toggle Button -->
        <button class="menu-toggle" type="button">
            <i class="fas fa-bars"></i>
        </button>

        <div class="login-card">
            <!-- Logo Section -->
            <div class="logo-section">
                <div class="logo">
                    <i class="fas fa-building"></i>
                </div>
                <div class="title">KECAMATAN BIDUK-BIDUK</div>
                <div class="subtitle">KABUPATEN BERAU</div>
            </div>

            <!-- Error Messages (if any) -->
            @if(session('error'))
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-circle me-2"></i>
                    {{ session('error') }}
                </div>
            @endif

            @if($errors->any())
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-circle me-2"></i>
                    @foreach($errors->all() as $error)
                        {{ $error }}<br>
                    @endforeach
                </div>
            @endif

            <!-- Login Form -->
            <form class="login-form" method="POST" action="{{ route('login') }}" id="loginForm">
                @csrf

                <div class="form-group">
                    <label for="username" class="form-label">Username</label>
                    <div style="position: relative;">
                        <input type="text"
                               class="form-control @error('username') is-invalid @enderror"
                               id="username"
                               name="username"
                               value="{{ old('username') }}"
                               required
                               autocomplete="username"
                               autofocus
                               placeholder="Masukkan username">
                        <i class="fas fa-user input-icon"></i>
                    </div>
                    @error('username')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="password" class="form-label">Password</label>
                    <div style="position: relative;">
                        <input type="password"
                               class="form-control @error('password') is-invalid @enderror"
                               id="password"
                               name="password"
                               required
                               autocomplete="current-password"
                               placeholder="Masukkan password">
                        <i class="fas fa-lock input-icon"></i>
                    </div>
                    @error('password')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                        <label class="form-check-label" for="remember" style="font-size: 14px; color: #7f8c8d;">
                            Ingat saya
                        </label>
                    </div>
                </div>

                <button type="submit" class="btn btn-submit" id="submitBtn">
                    <span id="submitText">Submit</span>
                </button>

                {{-- <div class="forgot-password">
                    <a href="{{ route('password.request') }}">Lupa password?</a>
                </div> --}}
            </form>
        </div>
    </div>

    <!-- Menu Toggle Button -->
    <button class="menu-toggle" type="button" id="menuToggleBtn">
        <i class="fas fa-bars"></i>
    </button>

    <!-- Modal Cek Validasi SKPT -->
    <div class="modal fade" id="skptModal" tabindex="-1" role="dialog" aria-labelledby="skptModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
    <div class="modal-content modal-green">
      <!-- Header -->
      <div class="modal-header modal-green__header">
        <div class="d-flex align-items-center gap-2">
          <span class="modal-green__icon">
            <i class="fas fa-search"></i>
          </span>
          <div>
            <h5 class="modal-title mb-0" id="skptModalLabel">Cek Validasi SKPT</h5>
            <small class="text-light">Masukkan nomor registrasi untuk melihat status SKPT</small>
          </div>
        </div>
        <button type="button" class="close text-white" data-dismiss="modal" aria-label="Tutup">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>

      <!-- Body -->
      <div class="modal-body">
        <!-- Form -->
        <form id="cekSkptForm" autocomplete="off" novalidate>
          <label for="nomorRegistrasi" class="form-label font-weight-bold">Nomor Registrasi SKPT</label>
          <div class="input-group input-group-lg sleek-input-group mb-2">
            <div class="input-group-prepend">
              <span class="input-group-text"><i class="fas fa-hashtag"></i></span>
            </div>
            <input
              type="text"
              class="form-control sleek-input"
              id="nomorRegistrasi"
              name="nomor_registrasi"
              placeholder="Contoh: 002"
              value=""
              required
            >
            <div class="input-group-append">
              <button type="submit" class="btn btn-cek btn-lg">
                <i class="fas fa-search mr-1"></i> Cek
              </button>
            </div>
          </div>
          <small class="text-muted">Gunakan format lengkap bila ada kode/tahun.</small>
        </form>

        <!-- Status -->
        <div id="statusResult" class="status-card mt-4" style="display: block;">
          <div class="d-flex justify-content-between align-items-center">
            <div class="d-flex align-items-center">
              <div class="status-dot pulse-warning mr-2" aria-hidden="true"></div>
              <div>
                <div class="font-weight-bold text-dark">Status SKPT</div>
                <small class="text-muted">Hasil pengecekan terakhir</small>
              </div>
            </div>
            <span class="badge-status is-warning status-badge">
              <i class="fas fa-clock mr-1"></i>
            </span>
          </div>
        </div>

        <!-- Loading -->
        <div id="loadingState" class="empty-state mt-4" style="display:none;">
          <div class="spinner-border text-success" role="status" aria-label="Memuat"></div>
          <p class="mt-3 text-muted mb-0">Mencari data SKPT...</p>
        </div>

        <!-- Tidak ada data -->
        <div id="noDataState" class="empty-state mt-4" style="display:none;">
          <div class="empty-state__icon"><i class="fas fa-search"></i></div>
          <h6 class="mb-1">Data Tidak Ditemukan</h6>
          <p class="text-muted mb-0">Periksa kembali nomor registrasi Anda.</p>
        </div>

        <!-- Download Dokumen -->
        <div class="doc-section">
          <div class="doc-section__header">
            <i class="fas fa-folder-open"></i>
            <h6 class="doc-section__title">Dokumen Pendukung</h6>
          </div>
          
          <div class="doc-grid">
            <div class="doc-card">
              <div class="doc-card__content">
                <div class="doc-card__icon">
                  <i class="fas fa-file-word"></i>
                </div>
                <div class="doc-card__info">
                  <p class="doc-card__name">Surat Pengantar RT</p>
                  <span class="doc-card__size">Template DOCX</span>
                </div>
                <div class="doc-card__action">
                  <button type="button" class="btn-download-mini" onclick="downloadDocument('surat-pengantar-rt')" title="Download">
                    <i class="fas fa-download"></i>
                  </button>
                </div>
              </div>
            </div>

            <div class="doc-card">
              <div class="doc-card__content">
                <div class="doc-card__icon">
                  <i class="fas fa-file-word"></i>
                </div>
                <div class="doc-card__info">
                  <p class="doc-card__name">Surat Pengantar Kepala Kampung</p>
                  <span class="doc-card__size">Template DOCX</span>
                </div>
                <div class="doc-card__action">
                  <button type="button" class="btn-download-mini" onclick="downloadDocument('surat-pengantar-kades')" title="Download">
                    <i class="fas fa-download"></i>
                  </button>
                </div>
              </div>
            </div>

            <div class="doc-card">
              <div class="doc-card__content">
                <div class="doc-card__icon">
                  <i class="fas fa-file-word"></i>
                </div>
                <div class="doc-card__info">
                  <p class="doc-card__name">Form Riwayat Pengusahaan Fisik Bidang Tanah</p>
                  <span class="doc-card__size">Template DOCX</span>
                </div>
                <div class="doc-card__action">
                  <button type="button" class="btn-download-mini" onclick="downloadDocument('form-riwayat-pengusahaan')" title="Download">
                    <i class="fas fa-download"></i>
                  </button>
                </div>
              </div>
            </div>

            <div class="doc-card">
              <div class="doc-card__content">
                <div class="doc-card__icon">
                  <i class="fas fa-file-pdf"></i>
                </div>
                <div class="doc-card__info">
                  <p class="doc-card__name">Berita Acara Kesepakatan Batas & Tidak Sengketa</p>
                  <span class="doc-card__size">Template PDF</span>
                </div>
                <div class="doc-card__action">
                  <button type="button" class="btn-download-mini" onclick="downloadDocument('berita-acara-kesepakatan')" title="Download">
                    <i class="fas fa-download"></i>
                  </button>
                </div>
              </div>
            </div>

            <div class="doc-card">
              <div class="doc-card__content">
                <div class="doc-card__icon">
                  <i class="fas fa-file-pdf"></i>
                </div>
                <div class="doc-card__info">
                  <p class="doc-card__name">Berita Acara Kesaksian</p>
                  <span class="doc-card__size">Template PDF</span>
                </div>
                <div class="doc-card__action">
                  <button type="button" class="btn-download-mini" onclick="downloadDocument('berita-acara-kesaksian')" title="Download">
                    <i class="fas fa-download"></i>
                  </button>
                </div>
              </div>
            </div>

            <div class="doc-card">
              <div class="doc-card__content">
                <div class="doc-card__icon">
                  <i class="fas fa-file-word"></i>
                </div>
                <div class="doc-card__info">
                  <p class="doc-card__name">Surat Keterangan Waris</p>
                  <span class="doc-card__size">Template DOCX</span>
                </div>
                <div class="doc-card__action">
                  <button type="button" class="btn-download-mini" onclick="downloadDocument('surat-keterangan-waris')" title="Download">
                    <i class="fas fa-download"></i>
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- Footer -->
      <div class="modal-footer modal-green__footer">
        <small class="text-muted">
          <i class="fas fa-info-circle mr-1"></i> Sistem Informasi Kecamatan Biduk-Biduk
        </small>
        <button type="button" class="btn btn-outline-secondary ml-auto" data-dismiss="modal">
          <i class="fas fa-times mr-1"></i> Tutup
        </button>
      </div>
    </div>
  </div>
</div>


    {{-- <div class="modal fade" id="skptModal" tabindex="-1" role="dialog" aria-labelledby="skptModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="skptModalLabel">
                        <i class="fas fa-search me-2"></i>
                        Cek Validasi SKPT
                    </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="cekSkptForm">
                        <div class="form-group">
                            <label for="nomorRegistrasi" class="form-label">Nomor Registrasi SKPT</label>
                            <div class="form-group-inline">
                                <input type="text"
                                       class="form-control"
                                       id="nomorRegistrasi"
                                       name="nomor_registrasi"
                                       placeholder="Masukkan nomor registrasi"
                                       value="002">
                                <button type="submit" class="btn btn-cek">
                                    <i class="fas fa-search"></i>
                                    CEK
                                </button>
                            </div>
                        </div>
                    </form>

                    <!-- Status Result - Show by default -->
                    <div id="statusResult" style="display: block;">
                        <div class="status-container">
                            <div class="status-label">Status SKPT :</div>
                            <span class="status-badge status-peninjauan">
                                <i class="fas fa-clock me-1"></i>
                                PENINJAUAN
                            </span>
                        </div>
                    </div>
                    <!-- Loading State -->
                    <div id="loadingState" style="display: none; text-align: center; padding: 30px;">
                        <div class="spinner-border text-success" role="status" style="width: 3rem; height: 3rem;">
                            <span class="sr-only">Loading...</span>
                        </div>
                        <p class="mt-3" style="color: #7f8c8d;">Mencari data SKPT...</p>
                    </div>

                    <!-- No Data State -->
                    <div id="noDataState" style="display: none; text-align: center; padding: 30px;">
                        <i class="fas fa-search" style="font-size: 48px; color: #bdc3c7; margin-bottom: 15px;"></i>
                        <h6 style="color: #7f8c8d;">Data Tidak Ditemukan</h6>
                        <p class="text-muted small">Nomor registrasi yang Anda masukkan tidak ditemukan dalam sistem.</p>
                    </div>
                    <div id="documentSection" style="margin-top: 20px;">
                        <!-- Document List -->
                        <hr>
                        <div class="document-list">
                            <h6>
                                <i class="fas fa-download me-2"></i>
                                Download Dokumen
                            </h6>

                            <div class="document-item">
                                <i class="fas fa-file-pdf doc-icon"></i>
                                <span class="doc-name">Surat Pengantar RT</span>
                                <button type="button" class="btn btn-download" onclick="downloadDocument('surat-pengantar-rt')">
                                    <i class="fas fa-download"></i>
                                    Download
                                </button>
                            </div>

                            <div class="document-item">
                                <i class="fas fa-file-pdf doc-icon"></i>
                                <span class="doc-name">Surat Pengantar Kepala Kampung</span>
                                <button type="button" class="btn btn-download" onclick="downloadDocument('surat-pengantar-kades')">
                                    <i class="fas fa-download"></i>
                                    Download
                                </button>
                            </div>

                            <div class="document-item">
                                <i class="fas fa-file-pdf doc-icon"></i>
                                <span class="doc-name">Form Riwayat Pengusahaan Fisik Bidang Tanah</span>
                                <button type="button" class="btn btn-download" onclick="downloadDocument('form-riwayat-pengusahaan')">
                                    <i class="fas fa-download"></i>
                                    Download
                                </button>
                            </div>

                            <div class="document-item">
                                <i class="fas fa-file-pdf doc-icon"></i>
                                <span class="doc-name">Berita Acara Kesepakatan Batas dan Pernyataan Tidak Sengketa</span>
                                <button type="button" class="btn btn-download" onclick="downloadDocument('berita-acara-kesepakatan')">
                                    <i class="fas fa-download"></i>
                                    Download
                                </button>
                            </div>

                            <div class="document-item">
                                <i class="fas fa-file-pdf doc-icon"></i>
                                <span class="doc-name">Berita Acara Kesaksian</span>
                                <button type="button" class="btn btn-download" onclick="downloadDocument('berita-acara-kesaksian')">
                                    <i class="fas fa-download"></i>
                                    Download
                                </button>
                            </div>

                            <div class="document-item">
                                <i class="fas fa-file-pdf doc-icon"></i>
                                <span class="doc-name">Surat Keterangan Waris</span>
                                <button type="button" class="btn btn-download" onclick="downloadDocument('surat-keterangan-waris')">
                                    <i class="fas fa-download"></i>
                                    Download
                                </button>
                            </div>
                        </div>
                    </div>


                </div>
                <div class="modal-footer" style="border-top: 1px solid #ecf0f1; padding: 15px 25px;">
                    <small class="text-muted">
                        <i class="fas fa-info-circle me-1"></i>
                        Sistem Informasi Kecamatan Biduk-Biduk
                    </small>
                    <button type="button" class="btn btn-secondary ml-auto" data-dismiss="modal">
                        <i class="fas fa-times me-1"></i>
                        Tutup
                    </button>
                </div>
            </div>
        </div>
    </div> --}}

    <!-- Bootstrap 4 JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.0/js/bootstrap.bundle.min.js"></script>

    <script>
        $(document).ready(function() {
            // Form submission with loading state
            $('#loginForm').on('submit', function() {
                var submitBtn = $('#submitBtn');
                var submitText = $('#submitText');

                submitBtn.addClass('loading').prop('disabled', true);
                submitText.text('Memproses...');

                // Re-enable after 10 seconds to prevent permanent disable
                setTimeout(function() {
                    if (submitBtn.hasClass('loading')) {
                        submitBtn.removeClass('loading').prop('disabled', false);
                        submitText.text('Submit');
                    }
                }, 10000);
            });

            // Input focus effects
            $('.form-control').on('focus', function() {
                $(this).closest('.form-group').find('.input-icon').css('color', '#1abc9c');
            });

            $('.form-control').on('blur', function() {
                $(this).closest('.form-group').find('.input-icon').css('color', '#bdc3c7');
            });

            // Auto-hide alerts after 5 seconds
            setTimeout(function() {
                $('.alert').fadeOut();
            }, 5000);

            // Menu toggle click handler
            $('.menu-toggle').on('click', function(e) {
                e.preventDefault();
                console.log('Menu toggle clicked'); // Debug log
                $('#skptModal').modal('show');
            });

            // SKPT Form submission

        });

        // Download document function
        function downloadDocument(docType) {
            // Show loading state on button
            var clickedButton = event.target.closest('.btn-download');
            var originalText = clickedButton.innerHTML;

            clickedButton.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Downloading...';
            clickedButton.disabled = true;

            var docNames = {
                'surat-pengantar-rt': 'surat_pengantar_ketua_rt.docx',
                'surat-pengantar-kades': 'surat_pengantar_kepala_kampung.docx',
                'form-riwayat-pengusahaan': 'riwayat_penguasaan_fisik_bidang_tanah.docx',
                'berita-acara-kesepakatan': 'berita acara kesepakatan batas dan pernyataan tidak sengketa.pdf',
                'berita-acara-kesaksian': 'berita acara kesaksian.pdf',
                'surat-keterangan-waris': 'surat_keterangan_waris.docx'
            };

            // Trigger actual download from file-pendukung folder
            var fileName = docNames[docType];
            var downloadUrl = '/file-pendukung/' + fileName;

            // Create temporary link for download
            var link = document.createElement('a');
            link.href = downloadUrl;
            link.download = fileName;
            link.target = '_blank';
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);

            // Reset button state after a short delay
            setTimeout(function() {
                clickedButton.innerHTML = originalText;
                clickedButton.disabled = false;

                // Show success message
                var toast = $('<div class="alert alert-success" style="position: fixed; top: 20px; right: 20px; z-index: 9999; min-width: 300px;">' +
                    '<i class="fas fa-check-circle me-2"></i>' +
                    'Download berhasil: ' + fileName +
                    '</div>');

                $('body').append(toast);

                setTimeout(function() {
                    toast.fadeOut(function() {
                        $(this).remove();
                    });
                }, 3000);
            }, 500);
        }
    </script>
<script>
function applyStatusUI(statusText){
  const badge = document.querySelector('#statusResult .status-badge');
  const dot   = document.querySelector('#statusResult .status-dot');
  if(!badge || !dot) return;

  // reset kelas
  badge.classList.remove('is-success','is-danger','is-warning');
  dot.classList.remove('pulse-success','pulse-danger','pulse-warning');

  let icon = '<i class="fas fa-clock mr-1"></i>';
  if (statusText === 'SELESAI') {
    badge.classList.add('is-success');
    dot.classList.add('pulse-success');
    icon = '<i class="fas fa-check-circle mr-1"></i>';
  } else if (statusText === 'BELUM SELESAI') {
    badge.classList.add('is-danger');
    dot.classList.add('pulse-danger');
    icon = '<i class="fas fa-times-circle mr-1"></i>';
  } else {
    badge.classList.add('is-warning');
    dot.classList.add('pulse-warning');
    icon = '<i class="fas fa-clock mr-1"></i>';
  }
  badge.innerHTML = icon + statusText;
}

// (opsional) Auto focus saat modal tampil
$('#skptModal').on('shown.bs.modal', function () {
  setTimeout(() => document.getElementById('nomorRegistrasi')?.focus(), 50);
});
</script>
<script>
$(function(){
    const $form         = $('#cekSkptForm');
    const $loading      = $('#loadingState');
    const $noData       = $('#noDataState');
    const $statusResult = $('#statusResult');
    const $badge        = $statusResult.find('.status-badge');

    function setLoading(on) {
        if (on) {
            $loading.show();
            $noData.hide();
            $statusResult.hide();
        } else {
            $loading.hide();
        }
    }

    function applyStatus(statusText) {
        let className = '';
        let icon = '';

        switch (statusText) {
            case 'SELESAI':
                className = 'badge-success'; // hijau
                icon = '<i class="fas fa-check-circle me-1"></i>';
                break;
            case 'BELUM SELESAI':
                className = 'badge-danger'; // merah
                icon = '<i class="fas fa-times-circle me-1"></i>';
                break;
            case 'PENINJAUAN':
            default:
                className = 'badge-warning'; // kuning
                icon = '<i class="fas fa-clock me-1"></i>';
                break;
        }

        $badge
            .removeClass('badge-success badge-danger badge-warning')
            .addClass(className)
            .html(icon + statusText);
    }

    $form.on('submit', function(e){
        e.preventDefault();
        setLoading(true);

        const nomor = $.trim($('#nomorRegistrasi').val() || '');
        if (!nomor) {
            alert('Silakan masukkan nomor registrasi SKPT.');
            setLoading(false);
            return;
        }
        $.ajax({
            method: 'POST',
            url: "{{ route('skpt.cek') }}",
            data: { nomor_registrasi: nomor },
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            dataType: 'json'
        })
        .done(function(resp){
            setLoading(false);
            applyStatusUI(resp.data.status);
            if (!resp || !resp.success) {
                $noData.show();
                return;
            }

            applyStatus(resp.data.status);
            $statusResult.show();
            $noData.hide();
        })
        .fail(function(xhr){
            setLoading(false);
            if (xhr.status === 404) {
                $noData.show();
                $statusResult.hide();
            } else {
                alert('Terjadi kesalahan. Silakan coba lagi.');
            }
        });
    });
});
</script>


</body>
</html>
