@extends('admin-layouts.master')

@section('title', 'Detail Permohonan SKPT')

@section('content')
<div class="row">
    <div class="col-12">
        <!-- Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h3 class="text-primary">Detail Permohonan SKPT</h3>
                <p class="text-muted mb-0">No. Registrasi: <span class="font-weight-bold">{{ $skpt->no_registrasi }}</span></p>
                <p class="text-muted mb-0">Terakhir Diperbarui: {{ $skpt->updated_at->format('d F Y, H:i') }} WITA</p>
            </div>
            <div>
                <a href="{{ route('skpt.index') }}" class="btn btn-sm btn-secondary">
                    <i class="fas fa-arrow-left"></i> Kembali
                </a>
                <a href="{{ route('skpt.edit', $skpt->id) }}" class="btn btn-sm btn-warning">
                    <i class="fas fa-edit"></i> Edit
                </a>
                <button class="btn btn-sm btn-danger" id="deleteBtn" data-id="{{ $skpt->id }}">
                    <i class="fas fa-trash"></i> Hapus
                </button>
            </div>
        </div>

        <!-- Status Card -->
        <div class="card mb-4 shadow-sm">
            <div class="card-header text-white d-flex justify-content-between align-items-center">
                <h6>Status Permohonan</h6>
                <span class="badge badge-{{ $skpt->status_permohonan === 'SELESAI' ? 'success' : ($skpt->status_permohonan === 'BELUM SELESAI' ? 'danger' : 'warning') }} text-white">
                    {{ ucfirst($skpt->status_permohonan) }}
                </span>
            </div>
            <div class="card-body">
                <p class="mb-0"><strong>Tanggal Pengajuan:</strong> {{ $skpt->tgl_permohonan->format('d F Y') }}</p>
                <p class="mb-0"><strong>Tanggal Penerimaan:</strong> {{ $skpt->tgl_penerimaan->format('d F Y') }}</p>
                <p class="mb-0"><strong>Verifikasi:</strong> {{ $skpt->verification_status ?? 'Belum Diverifikasi' }}</p>
                <p class="mb-0"><strong>Catatan Verifikasi:</strong> {{ $skpt->verification_notes ?? 'Tidak ada catatan' }}</p>
            </div>
        </div>

        <!-- Data Pemohon dan Tanah -->
        <div class="card mb-4 shadow-sm">
            <div class="card-header text-white">
                <h6>Informasi Pemohon dan Tanah</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <h6 class="text-info">Data Pemohon</h6>
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item"><strong>Nama:</strong> {{ $skpt->nama_pemohon }}</li>
                            <li class="list-group-item"><strong>NIK/No. KTP:</strong> {{ $skpt->nik }}</li>
                            <li class="list-group-item"><strong>Tempat, Tanggal Lahir:</strong> {{ $skpt->tempat_lahir }}, {{ $skpt->tanggal_lahir->format('d F Y') }}</li>
                            <li class="list-group-item"><strong>Email:</strong> {{ $skpt->email ?? 'Tidak ada' }}</li>
                            <li class="list-group-item"><strong>Telepon:</strong> {{ $skpt->telepon ?? 'Tidak ada' }}</li>
                            <li class="list-group-item"><strong>Pekerjaan:</strong> {{ $skpt->pekerjaan }}</li>
                            <li class="list-group-item"><strong>Alamat:</strong> RT {{ $skpt->alamat_rt }}/RW {{ $skpt->alamat_rw }}, Kode Pos {{ $skpt->alamat_kode_pos }}</li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <h6 class="text-info">Detail Tanah</h6>
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item"><strong>Letak Tanah:</strong> {{ $skpt->letak_tanah }}</li>
                            <li class="list-group-item"><strong>Alamat Tanah:</strong> RT {{ $skpt->tanah_rt }}/RW {{ $skpt->tanah_rw }}, Kode Pos {{ $skpt->tanah_kode_pos }}</li>
                            <li class="list-group-item"><strong>Dusun:</strong> {{ $skpt->dusun }}</li>
                            <li class="list-group-item"><strong>Kelurahan/Kampung:</strong> {{ $skpt->kelurahan_kampung }}</li>
                            <li class="list-group-item"><strong>Peruntukan:</strong> {{ $skpt->peruntukan }}</li>
                            <li class="list-group-item"><strong>Luas:</strong> {{ $skpt->luas }} m²</li>
                            <li class="list-group-item"><strong>Penanda Tanah:</strong> {{ $skpt->penanda_tanah }}</li>
                            <li class="list-group-item"><strong>Batas:</strong> U: {{ $skpt->utara }}, S: {{ $skpt->selatan }}, T: {{ $skpt->timur }}, B: {{ $skpt->barat }}</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Dokumen Wajib -->
        <div class="card mb-4 shadow-sm">
            <div class="card-header text-white d-flex justify-content-between align-items-center">
                <h6>Daftar Dokumen Wajib</h6>
                <button class="btn btn-sm btn-light" id="toggleDocs">Toggle All</button>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead>
                            <tr>
                                <th>Jenis Dokumen</th>
                                <th>Status Unggah</th>
                                <th>Status Verifikasi</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody id="documentsTable">
                            @forelse($skpt->documents->where('is_additional', false) as $document)
                                <tr class="document-row">
                                    <td>{{ $document->document_name }}</td>
                                    <td>
                                        <span class="badge badge-{{ $document->is_uploaded ? 'success' : 'danger' }} text-white">
                                            {{ $document->is_uploaded ? 'Terunggah' : 'Belum Terunggah' }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge badge-{{ $document->verification_status === 'SUDAH' ? 'success' : ($document->verification_status === 'DITOLAK' ? 'danger' : 'warning') }} text-white">
                                            {{ $document->verification_status ?? 'Pending' }}
                                        </span>
                                    </td>
                                    <td>
                                        @if($document->is_uploaded && $document->file_path)
                                            <a href="{{ asset('storage/' . $document->file_path) }}" class="btn btn-sm btn-info mr-1" target="_blank" download>
                                                <i class="fas fa-download"></i> Unduh
                                            </a>
                                        @endif
                                        @if($document->is_uploaded && !$document->verified_at)
                                            <button class="btn btn-sm btn-success verify-btn mr-1" data-skpt="{{ $skpt->id }}" data-document="{{ $document->id }}" data-toggle="modal" data-target="#verifyModal" data-name="{{ $document->document_name }}">
                                                <i class="fas fa-check"></i> Sudah Sesuai
                                            </button>
                                            <button class="btn btn-sm btn-danger verify-btn" data-skpt="{{ $skpt->id }}" data-document="{{ $document->id }}" data-toggle="modal" data-target="#verifyModal" data-name="{{ $document->document_name }}">
                                                <i class="fas fa-times"></i> Tidak Sesuai
                                            </button>
                                        @else
                                            @if($document->verification_status === 'DITOLAK')
                                                <button class="btn btn-sm btn-success verify-btn mr-1" data-skpt="{{ $skpt->id }}" data-document="{{ $document->id }}" data-toggle="modal" data-target="#verifyModal" data-name="{{ $document->document_name }}">
                                                    <i class="fas fa-check"></i> Sudah Sesuai
                                                </button>
                                                <button class="btn btn-sm btn-danger verify-btn" data-skpt="{{ $skpt->id }}" data-document="{{ $document->id }}" data-toggle="modal" data-target="#verifyModal" data-name="{{ $document->document_name }}">
                                                    <i class="fas fa-times"></i> Tidak Sesuai
                                                </button>
                                            @else
                                                <span class="text-muted">Tidak dapat diverifikasi</span>
                                            @endif
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="text-center">Tidak ada dokumen wajib yang terdaftar.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Dokumen Tambahan -->
        <div class="card mb-4 shadow-sm">
            <div class="card-header text-white">
                <h6>Daftar Dokumen Tambahan</h6>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead>
                            <tr>
                                <th>Jenis Dokumen</th>
                                <th>Status Unggah</th>
                                <th>Status Verifikasi</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody id="additionalDocumentsTable">
                            @forelse($skpt->additionalDocuments as $document)
                                <tr class="document-row">
                                    <td>{{ $document->document_name }}</td>
                                    <td>
                                        <span class="text-white badge badge-{{ $document->is_uploaded ? 'success' : 'danger' }}">
                                            {{ $document->is_uploaded ? 'Terunggah' : 'Belum Terunggah' }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="text-white badge badge-{{ $document->verification_status === 'SUDAH' ? 'success' : ($document->verification_status === 'DITOLAK' ? 'danger' : 'warning') }}">
                                            {{ $document->verification_status ?? 'Pending' }}
                                        </span>
                                    </td>
                                    <td>
                                        @if($document->is_uploaded && $document->file_path)
                                            <a href="{{ asset('storage/' . $document->file_path) }}" class="btn btn-sm btn-info mr-1" target="_blank" download>
                                                <i class="fas fa-download"></i> Unduh
                                            </a>
                                        @endif
                                        @if($document->is_uploaded && !$document->verified_at)
                                            <button class="btn btn-sm btn-success verify-btn mr-1" data-skpt="{{ $skpt->id }}" data-document="{{ $document->id }}" data-toggle="modal" data-target="#verifyModal" data-name="{{ $document->document_name }}">
                                                <i class="fas fa-check"></i> Sudah Sesuai
                                            </button>
                                            <button class="btn btn-sm btn-danger verify-btn" data-skpt="{{ $skpt->id }}" data-document="{{ $document->id }}" data-toggle="modal" data-target="#verifyModal" data-name="{{ $document->document_name }}">
                                                <i class="fas fa-times"></i> Tidak Sesuai
                                            </button>
                                        @else
                                            @if($document->verification_status === 'DITOLAK')
                                                <button class="btn btn-sm btn-success verify-btn mr-1" data-skpt="{{ $skpt->id }}" data-document="{{ $document->id }}" data-toggle="modal" data-target="#verifyModal" data-name="{{ $document->document_name }}">
                                                    <i class="fas fa-check"></i> Sudah Sesuai
                                                </button>
                                                <button class="btn btn-sm btn-danger verify-btn" data-skpt="{{ $skpt->id }}" data-document="{{ $document->id }}" data-toggle="modal" data-target="#verifyModal" data-name="{{ $document->document_name }}">
                                                    <i class="fas fa-times"></i> Tidak Sesuai
                                                </button>
                                            @else
                                                <span class="text-muted">Tidak dapat diverifikasi</span>
                                            @endif
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="text-center">Tidak ada dokumen tambahan yang terdaftar.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal Verifikasi -->
<div class="modal fade" id="verifyModal" tabindex="-1" aria-labelledby="verifyModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-gradient-success text-white">
                <h5 class="modal-title" id="verifyModalLabel">Verifikasi Dokumen</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{ route('skpt.additional-documents.verify', ['skpt' => ':skpt', 'additional_document' => ':document']) }}" method="POST" id="verifyForm">
                @csrf
                <input type="hidden" name="skpt" id="skptId">
                <input type="hidden" name="additional_document" id="documentId">
                <input type="hidden" name="action" id="verifyAction">
                <div class="modal-body">
                    <p>Apakah Anda yakin ingin mengubah status verifikasi untuk dokumen <strong><span id="docName"></span></strong>?</p>
                    <div class="form-group">
                        <label for="notes">Catatan (Opsional)</label>
                        <textarea class="form-control" id="notes" name="notes" rows="3" maxlength="1000" placeholder="Tambahkan catatan jika diperlukan"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-success">Konfirmasi</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
$(document).ready(function() {
    // Toggle visibility of document rows
    $('#toggleDocs').click(function() {
        $('#documentsTable .document-row').toggle();
        $('#additionalDocumentsTable .document-row').toggle();
        $(this).text(function(i, text) {
            return text === 'Toggle All' ? 'Hide All' : 'Toggle All';
        });
    });

    // Delete confirmation
    $('#deleteBtn').click(function() {
        if (confirm('Apakah Anda yakin ingin menghapus permohonan ini?')) {
            window.location.href = '{{ route('skpt.destroy', ':id') }}'.replace(':id', $(this).data('id'));
        }
    });

    // Show all documents by default
    $('#documentsTable .document-row').show();
    $('#additionalDocumentsTable .document-row').show();

    // Handle verify button click
    $('.verify-btn').click(function() {
        const skptId = $(this).data('skpt');
        const documentId = $(this).data('document');
        const docName = $(this).data('name');
        const action = $(this).hasClass('btn-success') ? 'approve' : 'reject';
        const isAdditional = $(this).closest('tbody').attr('id') === 'additionalDocumentsTable';

        // Update form action with dynamic route parameters
        let formAction;
        if (isAdditional) {
            formAction = '{{ route('skpt.additional-documents.verify', ['skpt' => ':skpt', 'additional_document' => ':document']) }}'
                .replace(':skpt', skptId)
                .replace(':document', documentId);
        } else {
            formAction = '{{ route('skpt.documents.verify', ['skpt' => ':skpt', 'document' => ':document']) }}'
                .replace(':skpt', skptId)
                .replace(':document', documentId);
        }
        $('#verifyForm').attr('action', formAction);

        $('#skptId').val(skptId);
        $('#documentId').val(documentId);
        $('#verifyAction').val(action);
        $('#docName').text(docName);
        $('#verifyModalLabel').text(action === 'approve' ? 'Verifikasi Dokumen (Sudah Sesuai)' : 'Tolak Dokumen (Tidak Sesuai)');
    });

    // Handle form submission with confirmation
    $('#verifyForm').on('submit', function(e) {
        if (!confirm('Apakah Anda yakin dengan keputusan ini?')) {
            e.preventDefault();
        }
    });

    // Handle SweetAlert on page load for session messages
    @if(session('success'))
        Swal.fire({
            icon: 'success',
            title: 'Sukses!',
            text: '{{ session('success') }}',
            confirmButtonText: 'OK',
            confirmButtonColor: '#1cc88a',
        });
    @endif

    @if(session('error'))
        Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: '{{ session('error') }}',
            confirmButtonText: 'OK',
            confirmButtonColor: '#e74a3b',
        });
    @endif
});
</script>
@endpush

@push('styles')
<style>
.card-header.bg-gradient-primary {
    background: linear-gradient(45deg, #4e73df, #224abe);
}
.card-header.bg-gradient-info {
    background: linear-gradient(45deg, #36b9cc, #1c8da0);
}
.card-header.bg-gradient-success {
    background: linear-gradient(45deg, #1cc88a, #17a673);
}
.list-group-item {
    border: none;
    padding: 0.5rem 1rem;
    background-color: #f8f9fc;
}
.table-responsive {
    overflow-x: auto;
}
.badge-success { background-color: #1cc88a; }
.badge-danger { background-color: #e74a3b; }
.badge-warning { background-color: #f6c23e; }
.btn-info { color: #fff; }
.alert { margin-bottom: 1rem; }
.modal-header.bg-gradient-success {
    background: linear-gradient(45deg, #1cc88a, #17a673);
}
.modal-body p { font-size: 1.1em; }
</style>
@endpush