@extends('admin-layouts.master')

@section('title', 'Daftar Permohonan SKPT')

@section('content')
<div class="row">
    <div class="col-12">
        <!-- Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h2 class="h4 mb-1">Daftar Permohonan SKPT</h2>
                <p class="text-muted mb-0">Kelola semua permohonan Surat Keterangan Penguasaan Tanah</p>
            </div>
            <a href="{{ route('skpt.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Tambah Permohonan
            </a>
        </div>

        <!-- Stats Cards -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card border-left-primary shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                    Total Permohonan</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $applications->total() }}</div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-file-alt fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-left-success shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                    Selesai</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                    {{ $applications->where('status_permohonan', 'SELESAI')->count() }}
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-left-warning shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                    Menunggu</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                    {{ $applications->where('status_permohonan', 'BELUM SELESAI')->count() }}
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-clock fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-left-info shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                    Dokumen Lengkap</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                    {{ $applications->where('status_kelengkapan_dokumen', 'LENGKAP')->count() }}
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-folder-open fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filter & Search -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Filter & Pencarian</h6>
            </div>
            <div class="card-body">
                <form method="GET" action="{{ route('skpt.index') }}" class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="search">Pencarian</label>
                            <input type="text" class="form-control form-control-sm" 
                                   id="search" name="search" 
                                   placeholder="NIK, Nama, atau No. Registrasi"
                                   value="{{ request('search') }}">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="year">Tahun</label>
                            <select class="form-control form-control-sm" id="year" name="year">
                                <option value="">Semua Tahun</option>
                                @foreach($years as $year)
                                    <option value="{{ $year }}" {{ request('year') == $year ? 'selected' : '' }}>
                                        {{ $year }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="status">Status Permohonan</label>
                            <select class="form-control form-control-sm" id="status" name="status">
                                <option value="">Semua Status</option>
                                <option value="BELUM SELESAI" {{ request('status') == 'BELUM SELESAI' ? 'selected' : '' }}>
                                    Belum Selesai
                                </option>
                                <option value="SELESAI" {{ request('status') == 'SELESAI' ? 'selected' : '' }}>
                                    Selesai
                                </option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="document_status">Kelengkapan Dokumen</label>
                            <select class="form-control form-control-sm" id="document_status" name="document_status">
                                <option value="">Semua</option>
                                <option value="LENGKAP" {{ request('document_status') == 'LENGKAP' ? 'selected' : '' }}>
                                    Lengkap
                                </option>
                                <option value="BELUM LENGKAP" {{ request('document_status') == 'BELUM LENGKAP' ? 'selected' : '' }}>
                                    Belum Lengkap
                                </option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-1">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div>
                                <button type="submit" class="btn btn-primary btn-sm">
                                    <i class="fas fa-search"></i>
                                </button>
                                <a href="{{ route('skpt.index') }}" class="btn btn-secondary btn-sm ml-1">
                                    <i class="fas fa-times"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Data Table -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Data Permohonan SKPT</h6>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th width="10%">No. Registrasi</th>
                                <th width="15%">Pemohon</th>
                                <th width="20%">Alamat</th>
                                <th width="15%">Kelengkapan Dokumen</th>
                                <th width="15%">Status Permohonan</th>
                                <th width="10%">Tanggal</th>
                                <th width="15%">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($applications as $app)
                            <tr>
                                <td>
                                    <strong class="text-primary">{{ $app->no_registrasi }}</strong>
                                </td>
                                <td>
                                    <div class="font-weight-bold">{{ $app->nama_pemohon }}</div>
                                    <small class="text-muted">NIK: {{ $app->nik }}</small>
                                </td>
                                <td>
                                    <small>{{ $app->letak_tanah }}</small><br>
                                    <small class="text-muted">{{ $app->kelurahan_kampung }}</small>
                                </td>
                                <td>
                                    @if($app->status_kelengkapan_dokumen == 'LENGKAP')
                                        <span class="badge badge-success">
                                            <i class="fas fa-check"></i> Lengkap
                                        </span>
                                    @else
                                        <span class="badge badge-danger">
                                            <i class="fas fa-exclamation-triangle"></i> Belum Lengkap
                                        </span>
                                    @endif
                                </td>
                                <td>
                                    @if($app->status_permohonan == 'SELESAI')
                                        <span class="badge badge-success">
                                            <i class="fas fa-check-circle"></i> Selesai
                                        </span>
                                    @else
                                        <span class="badge badge-warning">
                                            <i class="fas fa-clock"></i> Belum Selesai
                                        </span>
                                    @endif
                                </td>
                                <td>
                                    <small>{{ $app->tgl_penerimaan->format('d/m/Y') }}</small>
                                </td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="{{ route('skpt.show', $app) }}" 
                                           class="btn btn-sm btn-outline-primary" 
                                           data-toggle="tooltip" title="Lihat Detail">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('skpt.edit', $app) }}" 
                                           class="btn btn-sm btn-outline-warning"
                                           data-toggle="tooltip" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <button type="button" 
                                                class="btn btn-sm btn-outline-danger" 
                                                data-toggle="tooltip" title="Hapus"
                                                onclick="confirmDelete('{{ $app->no_registrasi }}', '{{ route('skpt.destroy', $app) }}')">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                        <button type="button" 
                                                class="btn btn-sm btn-outline-success update-status" 
                                                data-toggle="tooltip" title="Tandai Selesai"
                                                data-id="{{ $app->id }}"
                                                data-status="SELESAI">
                                            <i class="fas fa-check"></i>
                                        </button>
                                        <button type="button" 
                                                class="btn btn-sm btn-outline-warning update-status" 
                                                data-toggle="tooltip" title="Tandai Belum Selesai"
                                                data-id="{{ $app->id }}"
                                                data-status="BELUM SELESAI">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="7" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-inbox fa-3x mb-3"></i>
                                        <h5>Tidak ada data</h5>
                                        <p>Belum ada permohonan SKPT yang tersedia</p>
                                        <a href="{{ route('skpt.create') }}" class="btn btn-primary">
                                            <i class="fas fa-plus"></i> Tambah Permohonan Pertama
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                @if($applications->hasPages())
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="showing-info">
                        <small class="text-muted">
                            Menampilkan {{ $applications->firstItem() }} - {{ $applications->lastItem() }} 
                            dari {{ $applications->total() }} data
                        </small>
                    </div>
                    {{ $applications->links() }}
                </div>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Konfirmasi Hapus</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Apakah Anda yakin ingin menghapus permohonan SKPT <strong id="deleteItemName"></strong>?</p>
                <p class="text-danger"><small>Tindakan ini tidak dapat dibatalkan dan akan menghapus semua dokumen terkait.</small></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                <form id="deleteForm" method="POST" style="display: inline;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">
                        <i class="fas fa-trash"></i> Hapus
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmDelete(itemName, deleteUrl) {
    $('#deleteItemName').text(itemName);
    $('#deleteForm').attr('action', deleteUrl);
    $('#deleteModal').modal('show');
}

// Initialize tooltips
$(function () {
    $('[data-toggle="tooltip"]').tooltip();
});

// Update status permohonan
$('.update-status').on('click', function() {
    const id = $(this).data('id');
    const status = $(this).data('status');
    const currentStatus = $(this).closest('tr').find('td:nth-child(5)').text().trim();
    
    if (currentStatus === status) {
        Swal.fire({
            icon: 'info',
            title: 'Informasi',
            text: 'Status sudah ' + (status === 'SELESAI' ? 'selesai' : 'belum selesai') + '!',
            confirmButtonText: 'OK',
            confirmButtonColor: '#1cc88a',
        });
        return;
    }

    Swal.fire({
        title: 'Konfirmasi',
        text: 'Apakah Anda yakin ingin mengubah status permohonan menjadi ' + (status === 'SELESAI' ? 'Selesai' : 'Belum Selesai') + '?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#1cc88a',
        cancelButtonColor: '#e74a3b',
        confirmButtonText: 'Ya',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: '{{ route("skpt.updateStatus", ":id") }}'.replace(':id', id),
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    status: status
                },
                success: function(response) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Sukses!',
                        text: 'Status permohonan berhasil diperbarui.',
                        confirmButtonText: 'OK',
                        confirmButtonColor: '#1cc88a',
                    }).then(() => {
                        location.reload();
                    });
                },
                error: function(xhr) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: 'Gagal memperbarui status permohonan.',
                        confirmButtonText: 'OK',
                        confirmButtonColor: '#e74a3b',
                    });
                }
            });
        }
    });
});

// Success/Error Messages
@if(session('success'))
    $(document).ready(function() {
        Swal.fire({
            icon: 'success',
            title: 'Sukses!',
            text: '{{ session('success') }}',
            confirmButtonText: 'OK',
            confirmButtonColor: '#1cc88a',
        });
    });
@endif

@if(session('error'))
    $(document).ready(function() {
        Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: '{{ session('error') }}',
            confirmButtonText: 'OK',
            confirmButtonColor: '#e74a3b',
        });
    });
@endif
</script>
@endpush

@push('styles')
<style>
.border-left-primary {
    border-left: 0.25rem solid #4e73df !important;
}
.border-left-success {
    border-left: 0.25rem solid #1cc88a !important;
}
.border-left-info {
    border-left: 0.25rem solid #36b9cc !important;
}
.border-left-warning {
    border-left: 0.25rem solid #f6c23e !important;
}

.table-hover tbody tr:hover {
    background-color: rgba(0,0,0,.02);
}

.btn-group .btn {
    margin: 0 1px;
}

.card {
    box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15) !important;
}
</style>
@endpush