@extends('admin-layouts.master')

@section('title', 'Edit Permohonan SKPT')

@section('content')
<div class="container-fluid">
    <!-- Page Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="text-primary mb-2">Edit Permohonan SKPT</h1>
            <p class="text-muted mb-0">
                No. Registrasi: <span class="font-weight-bold">{{ $skpt->no_registrasi }}</span> |
                Status: <span class="badge badge-{{ $skpt->status_permohonan === 'SELESAI' ? 'success' : ($skpt->status_permohonan === 'BELUM SELESAI' ? 'danger' : 'warning') }}">
                    {{ ucfirst($skpt->status_permohonan) }}
                </span>
            </p>
        </div>
        <div class="d-flex gap-2">
            <a href="{{ route('skpt.index') }}" class="btn btn-secondary mr-2">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
            <a href="{{ route('skpt.show', $skpt->id) }}" class="btn btn-info">
                <i class="fas fa-eye"></i> Lihat Detail
            </a>
        </div>
    </div>

    <!-- Form Edit -->
    <form action="{{ route('skpt.update', $skpt->id) }}" method="POST" id="skptForm" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        <input type="hidden" name="nik" id="nik" value="{{ old('nik', $skpt->nik) }}">

        <div class="row">
            <!-- Data Pemohon & Detail Tanah -->
            <div class="col-lg-8">
                <!-- Informasi Tanggal -->
                <div class="card card-primary mb-4">
                    <div class="card-header">
                        <h5><i class="fas fa-calendar-alt"></i> Informasi Permohonan</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Tanggal Penerimaan</label>
                                    <input type="date" class="form-control @error('tgl_penerimaan') is-invalid @enderror"
                                           name="tgl_penerimaan" value="{{ old('tgl_penerimaan', $skpt->tgl_penerimaan->format('Y-m-d')) }}">
                                    @error('tgl_penerimaan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Tanggal Permohonan</label>
                                    <input type="date" class="form-control @error('tgl_permohonan') is-invalid @enderror"
                                           name="tgl_permohonan" value="{{ old('tgl_permohonan', $skpt->tgl_permohonan->format('Y-m-d')) }}">
                                    @error('tgl_permohonan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Data Pemohon -->
                <div class="card card-success mb-4">
                    <div class="card-header">
                        <h5><i class="fas fa-user"></i> Data Pemohon</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Nama Lengkap</label>
                                    <input type="text" class="form-control @error('nama_pemohon') is-invalid @enderror"
                                           name="nama_pemohon" value="{{ old('nama_pemohon', $skpt->nama_pemohon) }}"
                                           placeholder="Masukkan nama lengkap">
                                    @error('nama_pemohon')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">No. KTP/NIK</label>
                                    <input type="text" class="form-control @error('no_ktp') is-invalid @enderror"
                                           name="no_ktp" value="{{ old('no_ktp', $skpt->no_ktp) }}" maxlength="16"
                                           placeholder="16 digit nomor KTP">
                                    @error('no_ktp')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Tempat Lahir</label>
                                    <input type="text" class="form-control @error('tempat_lahir') is-invalid @enderror"
                                           name="tempat_lahir" value="{{ old('tempat_lahir', $skpt->tempat_lahir) }}"
                                           placeholder="Kota/Kabupaten lahir">
                                    @error('tempat_lahir')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Tanggal Lahir</label>
                                    <input type="date" class="form-control @error('tanggal_lahir') is-invalid @enderror"
                                           name="tanggal_lahir" value="{{ old('tanggal_lahir', $skpt->tanggal_lahir->format('Y-m-d')) }}">
                                    @error('tanggal_lahir')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Email</label>
                                    <input type="email" class="form-control @error('email') is-invalid @enderror"
                                           name="email" value="{{ old('email', $skpt->email) }}"
                                           placeholder="nama@email.com">
                                    @error('email')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">No. Telepon</label>
                                    <input type="tel" class="form-control @error('telepon') is-invalid @enderror"
                                           name="telepon" value="{{ old('telepon', $skpt->telepon) }}"
                                           placeholder="081234567890">
                                    @error('telepon')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Pekerjaan</label>
                                    <input type="text" class="form-control @error('pekerjaan') is-invalid @enderror"
                                           name="pekerjaan" value="{{ old('pekerjaan', $skpt->pekerjaan) }}"
                                           placeholder="Profesi/Pekerjaan">
                                    @error('pekerjaan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Alamat (RT/RW/No)</label>
                                    <div class="row">
                                        <div class="col-4">
                                            <input type="text" class="form-control @error('alamat_rt') is-invalid @enderror"
                                                   name="alamat_rt" value="{{ old('alamat_rt', $skpt->alamat_rt) }}"
                                                   placeholder="RT" maxlength="3">
                                            @error('alamat_rt')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="col-4">
                                            <input type="text" class="form-control @error('alamat_rw') is-invalid @enderror"
                                                   name="alamat_rw" value="{{ old('alamat_rw', $skpt->alamat_rw) }}"
                                                   placeholder="RW" maxlength="3">
                                            @error('alamat_rw')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="col-4">
                                            <input type="text" class="form-control @error('alamat_kode_pos') is-invalid @enderror"
                                                   name="alamat_kode_pos" value="{{ old('alamat_kode_pos', $skpt->alamat_kode_pos) }}"
                                                   placeholder="No" maxlength="5">
                                            @error('alamat_kode_pos')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Detail Tanah -->
                <div class="card card-info mb-4">
                    <div class="card-header">
                        <h5><i class="fas fa-map-marker-alt"></i> Detail Tanah</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Letak Tanah</label>
                                    <input type="text" class="form-control @error('letak_tanah') is-invalid @enderror"
                                           name="letak_tanah" value="{{ old('letak_tanah', $skpt->letak_tanah) }}"
                                           placeholder="Lokasi/alamat tanah">
                                    @error('letak_tanah')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Alamat Tanah (RT/RW/No)</label>
                                    <div class="row">
                                        <div class="col-4">
                                            <input type="text" class="form-control @error('tanah_rt') is-invalid @enderror"
                                                   name="tanah_rt" value="{{ old('tanah_rt', $skpt->tanah_rt) }}"
                                                   placeholder="RT" maxlength="3">
                                            @error('tanah_rt')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="col-4">
                                            <input type="text" class="form-control @error('tanah_rw') is-invalid @enderror"
                                                   name="tanah_rw" value="{{ old('tanah_rw', $skpt->tanah_rw) }}"
                                                   placeholder="RW" maxlength="3">
                                            @error('tanah_rw')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="col-4">
                                            <input type="text" class="form-control @error('tanah_kode_pos') is-invalid @enderror"
                                                   name="tanah_kode_pos" value="{{ old('tanah_kode_pos', $skpt->tanah_kode_pos) }}"
                                                   placeholder="No" maxlength="5">
                                            @error('tanah_kode_pos')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Dusun</label>
                                    <input type="text" class="form-control @error('dusun') is-invalid @enderror"
                                           name="dusun" value="{{ old('dusun', $skpt->dusun) }}"
                                           placeholder="Nama dusun">
                                    @error('dusun')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Kelurahan/Kampung</label>
                                    <select class="form-control @error('kelurahan_kampung') is-invalid @enderror"
                                            name="kelurahan_kampung">
                                        <option value="">Pilih Kelurahan/Kampung</option>
                                        @foreach($data_kampung as $kampung)
                                            <option value="{{ $kampung->nama_kampung }}"
                                                {{ old('kelurahan_kampung') == $kampung->nama_kampung ? 'selected' : '' }}>
                                                {{ $kampung->nama_kampung }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('kelurahan_kampung')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-label">Peruntukan</label>
                                    <select class="form-control @error('peruntukan') is-invalid @enderror" name="peruntukan">
                                        <option value="">Pilih Peruntukan</option>
                                        <option value="Perkebunan" {{ old('peruntukan', $skpt->peruntukan) == 'Perkebunan' ? 'selected' : '' }}>Perkebunan</option>
                                        <option value="Pertanian" {{ old('peruntukan', $skpt->peruntukan) == 'Pertanian' ? 'selected' : '' }}>Pertanian</option>
                                        <option value="Perumahan" {{ old('peruntukan', $skpt->peruntukan) == 'Perumahan' ? 'selected' : '' }}>Perumahan</option>
                                        <option value="Industri" {{ old('peruntukan', $skpt->peruntukan) == 'Industri' ? 'selected' : '' }}>Industri</option>
                                        <option value="Lainnya" {{ old('peruntukan', $skpt->peruntukan) == 'Lainnya' ? 'selected' : '' }}>Lainnya</option>
                                    </select>
                                    @error('peruntukan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-label">Luas Tanah</label>
                                    <div class="input-group">
                                        <input type="number" step="0.01" min="1"
                                               class="form-control @error('luas') is-invalid @enderror"
                                               name="luas" value="{{ old('luas', $skpt->luas) }}"
                                               placeholder="0.00">
                                        <div class="input-group-append">
                                            <span class="input-group-text">m²</span>
                                        </div>
                                    </div>
                                    @error('luas')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-label">Penanda Tanah</label>
                                    <select class="form-control @error('penanda_tanah') is-invalid @enderror" name="penanda_tanah">
                                        <option value="">Pilih Penanda</option>
                                        <option value="Batas Pagar" {{ old('penanda_tanah', $skpt->penanda_tanah) == 'Batas Pagar' ? 'selected' : '' }}>Batas Pagar</option>
                                        <option value="Batas Alam" {{ old('penanda_tanah', $skpt->penanda_tanah) == 'Batas Alam' ? 'selected' : '' }}>Batas Alam</option>
                                        <option value="Batas Bangunan" {{ old('penanda_tanah', $skpt->penanda_tanah) == 'Batas Bangunan' ? 'selected' : '' }}>Batas Bangunan</option>
                                        <option value="Lainnya" {{ old('penanda_tanah', $skpt->penanda_tanah) == 'Lainnya' ? 'selected' : '' }}>Lainnya</option>
                                    </select>
                                    @error('penanda_tanah')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Batas Tanah -->
                        <div class="row">
                            <div class="col-12">
                                <h6 class="text-info mb-3">Batas Tanah</h6>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-label">Utara</label>
                                    <select class="form-control @error('utara') is-invalid @enderror" name="utara">
                                        <option value="">Pilih Batas</option>
                                        <option value="Tanah Kosong" {{ old('utara', $skpt->utara) == 'Tanah Kosong' ? 'selected' : '' }}>Tanah Kosong</option>
                                        <option value="Rumah" {{ old('utara', $skpt->utara) == 'Rumah' ? 'selected' : '' }}>Rumah</option>
                                        <option value="Kebun" {{ old('utara', $skpt->utara) == 'Kebun' ? 'selected' : '' }}>Kebun</option>
                                        <option value="Jalan" {{ old('utara', $skpt->utara) == 'Jalan' ? 'selected' : '' }}>Jalan</option>
                                        <option value="Sungai" {{ old('utara', $skpt->utara) == 'Sungai' ? 'selected' : '' }}>Sungai</option>
                                        <option value="Lainnya" {{ old('utara', $skpt->utara) == 'Lainnya' ? 'selected' : '' }}>Lainnya</option>
                                    </select>
                                    @error('utara')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-label">Selatan</label>
                                    <select class="form-control @error('selatan') is-invalid @enderror" name="selatan">
                                        <option value="">Pilih Batas</option>
                                        <option value="Jalan Kampung" {{ old('selatan', $skpt->selatan) == 'Jalan Kampung' ? 'selected' : '' }}>Jalan Kampung</option>
                                        <option value="Rumah" {{ old('selatan', $skpt->selatan) == 'Rumah' ? 'selected' : '' }}>Rumah</option>
                                        <option value="Kebun" {{ old('selatan', $skpt->selatan) == 'Kebun' ? 'selected' : '' }}>Kebun</option>
                                        <option value="Tanah Kosong" {{ old('selatan', $skpt->selatan) == 'Tanah Kosong' ? 'selected' : '' }}>Tanah Kosong</option>
                                        <option value="Sungai" {{ old('selatan', $skpt->selatan) == 'Sungai' ? 'selected' : '' }}>Sungai</option>
                                        <option value="Lainnya" {{ old('selatan', $skpt->selatan) == 'Lainnya' ? 'selected' : '' }}>Lainnya</option>
                                    </select>
                                    @error('selatan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-label">Timur</label>
                                    <select class="form-control @error('timur') is-invalid @enderror" name="timur">
                                        <option value="">Pilih Batas</option>
                                        <option value="Tanah Kosong" {{ old('timur', $skpt->timur) == 'Tanah Kosong' ? 'selected' : '' }}>Tanah Kosong</option>
                                        <option value="Rumah" {{ old('timur', $skpt->timur) == 'Rumah' ? 'selected' : '' }}>Rumah</option>
                                        <option value="Kebun" {{ old('timur', $skpt->timur) == 'Kebun' ? 'selected' : '' }}>Kebun</option>
                                        <option value="Jalan" {{ old('timur', $skpt->timur) == 'Jalan' ? 'selected' : '' }}>Jalan</option>
                                        <option value="Sungai" {{ old('timur', $skpt->timur) == 'Sungai' ? 'selected' : '' }}>Sungai</option>
                                        <option value="Lainnya" {{ old('timur', $skpt->timur) == 'Lainnya' ? 'selected' : '' }}>Lainnya</option>
                                    </select>
                                    @error('timur')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-label">Barat</label>
                                    <select class="form-control @error('barat') is-invalid @enderror" name="barat">
                                        <option value="">Pilih Batas</option>
                                        <option value="Tanah Hasan" {{ old('barat', $skpt->barat) == 'Tanah Hasan' ? 'selected' : '' }}>Tanah Hasan</option>
                                        <option value="Rumah" {{ old('barat', $skpt->barat) == 'Rumah' ? 'selected' : '' }}>Rumah</option>
                                        <option value="Kebun" {{ old('barat', $skpt->barat) == 'Kebun' ? 'selected' : '' }}>Kebun</option>
                                        <option value="Tanah Kosong" {{ old('barat', $skpt->barat) == 'Tanah Kosong' ? 'selected' : '' }}>Tanah Kosong</option>
                                        <option value="Sungai" {{ old('barat', $skpt->barat) == 'Sungai' ? 'selected' : '' }}>Sungai</option>
                                        <option value="Lainnya" {{ old('barat', $skpt->barat) == 'Lainnya' ? 'selected' : '' }}>Lainnya</option>
                                    </select>
                                    @error('barat')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                 <!-- Data Anak -->
                <div class="card card-warning mb-4">
                    <div class="card-header">
                        <h5><i class="fas fa-child"></i> Data Anak (Maksimal 10 Anak)</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label>Data Anak (Maksimal 10 Anak)</label>
                            <div id="anakList">
                                {{-- Data anak akan di-append di sini --}}
                                @if(old('anak'))
                                    @foreach(old('anak') as $idx => $anak)
                                        <div class="row mb-2" id="anakRow{{ $idx }}">
                                            <div class="col-md-6">
                                                <input type="text" name="anak[{{ $idx }}][nama_anak]" class="form-control" placeholder="Nama Anak {{ $idx }}" value="{{ $anak['nama_anak'] ?? '' }}" required>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="number" name="anak[{{ $idx }}][usia]" class="form-control" placeholder="Usia" min="0" value="{{ $anak['usia'] ?? '' }}">
                                            </div>
                                            <div class="col-md-2">
                                                <button type="button" class="btn btn-danger" onclick="hapusAnak({{ $idx }})">Hapus</button>
                                            </div>
                                        </div>
                                    @endforeach
                                @else
                                    @foreach($skpt->anak as $idx => $anak)
                                        <div class="row mb-2" id="anakRow{{ $idx }}">
                                            <div class="col-md-6">
                                                <input type="text" name="anak[{{ $idx }}][nama_anak]" class="form-control" placeholder="Nama Anak {{ $idx }}" value="{{ $anak->nama_anak }}" required>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="number" name="anak[{{ $idx }}][usia]" class="form-control" placeholder="Usia" min="0" value="{{ $anak->usia }}">
                                            </div>
                                            <div class="col-md-2">
                                                <button type="button" class="btn btn-danger" onclick="hapusAnak({{ $idx }})">Hapus</button>
                                            </div>
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                            <button type="button" class="btn btn-primary btn-sm mt-2" onclick="tambahAnak()">Tambah Anak</button>
                        </div>

                        <script>
                        let anakCount = @if(old('anak')) {{ count(old('anak')) }} @else {{ $skpt->anak->count() }} @endif;
                        function tambahAnak() {
                            if (anakCount >= 10) return;
                            anakCount++;
                            let html = `
                                <div class=\"row mb-2\" id=\"anakRow${anakCount}\">
                                    <div class=\"col-md-6\">
                                        <input type=\"text\" name=\"anak[${anakCount}][nama_anak]\" class=\"form-control\" placeholder=\"Nama Anak ${anakCount}\" required>
                                    </div>
                                    <div class=\"col-md-4\">
                                        <input type=\"number\" name=\"anak[${anakCount}][usia]\" class=\"form-control\" placeholder=\"Usia\" min=\"0\">
                                    </div>
                                    <div class=\"col-md-2\">
                                        <button type=\"button\" class=\"btn btn-danger\" onclick=\"hapusAnak(${anakCount})\">Hapus</button>
                                    </div>
                                </div>
                            `;
                            document.getElementById('anakList').insertAdjacentHTML('beforeend', html);
                        }
                        function hapusAnak(idx) {
                            document.getElementById('anakRow'+idx).remove();
                        }
                        </script>
                    </div>
                </div>
            </div>

            <!-- Dokumen Wajib & Tambahan -->
            <div class="col-lg-4">
                <!-- Dokumen Wajib -->
                <div class="card card-success mb-4">
                    <div class="card-header">
                        <h5><i class="fas fa-file-check"></i> Dokumen Wajib</h5>
                    </div>
                    <div class="card-body">
                        @php
                            $documents = [
                                'ktp' => 'Photo Copy KTP',
                                'kk' => 'Photo Copy KK (Kartu Keluarga)',
                                'ktp_saksi' => 'Photo Copy KTP Saksi Batas',
                                'surat_pengantar_rt' => 'Surat Pengantar dari RT',
                                'surat_pengantar_kampung' => 'Surat Pengantar dari Kepala Kampung',
                                'copy_surat_riwayat' => 'Copy Surat Riwayat Peguasaan Fisik Bidang Tanah',
                                'surat_permohonan' => 'Surat Permohonan SKPT (sudah ditandatangani)',
                                'foto_bukti_1' => 'Foto copy bukti yuridis penguasaan tanah negara hal-1',
                                'foto_bukti_2' => 'Foto copy bukti yuridis penguasaan tanah negara hal-2',
                            ];
                        @endphp

                        @foreach($documents as $name => $label)
                            <div class="form-group">
                                <label class="form-label">{{ $label }}</label>
                                @php
                                    $document = $skpt->documents->where('document_type', $name)->first();
                                    $filePath = $document ? asset('storage/' . $document->file_path) : null;
                                @endphp
                                @if($filePath)
                                    <div class="d-flex align-items-center gap-2 mb-2 p-2 bg-light rounded">
                                        {{-- <i class="fas fa-file text-info"></i> --}}
                                        <a href="{{ $filePath }}" class="btn btn-sm btn-info" target="_blank">
                                            <i class="fas fa-eye"></i> Lihat File
                                        </a>
                                        <span class="ml-2 badge badge-secondary">{{ $document->file_extension }}</span>
                                    </div>
                                @endif
                                <input type="file" class="form-control @error($name) is-invalid @enderror"
                                       id="{{ $name }}" name="{{ $name }}"
                                       accept=".pdf,.jpg,.jpeg,.png">
                                <small class="text-muted">{{ $filePath ? 'Upload file baru untuk mengganti' : 'Belum ada file' }}</small>
                                @error($name)
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        @endforeach
                    </div>
                </div>

                <!-- Dokumen Tambahan -->
                <div class="card card-info mb-4">
                    <div class="card-header">
                        <h5><i class="fas fa-file-plus"></i> Dokumen Tambahan</h5>
                    </div>
                    <div class="card-body">
                        <div id="additionalDocuments">
                            @forelse($skpt->additionalDocuments as $index => $doc)
                                <div class="additional-doc mb-3 p-3 border rounded">
                                    <div class="form-group mb-2">
                                        <label class="form-label">Dokumen {{ $index + 1 }}</label>
                                        @if($doc->file_path)
                                            <div class="d-flex align-items-center gap-2 mb-2 p-2 bg-light rounded">

                                                <a href="{{ asset('storage/' . $doc->file_path) }}" class="btn btn-sm btn-info" target="_blank">
                                                    <i class="fas fa-eye"></i> Lihat File
                                                </a>
                                                <span class="badge badge-secondary">{{ $doc->file_extension }}</span>
                                            </div>
                                        @endif
                                        <input type="file" class="form-control"
                                               id="additional_{{ $index }}" name="additional_documents[]"
                                               accept=".pdf,.jpg,.jpeg,.png">
                                        <small class="text-muted">{{ $doc->file_path ? 'Upload file baru untuk mengganti' : 'Belum ada file' }}</small>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">Keterangan</label>
                                        <input type="text" class="form-control"
                                               id="additional_desc_{{ $index }}" name="additional_descriptions[]"
                                               value="{{ old('additional_descriptions.' . $index, $doc->description) }}"
                                               placeholder="Deskripsi dokumen" maxlength="255">
                                    </div>
                                </div>
                            @empty
                                <div class="additional-doc mb-3 p-3 border rounded">
                                    <div class="form-group mb-2">
                                        <label class="form-label">Dokumen 1</label>
                                        <input type="file" class="form-control"
                                               id="additional_0" name="additional_documents[]"
                                               accept=".pdf,.jpg,.jpeg,.png">
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">Keterangan</label>
                                        <input type="text" class="form-control"
                                               id="additional_desc_0" name="additional_descriptions[]"
                                               placeholder="Deskripsi dokumen" maxlength="255">
                                    </div>
                                </div>
                            @endforelse
                        </div>

                        <div class="d-flex gap-2">
                            <button type="button" class="btn btn-sm btn-success" id="addDoc">
                                <i class="fas fa-plus"></i> Tambah Dokumen
                            </button>
                            <button type="button" class="btn btn-sm btn-danger" id="removeDoc" style="display: {{ count($skpt->additionalDocuments) > 1 ? 'inline-block' : 'none' }};">
                                <i class="fas fa-minus"></i> Hapus Terakhir
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>



        <!-- Action Buttons -->
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <button type="button" class="btn btn-secondary" onclick="window.location='{{ route('skpt.index') }}'">
                        <i class="fas fa-arrow-left"></i> Batal
                    </button>
                    <div class="d-flex gap-2">
                        <button type="button" class="btn btn-warning" onclick="window.print()">
                            <i class="fas fa-print"></i> Preview Draft
                        </button>
                        <button type="submit" class="btn btn-success" id="submitBtn">
                            <i class="fas fa-save"></i> Simpan Perubahan
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-fill NIK from KTP input
    $('#no_ktp').on('input', function() {
        $('#nik').val($(this).val());
    });

    // Auto-fill tanah address from pemohon address
    $('input[name="alamat_rt"], input[name="alamat_rw"], input[name="alamat_kode_pos"]').on('input', function() {
        var field = $(this).attr('name').replace('alamat_', 'tanah_');
        var target = $('input[name="' + field + '"]');
        if (target.val() === '') {
            target.val($(this).val());
        }
    });

    // Form submission with confirmation and loading state
    $('#skptForm').on('submit', function(e) {
        if (confirm('Apakah Anda yakin ingin menyimpan perubahan?')) {
            $('#submitBtn').prop('disabled', true)
                          .html('<i class="fas fa-spinner fa-spin"></i> Menyimpan...');
        } else {
            e.preventDefault();
        }
    });

    // Dynamic additional documents
    let docCount = {{ count($skpt->additionalDocuments) ?: 1 }};

    $('#addDoc').click(function() {
        if (docCount < 5) {
            var newDoc = `
                <div class="additional-doc mb-3 p-3 border rounded animate-fadeIn">
                    <div class="form-group mb-2">
                        <label class="form-label">Dokumen ${docCount + 1}</label>
                        <input type="file" class="form-control"
                               id="additional_${docCount}" name="additional_documents[]"
                               accept=".pdf,.jpg,.jpeg,.png">
                    </div>
                    <div class="form-group">
                        <label class="form-label">Keterangan</label>
                        <input type="text" class="form-control"
                               id="additional_desc_${docCount}" name="additional_descriptions[]"
                               placeholder="Deskripsi dokumen" maxlength="255">
                    </div>
                </div>
            `;

            $('#additionalDocuments').append(newDoc);
            docCount++;

            if (docCount > 1) {
                $('#removeDoc').show();
            }

            if (docCount >= 5) {
                $('#addDoc').prop('disabled', true).html('<i class="fas fa-check"></i> Maksimal 5 Dokumen');
            }
        }
    });

    $('#removeDoc').click(function() {
        if (docCount > 1) {
            $('#additionalDocuments .additional-doc:last').remove();
            docCount--;

            if (docCount === 1) {
                $('#removeDoc').hide();
            }

            if (docCount < 5) {
                $('#addDoc').prop('disabled', false).html('<i class="fas fa-plus"></i> Tambah Dokumen');
            }
        }
    });

    // Real-time validation
    $('input[name="no_ktp"]').on('input', function() {
        var nik = $(this).val();
        if (nik.length > 0 && nik.length < 16) {
            $(this).addClass('is-invalid');
            $(this).next('.invalid-feedback').remove();
            $(this).after('<div class="invalid-feedback">NIK harus 16 digit</div>');
        } else if (nik.length === 16) {
            $(this).removeClass('is-invalid').addClass('is-valid');
            $(this).next('.invalid-feedback').remove();
        }
    });

    // Email validation
    $('input[name="email"]').on('input', function() {
        var email = $(this).val();
        var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (email.length > 0 && !emailRegex.test(email)) {
            $(this).addClass('is-invalid');
            $(this).next('.invalid-feedback').remove();
            $(this).after('<div class="invalid-feedback">Format email tidak valid</div>');
        } else if (emailRegex.test(email)) {
            $(this).removeClass('is-invalid').addClass('is-valid');
            $(this).next('.invalid-feedback').remove();
        }
    });

    // Phone validation
    $('input[name="telepon"]').on('input', function() {
        var phone = $(this).val();
        var phoneRegex = /^(\+62|62|0)8[1-9][0-9]{6,10}$/;
        if (phone.length > 0 && !phoneRegex.test(phone)) {
            $(this).addClass('is-invalid');
            $(this).next('.invalid-feedback').remove();
            $(this).after('<div class="invalid-feedback">Format nomor telepon tidak valid</div>');
        } else if (phoneRegex.test(phone)) {
            $(this).removeClass('is-invalid').addClass('is-valid');
            $(this).next('.invalid-feedback').remove();
        }
    });

    // File validation
    $('input[type="file"]').on('change', function() {
        var file = this.files[0];
        if (file) {
            var fileSize = file.size / 1024 / 1024; // MB
            var maxSize = 5; // 5MB

            if (fileSize > maxSize) {
                alert('Ukuran file terlalu besar. Maksimal 5MB.');
                $(this).val('');
                return false;
            }

            var allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'application/pdf'];
            if (!allowedTypes.includes(file.type)) {
                alert('Tipe file tidak didukung. Gunakan JPG, PNG, atau PDF.');
                $(this).val('');
                return false;
            }
        }
    });

    // Character counter for descriptions
    $(document).on('input', 'input[name="additional_descriptions[]"]', function() {
        var maxLength = 255;
        var currentLength = $(this).val().length;
        var remaining = maxLength - currentLength;

        // Remove existing counter
        $(this).siblings('.char-counter').remove();

        // Add counter
        $(this).after('<small class="char-counter text-muted">' + currentLength + '/' + maxLength + ' karakter</small>');

        if (remaining < 50) {
            $(this).siblings('.char-counter').removeClass('text-muted').addClass('text-warning');
        }
        if (remaining < 10) {
            $(this).siblings('.char-counter').removeClass('text-warning').addClass('text-danger');
        }
    });

    // Success/Error messages with SweetAlert
    @if(session('success'))
        Swal.fire({
            icon: 'success',
            title: 'Berhasil!',
            text: '{{ session("success") }}',
            timer: 3000,
            showConfirmButton: false,
            toast: true,
            position: 'top-end'
        });
    @endif

    @if(session('error'))
        Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: '{{ session("error") }}',
            timer: 5000,
            showConfirmButton: true,
            toast: true,
            position: 'top-end'
        });
    @endif

    @if($errors->any())
        Swal.fire({
            icon: 'warning',
            title: 'Perhatian!',
            text: 'Mohon periksa kembali form yang telah diisi',
            timer: 5000,
            showConfirmButton: true,
            toast: true,
            position: 'top-end'
        });
    @endif

    // Smooth scroll to first error
    if ($('.is-invalid').length > 0) {
        $('html, body').animate({
            scrollTop: $('.is-invalid').first().offset().top - 100
        }, 1000);
    }

    // Confirm before leaving page with unsaved changes
    var formChanged = false;
    $('input, select, textarea').on('change', function() {
        formChanged = true;
    });

    $(window).on('beforeunload', function() {
        if (formChanged && !$('#skptForm').data('submitted')) {
            return 'Anda memiliki perubahan yang belum disimpan. Yakin ingin meninggalkan halaman?';
        }
    });

    $('#skptForm').on('submit', function() {
        $(this).data('submitted', true);
        formChanged = false;
    });
});
</script>
@endpush
