@extends('admin-layouts.master')

@section('title', 'Detail RT/RW')

@section('content')
<div class="row">
    <div class="col-12">
        <!-- Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h2 class="h4 mb-1">Detail RTRW</h2>
                <p class="text-muted mb-0">Lihat detail data RTRW</p>
            </div>
            <a href="{{ route('rtrw.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>

        <!-- Detail -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Informasi RTRW</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>Nama RTRW:</strong> {{ $rtrw->nama_rtrw }}</p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>Warna:</strong> <span style="display: inline-block; width: 20px; height: 20px; background-color: {{ $rtrw->warna }};"></span> {{ $rtrw->warna }}</p>
                    </div>
                    <div class="col-12">
                        <p><strong>GeoJSON:</strong>
                            @if($rtrw->geojson_file)
                                <a href="{{ asset('storage/geojson/' . $rtrw->geojson_file) }}" target="_blank">Lihat File GeoJSON</a>
                            @else
                                Tidak ada file GeoJSON
                            @endif
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection