@extends('admin-layouts.master')

@section('title', 'Daftar RT/RW')

@section('content')
<div class="row">
    <div class="col-12">
        <!-- Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h2 class="h4 mb-1">Daftar RTRW</h2>
                <p class="text-muted mb-0">Kelola semua data RTRW</p>
            </div>
            <a href="{{ route('rtrw.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Tambah RTRW
            </a>
        </div>

        <!-- Stats Cards -->
        {{-- <div class="row mb-4">
            <div class="col-md-3">
                <div class="card border-left-primary shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                    Total RTRW</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $rtrws->total() }}</div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-map-marked-alt fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-left-success shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                    Aktif</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                    {{ $rtrws->where('status', 'Aktif')->count() }}
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-left-warning shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                    Nonaktif</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                    {{ $rtrws->where('status', 'Nonaktif')->count() }}
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-times-circle fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-left-info shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                    Jumlah Desa</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                    {{ $rtrws->sum('jumlah_desa') }}
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-home fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div> --}}

        <!-- Filter & Search -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Filter & Pencarian</h6>
            </div>
            <div class="card-body">
                <form method="GET" action="{{ route('rtrw.index') }}" class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="search">Pencarian</label>
                            <input type="text" class="form-control form-control-sm" 
                                   id="search" name="search" 
                                   placeholder="Kode atau RT/RW"
                                   value="{{ request('search') }}">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select class="form-control form-control-sm" id="status" name="status">
                                <option value="">Semua Status</option>
                                <option value="Aktif" {{ request('status') == 'Aktif' ? 'selected' : '' }}>
                                    Aktif
                                </option>
                                <option value="Nonaktif" {{ request('status') == 'Nonaktif' ? 'selected' : '' }}>
                                    Nonaktif
                                </option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div>
                                <button type="submit" class="btn btn-primary btn-sm">
                                    <i class="fas fa-search"></i>
                                </button>
                                <a href="{{ route('rtrw.index') }}" class="btn btn-secondary btn-sm ml-1">
                                    <i class="fas fa-times"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Data Table -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Data RT/RW</h6>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th width="10%">Nama RTRW</th>
                                <th width="15%">Warna</th>
                                <th width="15%">Geojson</th>

                                <th width="15%">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($rtrws as $kecamatan)
                            <tr>
                                <td>
                                    <strong class="text-primary">{{ $kecamatan->nama_rtrw }}</strong>
                                </td>
                                <td>
                                    <span style="display:inline-block; width:20px; height:20px; background-color: {{ $kecamatan->warna }}; border:1px solid #ccc; margin-right:5px;"></span>
                                    {{ $kecamatan->warna }}
                                </td>

                                <td>
                                    @if($kecamatan->geojson_file)
                                        <a href="{{ asset('storage/geojson/' . $kecamatan->geojson_file) }}" 
                                        class="btn btn-success btn-sm" 
                                        download="{{ $kecamatan->nama_rtrw }}.geojson"
                                        title="Download GeoJSON"
                                        data-toggle="tooltip">
                                            <i class="fas fa-download"></i> Download
                                        </a>
                                    @else
                                        <button class="btn btn-secondary btn-sm" disabled title="File tidak tersedia">
                                            <i class="fas fa-download"></i> Download
                                        </button>
                                    @endif
                                </td>
                              

                                {{-- <td>
                                    @if($kecamatan->status == 'Aktif')
                                        <span class="badge badge-success">
                                            <i class="fas fa-check"></i> Aktif
                                        </span>
                                    @else
                                        <span class="badge badge-warning">
                                            <i class="fas fa-times"></i> Nonaktif
                                        </span>
                                    @endif
                                </td> --}}
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="{{ route('rtrw.show', $kecamatan) }}" 
                                           class="btn btn-sm btn-outline-primary" 
                                           data-toggle="tooltip" title="Lihat Detail">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('rtrw.edit', $kecamatan) }}" 
                                           class="btn btn-sm btn-outline-warning"
                                           data-toggle="tooltip" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <button type="button" 
                                                class="btn btn-sm btn-outline-danger" 
                                                data-toggle="tooltip" title="Hapus"
                                                onclick="confirmDelete('{{ $kecamatan->id }}', '{{ route('rtrw.destroy', $kecamatan) }}')">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="7" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-map-marked-alt fa-3x mb-3"></i>
                                        <h5>Tidak ada data</h5>
                                        <p>Belum ada RTRW yang tersedia</p>
                                        <a href="{{ route('rtrw.create') }}" class="btn btn-primary">
                                            <i class="fas fa-plus"></i> Tambah RTRW                                       </a>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                @if($rtrws->hasPages())
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="showing-info">
                        <small class="text-muted">
                            Menampilkan {{ $rtrws->firstItem() }} - {{ $rtrws->lastItem() }} 
                            dari {{ $rtrws->total() }} data
                        </small>
                    </div>
                    {{ $rtrws->links() }}
                </div>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Konfirmasi Hapus</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Apakah Anda yakin ingin menghapus rtrw <strong id="deleteItemName"></strong>?</p>
                <p class="text-danger"><small>Tindakan ini tidak dapat dibatalkan dan akan menghapus data terkait.</small></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                <form id="deleteForm" method="POST" style="display: inline;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">
                        <i class="fas fa-trash"></i> Hapus
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmDelete(itemName, deleteUrl) {
    $('#deleteItemName').text(itemName);
    $('#deleteForm').attr('action', deleteUrl);
    $('#deleteModal').modal('show');
}

// Initialize tooltips
$(function () {
    $('[data-toggle="tooltip"]').tooltip();
});

// Success/Error Messages
@if(session('success'))
    $(document).ready(function() {
        Swal.fire({
            icon: 'success',
            title: 'Sukses!',
            text: '{{ session('success') }}',
            confirmButtonText: 'OK',
            confirmButtonColor: '#1cc88a',
        });
    });
@endif

@if(session('error'))
    $(document).ready(function() {
        Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: '{{ session('error') }}',
            confirmButtonText: 'OK',
            confirmButtonColor: '#e74a3b',
        });
    });
@endif
</script>
@endpush

@push('styles')
<style>
.border-left-primary {
    border-left: 0.25rem solid #4e73df !important;
}
.border-left-success {
    border-left: 0.25rem solid #1cc88a !important;
}
.border-left-info {
    border-left: 0.25rem solid #36b9cc !important;
}
.border-left-warning {
    border-left: 0.25rem solid #f6c23e !important;
}

.table-hover tbody tr:hover {
    background-color: rgba(0,0,0,.02);
}

.btn-group .btn {
    margin: 0 1px;
}

.card {
    box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15) !important;
}
</style>
@endpush