@extends('admin-layouts.master')

@section('title', 'Create New Role')

@section('content')
<style>
.card {
    border-radius: 8px;
    transition: all 0.3s ease;
}

.form-control {
    border-radius: 6px;
    border: 1px solid #e3e6f0;
}

.form-control:focus {
    border-color: #4e73df;
    box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
}

.custom-control-label {
    cursor: pointer;
}

.custom-control-input:checked ~ .custom-control-label::before {
    background-color: #4e73df;
    border-color: #4e73df;
}

.transition-icon {
    transition: transform 0.3s ease;
}

.btn-link:not(.collapsed) .transition-icon {
    transform: rotate(90deg);
}

.accordion .card-header {
    background-color: transparent;
}

.btn-link {
    color: #333 !important;
}

.btn-link:hover {
    color: #4e73df !important;
    text-decoration: none;
}

.badge {
    font-size: 0.75rem;
    font-weight: 500;
}

#selectedPermissionsList {
    max-height: 120px;
    overflow-y: auto;
}

.permission-item {
    background-color: #e7f1ff;
    color: #004085;
    padding: 2px 8px;
    border-radius: 12px;
    font-size: 0.75rem;
    margin: 2px;
    display: inline-block;
}
</style>
<div class="container-fluid">
    <!-- Header Section -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h2 class="mb-1 text-dark font-weight-bold">Create New Role</h2>
                    <p class="text-muted mb-0">Define a new role with specific permissions</p>
                </div>
                <div>
                    <a href="{{ route('roles.index') }}" class="btn btn-light btn-sm shadow-sm">
                        <i class="fas fa-arrow-left mr-1"></i> Back to Roles
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Error Messages -->
    @if($errors->any())
    <div class="row mb-3">
        <div class="col-md-12">
            <div class="alert alert-danger alert-dismissible fade show shadow-sm border-0" role="alert">
                <h6 class="alert-heading"><i class="fas fa-exclamation-circle mr-2"></i>Please fix the following errors:</h6>
                <ul class="mb-0">
                    @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                    @endforeach
                </ul>
                <button type="button" class="close" data-dismiss="alert">
                    <span>&times;</span>
                </button>
            </div>
        </div>
    </div>
    @endif

    <form action="{{ route('roles.store') }}" method="POST" id="roleForm">
        @csrf
        <div class="row">
            <!-- Role Information Card -->
            <div class="col-md-4 mb-4">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-header bg-white border-bottom-0 py-3">
                        <h6 class="mb-0 text-dark font-weight-semibold">
                            <i class="fas fa-info-circle text-primary mr-2"></i>
                            Role Information
                        </h6>
                    </div>
                    <div class="card-body">
                        <!-- Role Name -->
                        <div class="form-group">
                            <label for="name" class="form-label font-weight-semibold">Role Name <span class="text-danger">*</span></label>
                            <input type="text"
                                   class="form-control @error('name') is-invalid @enderror"
                                   id="name"
                                   name="name"
                                   value="{{ old('name') }}"
                                   placeholder="e.g., manager, staff"
                                   required>
                            <small class="form-text text-muted">Use lowercase, no spaces (use underscore if needed)</small>
                            @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>





                        <!-- Active Status -->
                        {{-- <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="hidden" name="is_active" value="0">
                                <input type="checkbox"
                                       class="custom-control-input"
                                       id="is_active"
                                       name="is_active"
                                       value="1"
                                       {{ old('is_active', '1') == '1' ? 'checked' : '' }}>
                                <label class="custom-control-label font-weight-semibold" for="is_active">
                                    Active Role
                                </label>
                            </div>
                            <small class="form-text text-muted">Inactive roles cannot be assigned to users</small>
                        </div> --}}

                        <!-- Selected Permissions Summary -->
                        <div class="mt-4 p-3 bg-light rounded">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span class="font-weight-semibold text-dark">Selected Permissions</span>
                                <span class="badge badge-primary" id="selectedCount">0</span>
                            </div>
                            <div id="selectedPermissionsList" class="text-muted small">
                                No permissions selected
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Permissions Card -->
            <div class="col-md-8 mb-4">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-header bg-white border-bottom-0 py-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <h6 class="mb-0 text-dark font-weight-semibold">
                                <i class="fas fa-key text-primary mr-2"></i>
                                Assign Permissions
                            </h6>
                            <div>
                                <button type="button" class="btn btn-sm btn-outline-primary" id="selectAll">
                                    <i class="fas fa-check-double mr-1"></i> Select All
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-secondary ml-1" id="clearAll">
                                    <i class="fas fa-times mr-1"></i> Clear All
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-0" style="max-height: 600px; overflow-y: auto;">
                        @if($groupedPermissions->count() > 0)
                        <div class="accordion" id="permissionsAccordion">
                            @foreach($groupedPermissions as $group => $groupPermissions)
                            <div class="border-bottom">
                                <div class="card-header bg-white border-0 py-3" id="heading{{ $loop->index }}">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <button class="btn btn-link text-left p-0 text-decoration-none collapsed"
                                                type="button"
                                                data-toggle="collapse"
                                                data-target="#collapse{{ $loop->index }}"
                                                aria-expanded="false">
                                            <h6 class="mb-0 text-dark font-weight-semibold">
                                                <i class="fas fa-chevron-right mr-2 transition-icon"></i>
                                                {{ ucfirst($group) }}
                                            </h6>
                                        </button>
                                        <div class="d-flex align-items-center">
                                            <span class="badge badge-light mr-2">{{ $groupPermissions->count() }} permissions</span>
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox"
                                                       class="custom-control-input group-checkbox"
                                                       id="group{{ $loop->index }}"
                                                       data-group="{{ $loop->index }}">
                                                <label class="custom-control-label" for="group{{ $loop->index }}">
                                                    <small>Select All</small>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div id="collapse{{ $loop->index }}"
                                     class="collapse"
                                     data-parent="#permissionsAccordion">
                                    <div class="card-body pt-0 pb-3">
                                        <div class="row">
                                            @foreach($groupPermissions as $permission)
                                            <div class="col-md-6 mb-2">
                                                <div class="custom-control custom-checkbox">
                                                    <input type="checkbox"
                                                           class="custom-control-input permission-checkbox"
                                                           id="permission{{ $permission->id }}"
                                                           name="permissions[]"
                                                           value="{{ $permission->id }}"
                                                           data-group="{{ $loop->parent->index }}"
                                                           data-name="{{ $permission->display_name ?? $permission->name }}"
                                                           {{ in_array($permission->id, old('permissions', [])) ? 'checked' : '' }}>
                                                    <label class="custom-control-label" for="permission{{ $permission->id }}">
                                                        <span class="font-weight-medium">{{ $permission->display_name ?? $permission->name }}</span>
                                                        @if($permission->description)
                                                        <br><small class="text-muted">{{ $permission->description }}</small>
                                                        @endif
                                                    </label>
                                                </div>
                                            </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                        @else
                        <div class="text-center py-5">
                            <i class="fas fa-key fa-3x text-muted mb-3"></i>
                            <h5 class="text-muted">No Permissions Available</h5>
                            <p class="text-muted">No permissions have been defined in the system.</p>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="row">
            <div class="col-md-12">
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <a href="{{ route('roles.index') }}" class="btn btn-light px-4">
                                <i class="fas fa-times mr-1"></i> Cancel
                            </a>
                            <button type="submit" class="btn btn-primary px-4" id="submitBtn">
                                <i class="fas fa-save mr-1"></i> Create Role
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    // Update selected permissions count and list
    function updateSelectedPermissions() {
        const checked = $('.permission-checkbox:checked');
        const count = checked.length;
        $('#selectedCount').text(count);

        if (count === 0) {
            $('#selectedPermissionsList').html('<span class="text-muted">No permissions selected</span>');
        } else {
            let html = '';
            checked.each(function() {
                const label = $(this).data('name');
                html += '<span class="permission-item">' + label + '</span>';
            });
            $('#selectedPermissionsList').html(html);
        }
    }

    // Handle permission checkbox changes
    $('.permission-checkbox').change(function() {
        updateSelectedPermissions();

        // Update group checkbox state
        const groupIndex = $(this).data('group');
        const groupPermissions = $(`.permission-checkbox[data-group="${groupIndex}"]`);
        const checkedInGroup = groupPermissions.filter(':checked').length;
        const totalInGroup = groupPermissions.length;

        const groupCheckbox = $(`#group${groupIndex}`);
        if (checkedInGroup === 0) {
            groupCheckbox.prop('indeterminate', false);
            groupCheckbox.prop('checked', false);
        } else if (checkedInGroup === totalInGroup) {
            groupCheckbox.prop('indeterminate', false);
            groupCheckbox.prop('checked', true);
        } else {
            groupCheckbox.prop('indeterminate', true);
        }
    });

    // Handle group checkbox changes
    $('.group-checkbox').change(function() {
        const groupIndex = $(this).data('group');
        const isChecked = $(this).prop('checked');

        $(`.permission-checkbox[data-group="${groupIndex}"]`).prop('checked', isChecked);
        updateSelectedPermissions();
    });

    // Select all permissions
    $('#selectAll').click(function() {
        $('.permission-checkbox, .group-checkbox').prop('checked', true);
        $('.group-checkbox').prop('indeterminate', false);
        updateSelectedPermissions();
    });

    // Clear all permissions
    $('#clearAll').click(function() {
        $('.permission-checkbox, .group-checkbox').prop('checked', false);
        $('.group-checkbox').prop('indeterminate', false);
        updateSelectedPermissions();
    });

    // Auto-generate display name from name
    $('#name').on('input', function() {
        const name = $(this).val();
        const displayName = name.replace(/_/g, ' ')
                                .replace(/\b\w/g, l => l.toUpperCase());
        if ($('#display_name').val() === '' || $('#display_name').data('auto') !== false) {
            $('#display_name').val(displayName);
            $('#display_name').data('auto', true);
        }
    });

    // Prevent auto-generation if user manually edits display name
    $('#display_name').on('input', function() {
        $(this).data('auto', false);
    });

    // Initialize selected permissions on page load
    updateSelectedPermissions();
});
</script>
@endpush
@endsection
