@extends('admin-layouts.master')

@section('content')

<div class="container-fluid">
    <h1 class="h3 mb-2 text-gray-800">Input Rekam Medis Manual</h1>
    <div class="row  justify-content-center align-items-center">
        <div class="col ">
            <div class="card ">
                <div class="card-body">
                    <form  action="{{ route('rekam-medis-manual.store')}}" method="POST" enctype="multipart/form-data">
                        @csrf
                       
                        <input type="hidden" name="nomor_rekam_medis" value="{{ $no_rekam_medis }}">
                        <input type="hidden" name="nomor_urut_pasien" value="{{ $nomor_pasien }}">
                        <input type="hidden" name="usia" value="" id="usia1">
                        <div class="form-row">
                            {{-- <div class="col">
                                <div class="form-group">
                                    <label for=""@error('nomor_rekam_medis') class="text-danger" @enderror >Nomor Rekam Medis</label>
                                    <input type="text" name="" class="form-control @error('name') form-control is-invalid @enderror"
                                    placeholder="" value="{{$no_rekam_medis}}" disabled>
                                    @error('nomor_rekam_medis')
                                        <span  class="text-danger"> {{ $message }} </span>
                                    @enderror
                                </div>
                            </div> --}}
                            <div class="col">
                                <div class="form-group">
                                    <label for=""@error('nomor_rekam_medis') class="text-danger" @enderror >Nomor Rekam Medis</label>
                                    <input type="text" name="nomor_rekam_medis" class="form-control @error('name') form-control is-invalid @enderror"
                                    placeholder="" value="{{ old('nomor_rekam_medis') }}" required>
                                    @error('nomor_rekam_medis')
                                        <span  class="text-danger"> {{ $message }} </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-group">
                                    <label for=""@error('nama_pasien') class="text-danger" @enderror >Nama Pasien</label>
                                    <input type="text" name="nama_pasien" class="form-control @error('name') form-control is-invalid @enderror"
                                    placeholder="" value="{{ old('nama_pasien') }}" required>
                                    @error('nama_pasien')
                                        <span  class="text-danger"> {{ $message }} </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-group">
                                    <label for=""@error('telp') class="text-danger" @enderror >No HP</label>
                                    <input type="text" name="telp" class="form-control @error('telp') form-control is-invalid @enderror"
                                    placeholder="" value="{{old('telp') }}" >
                                    @error('telp')
                                        <span  class="text-danger"> {{ $message }} </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col">
                                <label for=""@error('jenis_kelamin') class="text-danger " @enderror >Jenis Kelamin</label>
                                <div class="form-group mt-1 ">
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="jenis_kelamin" id="inlineRadio1" value="Laki-laki" required>
                                        <label class="form-check-label" for="inlineRadio1">Laki-laki</label>
                                      </div>
                                      <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="jenis_kelamin" id="inlineRadio2" value="Perempuan">
                                        <label class="form-check-label" for="inlineRadio2">Perempuan</label>
                                      </div>
                                </div>
                            </div>
                            
                        </div>
                        <div class="form-row">
                            <div class="col">
                                <div class="form-group">
                                    <label for=""@error('tanggal_lahir') class="text-danger" @enderror >Tanggal Lahir</label>
                                    <input id="tahun" type="date" name="tanggal_lahir" class="form-control @error('tanggal_lahir') form-control is-invalid @enderror"
                                    placeholder="" value="{{ old('tanggal_lahir') }}" required>
                                    @error('tanggal_lahir')
                                        <span  class="text-danger"> {{ $message }} </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-group">
                                    <label for=""@error('usia') class="text-danger" @enderror >Usia</label>
                                    <input type="text" name="" id="usia" class="form-control @error('email') form-control is-invalid @enderror"
                                    placeholder="" value="" disabled>
                                    @error('usia')
                                        <span  class="text-danger"> {{ $message }} </span>
                                    @enderror
                                </div>
                            </div>
                           <div class="col">
                            <div class="form-group @error('dokter') has-error @enderror " >
                                <label for=""@error('dokter') class="text-danger" @enderror >Dokter</label>
                                <select class="form-control" name="dokter" required>
                                    <option value="" selected disabled>Pilih</option>
                                  
                                    @foreach ($dokter as $key => $value)
                                        <option value="{{ $value->name }}">{{ $value->name}}</option>
                                    @endforeach
                                </select>
                                @error('dokter')
                                    <span  class="help-block"> {{ $message }} </span>
                                @enderror
                            </div>
                            
                           </div>
                           <div class="col">
                            <div class="form-group">
                                <label for=""@error('tanggal') class="text-danger" @enderror >Tanggal kunjungan</label>
                                <input  type="date" name="tanggal" class="form-control @error('tanggal') form-control is-invalid @enderror"
                                placeholder="" value="{{ old('tanggal') }}" required>
                                @error('tanggal')
                                    <span  class="text-danger"> {{ $message }} </span>
                                @enderror
                            </div>
                        </div>
                          </div>
                          <div class="form-row">
                              <div class="col">
                                <div class="form-group">
                                    <label for="exampleFormControlTextarea1">Alamat</label>
                                    <textarea class="form-control" id="exampleFormControlTextarea1" rows="3" name="alamat" value="{{ old('value') }}" required></textarea>
                                  </div>
                              </div>
                              <div class="col">
                                <div class="form-group">
                                    <label for="exampleFormControlTextarea1">Riwayat Alergi</label>
                                    <textarea class="form-control" id="exampleFormControlTextarea1" rows="3" name="riwayat_alergi" value="{{ old('value') }}" required></textarea>
                                  </div>
                              </div>
                              <div class="col">
                                <div class="form-group">
                                    <label for="exampleFormControlTextarea1">Riwayat Penyakit</label>
                                    <textarea class="form-control" id="exampleFormControlTextarea1" rows="3" name="riwayat_penyakit" value="{{ old('value') }}" required></textarea>
                                  </div>
                              </div>
                          </div>

                          <div class="form-row">
                            <div class="col">
                                <div class="form-group">
                                    <label for="exampleFormControlTextarea1">Anamnesa</label>
                                    <textarea class="form-control" id="exampleFormControlTextarea1" rows="3" name="anamnesa" value="{{ old('anamnesa') }} " required></textarea></textarea>
                                  </div>
                            </div>
                            <div class="col">
                                <div class="form-group">
                                    <label for="exampleFormControlTextarea1">Pemeriksaan Fisik</label>
                                    <textarea class="form-control" id="exampleFormControlTextarea1" rows="3" name="pemeriksaan_fisik" value="{{ old('pemeriksaan_fisik') }}" required></textarea>
                                  </div>
                            </div>
                        </div>
                        <div class="form-row">
                           
                            <div class="col">
                                <div class="form-group">
                                    <label for="exampleFormControlTextarea1">Hasil Penunjang</label>
                                    <textarea class="form-control" id="exampleFormControlTextarea1" rows="3" name="hasil_penunjang" value="{{ old('hasil_penunjang') }}" required></textarea>
                                  </div>
                            </div>
                            <div class="col">
                                <div class="form-group">
                                    <label for="exampleFormControlTextarea1">Diagnosa Kerja</label>
                                    <textarea class="form-control" id="exampleFormControlTextarea1" rows="3" name="diagnosa_kerja" value="{{ old('diagnosa_kerja') }}" required></textarea>
                                  </div>
                            </div>
                        </div>
                        <div class="form-row">
                            
                            <div class="col">
                                <div class="form-group">
                                    <label for="exampleFormControlTextarea1">Diagnosa Banding</label>
                                    <textarea class="form-control" id="exampleFormControlTextarea1" rows="3" name="diagnosa_banding" value="{{ old('diagnosa_banding') }}" required></textarea>
                                  </div>
                            </div>
                            <div class="col">
                                <div class="form-group">
                                    <label for="exampleFormControlTextarea1">Terapi</label>
                                    
                                    <textarea class="form-control" id="exampleFormControlTextarea1" rows="3" name="terapi" value="{{ old('terapi') }}" ></textarea>
                                  </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <input type="reset" value="Reset" class="btn btn-danger mt-3"/>
                            <input type="submit" value="Simpan" class="btn btn-primary mt-3">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<script>

    $(document).ready(function () {
            $('#tahun').change(function () {
                var userDateinput = document.getElementById("tahun").value;
               
                // function formatDate(userDateinput)
                //     {
                //         var allDate = userDateinput.split(' ');
                //         var thisDate = allDate[0].split('-');
                      
                //         var newDate = [thisDate[2],thisDate[1],thisDate[0] ].join("/");
    
                       
    
                //         return newDate;
                //     }
                // console.log(formatDate(userDateinput))
                // new Date((new Date).toLocaleString("en-US", {
                //     timeZone: "Asia/Jakarta"
                // }));
                var ctrldob = new Date(userDateinput);
                
               
                var today = new Date();
                var ctrldoa1 = today.getFullYear()+','+(today.getMonth()+1)+','+today.getDate();
                var ctrldoa = new Date(ctrldoa1)
                var diff = new Date(ctrldoa.getTime() - ctrldob.getTime());
                let tahun = (diff.getFullYear() - 1970); // Gives difference as year
                let bulan = (diff.getMonth()); // Gives month count of difference
                let tanggal= (diff.getDate() - 1); // Gives day count of difference
                
               
                document.getElementById("usia").value = `${tahun} Tahun ${bulan} Bulan ${tanggal} Hari`;
                document.getElementById("usia1").value = `${tahun} Tahun ${bulan} Bulan ${tanggal} Hari`;
            });
        });
    </script>
@endsection