{{-- resources/views/peninjauan/show.blade.php --}}
@extends('admin-layouts.master')

@section('title', 'Detail Peninjauan')

@section('content')
<div class="row">
    <div class="col-12">
        <!-- Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h2 class="h4 mb-1">Detail Peninjauan Lapangan</h2>
                <p class="text-muted mb-0">{{ $peninjauan->nomor_ba_kesaksian ?? 'Nomor BA: -' }}</p>
            </div>
            <div class="btn-group">
                <a href="{{ route('peninjauan.index') }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> Kembali
                </a>
                @if($peninjauan->status == 'draft')
                <a href="{{ route('peninjauan.edit', $peninjauan->id) }}" class="btn btn-warning">
                    <i class="fas fa-edit"></i> Edit
                </a>
                @endif
                <button type="button" class="btn btn-success" onclick="exportPDF()">
                    <i class="fas fa-file-pdf"></i> Export PDF
                </button>
            </div>
        </div>

        <!-- Status Card -->
        <div class="card shadow mb-4">
            <div class="card-body">
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <div class="d-flex align-items-center">
                            <div class="mr-3">
                                @if($peninjauan->status == 'completed')
                                    <span class="badge badge-success badge-lg">
                                        <i class="fas fa-check-circle"></i> Selesai
                                    </span>
                                @elseif($peninjauan->status == 'verified')
                                    <span class="badge badge-info badge-lg">
                                        <i class="fas fa-check"></i> Verified
                                    </span>
                                @elseif($peninjauan->status == 'submitted')
                                    <span class="badge badge-warning badge-lg">
                                        <i class="fas fa-clock"></i> Submitted
                                    </span>
                                @elseif($peninjauan->status == 'rejected')
                                    <span class="badge badge-danger badge-lg">
                                        <i class="fas fa-times-circle"></i> Ditolak
                                    </span>
                                @else
                                    <span class="badge badge-secondary badge-lg">
                                        <i class="fas fa-edit"></i> Draft
                                    </span>
                                @endif
                            </div>
                            <div>
                                <h6 class="mb-0">Status Peninjauan</h6>
                                <small class="text-muted">Dibuat: {{ $peninjauan->created_at->format('d/m/Y H:i') }}</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 text-md-right">
                        <div class="text-muted">
                            <small><i class="fas fa-user"></i> Dibuat oleh: {{ $peninjauan->creator->name ?? 'System' }}</small><br>
                            <small><i class="fas fa-clock"></i> Diperbarui: {{ $peninjauan->updated_at->format('d/m/Y H:i') }}</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Content Card -->
        <div class="card shadow mb-4">
            <!-- Navigation Tabs -->
            <div class="card-header p-0">
                <ul class="nav nav-tabs" id="peninjauanTabs" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" id="ba-kesaksian-tab" data-toggle="tab" href="#ba-kesaksian" role="tab">
                            BA Kesaksian
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="data-pemohon-tab" data-toggle="tab" href="#data-pemohon" role="tab">
                            Data Pemohon
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="batas-tanah-tab" data-toggle="tab" href="#batas-tanah" role="tab">
                            Batas Tanah
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="pendaftaran-tab" data-toggle="tab" href="#pendaftaran" role="tab">
                            Pendaftaran
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="pengukuran-tab" data-toggle="tab" href="#pengukuran" role="tab">
                            Pengukuran
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="kesimpulan-tab" data-toggle="tab" href="#kesimpulan" role="tab">
                            Kesimpulan
                        </a>
                    </li>
                </ul>
            </div>

            <!-- Tab Content -->
            <div class="card-body">
                <div class="tab-content" id="peninjauanTabContent">
                    <!-- BA Kesaksian Tab -->
                    <div class="tab-pane fade show active" id="ba-kesaksian" role="tabpanel">
                        <h5 class="section-title">BA Kesaksian</h5>

                        <div class="row mb-4">
                            <div class="col-md-6">
                                <div class="info-item">
                                    <label>Tanggal</label>
                                    <div class="info-value">
                                        {{ $peninjauan->ba_tanggal ? \Carbon\Carbon::parse($peninjauan->ba_tanggal)->format('d F Y') : '-' }}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-item">
                                    <label>Nomor BA Kesaksian</label>
                                    <div class="info-value">{{ $peninjauan->nomor_ba_kesaksian ?? '-' }}</div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="card bg-light">
                                    <div class="card-body">
                                        <h6 class="card-title">Saksi 1</h6>
                                        <div class="info-item mb-2">
                                            <label>Nama</label>
                                            <div class="info-value">{{ $peninjauan->saksi1_nama ?? '-' }}</div>
                                        </div>
                                        <div class="info-item mb-2">
                                            <label>Tempat/Tgl Lahir</label>
                                            <div class="info-value">{{ $peninjauan->saksi1_ttl ?? '-' }}</div>
                                        </div>
                                        <div class="info-item mb-2">
                                            <label>Pekerjaan</label>
                                            <div class="info-value">{{ $peninjauan->saksi1_pekerjaan ?? '-' }}</div>
                                        </div>
                                        <div class="info-item">
                                            <label>Alamat</label>
                                            <div class="info-value">{{ $peninjauan->saksi1_alamat ?? '-' }}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card bg-light">
                                    <div class="card-body">
                                        <h6 class="card-title">Saksi 2</h6>
                                        <div class="info-item mb-2">
                                            <label>Nama</label>
                                            <div class="info-value">{{ $peninjauan->saksi2_nama ?? '-' }}</div>
                                        </div>
                                        <div class="info-item mb-2">
                                            <label>Tempat/Tgl Lahir</label>
                                            <div class="info-value">{{ $peninjauan->saksi2_ttl ?? '-' }}</div>
                                        </div>
                                        <div class="info-item mb-2">
                                            <label>Pekerjaan</label>
                                            <div class="info-value">{{ $peninjauan->saksi2_pekerjaan ?? '-' }}</div>
                                        </div>
                                        <div class="info-item">
                                            <label>Alamat</label>
                                            <div class="info-value">{{ $peninjauan->saksi2_alamat ?? '-' }}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Data Pemohon Tab -->
                    <div class="tab-pane fade" id="data-pemohon" role="tabpanel">
                        <h5 class="section-title">Data Lokasi</h5>

                        <div class="row mb-4">
                            <div class="col-md-6">
                                <div class="info-item mb-3">
                                    <label>Jalan/Gg/Blok</label>
                                    <div class="info-value">{{ $peninjauan->jalan_gg_blok ?? '-' }}</div>
                                </div>
                                <div class="info-item mb-3">
                                    <label>Kampung/Kelurahan</label>
                                    <div class="info-value">{{ $peninjauan->kampung_kelurahan ?? '-' }}</div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-item mb-3">
                                    <label>RT/RW</label>
                                    <div class="info-value">{{ $peninjauan->rt ?? '-' }}/{{ $peninjauan->rw ?? '-' }}</div>
                                </div>
                                <div class="info-item mb-3">
                                    <label>Kecamatan</label>
                                    <div class="info-value">{{ $peninjauan->kecamatan ?? '-' }}</div>
                                </div>
                            </div>
                        </div>

                        <h5 class="section-title">Batas</h5>
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <div class="info-item mb-3">
                                    <label>Utara</label>
                                    <div class="info-value">{{ $peninjauan->batas_utara ?? '-' }}</div>
                                </div>
                                <div class="info-item mb-3">
                                    <label>Selatan</label>
                                    <div class="info-value">{{ $peninjauan->batas_selatan ?? '-' }}</div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-item mb-3">
                                    <label>Timur</label>
                                    <div class="info-value">{{ $peninjauan->batas_timur ?? '-' }}</div>
                                </div>
                                <div class="info-item mb-3">
                                    <label>Barat</label>
                                    <div class="info-value">{{ $peninjauan->batas_barat ?? '-' }}</div>
                                </div>
                            </div>
                        </div>

                        <div class="info-item mb-4">
                            <label>Luas</label>
                            <div class="info-value">{{ $peninjauan->luas ? $peninjauan->luas . ' m²' : '-' }}</div>
                        </div>

                        <h5 class="section-title">Data Pemilik</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="info-item mb-3">
                                    <label>Nama Pemilik</label>
                                    <div class="info-value">{{ $peninjauan->nama_pemilik ?? '-' }}</div>
                                </div>
                                <div class="info-item mb-3">
                                    <label>Dikuasai Oleh</label>
                                    <div class="info-value">{{ $peninjauan->dikuasai_oleh ?? '-' }}</div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-item mb-3">
                                    <label>Dikuasai Sejak Tahun</label>
                                    <div class="info-value">{{ $peninjauan->dikuasai_sejak ?? '-' }}</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Batas Tanah Tab -->
                    <div class="tab-pane fade" id="batas-tanah" role="tabpanel">
                        <h5 class="section-title">BA Kesepakatan Batas dan Pernyataan Tidak Sengketa</h5>

                        <div class="row mb-4">
                            <div class="col-md-6">
                                <div class="info-item mb-3">
                                    <label>Nomor BA Kesepakatan</label>
                                    <div class="info-value">{{ $peninjauan->nomor_ba_kesepakatan ?? '-' }}</div>
                                </div>
                                <div class="info-item mb-3">
                                    <label>Di Umumkan di</label>
                                    <div class="info-value">{{ $peninjauan->diumumkan_di ?? '-' }}</div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-item mb-3">
                                    <label>Tanggal</label>
                                    <div class="info-value">
                                        {{ $peninjauan->tanggal_ba_kesepakatan ? \Carbon\Carbon::parse($peninjauan->tanggal_ba_kesepakatan)->format('d F Y') : '-' }}
                                    </div>
                                </div>
                                <div class="info-item mb-3">
                                    <label>dan</label>
                                    <div class="info-value">{{ $peninjauan->diumumkan_dan ?? '-' }}</div>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-md-6">
                                <div class="info-item mb-3">
                                    <label>Tanda Batas</label>
                                    <div class="info-value">{{ $peninjauan->tanda_batas ?? '-' }}</div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-item mb-3">
                                    <label>Penguasaan Tanah</label>
                                    <div class="info-value">{{ $peninjauan->penguasaan_tanah ?? '-' }}</div>
                                </div>
                            </div>
                        </div>

                        <h5 class="section-title">Saksi yang Hadir</h5>
                        <div class="row">
                            @php
                                $saksiList = [
                                    'Saksi Batas Utara' => ['nama' => $peninjauan->saksi_utara_nama, 'alamat' => $peninjauan->saksi_utara_alamat],
                                    'Saksi Batas Timur' => ['nama' => $peninjauan->saksi_timur_nama, 'alamat' => $peninjauan->saksi_timur_alamat],
                                    'Saksi Batas Selatan' => ['nama' => $peninjauan->saksi_selatan_nama, 'alamat' => $peninjauan->saksi_selatan_alamat],
                                    'Saksi Batas Barat' => ['nama' => $peninjauan->saksi_barat_nama, 'alamat' => $peninjauan->saksi_barat_alamat],
                                    'Saksi Ketua RT' => ['nama' => $peninjauan->saksi_rt_nama, 'alamat' => $peninjauan->saksi_rt_alamat],
                                    'Juru Ukur' => ['nama' => $peninjauan->juru_ukur_nama, 'alamat' => $peninjauan->juru_ukur_alamat],
                                ];
                            @endphp

                            @foreach($saksiList as $title => $saksi)
                            @if($saksi['nama'])
                            <div class="col-md-6 mb-3">
                                <div class="card bg-light">
                                    <div class="card-body">
                                        <h6 class="card-title">{{ $title }}</h6>
                                        <div class="info-item mb-2">
                                            <label>Nama</label>
                                            <div class="info-value">{{ $saksi['nama'] ?? '-' }}</div>
                                        </div>
                                        <div class="info-item">
                                            <label>Alamat</label>
                                            <div class="info-value">{{ $saksi['alamat'] ?? '-' }}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endif
                            @endforeach
                        </div>
                    </div>

                    <!-- Pendaftaran Tab -->
                    <div class="tab-pane fade" id="pendaftaran" role="tabpanel">
                        <h5 class="section-title">BA Penelitian Penguasaan Tanah</h5>

                        <div class="row mb-4">
                            <div class="col-md-6">
                                <div class="info-item mb-3">
                                    <label>Nomor BA Penelitian</label>
                                    <div class="info-value">{{ $peninjauan->nomor_ba_penelitian ?? '-' }}</div>
                                </div>
                                <div class="info-item mb-3">
                                    <label>Penguasaan Tanah</label>
                                    <div class="info-value">{{ $peninjauan->penguasaan_tanah_detail ?? '-' }}</div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-item mb-3">
                                    <label>Bulan dan Tahun</label>
                                    <div class="info-value">
                                        {{ $peninjauan->bulan_tahun_penelitian ? \Carbon\Carbon::parse($peninjauan->bulan_tahun_penelitian)->format('F Y') : '-' }}
                                    </div>
                                </div>
                                <div class="info-item mb-3">
                                    <label>Riwayat Perolehan</label>
                                    <div class="info-value">{{ ucfirst($peninjauan->riwayat_perolehan ?? '-') }}</div>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-md-6">
                                <div class="info-item">
                                    <label>Data Yuridis</label>
                                    <div class="info-value">{{ $peninjauan->data_yuridis ?? '-' }}</div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-item">
                                    <label>Data Pendukung</label>
                                    <div class="info-value">{{ $peninjauan->data_pendukung ?? '-' }}</div>
                                </div>
                            </div>
                        </div>

                        <h5 class="section-title">IMB dan SPPT PBB</h5>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="info-item">
                                    <label>IMB Tanggal</label>
                                    <div class="info-value">
                                        {{ $peninjauan->imb_tanggal ? \Carbon\Carbon::parse($peninjauan->imb_tanggal)->format('d F Y') : '-' }}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="info-item">
                                    <label>No IMB</label>
                                    <div class="info-value">{{ $peninjauan->no_imb ?? '-' }}</div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="info-item">
                                    <label>SPPT PBB Tahun</label>
                                    <div class="info-value">{{ $peninjauan->sppt_pbb_tahun ?? '-' }}</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Pengukuran Tab -->
                    <div class="tab-pane fade" id="pengukuran" role="tabpanel">
                        <h5 class="section-title">BA Pengukuran Bidang Tanah</h5>

                        <div class="row mb-4">
                            <div class="col-md-6">
                                <div class="info-item mb-3">
                                    <label>Nomor BA Pengukuran</label>
                                    <div class="info-value">{{ $peninjauan->nomor_ba_pengukuran ?? '-' }}</div>
                                </div>
                                <div class="info-item mb-3">
                                    <label>Surat Tugas Nomor</label>
                                    <div class="info-value">{{ $peninjauan->surat_tugas_nomor ?? '-' }}</div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-item mb-3">
                                    <label>Tanggal Pengukuran</label>
                                    <div class="info-value">
                                        {{ $peninjauan->tanggal_pengukuran ? \Carbon\Carbon::parse($peninjauan->tanggal_pengukuran)->format('d F Y') : '-' }}
                                    </div>
                                </div>
                                <div class="info-item mb-3">
                                    <label>Petugas Ukur</label>
                                    <div class="info-value">{{ $peninjauan->petugas_ukur ?? '-' }}</div>
                                </div>
                            </div>
                        </div>

                        <!-- Koordinat Section -->
                        <h5 class="section-title">Data Koordinat</h5>
                        <div class="row mb-4">
                            <div class="col-12">
                                @if($peninjauan->coordinates)
                                    @php
                                        $coordinates = json_decode($peninjauan->coordinates, true);
                                    @endphp
                                    <div class="table-responsive">
                                        <table class="table table-sm table-bordered">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>No</th>
                                                    <th>Latitude</th>
                                                    <th>Longitude</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($coordinates as $index => $coord)
                                                <tr>
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>{{ $coord['lat'] ?? '-' }}</td>
                                                    <td>{{ $coord['lng'] ?? '-' }}</td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>

                                    <!-- Map Display -->
                                    <div id="showMap" style="height: 400px; border: 1px solid #e5e7eb; border-radius: 6px;" class="mb-3"></div>
                                @else
                                    <div class="alert alert-info">
                                        <i class="fas fa-info-circle"></i> Tidak ada data koordinat.
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Kesimpulan Tab -->
                    <div class="tab-pane fade" id="kesimpulan" role="tabpanel">
                        <h5 class="section-title">Kesimpulan Peninjauan</h5>

                        <div class="row mb-4">
                            <div class="col-md-6">
                                <div class="info-item mb-3">
                                    <label>Status Penguasaan Tanah</label>
                                    <div class="info-value">{{ ucfirst(str_replace('_', ' ', $peninjauan->status_penguasaan_kesimpulan ?? '-')) }}</div>
                                </div>
                                <div class="info-item mb-3">
                                    <label>Luas Tanah Terukur</label>
                                    <div class="info-value">{{ $peninjauan->luas_terukur_kesimpulan ? $peninjauan->luas_terukur_kesimpulan . ' m²' : '-' }}</div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-item mb-3">
                                    <label>Luas Tanah Menurut Surat</label>
                                    <div class="info-value">{{ $peninjauan->luas_surat_kesimpulan ? $peninjauan->luas_surat_kesimpulan . ' m²' : '-' }}</div>
                                </div>
                            </div>
                        </div>

                        <div class="info-item mb-4">
                            <label>Kesimpulan Status Tanah</label>
                            <div class="info-value">{{ $peninjauan->kesimpulan_status ?? '-' }}</div>
                        </div>

                        <h5 class="section-title">Rekomendasi</h5>
                        <div class="row mb-4">
                            <div class="col-12">
                                <div class="d-flex flex-wrap gap-2 mb-3">
                                    @if($peninjauan->rekomendasi_skpt)
                                        <span class="badge badge-success">Dapat diterbitkan SKPT</span>
                                    @endif
                                    @if($peninjauan->rekomendasi_sertifikat)
                                        <span class="badge badge-info">Dapat dilanjutkan proses sertifikat</span>
                                    @endif
                                    @if($peninjauan->rekomendasi_mediasi)
                                        <span class="badge badge-warning">Perlu mediasi</span>
                                    @endif
                                    @if($peninjauan->rekomendasi_verifikasi)
                                        <span class="badge badge-primary">Perlu verifikasi data tambahan</span>
                                    @endif
                                    @if($peninjauan->rekomendasi_tolak)
                                        <span class="badge badge-danger">Tidak dapat diproses</span>
                                    @endif
                                </div>

                                @if($peninjauan->catatan_rekomendasi)
                                <div class="info-item">
                                    <label>Catatan Rekomendasi</label>
                                    <div class="info-value">{{ $peninjauan->catatan_rekomendasi }}</div>
                                </div>
                                @endif
                            </div>
                        </div>

                        <h5 class="section-title">Data Petugas</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="card bg-light">
                                    <div class="card-body">
                                        <h6 class="card-title">Petugas 1</h6>
                                        <div class="info-item mb-2">
                                            <label>Nama</label>
                                            <div class="info-value">{{ $peninjauan->petugas1_nama ?? '-' }}</div>
                                        </div>
                                        <div class="info-item mb-2">
                                            <label>NIP</label>
                                            <div class="info-value">{{ $peninjauan->petugas1_nip ?? '-' }}</div>
                                        </div>
                                        <div class="info-item">
                                            <label>Jabatan</label>
                                            <div class="info-value">{{ $peninjauan->petugas1_jabatan ?? '-' }}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card bg-light">
                                    <div class="card-body">
                                        <h6 class="card-title">Petugas 2</h6>
                                        <div class="info-item mb-2">
                                            <label>Nama</label>
                                            <div class="info-value">{{ $peninjauan->petugas2_nama ?? '-' }}</div>
                                        </div>
                                        <div class="info-item mb-2">
                                            <label>NIP</label>
                                            <div class="info-value">{{ $peninjauan->petugas2_nip ?? '-' }}</div>
                                        </div>
                                        <div class="info-item">
                                            <label>Jabatan</label>
                                            <div class="info-value">{{ $peninjauan->petugas2_jabatan ?? '-' }}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <h5 class="section-title">Pengesahan</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="info-item mb-3">
                                    <label>Tempat Pengesahan</label>
                                    <div class="info-value">{{ $peninjauan->tempat_pengesahan ?? '-' }}</div>
                                </div>
                                <div class="info-item mb-3">
                                    <label>Mengetahui - Nama</label>
                                    <div class="info-value">{{ $peninjauan->mengetahui_nama ?? '-' }}</div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-item mb-3">
                                    <label>Tanggal Pengesahan</label>
                                    <div class="info-value">
                                        {{ $peninjauan->tanggal_pengesahan ? \Carbon\Carbon::parse($peninjauan->tanggal_pengesahan)->format('d F Y') : '-' }}
                                    </div>
                                </div>
                                <div class="info-item mb-3">
                                    <label>NIP</label>
                                    <div class="info-value">{{ $peninjauan->mengetahui_nip ?? '-' }}</div>
                                </div>
                            </div>
                        </div>

                        <div class="info-item">
                            <label>Jabatan</label>
                            <div class="info-value">{{ $peninjauan->mengetahui_jabatan ?? '-' }}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Update Status Modal -->
<div class="modal fade" id="updateStatusModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Update Status Peninjauan</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="updateStatusForm">
                    @csrf
                    <div class="form-group">
                        <label for="status">Status Baru</label>
                        <select class="form-control" id="status" name="status" required>
                            <option value="draft" {{ $peninjauan->status == 'draft' ? 'selected' : '' }}>Draft</option>
                            <option value="submitted" {{ $peninjauan->status == 'submitted' ? 'selected' : '' }}>Submitted</option>
                            <option value="verified" {{ $peninjauan->status == 'verified' ? 'selected' : '' }}>Verified</option>
                            <option value="completed" {{ $peninjauan->status == 'completed' ? 'selected' : '' }}>Completed</option>
                            <option value="rejected" {{ $peninjauan->status == 'rejected' ? 'selected' : '' }}>Rejected</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="keterangan">Keterangan (Opsional)</label>
                        <textarea class="form-control" id="keterangan" name="keterangan" rows="3"
                                  placeholder="Tambahkan keterangan jika diperlukan..."></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                <button type="button" class="btn btn-primary" onclick="submitStatusUpdate()">
                    <i class="fas fa-save"></i> Update Status
                </button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<!-- Leaflet CSS & JS -->
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.7.1/dist/leaflet.css" />
<script src="https://unpkg.com/leaflet@1.7.1/dist/leaflet.js"></script>

<script>
$(document).ready(function() {
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();

    // Tab navigation with map initialization
    $('#peninjauanTabs a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
        const tabId = $(e.target).attr('href').substring(1);

        if (tabId === 'pengukuran') {
            setTimeout(() => {
                initShowMap();
            }, 100);
        }
    });
});

// Initialize map for show page
function initShowMap() {
    @if($peninjauan->coordinates)
        const coordinates = {!! $peninjauan->coordinates !!};

        if (coordinates && coordinates.length > 0) {
            // Initialize map
            const showMap = L.map('showMap').setView([coordinates[0].lat, coordinates[0].lng], 18);

            // Add tile layer
            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                attribution: '© OpenStreetMap contributors',
                maxZoom: 20
            }).addTo(showMap);

            // Add markers with numbers
            coordinates.forEach((coord, index) => {
                L.marker([coord.lat, coord.lng], {
                    icon: L.divIcon({
                        className: 'custom-div-icon',
                        html: `<div style="background: #dc2626; color: white; width: 24px; height: 24px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 11px; font-weight: bold; border: 2px solid white; box-shadow: 0 2px 4px rgba(0,0,0,0.3);">${index + 1}</div>`,
                        iconSize: [24, 24],
                        iconAnchor: [12, 12]
                    })
                }).addTo(showMap);
            });

            // Draw polygon
            if (coordinates.length >= 3) {
                const latlngs = coordinates.map(coord => [coord.lat, coord.lng]);
                const polygon = L.polygon(latlngs, {
                    color: '#dc2626',
                    fillColor: '#dc2626',
                    fillOpacity: 0.2,
                    weight: 2
                }).addTo(showMap);

                // Fit map to polygon bounds
                showMap.fitBounds(polygon.getBounds());
            }
        }
    @endif
}

// Export PDF function
function exportPDF() {
    window.open('{{ route("peninjauan.exportPdf", $peninjauan->id) }}', '_blank');
}

// Update Status function
function updateStatus(newStatus) {
    $('#status').val(newStatus);
    $('#updateStatusModal').modal('show');
}

function submitStatusUpdate() {
    const formData = new FormData(document.getElementById('updateStatusForm'));

    $.ajax({

        url: '{{ route("peninjauan.updateStatus", ":id") }}'.replace(':id', id),
        method: 'POST',
        data: {
            id: {{ $peninjauan->id }},
            status: $('#status').val(),
            keterangan: $('#keterangan').val(),
            _token: '{{ csrf_token() }}'
        },
        success: function(response) {
            $('#updateStatusModal').modal('hide');
            Swal.fire({
                icon: 'success',
                title: 'Sukses!',
                text: 'Status peninjauan berhasil diperbarui.',
                confirmButtonText: 'OK',
                confirmButtonColor: '#1cc88a',
            }).then(() => {
                location.reload();
            });
        },
        error: function(xhr) {
            Swal.fire({
                icon: 'error',
                title: 'Error!',
                text: 'Gagal memperbarui status peninjauan.',
                confirmButtonText: 'OK',
                confirmButtonColor: '#e74a3b',
            });
        }
    });
}

// Print function
function printDocument() {
    window.print();
}
</script>
@endpush

@push('styles')
<style>
.nav-tabs .nav-link {
    color: #495057 !important;
}

.nav-tabs .nav-link.active {
    color: #000 !important;
    background-color: #fff !important;
    border: 1px solid #dee2e6;
    border-bottom-color: transparent;
    font-weight: 600;
}

.section-title {
    font-size: 1.1rem;
    font-weight: 600;
    color: #495057;
    border-bottom: 2px solid #e9ecef;
    padding-bottom: 8px;
    margin-bottom: 20px;
}

.info-item {
    margin-bottom: 1rem;
}

.info-item label {
    font-weight: 600;
    color: #6c757d;
    font-size: 0.875rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    margin-bottom: 4px;
    display: block;
}

.info-value {
    color: #495057;
    font-size: 0.95rem;
    min-height: 20px;
    padding: 4px 0;
}

.badge-lg {
    padding: 0.5rem 1rem;
    font-size: 0.875rem;
}

.card {
    box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15) !important;
    border: none;
    border-radius: 0.5rem;
}

.card-title {
    color: #5a5c69;
    font-weight: 600;
    margin-bottom: 1rem;
}

.gap-2 > * {
    margin-right: 0.5rem !important;
    margin-bottom: 0.5rem !important;
}

.text-gray-800 {
    color: #5a5c69 !important;
}

.btn-group .btn {
    margin-left: 2px;
}

.btn-group .btn:first-child {
    margin-left: 0;
}

@media print {
    .btn, .btn-group {
        display: none !important;
    }

    .card {
        box-shadow: none !important;
        border: 1px solid #dee2e6 !important;
    }
}
</style>
@endpush
