
{{-- resources/views/peninjauan/partials/tab-data-pemohon.blade.php --}}

<!-- Data Pemohon/Peralihan Tab -->
<div class="tab-pane fade" id="data-pemohon" role="tabpanel">
    <div class="card">
        <div class="card-header">
            Detail BA Kesaksian
        </div>
        <div class="card-body">
            <!-- Data Lokasi Section -->
            {{-- <h5 class="section-title">Data Lokasi</h5> --}}
            
            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="jalan_gg_blok">Jalan/Gg/Blok</label>
                        <input type="text" class="form-control" id="jalan_gg_blok" name="jalan_gg_blok" value="{{ old('jalan_gg_blok') }}" placeholder="Nama jalan/gang/blok">
                        @error('jalan_gg_blok')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="rt">RT/RW</label>
                        <div class="d-flex align-items-center">
                            <input type="text" class="form-control" id="rt" name="rt" value="{{ old('rt') }}" placeholder="RT" style="width: 80px;">
                            <span class="mx-2">/</span>
                            <input type="text" class="form-control" id="rw" name="rw" value="{{ old('rw') }}" placeholder="RW" style="width: 80px;">
                        </div>
                        @error('rt')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                        @error('rw')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="kampung_kelurahan">Kampung/Kelurahan</label>
                        <input type="text" class="form-control" id="kampung_kelurahan" name="kampung_kelurahan" value="{{ old('kampung_kelurahan') }}" placeholder="Nama kampung/kelurahan">
                        @error('kampung_kelurahan')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="kecamatan">Kecamatan</label>
                        <input type="text" class="form-control" id="kecamatan" name="kecamatan" value="{{ old('kecamatan') }}" placeholder="Nama kecamatan">
                        @error('kecamatan')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Batas-Batas Section -->
            <h5 class="section-title">Batas</h5>
            
            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="batas_utara">Utara</label>
                        <input type="text" class="form-control" id="batas_utara" name="batas_utara" value="{{ old('batas_utara') }}" placeholder="Batas utara">
                        @error('batas_utara')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="batas_timur">Timur</label>
                        <input type="text" class="form-control" id="batas_timur" name="batas_timur" value="{{ old('batas_timur') }}" placeholder="Batas timur">
                        @error('batas_timur')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="batas_selatan">Selatan</label>
                        <input type="text" class="form-control" id="batas_selatan" name="batas_selatan" value="{{ old('batas_selatan') }}" placeholder="Batas selatan">
                        @error('batas_selatan')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="batas_barat">Barat</label>
                        <input type="text" class="form-control" id="batas_barat" name="batas_barat" value="{{ old('batas_barat') }}" placeholder="Batas barat">
                        @error('batas_barat')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-12">
                    <div class="form-group">
                        <label for="luas">Luas</label>
                        <div class="d-flex align-items-center">
                            <input type="number" class="form-control" id="luas" name="luas" value="{{ old('luas') }}" placeholder="Luas tanah" style="width: 200px;" step="0.01">
                            <span class="ml-2">m²</span>
                        </div>
                        @error('luas')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Hak Penguasaan Section -->
            <h5 class="section-title">Hak Yasan Patak D/C (Nomor, Persil, Klas)</h5>
            
            <div class="row mb-3">
                <div class="col-12">
                    <div class="form-group">
                        <label for="tanah_negara">Tanah Negara (Jenis dan Nomor Serp)</label>
                        <input type="text" class="form-control" id="tanah_negara" name="tanah_negara" value="{{ old('tanah_negara') }}" placeholder="Jenis dan nomor serp">
                        @error('tanah_negara')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-12">
                    <div class="form-group">
                        <label for="sppt">SPPT (Tahun dan Nomor)</label>
                        <input type="text" class="form-control" id="sppt" name="sppt" value="{{ old('sppt') }}" placeholder="Tahun dan nomor SPPT">
                        @error('sppt')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Data Pemilik Section -->
            <h5 class="section-title">Data Pemilik</h5>
            
            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="nama_pemilik">Nama</label>
                        <input type="text" class="form-control" id="nama_pemilik" name="nama_pemilik" value="{{ old('nama_pemilik') }}" placeholder="Nama pemilik">
                        @error('nama_pemilik')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="dikuasai_sejak">Dikuasai Sejak Tahun</label>
                        <input type="number" class="form-control" id="dikuasai_sejak" name="dikuasai_sejak" value="{{ old('dikuasai_sejak') }}" placeholder="Tahun" min="1900" max="{{ date('Y') }}">
                        @error('dikuasai_sejak')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-12">
                    <div class="form-group">
                        <label for="dikuasai_oleh">Dikuasai Oleh</label>
                        <input type="text" class="form-control" id="dikuasai_oleh" name="dikuasai_oleh" value="{{ old('dikuasai_oleh') }}" placeholder="Nama yang menguasai">
                        @error('dikuasai_oleh')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Peralihan Tanah Section -->
            <h5 class="section-title">Peralihan Tanah Secara Berturut-turut</h5>
            
            <!-- Pemilik 1 -->
            <div class="card bg-light mb-3">
                <div class="card-body">
                    <h6 class="card-title">Pemilik 1</h6>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="pemilik1_tahun">Pada Tahun</label>
                                <input type="number" class="form-control" id="pemilik1_tahun" name="pemilik1_tahun" value="{{ old('pemilik1_tahun') }}" placeholder="Tahun" min="1900" max="{{ date('Y') }}">
                                @error('pemilik1_tahun')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="pemilik1_dikuasai">Dikuasai oleh</label>
                                <input type="text" class="form-control" id="pemilik1_dikuasai" name="pemilik1_dikuasai" value="{{ old('pemilik1_dikuasai') }}" placeholder="Nama yang menguasai">
                                @error('pemilik1_dikuasai')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="pemilik1_dialihkan">Dialihkan</label>
                                <select class="form-control" id="pemilik1_dialihkan" name="pemilik1_dialihkan">
                                    <option value="">-- Pilih --</option>
                                    <option value="sebagian" {{ old('pemilik1_dialihkan') == 'sebagian' ? 'selected' : '' }}>Sebagian</option>
                                    <option value="seluruhnya" {{ old('pemilik1_dialihkan') == 'seluruhnya' ? 'selected' : '' }}>Seluruhnya</option>
                                  
                                </select>
                                @error('pemilik1_dialihkan')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="pemilik1_luas">Luas (m²)</label>
                                <input type="number" class="form-control" id="pemilik1_luas" name="pemilik1_luas" value="{{ old('pemilik1_luas') }}" placeholder="Luas" step="0.01">
                                @error('pemilik1_luas')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Pemilik 2 -->
            <div class="card bg-light mb-3">
                <div class="card-body">
                    <h6 class="card-title">Pemilik 2</h6>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="pemilik2_tahun">Pada Tahun</label>
                                <input type="number" class="form-control" id="pemilik2_tahun" name="pemilik2_tahun" value="{{ old('pemilik2_tahun') }}" placeholder="Tahun" min="1900" max="{{ date('Y') }}">
                                @error('pemilik2_tahun')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="pemilik2_dikuasai">Dikuasai oleh</label>
                                <input type="text" class="form-control" id="pemilik2_dikuasai" name="pemilik2_dikuasai" value="{{ old('pemilik2_dikuasai') }}" placeholder="Nama yang menguasai">
                                @error('pemilik2_dikuasai')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="pemilik2_dialihkan">Dialihkan</label>
                                <select class="form-control" id="pemilik2_dialihkan" name="pemilik2_dialihkan">
                                    <option value="">-- Pilih --</option>
                                     <option value="sebagian" {{ old('pemilik2_dialihkan') == 'sebagian' ? 'selected' : '' }}>Sebagian</option>
                                    <option value="seluruhnya" {{ old('pemilik2_dialihkan') == 'seluruhnya' ? 'selected' : '' }}>Seluruhnya</option>
                                </select>
                                @error('pemilik2_dialihkan')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="pemilik2_luas">Luas (m²)</label>
                                <input type="number" class="form-control" id="pemilik2_luas" name="pemilik2_luas" value="{{ old('pemilik2_luas') }}" placeholder="Luas" step="0.01">
                                @error('pemilik2_luas')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Pemilik 3 -->
            <div class="card bg-light mb-3">
                <div class="card-body">
                    <h6 class="card-title">Pemilik 3</h6>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="pemilik3_tahun">Pada Tahun</label>
                                <input type="number" class="form-control" id="pemilik3_tahun" name="pemilik3_tahun" value="{{ old('pemilik3_tahun') }}" placeholder="Tahun" min="1900" max="{{ date('Y') }}">
                                @error('pemilik3_tahun')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="pemilik3_dikuasai">Dikuasai oleh</label>
                                <input type="text" class="form-control" id="pemilik3_dikuasai" name="pemilik3_dikuasai" value="{{ old('pemilik3_dikuasai') }}" placeholder="Nama yang menguasai">
                                @error('pemilik3_dikuasai')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="pemilik3_dialihkan">Dialihkan</label>
                                <select class="form-control" id="pemilik3_dialihkan" name="pemilik3_dialihkan">
                                    <option value="">-- Pilih --</option>
                                     <option value="sebagian" {{ old('pemilik3_dialihkan') == 'sebagian' ? 'selected' : '' }}>Sebagian</option>
                                    <option value="seluruhnya" {{ old('pemilik3_dialihkan') == 'seluruhnya' ? 'selected' : '' }}>Seluruhnya</option>
                                </select>
                                @error('pemilik3_dialihkan')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="pemilik3_luas">Luas (m²)</label>
                                <input type="number" class="form-control" id="pemilik3_luas" name="pemilik3_luas" value="{{ old('pemilik3_luas') }}" placeholder="Luas" step="0.01">
                                @error('pemilik3_luas')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Pemilik 4 -->
            <div class="card bg-light mb-3">
                <div class="card-body">
                    <h6 class="card-title">Pemilik 4</h6>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="pemilik4_tahun">Pada Tahun</label>
                                <input type="number" class="form-control" id="pemilik4_tahun" name="pemilik4_tahun" value="{{ old('pemilik4_tahun') }}" placeholder="Tahun" min="1900" max="{{ date('Y') }}">
                                @error('pemilik4_tahun')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="pemilik4_dikuasai">Dikuasai oleh</label>
                                <input type="text" class="form-control" id="pemilik4_dikuasai" name="pemilik4_dikuasai" value="{{ old('pemilik4_dikuasai') }}" placeholder="Nama yang menguasai">
                                @error('pemilik4_dikuasai')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="pemilik4_dialihkan">Dialihkan</label>
                                <select class="form-control" id="pemilik4_dialihkan" name="pemilik4_dialihkan">
                                    <option value="">-- Pilih --</option>
                                     <option value="sebagian" {{ old('pemilik4_dialihkan') == 'sebagian' ? 'selected' : '' }}>Sebagian</option>
                                    <option value="seluruhnya" {{ old('pemilik4_dialihkan') == 'seluruhnya' ? 'selected' : '' }}>Seluruhnya</option>
                                </select>
                                @error('pemilik4_dialihkan')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="pemilik4_luas">Luas (m²)</label>
                                <input type="number" class="form-control" id="pemilik4_luas" name="pemilik4_luas" value="{{ old('pemilik4_luas') }}" placeholder="Luas" step="0.01">
                                @error('pemilik4_luas')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Form Actions -->
        <div class="card-footer d-flex justify-content-between">
            <button type="button" class="btn btn-secondary" onclick="previousTab()">
                ← Sebelumnya
            </button>
            <div>
                <button type="button" class="btn btn-secondary mr-2" onclick="saveDraft()">
                    💾 Simpan Draft
                </button>
                <button type="button" class="btn btn-primary" onclick="nextTab()">
                    Selanjutnya →
                </button>
            </div>
        </div>
    </div>
</div>
