<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Berita Acara Penelitian Penguasaan Tanah</title>
    <style>
    body { font-family: 'Times New Roman', Times, serif; font-size: 12pt; margin: 0; }
    .center { text-align: center; }
    .table { width: 100%; border-collapse: collapse; }
    .table td, .table th { padding: 2px 3px; vertical-align: top; }
    .bordered td, .bordered th { border: 1px solid #000; }
    .signature { height: 60px; }
    .mt-2 { margin-top: 0.5em; }
    .mt-4 { margin-top: 1em; }
    .judul { font-size: 15pt; font-weight: bold; }
    .nomor { font-size: 12pt; }
    .section-title { font-weight: bold; margin-top: 0.5em; }
    .indent { text-indent: 1.5em; margin-bottom: 0.5em; margin-top: 0.5em; }
    p { margin-top: 0.5em; margin-bottom: 0.5em; }
    .table tr { height: 22px; }
    </style>
</head>
<body>
    <div class="center">
        <span class="judul">BERITA ACARA PENELITIAN PENGUASAAN TANAH</span><br>
        <span class="nomor">Nomor: {{ isset($peninjauan->nomor_ba_kesaksian) ? str_replace('BA-', 'BA-PPUT-', $peninjauan->nomor_ba_kesaksian) : '_________' }}</span>
    </div>
    <div style="height:8px;"></div>

    <p class="indent">Pada hari ini {{ \Carbon\Carbon::now()->translatedFormat('l') }} Tanggal {{Carbon\Carbon::now()->format('d')}} Bulan {{Carbon\Carbon::now()->translatedFormat('F')}} Tahun {{Carbon\Carbon::now()->format('Y')}} Kami yang bertanda tangan dibawah ini :</p>

    <table class="table" style="margin-bottom:0.5em;">
        <tr>
            <td width="5%" style="vertical-align:top;">1</td>
            <td width="95%" style="vertical-align:top;">
                Nama &nbsp;&nbsp;: {{ $peninjauan->dataKampung->nama_kepala_kampung ?? '....................................................' }}<br>
                Jabatan : Kepala Kampung/Lurah {{ $peninjauan->petugas_jabatan ?? '' }}
            </td>
        </tr>
        <tr>
            <td width="5%" style="vertical-align:top;">2</td>
            <td width="95%" style="vertical-align:top;">
                Nama &nbsp;&nbsp;: {{ $peninjauan->nama_kaur_pemerintahan ?? '....................................................' }}<br>
                Jabatan : Kaur Pemerintahan {{ $peninjauan->saksi_jabatan ?? '' }}
            </td>
        </tr>
    </table>

    <p class="indent">Telah melaksanakan penelitian penguasaan tanah yang dikuasai/digunakan pertama kali
oleh {{ $peninjauan->nama_pemilik ?? '...........' }} pada bulan {{ \Carbon\Carbon::parse($peninjauan->ba_tanggal ?? now())->translatedFormat('F') }} tahun {{ \Carbon\Carbon::parse($peninjauan->ba_tanggal ?? now())->translatedFormat('Y') }}, selanjutnya diperoleh data-data sebagai berikut:</p>
    <table class="table" style="margin-bottom:0.5em;">
        <tr>
            <td colspan="3"><b>1. DATA FISIK TANAH:</b></td>
        </tr>
        <tr>
            <td width="20px">a.</td>
            <td width="180px">Letak tanah</td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td>Jalan/Gang/Blok</td>
            <td>: {{ $peninjauan->jalan_gg_blok ?? '....................................................' }}</td>
        </tr>
        <tr>
            <td></td>
            <td>RT/RW</td>
            <td>: {{ $peninjauan->rt ?? '....................................................' }}/{{ $peninjauan->rw ?? '....................................................' }}</td>
        </tr>
        <tr>
            <td></td>
            <td>Kampung/Kelurahan</td>
            <td>: {{ $peninjauan->kampung_kelurahan ?? '....................................................' }}</td>
        </tr>
        <tr>
            <td></td>
            <td>Kecamatan</td>
            <td>: {{ $peninjauan->kecamatan ?? '....................................................' }}</td>
        </tr>
        <tr>
            <td></td>
            <td>Kabupaten</td>
            <td>: Berau</td>
        </tr>
        <tr>
            <td width="20px">b.</td>
            <td>Batas-batas bidang tanah</td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td>Utara</td>
            <td>: {{ $peninjauan->batas_utara ?? '....................' }}</td>
        </tr>
        <tr>
            <td></td>
            <td>Timur</td>
            <td>: {{ $peninjauan->batas_timur ?? '....................' }}</td>
        </tr>
        <tr>
            <td></td>
            <td>Selatan</td>
            <td>: {{ $peninjauan->batas_selatan ?? '....................' }}</td>
        </tr>
        <tr>
            <td></td>
            <td>Barat</td>
            <td>: {{ $peninjauan->batas_barat ?? '....................' }}</td>
        </tr>
        <tr>
            <td width="20px">c.</td>
            <td>Luas Tanah</td>
            <td>: {{ $peninjauan->luas ?? '....................' }} m²</td>
        </tr>
        <tr>
            <td width="20px">d.</td>
            <td>Penggunaan tanah saat ini</td>
            <td>: {{ $peninjauan->penggunaan_tanah ?? '....................' }}</td>
        </tr>
        <tr>
            <td width="20px">e.</td>
            <td>Patok tanda batas di lapangan berupa</td>
            <td>: {{ $peninjauan->tanda_batas ?? '....................' }}</td>
        </tr>
        <tr><td colspan="3"><b>2. DATA YURIDIS</b></td></tr>
        <tr>
            <td></td>
            <td colspan="2">Riwayat perolehan tanah: diuraikan secara berurut perolehan tanah sebagai berikut:<br>
            <b>{{ $peninjauan->riwayat_perolehan ?? '....................................................................................................................' }}</b><br>
            </td>
        </tr>
        <tr><td colspan="3"><b>3. DATA PENDUKUNG</b></td></tr>
        <tr>
            <td></td>
            <td colspan="2">Photo dokumentasi/kwitansi bukti perolehan tanah</td>
        </tr>
        <tr>
            <td></td>
            <td>IMB Tanggal</td>
            <td>: {{ Carbon\Carbon::parse($peninjauan->imb_tanggal)->format('d/m/Y') ?? '....................' }} </td>
            <td>No. {{ $peninjauan->no_imb ?? '....................' }}</td>
        </tr>
        <tr>
            <td></td>
            <td>SPPT PBB Tahun</td>
            <td>: {{ $peninjauan->sppt_pbb_tahun ?? '....................' }}</td>
            <td></td>
        </tr>
    </table>



    <p class="indent">
        Demikian Berita Acara Penelitian Penguasaaan Tanah ini dibuat dengan sebenarnya untuk dapat dipergunakan sebagaimana mestinya.<br>
        <span style="display:block; margin-top:1em; text-align:center;">Yang melaksanakan pemeriksaan,</span>
    </p>

    <table class="table" style="margin-top:0.5em;">
        <tr>
            <td class="center" style="width:50%;">
                Kepala Kampung/Lurah,
            </td>
            <td class="center" style="width:50%;">
                Kaur Pemerintahan
            </td>
        </tr>
        <tr>
            <td class="center" style="height:100px; vertical-align:bottom;">
                {{ $peninjauan->dataKampung->nama_kepala_kampung ?? '....................................................' }}
            </td>
            <td class="center" style="height:100px; vertical-align:bottom;">
                {{ $peninjauan->nama_kaur_pemerintahan ?? '....................................................' }}
            </td>
        </tr>
    </table>

    <div style="margin-top:1em; font-size:11pt;">
        <i>*) coret yang tidak perlu</i>
    </div>
</body>
</html>
