@extends('admin-layouts.master')

@section('content')

<div class="container-fluid">

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Pengeluaran (Filter)</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                Rp {{ number_format($totalPengeluaran, 0, ',', '.') }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-calculator fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Bulan Ini</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                Rp {{ number_format($bulanIni, 0, ',', '.') }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-calendar-alt fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Tahun Ini</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                Rp {{ number_format($tahunIni, 0, ',', '.') }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-chart-line fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Total Data</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $pengeluarans->total() }} Item
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clipboard-list fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold text-primary">Data Pengeluaran</h6>
            <!-- Export Buttons -->
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-success btn-sm" onclick="exportExcel()" title="Export ke Excel">
                    <i class="fas fa-file-excel"></i> Export Excel
                </button>
                <button type="button" class="btn btn-info btn-sm" onclick="printData()" title="Print Data">
                    <i class="fas fa-print"></i> Print
                </button>
            </div>
        </div>
        <div class="card-body">
            <!-- Filter & Search Section -->
            <div class="row mb-3">
                <div class="col-md-12">
                    <form method="GET" action="{{ route('pengeluaran.index') }}" id="filterForm">
                        <div class="row">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="search" class="small">Cari Deskripsi:</label>
                                    <input type="text" class="form-control form-control-sm" id="search" name="search" 
                                           value="{{ request('search') }}" placeholder="Masukkan kata kunci...">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="bulan" class="small">Bulan:</label>
                                    <select class="form-control form-control-sm" id="bulan" name="bulan">
                                        <option value="">Semua Bulan</option>
                                        @for($i = 1; $i <= 12; $i++)
                                            <option value="{{ $i }}" {{ request('bulan') == $i ? 'selected' : '' }}>
                                                {{ DateTime::createFromFormat('!m', $i)->format('F') }}
                                            </option>
                                        @endfor
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="tahun" class="small">Tahun:</label>
                                    <select class="form-control form-control-sm" id="tahun" name="tahun">
                                        <option value="">Pilih Tahun</option>
                                        @for($i = date('Y'); $i >= 2020; $i--)
                                            <option value="{{ $i }}" {{ request('tahun', date('Y')) == $i ? 'selected' : '' }}>
                                                {{ $i }}
                                            </option>
                                        @endfor
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label class="small">&nbsp;</label>
                                    <div class="d-flex">
                                        <button type="submit" class="btn btn-info btn-sm mr-1">
                                            <i class="fas fa-search"></i> Filter
                                        </button>
                                        <a href="{{ route('pengeluaran.index') }}" class="btn btn-secondary btn-sm">
                                            <i class="fas fa-sync-alt"></i> Reset
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label class="small">&nbsp;</label>
                                    <div>
                                        <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#pengeluaranModal" id="addPengeluaranBtn">
                                            <i class="fas fa-plus"></i> Tambah Data
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label class="small">Quick Export:</label>
                                    <div class="dropdown">
                                        <button class="btn btn-outline-success btn-sm dropdown-toggle w-100" type="button" id="quickExportDropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            <i class="fas fa-download"></i> Export
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-right" aria-labelledby="quickExportDropdown">
                                            <a class="dropdown-item" href="#" onclick="exportExcel()">
                                                <i class="fas fa-file-excel text-success"></i> Export Excel (.csv)
                                            </a>
                                            <div class="dropdown-divider"></div>
                                            <a class="dropdown-item" href="#" onclick="printData()">
                                                <i class="fas fa-print text-primary"></i> Print Laporan
                                            </a>
                                            <a class="dropdown-item" href="#" onclick="printPreview()">
                                                <i class="fas fa-eye text-info"></i> Preview Print
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Alert untuk info filter -->
            @if(request('search') || request('bulan') || request('tahun'))
            <div class="alert alert-info alert-dismissible fade show" role="alert">
                <i class="fas fa-info-circle"></i>
                <strong>Filter Aktif:</strong> 
                @if(request('search'))
                    Pencarian: "{{ request('search') }}"
                @endif
                @if(request('bulan'))
                    , Bulan: {{ DateTime::createFromFormat('!m', request('bulan'))->format('F') }}
                @endif
                @if(request('tahun'))
                    , Tahun: {{ request('tahun') }}
                @endif
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            @endif

            <div class="table-responsive">
                <table class="table table-bordered table-hover" width="100%" cellspacing="0">
                    <thead class="thead-light">
                        <tr>
                            <th width="5%">No</th>
                            <th width="15%">Tanggal</th>
                            <th width="30">Deskripsi</th>
                            <th width="20%">Jumlah</th>
                            <th width="20%">Aksi</th>
                            <th width="10%">Verif</th>

                        </tr>
                    </thead>
                    
                    <tbody>
                        @forelse ($pengeluarans as $pengeluaran)
                        <tr>
                            <td>{{ ($pengeluarans->currentPage() - 1) * $pengeluarans->perPage() + $loop->iteration }}</td>
                            <td>
                                <span class="badge badge-info">
                                    {{ $pengeluaran->tanggal_format }}
                                </span>
                            </td>
                            <td>{{ $pengeluaran->deskripsi }}</td>
                            <td>
                                <strong class="text-danger">{{ $pengeluaran->jumlah_format }}</strong>
                            </td>
                            <td>
                                <div class="btn-group" role="group">
                                    <button class="btn btn-warning btn-sm" 
                                            onclick="editPengeluaran({{ $pengeluaran->id }}, '{{ $pengeluaran->tanggal }}', '{{ addslashes($pengeluaran->deskripsi) }}', {{ $pengeluaran->jumlah_pengeluaran }})"
                                            title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <button onclick="deletePengeluaran({{ $pengeluaran->id }})" 
                                            class="btn btn-danger btn-sm" title="Hapus">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                    
                                </div>
                               
                            </td>
                           <td class="text-center">
    <button type="button" 
            class="btn btn-sm {{ $pengeluaran->status ? 'btn-success' : 'btn-secondary' }} toggle-status"
            data-id="{{ $pengeluaran->id }}">
        <i class="fas {{ $pengeluaran->status ? 'fa-check-circle' : 'fa-times-circle' }}"></i>
        {{ $pengeluaran->status ? 'Terverifikasi' : 'Belum' }}
    </button>
</td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="5" class="text-center">
                                <div class="py-4">
                                    <i class="fas fa-inbox fa-3x text-gray-300 mb-3"></i>
                                    <p class="text-gray-500">Belum ada data pengeluaran</p>
                                    <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#pengeluaranModal">
                                        <i class="fas fa-plus"></i> Tambah Pengeluaran Pertama
                                    </button>
                                </div>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            @if ($pengeluarans->hasPages())
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div>
                        <p class="mb-0 text-muted small">
                            Menampilkan {{ $pengeluarans->firstItem() }} sampai {{ $pengeluarans->lastItem() }} 
                            dari {{ $pengeluarans->total() }} data
                        </p>
                    </div>
                    <div>
                        {{ $pengeluarans->links('pagination::bootstrap-4') }}
                    </div>
                </div>
            @endif

        </div>
    </div>

</div>

<!-- Modal untuk Tambah/Edit Pengeluaran -->
<div class="modal fade" id="pengeluaranModal" tabindex="-1" role="dialog" aria-labelledby="pengeluaranModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="pengeluaranModalLabel">
                    <i class="fas fa-plus-circle mr-2"></i>Tambah Pengeluaran
                </h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="pengeluaranForm" method="POST" action="{{ route('pengeluaran.store') }}">
                @csrf
                <div id="methodField"></div>
                <input type="hidden" name="id" id="pengeluaran_id" value="">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="tanggal">Tanggal <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" id="tanggal" name="tanggal" 
                                       value="{{ date('Y-m-d') }}" required>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="jumlah_pengeluaran">Jumlah Pengeluaran <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">Rp</span>
                                    </div>
                                    <input type="number" class="form-control" id="jumlah_pengeluaran" name="jumlah_pengeluaran" 
                                           placeholder="0" min="0" step="0.01" required>
                                </div>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="deskripsi">Deskripsi <span class="text-danger">*</span></label>
                        <textarea class="form-control" id="deskripsi" name="deskripsi" rows="3" 
                                  placeholder="Masukkan deskripsi pengeluaran..." required></textarea>
                        <div class="invalid-feedback"></div>
                        <small class="form-text text-muted">Maksimal 255 karakter</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">
                        <i class="fas fa-times"></i> Batal
                    </button>
                    <button type="submit" class="btn btn-primary" id="submitBtn">
                        <i class="fas fa-save"></i> Simpan
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Form untuk Delete -->
<form action="" method="post" id="deleteForm">
    @csrf
    @method("DELETE")
    <input type="submit" value="Hapus" style="display:none">
</form>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
<script>
// Global variables
let isEdit = false;
let editId = null;
document.querySelectorAll('.toggle-status').forEach(btn => {
    btn.addEventListener('click', async (e) => {
        const el = e.currentTarget;
        const id = el.dataset.id;
        const status = !el.classList.contains('btn-success'); // toggle

        const res = await fetch(`/pengeluaran/${id}/toggle-status`, {
            method: 'PATCH',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ status })
        });

        if (res.ok) {
            if (status) {
                el.classList.remove('btn-secondary');
                el.classList.add('btn-success');
                el.innerHTML = '<i class="fas fa-check-circle"></i> Terverifikasi';
            } else {
                el.classList.remove('btn-success');
                el.classList.add('btn-secondary');
                el.innerHTML = '<i class="fas fa-times-circle"></i> Belum';
            }
        }
    });
});

// Event listeners
$(document).ready(function() {
    // Handle form submission
    $('#pengeluaranForm').submit(function(e) {
        e.preventDefault();
        submitForm();
    });

    // Reset modal when closed
    $('#pengeluaranModal').on('hidden.bs.modal', function() {
        resetModal();
    });

    // Format number input
    $('#jumlah_pengeluaran').on('input', function() {
        let value = $(this).val();
        // Remove non-numeric characters except decimal point
        value = value.replace(/[^0-9.]/g, '');
        $(this).val(value);
    });


});

// Export functions
function exportExcel() {
    const form = $('#filterForm');
    const params = form.serialize();
    
    // Show loading
    Swal.fire({
        title: 'Memproses Export...',
        text: 'Mohon tunggu sebentar',
        icon: 'info',
        allowOutsideClick: false,
        showConfirmButton: false,
        willOpen: () => {
            Swal.showLoading()
        }
    });
    
    // Create download link
    const url = `{{ route('pengeluaran.export.excel') }}?${params}`;
    window.open(url, '_blank');
    
    // Close loading after short delay
    setTimeout(() => {
        Swal.close();
    }, 1000);
}

function printData() {
    const form = $('#filterForm');
    const params = form.serialize();
    
    // Show loading
    Swal.fire({
        title: 'Mempersiapkan Print...',
        text: 'Membuka jendela print',
        icon: 'info',
        timer: 1000,
        showConfirmButton: false
    });
    
    const url = `{{ route('pengeluaran.export.print') }}?${params}`;
    window.open(url, '_blank', 'width=800,height=600');
}

function printPreview() {
    const form = $('#filterForm');
    const params = form.serialize();
    
    const url = `{{ route('pengeluaran.export.print') }}?${params}`;
    window.open(url, '_blank', 'width=1000,height=700');
}

// Add new pengeluaran
$(document).on('click', '#addPengeluaranBtn', function() {
    resetModal();
    $('#pengeluaranModalLabel').html('<i class="fas fa-plus-circle mr-2"></i>Tambah Pengeluaran Baru');
    $('#submitBtn').html('<i class="fas fa-save"></i> Simpan');
    $('#pengeluaranForm').attr('action', '{{ route("pengeluaran.store") }}');
    isEdit = false;
});

// Edit pengeluaran function
function editPengeluaran(id, tanggal, deskripsi, jumlah) {
    isEdit = true;
    editId = id;
    
    $('#pengeluaranModalLabel').html('<i class="fas fa-edit mr-2"></i>Edit Pengeluaran');
    $('#submitBtn').html('<i class="fas fa-save"></i> Update');
    $('#methodField').html('@method("PUT")');
    $('#pengeluaranForm').attr('action', `{{ url('pengeluaran') }}/${id}`);
    
    // Fill form with existing data
    let tgl = tanggal.split(' ')[0]; // kalau inputnya '2025-08-25 12:30:00'
    $('#tanggal').val(tgl);
    $('#deskripsi').val(deskripsi);
    $('#jumlah_pengeluaran').val(jumlah);
    $('#pengeluaran_id').val(id);
    
    $('#pengeluaranModal').modal('show');
}

// Delete pengeluaran function
function deletePengeluaran(id) {
    Swal.fire({
        title: 'Apakah Anda yakin?',
        text: "Data pengeluaran yang sudah dihapus tidak dapat dikembalikan!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Ya, Hapus!',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.value) {
            // Set form action and submit
            $('#deleteForm').attr('action', `{{ url('pengeluaran') }}/${id}`);
            $('#deleteForm').submit();
        }
    });
}

// Submit form function
function submitForm() {
    const formData = new FormData($('#pengeluaranForm')[0]);
    const url = $('#pengeluaranForm').attr('action');
    
    // Show loading
    $('#submitBtn').prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Menyimpan...');
    
    // Clear previous errors
    $('.form-control').removeClass('is-invalid');
    $('.invalid-feedback').text('');
    
    $.ajax({
        url: url,
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        },
        success: function(response) {
            $('#pengeluaranModal').modal('hide');
            Swal.fire({
                title: 'Berhasil!',
                text: response.message || (isEdit ? 'Pengeluaran berhasil diupdate!' : 'Pengeluaran berhasil disimpan!'),
                icon: 'success',
                timer: 2000,
                showConfirmButton: false
            }).then(() => {
                location.reload();
            });
        },
        error: function(xhr) {
            console.log('Error response:', xhr);
            
            if (xhr.status === 422) {
                // Validation errors
                const errors = xhr.responseJSON.errors;
                if (errors) {
                    Object.keys(errors).forEach(function(key) {
                        const field = $(`#${key}`);
                        field.addClass('is-invalid');
                        field.siblings('.invalid-feedback').text(errors[key][0]);
                    });
                }
                
                Swal.fire({
                    title: 'Validasi Error!',
                    text: 'Silakan periksa form Anda.',
                    icon: 'error'
                });
            } else {
                // Other errors
                const message = xhr.responseJSON?.message || 'Terjadi kesalahan saat menyimpan data.';
                Swal.fire({
                    title: 'Error!',
                    text: message,
                    icon: 'error'
                });
            }
        },
        complete: function() {
            $('#submitBtn').prop('disabled', false).html(isEdit ? '<i class="fas fa-save"></i> Update' : '<i class="fas fa-save"></i> Simpan');
        }
    });
}

// Reset modal function
function resetModal() {
    $('#pengeluaranForm')[0].reset();
    $('#methodField').empty();
    $('.form-control').removeClass('is-invalid');
    $('.invalid-feedback').text('');
    $('#pengeluaran_id').val('');
    $('#tanggal').val('{{ date('Y-m-d') }}');
    isEdit = false;
    editId = null;
}

// Handle success messages from server
@if(session('success'))
    Swal.fire({
        title: 'Berhasil!',
        text: '{{ session("success") }}',
        icon: 'success',
        timer: 3000,
        showConfirmButton: false
    });
@endif

@if(session('error'))
    Swal.fire({
        title: 'Error!',
        text: '{{ session("error") }}',
        icon: 'error'
    });
@endif
</script>

@endpush

@endsection