<div class="row">
    <div class="col-md-6">
        <h6 class="text-primary font-weight-bold mb-3">Data Pemohon</h6>
        <table class="table table-sm table-borderless">
            <tr>
                <td class="font-weight-bold" style="width: 40%;">No. Registrasi:</td>
                <td>{{ $application->no_registrasi }}</td>
            </tr>
            <tr>
                <td class="font-weight-bold">Nama Pemohon:</td>
                <td>{{ strtoupper($application->nama_pemohon) }}</td>
            </tr>
            <tr>
                <td class="font-weight-bold">NIK:</td>
                <td>{{ $application->nik }}</td>
            </tr>
            <tr>
                <td class="font-weight-bold">Tempat, Tgl Lahir:</td>
                <td>{{ $application->tempat_lahir }}, {{ $application->tanggal_lahir->format('d F Y') }}</td>
            </tr>
            <tr>
                <td class="font-weight-bold">Pekerjaan:</td>
                <td>{{ $application->pekerjaan }}</td>
            </tr>
            <tr>
                <td class="font-weight-bold">Telepon:</td>
                <td>{{ $application->telepon }}</td>
            </tr>
        </table>
    </div>
    
    <div class="col-md-6">
        <h6 class="text-primary font-weight-bold mb-3">Data Tanah</h6>
        <table class="table table-sm table-borderless">
            <tr>
                <td class="font-weight-bold" style="width: 40%;">Lokasi Tanah:</td>
                <td>{{ $application->letak_tanah }}</td>
            </tr>
            <tr>
                <td class="font-weight-bold">RT/RW:</td>
                <td>{{ $application->tanah_rt }}/{{ $application->tanah_rw }}</td>
            </tr>
            <tr>
                <td class="font-weight-bold">Kampung:</td>
                <td>{{ $application->kelurahan_kampung }}</td>
            </tr>
            <tr>
                <td class="font-weight-bold">Luas Tanah:</td>
                <td>{{ number_format($application->luas, 0, ',', '.') }} m²</td>
            </tr>
            <tr>
                <td class="font-weight-bold">Peruntukan:</td>
                <td>{{ $application->peruntukan }}</td>
            </tr>
            <tr>
                <td class="font-weight-bold">Status:</td>
                <td>
                    @if($application->status_permohonan == 'SELESAI')
                        <span class="badge badge-success">SELESAI</span>
                    @else
                        <span class="badge badge-warning">BELUM SELESAI</span>
                    @endif
                </td>
            </tr>
        </table>
    </div>
</div>

@if($application->peninjauan)
<hr class="my-4">
<div class="row">
    <div class="col-12">
        <h6 class="text-primary font-weight-bold mb-3">Data Peninjauan</h6>
        <table class="table table-sm table-borderless">
            <tr>
                <td class="font-weight-bold" style="width: 20%;">No. BA Penelitian:</td>
                <td style="width: 30%;">{{ $application->peninjauan->nomor_ba_penelitian ?? '-' }}</td>
                <td class="font-weight-bold" style="width: 20%;">Tanggal BA:</td>
                <td style="width: 30%;">{{ $application->peninjauan->bulan_tahun_penelitian ? $application->peninjauan->bulan_tahun_penelitian->format('d F Y') : '-' }}</td>
            </tr>
            <tr>
                <td class="font-weight-bold">Status Penguasaan:</td>
                <td>{{ $application->peninjauan->status_penguasaan_kesimpulan ? ucfirst(str_replace('_', ' ', $application->peninjauan->status_penguasaan_kesimpulan)) : '-' }}</td>
                <td class="font-weight-bold">Luas Terukur:</td>
                <td>{{ $application->peninjauan->luas_terukur_kesimpulan ? number_format($application->peninjauan->luas_terukur_kesimpulan, 0, ',', '.') . ' m²' : '-' }}</td>
            </tr>
            <tr>
                <td class="font-weight-bold">Petugas 1:</td>
                <td>{{ $application->peninjauan->petugas1_nama ?? '-' }}</td>
                <td class="font-weight-bold">Petugas 2:</td>
                <td>{{ $application->peninjauan->petugas2_nama ?? '-' }}</td>
            </tr>
        </table>
    </div>
</div>
@endif

<div class="row mt-4">
    <div class="col-12">
        <h6 class="text-primary font-weight-bold mb-3">Rekomendasi</h6>
        <div class="row">
            @if($application->peninjauan)
                <div class="col-md-6">
                    <ul class="list-unstyled">
                        <li class="mb-2">
                            <i class="fas fa-{{ $application->peninjauan->rekomendasi_skpt ? 'check text-success' : 'times text-muted' }}"></i>
                            <span class="{{ $application->peninjauan->rekomendasi_skpt ? 'font-weight-bold text-success' : 'text-muted' }}">SKPT</span>
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-{{ $application->peninjauan->rekomendasi_sertifikat ? 'check text-success' : 'times text-muted' }}"></i>
                            <span class="{{ $application->peninjauan->rekomendasi_sertifikat ? 'font-weight-bold text-success' : 'text-muted' }}">Sertifikat</span>
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-{{ $application->peninjauan->rekomendasi_mediasi ? 'check text-success' : 'times text-muted' }}"></i>
                            <span class="{{ $application->peninjauan->rekomendasi_mediasi ? 'font-weight-bold text-success' : 'text-muted' }}">Mediasi</span>
                        </li>
                    </ul>
                </div>
                <div class="col-md-6">
                    <ul class="list-unstyled">
                        <li class="mb-2">
                            <i class="fas fa-{{ $application->peninjauan->rekomendasi_verifikasi ? 'check text-success' : 'times text-muted' }}"></i>
                            <span class="{{ $application->peninjauan->rekomendasi_verifikasi ? 'font-weight-bold text-success' : 'text-muted' }}">Verifikasi</span>
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-{{ $application->peninjauan->rekomendasi_tolak ? 'check text-danger' : 'times text-muted' }}"></i>
                            <span class="{{ $application->peninjauan->rekomendasi_tolak ? 'font-weight-bold text-danger' : 'text-muted' }}">Tolak</span>
                        </li>
                    </ul>
                </div>
                @if($application->peninjauan->catatan_rekomendasi)
                <div class="col-12 mt-2">
                    <small class="text-muted font-weight-bold">Catatan:</small>
                    <p class="small text-muted mt-1">{{ $application->peninjauan->catatan_rekomendasi }}</p>
                </div>
                @endif
            @else
                <div class="col-12">
                    <p class="text-muted text-center">Data peninjauan belum tersedia</p>
                </div>
            @endif
        </div>
    </div>
</div>