@extends('admin-layouts.master')

@section('content')

<div class="container-fluid">
    <h1 class="h3 mb-2 text-gray-800">Isi Pemeriksaan Pasien</h1>
    <div class="card">
        <div class="card-body">
            <form  action="{{ route('pemeriksaan.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="pasien_id" value="{{ $pasien->id }}">
                <input type="hidden" name="antrian_id" value="{{ $antrian->id }}">
                <div class="form-row">
                    <div class="col">
                        <div class="form-group ">
                            <label for=""@error('name') class="text-danger" @enderror >Nama Pasien</label>
                            <input type="text" name="name" class="form-control @error('name') form-control is-invalid @enderror"
                            placeholder="" value="{{ $pasien->nama_pasien}}" readonly>
                            @error('name')
                                <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                        </div>
                    </div>
                    <div class="col">
                        <div class="form-group ">
                            <label for=""@error('name') class="text-danger" @enderror >Usia Pasien</label>
                            <input type="text" class="form-control @error('name') form-control is-invalid @enderror"
                            placeholder="" value="{{ $pasien->usia}}" readonly>
                            @error('name')
                                <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                        </div>
                    </div>
                </div>
                <div class="form-row">
                    <div class="col">
                        <div class="form-group">
                            <label for=""@error('tekanan_darah') class="text-danger" @enderror >Tekanan Darah (mmhg)
                            </label>
                            <input type="text" name="tekanan_darah" class="form-control @error('tekanan_darah') form-control is-invalid @enderror"
                            placeholder="" value="{{ old('tekanan_darah') }}">
                            @error('tekanan_darah')
                                <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                        </div>
                    </div>
                    <div class="col">
                        <div class="form-group">
                            <label for=""@error('berat_badan') class="text-danger" @enderror >Berat Badan (Kg)</label>
                            <input type="text" name="berat_badan" class="form-control @error('berat_badan') form-control is-invalid @enderror"
                            placeholder="" value="{{ old('berat_badan') }}">
                            @error('berat_badan')
                                <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                        </div>
                    </div>
                    <div class="col">
                        <div class="form-group">
                            <label for=""@error('tinggi_badan') class="text-danger" @enderror >Tinggi Badan (Cm)</label>
                            <input type="text" name="tinggi_badan" class="form-control @error('tinggi_badan') form-control is-invalid @enderror"
                            placeholder="" value="{{ old('tinggi_badan') }}">
                            @error('tinggi_badan')
                                <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                        </div>
                    </div>
                </div>
               
                <div class="form-row">
                    <div class="col">
                        <div class="form-group">
                            <label for=""@error('respi') class="text-danger" @enderror >Respi (x/menit)</label>
                            <input type="text" name="respi" class="form-control @error('respi') form-control is-invalid @enderror"
                            placeholder="" value="{{ old('respi') }}">
                            @error('respi')
                                <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                        </div>
                    </div>
                    <div class="col">
                        <div class="form-group">
                            <label for=""@error('suhu') class="text-danger" @enderror >Suhu Tubuh (°C)</label>
                            <input type="text" name="suhu" class="form-control @error('suhu') form-control is-invalid @enderror"
                            placeholder="" value="{{ old('suhu') }}">
                            @error('suhu')
                                <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                        </div>
                    </div>
                    <div class="col">
                        <div class="form-group">
                            <label for=""@error('nadi') class="text-danger" @enderror >Nadi (x/menit)</label>
                            <input type="text" name="nadi" class="form-control @error('nadi') form-control is-invalid @enderror"
                            placeholder="" value="{{ old('nadi') }}">
                            @error('nadi')
                                <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label for="exampleFormControlTextarea1">Keluhan Utama</label>
                    <textarea class="form-control" id="exampleFormControlTextarea1" rows="3" name="keluhan_utama" value="{{ old('keluhan_utama') }}" required></textarea>
                  </div>
                <div class="form-group">
                    <a href="javascript:history.back()" class="btn btn-danger mt-3"> Kembali</a>
                    <input type="submit" value="Simpan" class="btn btn-primary mt-3">
                    
                </div>
            </form>
        </div>
    </div>
</div>
@endsection