@extends('admin-layouts.master')

@section('content')

<div class="container-fluid">

    <!-- Page Heading -->
    <h1 class="h3 mb-2 text-gray-800">Data Pasien</h1>
    

    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Data Rekam Medis Pasien</h6>
        </div>
        <div class="card-body">
            <div class="text-right px-3 py-3">

                {{-- <a href="{{ route('pasien.create') }}" class="btn btn-outline-primary">
                    Tambah User
                </a> --}}

            </div>
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>No Rekam Medis</th>
                            <th>Nama Pasien</th>
                            <th>Jenis Kelamin</th>
                            <th>Usia</th>
                            <th>Alamat</th>
                            <th>Nomor Hp</th>
                            <th>Tanggal Rekam</th>
                            <th>Riwayat Pasien</th>
                            <th>Riwayat Penyakit</th>
                        </tr>
                    </thead>
                    
                    <tbody>
                        @foreach ($pasien as $u)
                        <tr>
                            @php
                
                          
                            @endphp
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $u->nomor_rekam_medis }}</td>
                            <td>{{ $u->nama_pasien }}</td>
                            <td>{{ $u->jenis_kelamin }}</td>
                            <td>{{ $u->usia }}</td>
                            <td>{{ $u->alamat }}</td>
                            @if($u->telp != NULL)
                            <td>{{ $u->telp }}</td>
                            @else
                            <td>TIDAK ADA</td>
                            @endif
                            <td>{{ Carbon\Carbon::parse($u->created_at)->translatedFormat('d F Y') }}</td>
                            <td>{{ $u->riwayat_alergi }}</td>
                            <td>
                               {{ $u->riwayat_penyakit }}
                            </td>
                        </tr>
                        @endforeach
                        
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>

    @push('scripts')
 
   <script src="https://code.jquery.com/jquery-3.6.0.slim.js" integrity="sha256-HwWONEZrpuoh951cQD1ov2HUK5zA5DwJ1DNUXaM6FsY=" crossorigin="anonymous"></script>
<script src="{{ asset('template-admin/vendor/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('template-admin/vendor/datatables/dataTables.bootstrap4.min.js') }}"></script>

<script src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.bootstrap4.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.colVis.min.js"></script>
<script>
       $(document).ready(function() {
        $('#dataTable').DataTable( {
            dom: 'Bfrtip',
            buttons: [
                { extend: 'copyHtml5', className: 'btn-light btn-outline-primary', title: 'Rekam_Medis_Sinar_Wargi', text:'<i class="fas fa-copy"></i> Copy'},
                { extend: 'excelHtml5', className: 'btn-light btn-outline-success', title: 'Rekam_Medis_Sinar_Wargi',text: '<i class="fas fa-file-excel"></i> Excel',},
                { extend: 'csvHtml5', className: 'btn-light btn-outline-info',title: 'Rekam_Medis_Sinar_Wargi', text: '<i class="fas fa-file-csv"></i> CSV',},
                { extend: 'pdfHtml5', className: 'btn-light btn-outline-danger',title: 'Rekam_Medis_Sinar_Wargi', text: '<i class="fas fa-print"></i> Print',},
                
            ]
        } );
    } );
   </script>
@endpush

@endsection