@extends('admin-layouts.master')

@section('content')

<div class="container-fluid">
    <h1 class="h3 mb-2 text-gray-800">Edit Data Pasien</h1>
    <div class="row  justify-content-center align-items-center">
        <div class="col ">
            <div class="card ">
                <div class="card-body">
                    <form  action="{{ route('pasien.update', $pasien)}}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <input type="hidden" name="nomor_rekam_medis" value="{{ $pasien->nomor_rekam_medis }}">
                        
                        
                        <input type="hidden" name="usia1" value="" id="usia1">
                        <div class="form-row">
                            <div class="col">
                                <div class="form-group">
                                    <label for=""@error('nomor_rekam_medis') class="text-danger" @enderror >Nomor Rekam Medis</label>
                                    <input type="text" name="" class="form-control @error('name') form-control is-invalid @enderror"
                                    placeholder="" value="{{$pasien->nomor_rekam_medis}}" readonly>
                                    @error('nomor_rekam_medis')
                                        <span  class="text-danger"> {{ $message }} </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-group">
                                    <label for=""@error('nama_pasien') class="text-danger" @enderror >Nama Pasien</label>
                                    <input type="text" name="nama_pasien" class="form-control @error('name') form-control is-invalid @enderror"
                                    placeholder="" value="{{$pasien->nama_pasien ?? old('nama_pasien') }}">
                                    @error('nama_pasien')
                                        <span  class="text-danger"> {{ $message }} </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-group">
                                    <label for=""@error('telp') class="text-danger" @enderror >No HP</label>
                                    <input type="text" name="telp" class="form-control @error('telp') form-control is-invalid @enderror"
                                    placeholder="" value="{{$pasien->telp ?? old('telp') }}">
                                    @error('telp')
                                        <span  class="text-danger"> {{ $message }} </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col">
                                
                                    <label for=""@error('jenis_kelamin') class="text-danger " @enderror >Jenis Kelamin</label>
                                    <div class="form-group mt-1 ">
                                        @if($pasien->jenis_kelamin == 'Laki-laki')
                                          <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="jenis_kelamin" id="inlineRadio1" value="Laki-laki" checked>
                                            <label class="form-check-label" for="inlineRadio1">Laki-laki</label>
                                          </div>
                                          <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="jenis_kelamin" id="inlineRadio2" value="Perempuan">
                                            <label class="form-check-label" for="inlineRadio2">Perempuan</label>
                                          </div>
                                        @else
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="jenis_kelamin" id="inlineRadio1" value="Laki-laki">
                                            <label class="form-check-label" for="inlineRadio1">Laki-laki</label>
                                          </div>
                                          <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="jenis_kelamin" id="inlineRadio2" value="Perempuan" checked>
                                            <label class="form-check-label" for="inlineRadio2">Perempuan</label>
                                          </div>
                                        @endif
                                    </div>
                               
                            </div>
                           
                        </div>
                        <div class="form-row">
                        
                            <div class="col">
                                <div class="form-group">
                                    <label for=""@error('tanggal_lahir') class="text-danger" @enderror >Tanggal Lahir</label>
                                    <input id="tahun" type="date" name="tanggal_lahir" class="form-control @error('tanggal_lahir') form-control is-invalid @enderror"
                                    placeholder="" value="{{$pasien->tanggal_lahir ?? old('tanggal_lahir') }}">
                                    @error('tanggal_lahir')
                                        <span  class="text-danger"> {{ $message }} </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-group">
                                    <label for=""@error('usia') class="text-danger" @enderror >Usia</label>
                                    <input type="text" name="usia" id="usia" class="form-control @error('email') form-control is-invalid @enderror"
                                    placeholder="" value="{{ $pasien->usia }}" readonly>
                                    @error('usia')
                                        <span  class="text-danger"> {{ $message }} </span>
                                    @enderror
                                </div>
                            </div>
                           <div class="col">
                            <div class="form-group @error('dokter') has-error @enderror " >
                                <label for=""@error('dokter') class="text-danger" @enderror >Dokter</label>
                                <select class="form-control" name="dokter">
                                    <option value="" selected disabled>Pilih</option>
                                   
                                    @foreach ($dokter as $key => $value)
                                    <option value="{{ $value->name }}" @if($value->name == $pasien->dokter) selected @endif>{{ $value->name}}</option>
                                    @endforeach
                                </select>
                                @error('dokter')
                                    <span  class="help-block"> {{ $message }} </span>
                                @enderror
                            </div>
                           </div>
                          </div>
                          <div class="form-group">
                            <label for="exampleFormControlTextarea1">Alamat</label>
                            <textarea class="form-control" id="exampleFormControlTextarea1" rows="3" name="alamat" value=""> {{ $pasien->alamat }}</textarea>
                          </div>
                          <div class="form-group">
                            <label for="exampleFormControlTextarea1">Riwayat Alergi</label>
                            <textarea class="form-control" id="exampleFormControlTextarea1" rows="3" name="riwayat_alergi" value="">{{ $pasien->riwayat_alergi }}</textarea>
                          </div>
                          <div class="form-group">
                            <label for="exampleFormControlTextarea1">Riwayat Penyakit</label>
                            <textarea class="form-control" id="exampleFormControlTextarea1" rows="3" name="riwayat_penyakit" value="">{{ $pasien->riwayat_penyakit }}</textarea>
                          </div>
                          
                        <div class="form-group">
                            <a href="{{ route('pasien.index') }}" class="btn btn-danger mt-3">Kembali</a>
                            <input type="submit" value="Update" class="btn btn-primary mt-3">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<script>

$(document).ready(function () {
        $('#tahun').change(function () {
            var userDateinput = document.getElementById("tahun").value;  
            // console.log(userDateinput);

            var ctrldob = new Date(userDateinput);
            
           
            var today = new Date();
            var ctrldoa1 = today.getFullYear()+','+(today.getMonth()+1)+','+today.getDate();
            var ctrldoa = new Date(ctrldoa1)
            var diff = new Date(ctrldoa.getTime() - ctrldob.getTime());
            let tahun = (diff.getFullYear() - 1970); // Gives difference as year
            let bulan = (diff.getMonth()); // Gives month count of difference
            let tanggal= (diff.getDate() - 1); // Gives day count of difference
            
           
            document.getElementById("usia").value = `${tahun} Tahun ${bulan} Bulan ${tanggal} Hari`;
            document.getElementById("usia1").value = `${tahun} Tahun ${bulan} Bulan ${tanggal} Hari`;
        });
    });
</script>
@endsection