@extends('admin-layouts.master')

@section('content')
<div class="container-fluid">

    <!-- Page Heading -->
    {{-- <h1 class="h3 mb-2 text-gray-800">{{$title}}</h1> --}}
    

    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">{{$title}}</h6>
        </div>
        <div class="card-body">
            <div class="text-right px-3 py-3">
                <button type="button" class="btn btn-outline-primary" data-toggle="modal" data-target="#serviceCategoryModal" id="addServiceCategoryBtn">
                    <i class="fas fa-plus"></i> Tambah 
                </button>
            </div>
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Nama Kategori</th>
                            <th>Deskripsi</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    
                    <tbody>
                        @foreach ($ms_service_categories as $sc)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{$sc->name ?? ''}}</td>
                            <td>{{ $sc->description ?? '' }}</td>
                            <td>
                                <button class="btn btn-info btn-sm" onclick="viewServiceCategory({{$sc->id}})">
                                    <i class="fas fa-eye"></i>
                                </button>
                                <button class="btn btn-warning btn-sm" onclick="editServiceCategory({{$sc->id}}, '{{addslashes($sc->name ?? '')}}', '{{addslashes($sc->description ?? '')}}')">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button onclick="deleteServiceCategory({{$sc->id}})" class="btn btn-danger btn-sm">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>

<!-- Modal untuk Tambah/Edit Kategori Service -->
<div class="modal fade" id="serviceCategoryModal" tabindex="-1" role="dialog" aria-labelledby="serviceCategoryModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="serviceCategoryModalLabel">Tambah Kategori Service</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="serviceCategoryForm" method="POST" action="{{ route('ms-services-category.store') }}">
                @csrf
                <div id="methodField"></div>
                <input type="hidden" name="id" id="service_category_id" value="">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="name">Nama Kategori <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="name" name="name" placeholder="Contoh: Laundry, Cleaning, Maintenance" required>
                        <div class="invalid-feedback"></div>
                    </div>

                    <div class="form-group">
                        <label for="description">Deskripsi <span class="text-danger">*</span></label>
                        <textarea class="form-control" id="description" name="description" rows="4" placeholder="Masukkan deskripsi kategori service..." required></textarea>
                        <div class="invalid-feedback"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary" id="submitBtn">
                        <i class="fas fa-save"></i> Simpan
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Form untuk Delete -->
<form action="" method="post" id="deleteForm">
    @csrf
    @method("DELETE")
    <input type="submit" value="Hapus" style="display:none">
</form>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ho+j7jyWK8fNQe+A12Hb8AhRq26LrZ/JpcUGGOn+Y7RsweNrtN/tE3MoK7ZeZDyx" crossorigin="anonymous"></script>

<script>
// Global variables
let isEdit = false;
let editId = null;

// Event listeners
$(document).ready(function() {
    // Handle form submission
    $('#serviceCategoryForm').submit(function(e) {
        e.preventDefault();
        submitForm();
    });

    // Reset modal when closed
    $('#serviceCategoryModal').on('hidden.bs.modal', function() {
        resetModal();
    });
});

// Add new service category
$('#addServiceCategoryBtn').click(function() {
    resetModal();
    $('#serviceCategoryModalLabel').text('Tambah Kategori Service Baru');
    $('#submitBtn').html('<i class="fas fa-save"></i> Simpan');
    $('#serviceCategoryForm').attr('action', '{{ route("ms-services-category.store") }}');
    isEdit = false;
});

// Edit service category function
function editServiceCategory(id, name, description = '') {
    isEdit = true;
    editId = id;
    
    $('#serviceCategoryModalLabel').text('Edit Kategori Service');
    $('#submitBtn').html('<i class="fas fa-save"></i> Update');
    $('#methodField').html('@method("PUT")');
    $('#serviceCategoryForm').attr('action', `{{ url('ms-services-category') }}/${id}`);
    
    // Fill form with existing data
    $('#name').val(name);
    $('#description').val(description);
    $('#service_category_id').val(id);
    
    $('#serviceCategoryModal').modal('show');
}

// View service category function
function viewServiceCategory(id) {
    // You can implement view functionality here
    // For now, just show an alert
    Swal.fire({
        title: 'Detail Kategori Service',
        text: 'Fungsi view akan diimplementasikan sesuai kebutuhan',
        icon: 'info'
    });
}

// Delete service category function
function deleteServiceCategory(id) {
    Swal.fire({
        title: 'Apakah Anda yakin?',
        text: "Data kategori service yang sudah dihapus tidak dapat dikembalikan!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Ya, Hapus!',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.value) {
            // Set form action and submit
            $('#deleteForm').attr('action', `{{ url('ms-services-category') }}/${id}`);
            $('#deleteForm').submit();
        }
    });
}

// Submit form function
function submitForm() {
    const formData = new FormData($('#serviceCategoryForm')[0]);
    const url = $('#serviceCategoryForm').attr('action');
    
    // Show loading
    $('#submitBtn').prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Menyimpan...');
    
    // Clear previous errors
    $('.form-control').removeClass('is-invalid');
    $('.invalid-feedback').text('');
    
    $.ajax({
        url: url,
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        },
        success: function(response) {
            $('#serviceCategoryModal').modal('hide');
            Swal.fire({
                title: 'Berhasil!',
                text: response.message || (isEdit ? 'Kategori service berhasil diupdate!' : 'Kategori service berhasil disimpan!'),
                icon: 'success',
                timer: 2000,
                showConfirmButton: false
            }).then(() => {
                location.reload();
            });
        },
        error: function(xhr) {
            console.log('Error response:', xhr);
            
            if (xhr.status === 422) {
                // Validation errors
                const errors = xhr.responseJSON.errors;
                if (errors) {
                    Object.keys(errors).forEach(function(key) {
                        const field = $(`#${key}`);
                        field.addClass('is-invalid');
                        field.siblings('.invalid-feedback').text(errors[key][0]);
                    });
                }
                
                Swal.fire({
                    title: 'Validasi Error!',
                    text: 'Silakan periksa form Anda.',
                    icon: 'error'
                });
            } else {
                // Other errors
                const message = xhr.responseJSON?.message || 'Terjadi kesalahan saat menyimpan data.';
                Swal.fire({
                    title: 'Error!',
                    text: message,
                    icon: 'error'
                });
            }
        },
        complete: function() {
            $('#submitBtn').prop('disabled', false).html(isEdit ? '<i class="fas fa-save"></i> Update' : '<i class="fas fa-save"></i> Simpan');
        }
    });
}

// Reset modal function
function resetModal() {
    $('#serviceCategoryForm')[0].reset();
    $('#methodField').empty();
    $('.form-control').removeClass('is-invalid');
    $('.invalid-feedback').text('');
    $('#service_category_id').val('');
    isEdit = false;
    editId = null;
}

// Handle success messages from server
@if(session('success'))
    Swal.fire({
        title: 'Berhasil!',
        text: '{{ session("success") }}',
        icon: 'success',
        timer: 3000,
        showConfirmButton: false
    });
@endif

@if(session('error'))
    Swal.fire({
        title: 'Error!',
        text: '{{ session("error") }}',
        icon: 'error'
    });
@endif
</script>

@endpush

@endsection