@extends('admin-layouts.master')

@section('title', $title)

@section('content')
<style>
    .hover-card {
        transition: all 0.3s ease;
    }
    .hover-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 25px rgba(0,0,0,0.15) !important;
    }
    
    .room-card {
        transition: all 0.3s ease;
        border-width: 2px;
    }
    .room-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
    }
    
    .border-left-primary { border-left: 0.25rem solid #4e73df !important; }
    .border-left-success { border-left: 0.25rem solid #1cc88a !important; }
    .border-left-danger { border-left: 0.25rem solid #e74a3b !important; }
    .border-left-warning { border-left: 0.25rem solid #f6c23e !important; }
    .border-left-info { border-left: 0.25rem solid #36b9cc !important; }
    
    .room-details .border-right {
        border-right: 1px solid #e3e6f0;
    }
    
    .action-buttons .btn {
        margin-left: 2px;
    }
    
    .status-info .badge {
        font-size: 0.8rem;
        padding: 0.4em 0.6em;
    }
    
    @media (max-width: 768px) {
        .room-card {
            margin-bottom: 1rem;
        }
        .hover-card:hover {
            transform: none;
        }
        .room-card:hover {
            transform: none;
        }
    }
</style>
<div class="container-fluid">
    <!-- Page Header -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <div>
            <h1 class="h3 mb-2 text-gray-800">
                <i class="fas fa-bed text-primary me-2"></i>{{ $title }}
            </h1>
            <p class="mb-0 text-gray-600">{{ $subtitle }}</p>
        </div>
        <div class="d-flex gap-2">
            <a href="{{ route($route.'.create') }}" class="btn btn-primary shadow-sm mr-2">
                <i class="fas fa-plus fa-sm me-1"></i> Tambah Kamar
            </a>
            <button class="btn btn-success shadow-sm" onclick="refreshPage()">
                <i class="fas fa-sync-alt fa-sm me-1"></i> Refresh
            </button>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2 hover-card">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Kamar</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $statistics['total_rooms'] }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-bed fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2 hover-card">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Tersedia</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $statistics['available_rooms'] }}</div>
                            <div class="text-xs text-success">{{ $statistics['total_rooms'] > 0 ? round(($statistics['available_rooms']/$statistics['total_rooms'])*100, 1) : 0 }}%</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-danger shadow h-100 py-2 hover-card">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">Terisi</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $statistics['occupied_rooms'] }}</div>
                            <div class="text-xs text-danger">{{ $statistics['occupancy_rate'] }}% Okupansi</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-users fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2 hover-card">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Maintenance</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $statistics['maintenance_rooms'] + $statistics['cleaning_rooms'] }}</div>
                            <div class="text-xs text-muted">{{ $statistics['maintenance_rooms'] }} Maintenance, {{ $statistics['cleaning_rooms'] }} Cleaning</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-tools fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Today's Activity -->
    @if($today_bookings['total_check_ins'] > 0 || $today_bookings['total_check_outs'] > 0)
    <div class="row mb-4">
        <div class="col-12">
            <div class="card shadow-sm border-left-info">
                <div class="card-header bg-info text-white py-2">
                    <h6 class="mb-0"><i class="fas fa-calendar-day me-1"></i> Aktivitas Hari Ini</h6>
                </div>
                <div class="card-body py-2">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="d-flex align-items-center">
                                <i class="fas fa-sign-in-alt text-success me-2"></i>
                                <span class="text-success font-weight-bold">{{ $today_bookings['total_check_ins'] }} Check-in</span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex align-items-center">
                                <i class="fas fa-sign-out-alt text-danger me-2"></i>
                                <span class="text-danger font-weight-bold">{{ $today_bookings['total_check_outs'] }} Check-out</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Filter Section -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-filter me-1"></i>Filter & Pencarian
            </h6>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route($route.'.index') }}" id="filterForm">
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <label class="form-label small font-weight-bold">Cari Kamar</label>
                        <div class="input-group">
                            <input type="text" class="form-control" name="search" 
                                   value="{{ $filters['search'] }}" 
                                   placeholder="Nomor kamar atau tipe...">
                            <div class="input-group-append">
                                <button class="btn btn-outline-secondary" type="button" onclick="clearSearch()">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-2 mb-3">
                        <label class="form-label small font-weight-bold">Status</label>
                        <select class="form-control" name="status" onchange="submitFilter()">
                            <option value="">Semua Status</option>
                            <option value="available" {{ $filters['status'] == 'available' ? 'selected' : '' }}>Tersedia</option>
                            <option value="occupied" {{ $filters['status'] == 'occupied' ? 'selected' : '' }}>Terisi</option>
                            <option value="maintenance" {{ $filters['status'] == 'maintenance' ? 'selected' : '' }}>Maintenance</option>
                            <option value="cleaning" {{ $filters['status'] == 'cleaning' ? 'selected' : '' }}>Cleaning</option>
                        </select>
                    </div>
                    
                    <div class="col-md-3 mb-3">
                        <label class="form-label small font-weight-bold">Tipe Kamar</label>
                        <select class="form-control" name="type_room_id" onchange="submitFilter()">
                            <option value="">Semua Tipe</option>
                            @foreach($ms_type_rooms as $type)
                                <option value="{{ $type->id }}" {{ $filters['type_room_id'] == $type->id ? 'selected' : '' }}>
                                    {{ $type->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="col-md-2 mb-3">
                        <label class="form-label small font-weight-bold">Urutkan</label>
                        <select class="form-control" name="sort_by" onchange="submitFilter()">
                            <option value="room_number" {{ $filters['sort_by'] == 'room_number' ? 'selected' : '' }}>Nomor Kamar</option>
                            <option value="type_name" {{ $filters['sort_by'] == 'type_name' ? 'selected' : '' }}>Tipe Kamar</option>
                            <option value="status" {{ $filters['sort_by'] == 'status' ? 'selected' : '' }}>Status</option>
                            <option value="created_at" {{ $filters['sort_by'] == 'created_at' ? 'selected' : '' }}>Tanggal Dibuat</option>
                        </select>
                        <input type="hidden" name="sort_order" value="{{ $filters['sort_order'] }}">
                    </div>
                    
                    <div class="col-md-2 mb-3">
                        <label class="form-label small font-weight-bold">&nbsp;</label>
                        <div class="d-flex">
                            <button type="submit" class="btn btn-primary btn-sm me-1 mr-2">
                                <i class="fas fa-search"></i> Cari
                            </button>
                            <a href="{{ route($route.'.index') }}" class="btn btn-secondary btn-sm">
                                <i class="fas fa-undo"></i> Reset
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Rooms Grid -->
    <div class="row">
        @forelse($ms_rooms as $room)
            <div class="col-xl-4 col-lg-6 col-md-6 mb-4">
                <div class="card room-card shadow-sm h-100 {{ $room->status == 'available' ? 'border-success' : ($room->status == 'occupied' ? 'border-danger' : 'border-warning') }}">
                    <!-- Room Header -->
                    <div class="card-header d-flex justify-content-between align-items-center py-2 {{ $room->status == 'available' ? 'bg-success' : ($room->status == 'occupied' ? 'bg-danger' : 'bg-warning') }} text-white">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-bed me-2"></i>
                            <strong>{{ $room->room_number }}</strong>
                        </div>
                        <div class="dropdown">
                            <button class="btn btn-sm btn-outline-light dropdown-toggle" type="button" data-toggle="dropdown">
                                <i class="fas fa-cog"></i>
                            </button>
                            <div class="dropdown-menu dropdown-menu-right">
                                <a class="dropdown-item" href="{{ route($route.'.show', $room->id) }}">
                                    <i class="fas fa-eye text-info"></i> Detail
                                </a>
                                <a class="dropdown-item" href="{{ route($route.'.edit', $room->id) }}">
                                    <i class="fas fa-edit text-warning"></i> Edit
                                </a>
                                <div class="dropdown-divider"></div>
                                <h6 class="dropdown-header">Ubah Status:</h6>
                                <a class="dropdown-item" href="#" onclick="changeStatus({{ $room->id }}, 'available')">
                                    <i class="fas fa-check-circle text-success"></i> Tersedia
                                </a>
                                <a class="dropdown-item" href="#" onclick="changeStatus({{ $room->id }}, 'occupied')">
                                    <i class="fas fa-user text-danger"></i> Terisi
                                </a>
                                <a class="dropdown-item" href="#" onclick="changeStatus({{ $room->id }}, 'maintenance')">
                                    <i class="fas fa-tools text-warning"></i> Maintenance
                                </a>
                                <a class="dropdown-item" href="#" onclick="changeStatus({{ $room->id }}, 'cleaning')">
                                    <i class="fas fa-broom text-info"></i> Cleaning
                                </a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item text-danger" href="#" onclick="deleteRoom({{ $room->id }})">
                                    <i class="fas fa-trash"></i> Hapus
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Room Body -->
                    <div class="card-body">
                        <div class="room-info">
                            <h6 class="card-title mb-2 text-primary">
                                {{ $room->typeRoom->name ?? 'Unknown Type' }}
                            </h6>
                            
                            <div class="room-details mb-3">
                                <div class="row text-center">
                                    <div class="col-6">
                                        <div class="border-right">
                                            <i class="fas fa-user text-primary"></i>
                                            <div class="font-weight-bold">{{ $room->max_capacity_adult }}</div>
                                            <small class="text-muted">Dewasa</small>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <i class="fas fa-child text-info"></i>
                                        <div class="font-weight-bold">{{ $room->max_capacity_child }}</div>
                                        <small class="text-muted">Anak</small>
                                    </div>
                                </div>
                            </div>
                            
                            @if($room->typeRoom)
                            <div class="price-info mb-3">
                                <div class="d-flex justify-content-between">
                                    <span class="text-muted">Harga per malam:</span>
                                    <strong class="text-success">Rp {{ number_format($room->typeRoom->harga_per_malam, 0, ',', '.') }}</strong>
                                </div>
                                @if($room->typeRoom->harga_per_orang > 0)
                                <div class="d-flex justify-content-between">
                                    <span class="text-muted">Harga per orang:</span>
                                    <strong class="text-info">Rp {{ number_format($room->typeRoom->harga_per_orang, 0, ',', '.') }}</strong>
                                </div>
                                @endif
                            </div>
                            @endif
                            
                            @if($room->description)
                            <div class="description mb-3">
                                <small class="text-muted">
                                    {{ Str::limit($room->description, 80) }}
                                </small>
                            </div>
                            @endif
                        </div>
                    </div>
                    
                    <!-- Room Footer -->
                    <div class="card-footer bg-light d-flex justify-content-between align-items-center">
                        <div class="status-info">
                            @php
                                $statusConfig = [
                                    'available' => ['class' => 'success', 'icon' => 'check-circle', 'text' => 'Tersedia'],
                                    'occupied' => ['class' => 'danger', 'icon' => 'user', 'text' => 'Terisi'],
                                    'maintenance' => ['class' => 'warning', 'icon' => 'tools', 'text' => 'Maintenance'],
                                    'cleaning' => ['class' => 'info', 'icon' => 'broom', 'text' => 'Cleaning']
                                ];
                                $config = $statusConfig[$room->status] ?? ['class' => 'secondary', 'icon' => 'question', 'text' => 'Unknown'];
                            @endphp
                            <span class="badge badge-{{ $config['class'] }}">
                                <i class="fas fa-{{ $config['icon'] }} me-1"></i>{{ $config['text'] }}
                            </span>
                        </div>
                        
                        <div class="action-buttons">
                            <a href="{{ route($route.'.show', $room->id) }}" class="btn btn-sm btn-outline-primary"  title="Lihat Detail">
                                <i class="fas fa-eye"></i>
                            </a>
                            <a href="{{ route($route.'.edit', $room->id) }}" class="btn btn-sm btn-outline-warning" title="Edit">
                                <i class="fas fa-edit"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        @empty
            <div class="col-12">
                <div class="card shadow-sm">
                    <div class="card-body text-center py-5">
                        <i class="fas fa-bed fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">Tidak ada kamar ditemukan</h5>
                        <p class="text-muted">
                            @if(request()->hasAny(['search', 'status', 'type_room_id']))
                                Coba ubah filter pencarian atau <a href="{{ route($route.'.index') }}">reset filter</a>
                            @else
                                <a href="{{ route($route.'.create') }}" class="btn btn-primary mt-2">
                                    <i class="fas fa-plus me-1"></i> Tambah Kamar Pertama
                                </a>
                            @endif
                        </p>
                    </div>
                </div>
            </div>
        @endforelse
    </div>

    <!-- Pagination -->
    @if($ms_rooms->hasPages())
    <div class="d-flex justify-content-center">
        {{ $ms_rooms->links() }}
    </div>
    @endif
</div>

<!-- Room Detail Modal -->
<div class="modal fade" id="roomDetailModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-info text-white">
                <h5 class="modal-title">
                    <i class="fas fa-info-circle me-2"></i>Detail Kamar
                </h5>
                <button type="button" class="close text-white" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body" id="roomDetailContent">
                <div class="text-center py-4">
                    <i class="fas fa-spinner fa-spin fa-2x text-primary"></i>
                    <p class="mt-2">Memuat data...</p>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>

<!-- Delete Form -->
<form action="" method="post" id="deleteForm">
    @csrf
    @method("DELETE")
</form>
@endsection


@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ho+j7jyWK8fNQe+A12Hb8AhRq26LrZ/JpcUGGOn+Y7RsweNrtN/tE3MoK7ZeZDyx" crossorigin="anonymous"></script>

<script>
// Filter functions
function submitFilter() {
    document.getElementById('filterForm').submit();
}

function clearSearch() {
    document.querySelector('input[name="search"]').value = '';
    submitFilter();
}

function refreshPage() {
    window.location.reload();
}

// View room detail
function viewRoom(id) {
    $('#roomDetailModal').modal('show');
    
    $.ajax({
        url: `{{ route($route.'.index') }}/${id}/data`,
        method: 'GET',
        
        success: function(response) {
            if (response.success) {
                const data = response.data;
                const content = `
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card mb-3">
                                <div class="card-header bg-primary text-white">
                                    <h6 class="mb-0"><i class="fas fa-info-circle me-1"></i> Informasi Kamar</h6>
                                </div>
                                <div class="card-body">
                                    <table class="table table-sm">
                                        <tr><td><strong>Nomor Kamar:</strong></td><td>${data.room_number}</td></tr>
                                        <tr><td><strong>Tipe Kamar:</strong></td><td>${data.type_name}</td></tr>
                                        <tr><td><strong>Kapasitas Dewasa:</strong></td><td>${data.max_capacity_adult} orang</td></tr>
                                        <tr><td><strong>Kapasitas Anak:</strong></td><td>${data.max_capacity_child} orang</td></tr>
                                        <tr><td><strong>Status:</strong></td><td><span class="badge badge-success">${data.status}</span></td></tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card mb-3">
                                <div class="card-header bg-success text-white">
                                    <h6 class="mb-0"><i class="fas fa-money-bill-wave me-1"></i> Informasi Harga</h6>
                                </div>
                                <div class="card-body">
                                    <div class="text-center">
                                        <h4 class="text-success">${data.price_formatted}</h4>
                                        <small class="text-muted">per malam</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    ${data.description ? `
                        <div class="card">
                            <div class="card-header bg-info text-white">
                                <h6 class="mb-0"><i class="fas fa-align-left me-1"></i> Deskripsi</h6>
                            </div>
                            <div class="card-body">
                                <p class="mb-0">${data.description}</p>
                            </div>
                        </div>
                    ` : ''}
                `;
                
                $('#roomDetailContent').html(content);
            } else {
                $('#roomDetailContent').html(`
                    <div class="alert alert-danger">
                        <i class="fas fa-exclamation-triangle me-1"></i>
                        ${response.message || 'Gagal memuat data'}
                    </div>
                `);
            }
        },
        error: function() {
            $('#roomDetailContent').html(`
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-triangle me-1"></i>
                    Terjadi kesalahan saat memuat data
                </div>
            `);
        }
    });
}

// Change room status
function changeStatus(id, status) {
    const statusLabels = {
        'available': 'Tersedia',
        'occupied': 'Terisi',
        'maintenance': 'Maintenance',
        'cleaning': 'Cleaning'
    };
    
    Swal.fire({
        title: 'Konfirmasi',
        text: `Ubah status kamar menjadi ${statusLabels[status]}?`,
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Ya, Ubah!',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: `{{ route($route.'.index') }}/${id}/status`,
                method: 'PUT',
                data: {
                    status: status,
                    _token: $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            title: 'Berhasil!',
                            text: response.message,
                            icon: 'success',
                            timer: 2000,
                            showConfirmButton: false
                        }).then(() => {
                            location.reload();
                        });
                    } else {
                        Swal.fire('Error!', response.message, 'error');
                    }
                },
                error: function() {
                    Swal.fire('Error!', 'Terjadi kesalahan saat mengubah status', 'error');
                }
            });
        }
    });
}

// Delete room
function deleteRoom(id) {
    Swal.fire({
        title: 'Konfirmasi Hapus',
        text: 'Apakah Anda yakin ingin menghapus kamar ini?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Ya, Hapus!',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            $('#deleteForm').attr('action', `{{ route($route.'.index') }}/${id}`);
            $('#deleteForm').submit();
        }
    });
}

// Handle success/error messages
@if(session('success'))
    Swal.fire({
        title: 'Berhasil!',
        text: '{{ session("success") }}',
        icon: 'success',
        timer: 3000,
        showConfirmButton: false
    });
@endif

@if(session('error'))
    Swal.fire({
        title: 'Error!',
        text: '{{ session("error") }}',
        icon: 'error'
    });
@endif
</script>
@endpush