@extends('admin-layouts.master')

@section('content')

<div class="container-fluid">
    <h1 class="h3 mb-2 text-gray-800">Verifikasi Pemeriksaan Pasien</h1>
    <div class="card">
        <div class="card-body">
            <div class="form-row">

                <div class="col">
                    <div class="form-group text-center">
                        <label for=""@error('name') class="text-danger" @enderror >Nomor Rekam Medis</label>
                        <input type="text" name="name" class="form-control @error('name') form-control is-invalid @enderror"
                        placeholder="" value="{{ $pasien->pasien->nomor_rekam_medis}}" readonly>
                        @error('name')
                            <span  class="text-danger"> {{ $message }} </span>
                        @enderror
                    </div>
                </div>
                <div class="col">
                    <div class="form-group text-center">
                        <label for=""@error('name') class="text-danger" @enderror >Nama Pasien</label>
                        <input type="text" name="name" class="form-control @error('name') form-control is-invalid @enderror"
                        placeholder="" value="{{ $pasien->pasien->nama_pasien}}" readonly>
                        @error('name')
                            <span  class="text-danger"> {{ $message }} </span>
                        @enderror
                    </div>
                </div>
            </div>

                <h4 class="mt-2 mb-2">*Data Hasil Pemeriksaan Pasien</h4>
                <div class="form-row">
                    <div class="col">
                        <div class="form-group">
                            <label for="exampleFormControlTextarea1">Anamnesa</label>
                            <textarea class="form-control" id="exampleFormControlTextarea1" rows="3" name="anamnesa" value="{{ old('anamnesa') }} " readonly>{{ $pasien->anamnesa}}</textarea>
                          </div>
                    </div>
                    <div class="col">
                        <div class="form-group">
                            <label for="exampleFormControlTextarea1">Pemeriksaan Fisik</label>
                            <textarea class="form-control" id="exampleFormControlTextarea1" rows="3" name="pemeriksaan_fisik" value="{{ old('pemeriksaan_fisik') }}" readonly>{{ $pasien->pemeriksaan_fisik }}</textarea>
                          </div>
                    </div>
                    
                </div>
                <div class="form-row">
                   
                   
                    <div class="col">
                        <div class="form-group">
                            <label for="exampleFormControlTextarea1">Hasil Penunjang</label>
                            <textarea class="form-control" id="exampleFormControlTextarea1" rows="3" name="hasil_penunjang" value="{{ old('hasil_penunjang') }}" readonly>{{ $pasien->hasil_penunjang }}</textarea>
                          </div>
                    </div>
                    <div class="col">
                        <div class="form-group">
                            <label for="exampleFormControlTextarea1">Diagnosa Kerja</label>
                            <textarea class="form-control" id="exampleFormControlTextarea1" rows="3" name="diagnosa_kerja" value="{{ old('diagnosa_kerja') }}" readonly>{{ $pasien->diagnosa_kerja }}</textarea>
                          </div>
                    </div>
                </div>
                <div class="form-row">
                   
                    <div class="col">
                        <div class="form-group">
                            <label for="exampleFormControlTextarea1">Diagnosa Banding</label>
                            <textarea class="form-control" id="exampleFormControlTextarea1" rows="3" name="diagnosa_banding" value="{{ old('diagnosa_banding') }}" readonly>{{ $pasien->diagnosa_banding }}</textarea>
                          </div>
                    </div>
                    <div class="col">
                        <div class="form-group">
                            <label for="exampleFormControlTextarea1">Terapi</label>
                            <textarea class="form-control" rows="3" id="myTextarea" name="terapi-area" >{{ $pasien->terapi }}</textarea>
                          </div>
                    </div>
                   
                </div>
                <div class="form-group">
                    <a href="javascript:history.back()" class="btn btn-danger mt-3">Kembali</a>
                    <button href="{{route('verifikasi-pasien.store', ['pasien'=>$pasien->pasien->id,'antrian'=>$pasien->antrian->id])}}" id="delete" class="btn btn-primary mt-3"><i class="fas fa-clipboard-check"></i> Verifikasi</button>
                </div>
            
        </div>
    </div>
</div>
@php
    
    //    $nameTerapi =\Cookie::get('terapi-area');
    //     dd($nameTerapi);
@endphp
<form action="" method="post" id="deleteForm">
    @csrf
    @method("POST")
   
    <input type="text" id="terapi2" value="" name="terapi" style="display:none">
    {{-- @php
        $value_terapi = request()->get('terapi3');
        
    @endphp
    @if($value_terapi == null)
        <input type="text" value="{{ $pasien->terapi }}" name="terapi" style="display:none">
    @else
        <input type="text" id="terapi2" value="" name="terapi" style="display:none">
    @endif --}}
    <input type="submit" value="Simpan" style="display:none">
    </form>
    
    @push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ho+j7jyWK8fNQe+A12Hb8AhRq26LrZ/JpcUGGOn+Y7RsweNrtN/tE3MoK7ZeZDyx" crossorigin="anonymous">
    </script>
    <script>
       
    //     function displayType() {
    //     var inputKetikan =  document.getElementById("myTextarea");
    //     var targetKetikan =  document.getElementById("terapi2");
    //     var a = targetKetikan.value = inputKetikan.value;
    //     console.log(a)
    // }
        
        var inputKetikan =  document.getElementById("myTextarea");
        console.log(inputKetikan)
         
            inputKetikan.onkeyup = function(){  
            var targetKetikan =  document.getElementById("terapi2");
            var a = targetKetikan.value = inputKetikan.value;
            console.log(a)
         }
        
    </script>
    <script>
   

    $('button#delete').on('click', function(e){
      e.preventDefault();
    
      var href = $(this).attr('href');
    
      Swal.fire({
          title: 'Apakah Kamu yakin akan melakukan verifikasi data ini?',
          text: "Data yang sudah diverif akan langsung disimpan",
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Ya, Verif'
          }).then((result) => {
          if (result.value) {
              document.getElementById('deleteForm').action = href;
              document.getElementById('deleteForm').submit();
                  Swal.fire(
                  'Berhasi Diverif',
                  'Data Kamu Berhasil Diverif',
                  'success'
                  )
              }
          })
    
    
    })
   
    </script>
    @endpush
@endsection