@extends('admin-layouts.master')

@section('content')
<div class="container-fluid">

    <!-- Page Heading -->
    <h1 class="h3 mb-2 text-gray-800">Data Jenis Pemeriksaan</h1>
    

    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Jenis Pemeriksaan</h6>
        </div>
        <div class="card-body">
            <div class="text-right px-3 py-3">

                <a href="{{ route('jenis-pemeriksaan-lab.create') }}" class="btn btn-outline-primary">
                    Tambah Jenis
                </a>

            </div>
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Nama Pemeriksaan</th>
                            <th>Nilai Rujukan (L)</th>
                           <th>Nilai Rujukan (P)</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    
                    <tbody>
                        @foreach($jenis_pemeriksaan as $u)
                        <tr>
                                
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $u->nama_pemeriksaan }}</td>
                            
                            <td>{{ $u->nilai_rujukan_l }}</td>
                            <td>{{ $u->nilai_rujukan_p }}</td>
                            <td>
                                <a class="btn btn-warning" href="{{ route('jenis-pemeriksaan-lab.edit',$u) }}"><i class="fas fa-edit"></i>Edit</a>
                                <button href="{{route('jenis-pemeriksaan-lab.destroy', $u)}}" id="delete" class="btn btn-danger">Hapus</button>
                            </td>
                        </tr>
                        @endforeach
                        
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>
<form action="" method="post" id="deleteForm">
    @csrf
    @method("DELETE")
    <input type="submit" value="Hapus" style="display:none">
    </form>
    @push('scripts')
    
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ho+j7jyWK8fNQe+A12Hb8AhRq26LrZ/JpcUGGOn+Y7RsweNrtN/tE3MoK7ZeZDyx" crossorigin="anonymous">
    </script>

    <script>
    $('button#delete').on('click', function(e){
      e.preventDefault();
    
      var href = $(this).attr('href');
    
      Swal.fire({
          title: 'Apakah Kamu yakin akan menghapus data ini?',
          text: "Data yang sudah dihapus tidak dapat dikembalikan!",
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Ya, Hapus!'
          }).then((result) => {
          if (result.value) {
              document.getElementById('deleteForm').action = href;
              document.getElementById('deleteForm').submit();
                  Swal.fire(
                  'Berhasi Dihapus!',
                  'Data Kamu Berhasil Dihapus.',
                  'success'
                  )
              }
          })
    
    
    })
   
    </script>
<script src="{{ asset('template-admin/vendor/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('template-admin/vendor/datatables/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('template-admin/js/demo/datatables-demo.js') }}"></script>
@endpush

@endsection