@extends('admin-layouts.master')

@section('content')

<div class="container-fluid">
    <h1 class="h3 mb-2 text-gray-800">Edit Jenis Pemeriksaan Lab</h1>
    <div class="card">
        <div class="card-body">
            <form  action="{{ route('jenis-pemeriksaan-lab.update',$jenis_pemeriksaan)}}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="form-group">
                    <label for=""@error('name') class="text-danger" @enderror >Nama Pemeriksaan</label>
                    <input type="text" name="nama_pemeriksaan" class="form-control @error('nama_pemeriksaan') form-control is-invalid @enderror"
                    placeholder="" value="{{$jenis_pemeriksaan->nama_pemeriksaan ?? old('nama_pemeriksaan') }}">
                    @error('nama_pemeriksaan')
                        <span  class="text-danger"> {{ $message }} </span>
                    @enderror
                </div>
                <div class="form-group">
                    <label for=""@error('nilai_rujukan_l') class="text-danger" @enderror >Nilai Rujukan (L)</label>
                    <input type="text" name="nilai_rujukan_l" class="form-control @error('nilai_rujukan_l') form-control is-invalid @enderror"
                    placeholder="" value="{{$jenis_pemeriksaan->nilai_rujukan_l ?? old('nilai_rujukan_l') }}">
                    @error('nilai_rujukan_l')
                        <span  class="text-danger"> {{ $message }} </span>
                    @enderror
                </div>
                <div class="form-group">
                    <label for=""@error('nilai_rujukan_p') class="text-danger" @enderror >Nilai Rujukan (P)</label>
                    <input type="text" name="nilai_rujukan_p" class="form-control @error('nilai_rujukan_p') form-control is-invalid @enderror"
                    placeholder="" value="{{$jenis_pemeriksaan->nilai_rujukan_p ?? old('nilai_rujukan_p') }}">
                    @error('nilai_rujukan_p')
                        <span  class="text-danger"> {{ $message }} </span>
                    @enderror
                </div>
                
               
                <div class="form-group">
                    <a href="{{ route('user.index') }}" class="btn btn-danger mt-3"> Kembali</a>
                    <input type="submit" value="Simpan" class="btn btn-primary mt-3">
                    
                </div>
            </form>
        </div>
    </div>
</div>
@endsection