@extends('admin-layouts.master')
<style>
@media print {
    .btn, .d-sm-flex, .card-shadow, .shadow-sm, .card-header {
        display: none !important;
    }

    .card {
        border: none !important;
        box-shadow: none !important;
    }

    body {
        background: white !important;
    }

    .container-fluid {
        padding: 0 !important;
    }

    .row.mt-4, .row.mt-5 {
        margin-top: 1rem !important;
    }
}

.border-left-primary {
    border-left: 0.25rem solid #4e73df !important;
}

.border-left-success {
    border-left: 0.25rem solid #1cc88a !important;
}

.border-left-info {
    border-left: 0.25rem solid #36b9cc !important;
}

.border-left-warning {
    border-left: 0.25rem solid #f6c23e !important;
}

.border-left-secondary {
    border-left: 0.25rem solid #858796 !important;
}

/* Timeline Styles */
.timeline {
    position: relative;
    padding-left: 30px;
}

.timeline::before {
    content: '';
    position: absolute;
    left: 10px;
    top: 0;
    bottom: 0;
    width: 2px;
    background: #dee2e6;
}

.timeline-item {
    position: relative;
    margin-bottom: 20px;
}

.timeline-marker {
    position: absolute;
    left: -24px;
    top: 5px;
    width: 12px;
    height: 12px;
    border-radius: 50%;
    border: 2px solid #fff;
    box-shadow: 0 0 0 2px #dee2e6;
}

.timeline-content {
    background: #f8f9fc;
    padding: 15px;
    border-radius: 5px;
    border-left: 3px solid #4e73df;
}

.timeline-title {
    margin-bottom: 5px;
    font-weight: 600;
    color: #5a5c69;
}

.timeline-description {
    margin-bottom: 5px;
    font-size: 0.9rem;
}

/* Status Badge Colors */
.bg-success { background-color: #1cc88a !important; }
.bg-info { background-color: #36b9cc !important; }
.bg-warning { background-color: #f6c23e !important; }
.bg-purple { background-color: #6f42c1 !important; }
.bg-primary { background-color: #4e73df !important; }
.bg-secondary { background-color: #858796 !important; }

/* Enhanced button styles */
.btn-group-lg > .btn {
    padding: 0.75rem 1.5rem;
    font-size: 1.1rem;
}

/* Card enhancements */
.card {
    transition: all 0.3s ease;
}

.card:hover {
    transform: translateY(-2px);
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;
}

/* Alert enhancements */
.alert {
    border-left: 4px solid;
}

.alert-success {
    border-left-color: #1cc88a;
}

.alert-warning {
    border-left-color: #f6c23e;
}

.alert-danger {
    border-left-color: #e74a3b;
}

/* Table hover effects */
.table tbody tr:hover {
    background-color: rgba(78, 115, 223, 0.05);
}

/* Loading animation */
.loading-spinner {
    display: inline-block;
    width: 20px;
    height: 20px;
    border: 3px solid rgba(255,255,255,.3);
    border-radius: 50%;
    border-top-color: #fff;
    animation: spin 1s ease-in-out infinite;
}

/* Payment method styling */
.payment-method-info {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border-radius: 10px;
    padding: 1rem;
    margin-bottom: 1rem;
}

.payment-method-badge {
    background: rgba(255, 255, 255, 0.2);
    border: 1px solid rgba(255, 255, 255, 0.3);
    color: white;
    padding: 0.25rem 0.75rem;
    border-radius: 15px;
    font-size: 0.85rem;
    font-weight: 600;
}

.admin-fee-highlight {
    background: rgba(255, 193, 7, 0.1);
    border-left: 3px solid #ffc107;
    padding: 0.5rem;
    border-radius: 0 5px 5px 0;
}

@keyframes spin {
    to { transform: rotate(360deg); }
}
</style>
@section('content')
<div class="container-fluid">

    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Invoice {{ $invoice->invoice_number }}</h1>
        <div>
            <a href="{{ route('invoices.index') }}" class="btn btn-sm btn-secondary shadow-sm mr-2">
                <i class="fas fa-arrow-left fa-sm text-white-50"></i> Kembali
            </a>
            <a href="{{ route('invoices.download-pdf', $invoice->id) }}" class="btn btn-sm btn-info shadow-sm mr-2">
                <i class="fas fa-download fa-sm text-white-50"></i> Download PDF
            </a>
            <button onclick="window.print()" class="btn btn-sm btn-primary shadow-sm">
                <i class="fas fa-print fa-sm text-white-50"></i> Print
            </button>
        </div>
    </div>

    <!-- Payment Method Info Card -->
    @if($invoice->metodePembayaran)
    <div class="card shadow mb-4">
        <div class="card-body">
            <div class="payment-method-info">
                <div class="row align-items-center">
                    <div class="col-md-8">
                        <h6 class="mb-2">
                            <i class="fas fa-credit-card mr-2"></i>Metode Pembayaran
                        </h6>
                        <div class="d-flex align-items-center mb-2">
                            <span class="payment-method-badge mr-3">
                                <i class="fas {{ $invoice->metodePembayaran->icon ?? 'fa-credit-card' }} mr-1"></i>
                                {{ $invoice->metodePembayaran->nama }}
                            </span>
                            @if($invoice->metodePembayaran->deskripsi)
                            <small class="text-white-50">{{ $invoice->metodePembayaran->deskripsi }}</small>
                            @endif
                        </div>
                        @if($invoice->metodePembayaran->biaya_admin > 0)
                        <div class="admin-fee-highlight mt-2">
                            <small>
                                <i class="fas fa-info-circle mr-1"></i>
                                Biaya admin: <strong>Rp {{ number_format($invoice->metodePembayaran->biaya_admin, 0, ',', '.') }}</strong> (sudah termasuk dalam total)
                            </small>
                        </div>
                        @endif
                    </div>
                    <div class="col-md-4 text-right">
                        @if($invoice->status === 'paid')
                        <div class="text-white">
                            <i class="fas fa-check-circle fa-2x text-success mb-2"></i>
                            <div><small>Dibayar via {{ $invoice->metodePembayaran->nama }}</small></div>
                        </div>
                        @else
                        <div class="text-white">
                            <i class="fas fa-clock fa-2x text-warning mb-2"></i>
                            <div><small>Siap untuk pembayaran</small></div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Invoice Card -->
    <div class="card shadow mb-4">
        <div class="card-body">
            <!-- Invoice Header -->
            <div class="row mb-4">
                <div class="col-md-6">
                    <h3 class="text-primary mb-3">
                         <img src="/images/Logo.jpg" width="30%" alt="Melati Hotel Logo" onerror="this.style.display='none'; this.parentElement.nextElementSibling.style.display='block';">
                    </h3>
                    <p class="text-muted mb-1">Alamat : Jl. H. Isa II, Karang Ambun</p>
                    <p class="text-muted mb-1">Kec. Tj. Redeb, Kabupaten Berau, Kalimantan Timur</p>
                    <p class="text-muted mb-1">Telepon:  (0554) 2024771</p>
                    {{-- <p class="text-muted">Email: info@hotel.com</p> --}}
                </div>
                <div class="col-md-6 text-right">
                    <h2 class="text-dark mb-3">INVOICE</h2>
                    <table class="table table-borderless table-sm w-auto ml-auto">
                        <tr>
                            <td class="text-right"><strong>No. Invoice:</strong></td>
                            <td class="text-primary"><strong>{{ $invoice->invoice_number }}</strong></td>
                        </tr>
                        <tr>
                            <td class="text-right"><strong>Tanggal:</strong></td>
                            <td>{{ $invoice->invoice_date_formatted }}</td>
                        </tr>
                        <tr>
                            <td class="text-right"><strong>Jatuh Tempo:</strong></td>
                            <td>{{ $invoice->due_date_formatted }}</td>
                        </tr>
                        <tr>
                            <td class="text-right"><strong>Status:</strong></td>
                            <td>{!! $invoice->status_badge !!}</td>
                        </tr>
                        @if($invoice->metodePembayaran)
                        <tr>
                            <td class="text-right"><strong>Metode Bayar:</strong></td>
                            <td>
                                <span class="badge badge-primary">
                                    <i class="fas {{ $invoice->metodePembayaran->icon ?? 'fa-credit-card' }} mr-1"></i>
                                    {{ $invoice->metodePembayaran->nama }}
                                </span>
                            </td>
                        </tr>
                        @endif
                    </table>
                </div>
            </div>

            <hr>

            <!-- Bill To -->
            <div class="row mb-4">
                <div class="col-md-6">
                    <h5 class="text-dark mb-3">Bill To:</h5>
                    <div class="border-left border-primary pl-3">
                        <h6 class="mb-1">{{ $invoice->booking->guest->name }}</h6>
                        <p class="text-muted mb-1">{{ $invoice->booking->guest->phone ?? 'No phone' }}</p>
                        <p class="text-muted mb-1">{{ $invoice->booking->guest->email ?? 'No email' }}</p>
                        @if($invoice->booking->guest->address)
                        <p class="text-muted mb-0">{{ $invoice->booking->guest->address }}</p>
                        @endif
                    </div>
                </div>
                <div class="col-md-6">
                    <h5 class="text-dark mb-3">Booking Details:</h5>
                    <table class="table table-borderless table-sm">
                        <tr>
                            <td><strong>Booking ID:</strong></td>
                            <td>#{{ $invoice->booking->id }}</td>
                        </tr>
                        <tr>
                            <td><strong>Check-in:</strong></td>
                            <td>{{ $invoice->booking->check_in_date_formatted }}</td>
                        </tr>
                        <tr>
                            <td><strong>Check-out:</strong></td>
                            <td>{{ $invoice->booking->check_out_date_formatted }}</td>
                        </tr>
                        <tr>
                            <td><strong>Hari:</strong></td>
                            <td>{{ $invoice->booking->nights }} Hari</td>
                        </tr>
                    </table>
                </div>
            </div>

            <!-- Room Details -->
            @if($invoice->booking->bookingDetails->count() > 0)
            <h5 class="text-dark mb-3">Detail Kamar:</h5>
            <div class="table-responsive mb-4">
                <table class="table table-bordered">
                    <thead class="thead-light">
                        <tr>
                            <th>Kamar</th>
                            <th>Tipe Kamar</th>
                            <th class="text-center">Hari</th>
                            <th class="text-right">Harga/Hari</th>
                            <th class="text-right">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($invoice->booking->bookingDetails as $detail)
                        <tr>
                            <td>Kamar {{ $detail->room->room_number }}</td>
                            <td>{{ $detail->room->typeRoom->name }}</td>
                            <td class="text-center">{{ $detail->nights }}</td>
                            <td class="text-right">Rp {{ number_format($detail->room_price, 0, ',', '.') }}</td>
                            <td class="text-right">Rp {{ number_format($detail->total_price, 0, ',', '.') }}</td>
                        </tr>
                        @endforeach
                        <tr class="table-light">
                            <td colspan="4" class="text-right"><strong>Subtotal Kamar:</strong></td>
                            <td class="text-right"><strong>{{ $invoice->formatted_room_total }}</strong></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            @endif

            <!-- Services Details -->
            @if($invoice->booking->bookingServices->count() > 0)
            <h5 class="text-dark mb-3">Detail Layanan:</h5>
            <div class="table-responsive mb-4">
                <table class="table table-bordered">
                    <thead class="thead-light">
                        <tr>
                            <th>Layanan</th>
                            <th>Kategori</th>
                            <th class="text-center">Qty</th>
                            <th class="text-right">Harga/Unit</th>
                            <th class="text-right">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($invoice->booking->bookingServices as $service)
                        <tr>
                            <td>{{ $service->service->name }}</td>
                            <td>
                                <span class="badge badge-{{ $service->service->category_color }}">
                                    {{ $service->service->category->name }}
                                </span>
                            </td>
                            <td class="text-center">{{ $service->quantity }}</td>
                            <td class="text-right">Rp {{ number_format($service->unit_price, 0, ',', '.') }}</td>
                            <td class="text-right">Rp {{ number_format($service->total_amount, 0, ',', '.') }}</td>
                        </tr>
                        @endforeach
                        <tr class="table-light">
                            <td colspan="4" class="text-right"><strong>Subtotal Layanan:</strong></td>
                            <td class="text-right"><strong>{{ $invoice->formatted_services_total }}</strong></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            @endif

            <!-- Invoice Summary -->
            <div class="row">
                <div class="col-md-6">
                    @if($invoice->notes)
                    <div class="card border-left-info">
                        <div class="card-body">
                            <h6 class="text-info mb-2">Catatan:</h6>
                            <p class="text-muted mb-0">{{ $invoice->notes }}</p>
                        </div>
                    </div>
                    @endif
                </div>
                <div class="col-md-6">
                    <div class="card border-left-success">
                        <div class="card-body">
                            <table class="table table-borderless mb-0">
                                <tr>
                                    <td class="text-right"><strong>Subtotal:</strong></td>
                                    <td class="text-right" style="width: 150px;">{{ $invoice->formatted_subtotal }}</td>
                                </tr>
                                @if($invoice->discount_amount > 0)
                                <tr>
                                    <td class="text-right"><strong>Diskon:</strong></td>
                                    <td class="text-right text-danger">- {{ $invoice->formatted_discount_amount }}</td>
                                </tr>
                                @endif
                                <tr>
                                    <td class="text-right"><strong>Pajak ({{ $invoice->tax_rate }}%):</strong></td>
                                    <td class="text-right">{{ $invoice->formatted_tax_amount }}</td>
                                </tr>
                                @if($invoice->metodePembayaran && $invoice->metodePembayaran->biaya_admin > 0)
                                <tr>
                                    <td class="text-right"><strong>Biaya Admin:</strong></td>
                                    <td class="text-right">Rp {{ number_format($invoice->metodePembayaran->biaya_admin, 0, ',', '.') }}</td>
                                </tr>
                                @endif
                                <tr class="border-top">
                                    <td class="text-right"><h5><strong>Grand Total:</strong></h5></td>
                                    <td class="text-right"><h5 class="text-success"><strong>{{ $invoice->formatted_grand_total }}</strong></h5></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Payment Status & Actions -->
            @if($invoice->status === 'paid')
            <div class="row mt-4">
                <div class="col-12">
                    <div class="alert alert-success" role="alert">
                        <i class="fas fa-check-circle"></i>
                        <strong>Invoice Lunas!</strong>
                        @if($invoice->paid_at)
                            Dibayar pada {{ $invoice->paid_at->format('d/m/Y H:i') }}
                        @endif
                        @if($invoice->metodePembayaran)
                            via {{ $invoice->metodePembayaran->nama }}
                        @endif
                    </div>
                </div>
            </div>
            @elseif($invoice->status === 'pending')
            <div class="row mt-4">
                <div class="col-12">
                    <div class="alert alert-warning" role="alert">
                        <i class="fas fa-clock"></i>
                        <strong>Menunggu Pembayaran</strong>
                        @if($invoice->getDaysUntilDue() !== null)
                            @if($invoice->getDaysUntilDue() > 0)
                                - Jatuh tempo dalam {{ $invoice->getDaysUntilDue() }} hari
                            @elseif($invoice->getDaysUntilDue() == 0)
                                - Jatuh tempo hari ini
                            @else
                                - Terlambat {{ abs($invoice->getDaysUntilDue()) }} hari
                            @endif
                        @endif
                        @if($invoice->metodePembayaran)
                        <div class="mt-2">
                            <small class="text-warning">
                                <i class="fas fa-info-circle mr-1"></i>
                                Dapat dibayar menggunakan {{ $invoice->metodePembayaran->nama }}
                                @if($invoice->metodePembayaran->biaya_admin > 0)
                                (+ biaya admin Rp {{ number_format($invoice->metodePembayaran->biaya_admin, 0, ',', '.') }})
                                @endif
                            </small>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
            @elseif($invoice->status === 'overdue')
            <div class="row mt-4">
                <div class="col-12">
                    <div class="alert alert-danger" role="alert">
                        <i class="fas fa-exclamation-triangle"></i>
                        <strong>Invoice Terlambat</strong>
                        @if($invoice->getDaysUntilDue() !== null)
                            - Terlambat {{ abs($invoice->getDaysUntilDue()) }} hari
                        @endif
                        @if($invoice->metodePembayaran)
                        <div class="mt-2">
                            <small class="text-danger">
                                <i class="fas fa-credit-card mr-1"></i>
                                Segera bayar menggunakan {{ $invoice->metodePembayaran->nama }} untuk menghindari denda
                            </small>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
            @elseif($invoice->status === 'cancelled')
            <div class="row mt-4">
                <div class="col-12">
                    <div class="alert alert-danger" role="alert">
                        <i class="fas fa-times-circle"></i>
                        <strong>Invoice Dibatalkan</strong>
                        @if($invoice->cancelled_at)
                            pada {{ $invoice->cancelled_at->format('d/m/Y H:i') }}
                        @endif
                    </div>
                </div>
            </div>
            @endif

            <!-- Action Buttons -->
            @if(!in_array($invoice->status, ['paid', 'cancelled']))
            <div class="row mt-4">
                <div class="col-12 text-center">
                    <div class="btn-group btn-group-lg" role="group">
                        <button class="btn btn-success" onclick="markAsPaid({{ $invoice->id }})">
                            <i class="fas fa-check"></i> Tandai Sebagai Dibayar
                            @if($invoice->metodePembayaran)
                            <small class="d-block">via {{ $invoice->metodePembayaran->nama }}</small>
                            @endif
                        </button>
                        <button class="btn btn-danger" onclick="cancelInvoice({{ $invoice->id }})">
                            <i class="fas fa-times"></i> Batalkan Invoice
                        </button>
                    </div>
                </div>
            </div>
            @endif

            <!-- Quick Actions for Paid Invoices -->
            @if($invoice->status === 'paid')
            <div class="row mt-4">
                <div class="col-12 text-center">
                    <div class="btn-group" role="group">
                        <a href="{{ route('invoices.download-pdf', $invoice->id) }}" class="btn btn-primary">
                            <i class="fas fa-download"></i> Download Receipt
                        </a>
                        {{-- <button onclick="sendEmailInvoice({{ $invoice->id }})" class="btn btn-info">
                            <i class="fas fa-envelope"></i> Email to Guest
                        </button>
                        <a href="{{ route('booking-services.create', ['booking_id' => $invoice->booking->id]) }}" class="btn btn-secondary">
                            <i class="fas fa-plus"></i> Add More Services
                        </a> --}}
                    </div>
                </div>
            </div>
            @endif

            <!-- Additional Information -->
            <div class="row mt-5">
                <div class="col-md-6">
                    <div class="card border-left-info">
                        <div class="card-body">
                            <h6 class="text-info mb-2">Invoice Information:</h6>
                            <table class="table table-borderless table-sm mb-0">
                                <tr>
                                    <td><strong>Created by:</strong></td>
                                    <td>{{ $invoice->createdBy->name ?? 'System' }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Created at:</strong></td>
                                    <td>{{ $invoice->created_at->format('d/m/Y H:i') }}</td>
                                </tr>
                                @if($invoice->updated_at != $invoice->created_at)
                                <tr>
                                    <td><strong>Last updated:</strong></td>
                                    <td>{{ $invoice->updated_at->format('d/m/Y H:i') }}</td>
                                </tr>
                                @endif
                                @if($invoice->paid_at)
                                <tr>
                                    <td><strong>Payment date:</strong></td>
                                    <td>{{ $invoice->paid_at->format('d/m/Y H:i') }}</td>
                                </tr>
                                @endif
                                @if($invoice->metodePembayaran)
                                <tr>
                                    <td><strong>Payment method:</strong></td>
                                    <td>
                                        <span class="badge badge-primary">
                                            <i class="fas {{ $invoice->metodePembayaran->icon ?? 'fa-credit-card' }} mr-1"></i>
                                            {{ $invoice->metodePembayaran->nama }}
                                        </span>
                                    </td>
                                </tr>
                                @endif
                            </table>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card border-left-warning">
                        <div class="card-body">
                            <h6 class="text-warning mb-2">Payment Summary:</h6>
                            <table class="table table-borderless table-sm mb-0">
                                <tr>
                                    <td><strong>Rooms ({{ $invoice->booking->bookingDetails->count() }} rooms):</strong></td>
                                    <td class="text-right">{{ $invoice->formatted_room_total }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Services ({{ $invoice->booking->bookingServices->count() }} items):</strong></td>
                                    <td class="text-right">{{ $invoice->formatted_services_total }}</td>
                                </tr>
                                @if($invoice->discount_amount > 0)
                                <tr>
                                    <td><strong>Discount:</strong></td>
                                    <td class="text-right text-success">{{ $invoice->formatted_discount_amount }}</td>
                                </tr>
                                @endif
                                <tr>
                                    <td><strong>Tax:</strong></td>
                                    <td class="text-right">{{ $invoice->formatted_tax_amount }}</td>
                                </tr>
                                @if($invoice->metodePembayaran && $invoice->metodePembayaran->biaya_admin > 0)
                                <tr>
                                    <td><strong>Admin Fee:</strong></td>
                                    <td class="text-right text-warning">Rp {{ number_format($invoice->metodePembayaran->biaya_admin, 0, ',', '.') }}</td>
                                </tr>
                                @endif
                                <tr class="border-top">
                                    <td><strong>Final Amount:</strong></td>
                                    <td class="text-right"><strong>{{ $invoice->formatted_grand_total }}</strong></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Booking Services Detail (if any) -->
            @if($invoice->booking->bookingServices->count() > 0)
            <div class="row mt-4">
                <div class="col-12">
                    <div class="card border-left-secondary">
                        <div class="card-header">
                            <h6 class="m-0 font-weight-bold text-secondary">Service Usage Timeline</h6>
                        </div>
                        <div class="card-body">
                            <div class="timeline">
                                @foreach($invoice->booking->bookingServices->sortBy('service_date') as $service)
                                <div class="timeline-item">
                                    <div class="timeline-marker bg-{{ $service->service->category_color }}"></div>
                                    <div class="timeline-content">
                                        <h6 class="timeline-title">{{ $service->service->name }}</h6>
                                        <p class="timeline-description">
                                            <span class="badge badge-{{ $service->service->category_color }}">{{ $service->service->category->name }}</span>
                                            Quantity: {{ $service->quantity }} |
                                            Date: {{ $service->service_date_formatted }} |
                                            Amount: {{ $service->formatted_total_amount }}
                                        </p>
                                        @if($service->notes)
                                        <small class="text-muted">Note: {{ $service->notes }}</small>
                                        @endif
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endif

            <!-- Related Actions -->
            <div class="row mt-4">
                <div class="col-12">
                    <div class="card border-left-primary">
                        <div class="card-header">
                            <h6 class="m-0 font-weight-bold text-primary">Related Actions</h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-4">
                                    <a href="{{ route('bookings.show', $invoice->booking->id) }}" class="btn btn-outline-primary btn-block">
                                        <i class="fas fa-bed"></i> View Booking Details
                                    </a>
                                </div>
                                <div class="col-md-4">
                                    <a href="{{ route('booking-services.index', ['booking_id' => $invoice->booking->id]) }}" class="btn btn-outline-secondary btn-block">
                                        <i class="fas fa-concierge-bell"></i> View All Services
                                    </a>
                                </div>
                                <div class="col-md-4">
                                    <a href="{{ route('guests.show', $invoice->booking->guest->id) }}" class="btn btn-outline-info btn-block">
                                        <i class="fas fa-user"></i> View Guest Profile
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Footer -->
            <div class="row mt-5">
                <div class="col-12 text-center">
                    <hr>
                    <p class="text-muted small mb-0">
                        Terima kasih atas kepercayaan Anda. Semoga pengalaman menginap Anda menyenangkan!
                    </p>
                    <p class="text-muted small">
                        Invoice ini dibuat secara otomatis pada {{ $invoice->created_at->format('d/m/Y H:i') }}
                        @if($invoice->metodePembayaran)
                        | Metode pembayaran: {{ $invoice->metodePembayaran->nama }}
                        @endif
                    </p>
                </div>
            </div>
        </div>
    </div>

</div>


@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
// Mark invoice as paid
function markAsPaid(id) {
    Swal.fire({
        title: 'Konfirmasi Pembayaran',
        html: `
            <p>Apakah Anda yakin invoice ini sudah dibayar?</p>
            @if($invoice->metodePembayaran)
            <div class="alert alert-info">
                <i class="fas fa-credit-card"></i>
                <strong>Metode Pembayaran:</strong> {{ $invoice->metodePembayaran->nama }}
                @if($invoice->metodePembayaran->biaya_admin > 0)
                <br><small>Biaya admin: Rp {{ number_format($invoice->metodePembayaran->biaya_admin, 0, ',', '.') }}</small>
                @endif
            </div>
            @endif
        `,
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Ya, Sudah Dibayar!',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            // Show loading
            Swal.fire({
                title: 'Memproses...',
                html: 'Sedang memperbarui status pembayaran',
                allowOutsideClick: false,
                allowEscapeKey: false,
                showConfirmButton: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            $.ajax({
                url: `{{ url('invoices') }}/${id}/mark-as-paid`,
                method: 'PATCH',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Berhasil!',
                            html: `
                                <p>${response.message}</p>
                                @if($invoice->metodePembayaran)
                                <div class="alert alert-success">
                                    <i class="fas fa-check-circle"></i>
                                    Pembayaran via <strong>{{ $invoice->metodePembayaran->nama }}</strong> berhasil dicatat
                                </div>
                                @endif
                            `,
                            timer: 3000,
                            showConfirmButton: false
                        }).then(() => {
                            location.reload();
                        });
                    }
                },
                error: function(xhr) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Gagal!',
                        text: xhr.responseJSON?.message || 'Gagal mengupdate status invoice',
                        confirmButtonText: 'Tutup'
                    });
                }
            });
        }
    });
}

// Cancel invoice
function cancelInvoice(id) {
    Swal.fire({
        title: 'Konfirmasi Pembatalan',
        html: `
            <p>Apakah Anda yakin ingin membatalkan invoice ini?</p>
            <div class="alert alert-warning">
                <i class="fas fa-exclamation-triangle"></i>
                <strong>Peringatan:</strong> Tindakan ini tidak dapat dibatalkan
            </div>
        `,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Ya, Batalkan!',
        cancelButtonText: 'Tidak'
    }).then((result) => {
        if (result.isConfirmed) {
            // Show loading
            Swal.fire({
                title: 'Memproses...',
                html: 'Sedang membatalkan invoice',
                allowOutsideClick: false,
                allowEscapeKey: false,
                showConfirmButton: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            $.ajax({
                url: `{{ url('invoices') }}/${id}/cancel`,
                method: 'PATCH',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Berhasil!',
                            text: response.message,
                            timer: 2000,
                            showConfirmButton: false
                        }).then(() => {
                            location.reload();
                        });
                    }
                },
                error: function(xhr) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Gagal!',
                        text: xhr.responseJSON?.message || 'Gagal membatalkan invoice',
                        confirmButtonText: 'Tutup'
                    });
                }
            });
        }
    });
}

// Send email invoice
function sendEmailInvoice(id) {
    Swal.fire({
        title: 'Kirim Email Invoice',
        html: `
            <p>Kirim invoice ke email tamu?</p>
            <div class="form-group">
                <input type="email" class="form-control" id="guest-email" placeholder="Email tamu" value="{{ $invoice->booking->guest->email ?? '' }}">
            </div>
            @if($invoice->metodePembayaran)
            <div class="alert alert-info">
                <small>Invoice akan menyertakan informasi metode pembayaran: <strong>{{ $invoice->metodePembayaran->nama }}</strong></small>
            </div>
            @endif
        `,
        icon: 'info',
        showCancelButton: true,
        confirmButtonColor: '#17a2b8',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Kirim Email',
        cancelButtonText: 'Batal',
        preConfirm: () => {
            const email = document.getElementById('guest-email').value;
            if (!email) {
                Swal.showValidationMessage('Email harus diisi');
                return false;
            }
            return email;
        }
    }).then((result) => {
        if (result.isConfirmed) {
            // Show loading
            Swal.fire({
                title: 'Mengirim Email...',
                html: 'Sedang mengirim invoice ke email tamu',
                allowOutsideClick: false,
                allowEscapeKey: false,
                showConfirmButton: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            $.ajax({
                url: `{{ url('invoices') }}/${id}/send-email`,
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    email: result.value
                },
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Email Terkirim!',
                            html: `
                                <p>${response.message}</p>
                                <div class="alert alert-success">
                                    <i class="fas fa-envelope"></i>
                                    Email telah dikirim ke: <strong>${result.value}</strong>
                                </div>
                            `,
                            confirmButtonText: 'Tutup'
                        });
                    }
                },
                error: function(xhr) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Gagal Mengirim!',
                        text: xhr.responseJSON?.message || 'Gagal mengirim email invoice',
                        confirmButtonText: 'Tutup'
                    });
                }
            });
        }
    });
}

// Handle success messages from server
@if(session('success'))
    Swal.fire({
        title: 'Berhasil!',
        text: '{{ session("success") }}',
        icon: 'success',
        timer: 3000,
        showConfirmButton: false
    });
@endif

@if(session('error'))
    Swal.fire({
        title: 'Error!',
        text: '{{ session("error") }}',
        icon: 'error'
    });
@endif

// Auto-refresh for overdue invoices
@if($invoice->status === 'pending' && $invoice->getDaysUntilDue() !== null && $invoice->getDaysUntilDue() < 0)
    // Check if invoice should be marked as overdue
    setTimeout(() => {
        location.reload();
    }, 60000); // Refresh after 1 minute
@endif
</script>

@endpush
@endsection
