<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice {{ $invoice->invoice_number }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 20px;
        }

        .header {
            margin-bottom: 30px;
            border-bottom: 2px solid #4e73df;
            padding-bottom: 20px;
        }

        .company-info {
            float: left;
            width: 50%;
        }

        .invoice-info {
            float: right;
            width: 45%;
            text-align: right;
        }

        .clearfix::after {
            content: "";
            display: table;
            clear: both;
        }

        .bill-to {
            margin: 30px 0;
        }

        .bill-to-left {
            float: left;
            width: 50%;
        }

        .bill-to-right {
            float: right;
            width: 45%;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }

        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }

        th {
            background-color: #f8f9fc;
            font-weight: bold;
        }

        .text-right {
            text-align: right;
        }

        .text-center {
            text-align: center;
        }

        .total-section {
            float: right;
            width: 300px;
            margin-top: 20px;
        }

        .total-section table {
            margin: 0;
        }

        .total-section th, .total-section td {
            border: none;
            border-bottom: 1px solid #ddd;
        }

        .grand-total {
            font-size: 14px;
            font-weight: bold;
            background-color: #d4edda;
        }

        .badge {
            display: inline-block;
            padding: 3px 6px;
            font-size: 10px;
            font-weight: bold;
            border-radius: 3px;
            color: white;
        }

        .badge-success { background-color: #28a745; }
        .badge-warning { background-color: #ffc107; color: #212529; }
        .badge-info { background-color: #17a2b8; }
        .badge-secondary { background-color: #6c757d; }
        .badge-primary { background-color: #007bff; }

        .notes {
            margin-top: 30px;
            padding: 15px;
            background-color: #f8f9fc;
            border-left: 4px solid #36b9cc;
        }

        .payment-method-info {
            margin-top: 20px;
            padding: 15px;
            background-color: #fff3cd;
            border-left: 4px solid #ffc107;
            border-radius: 5px;
        }

        .footer {
            margin-top: 50px;
            text-align: center;
            font-size: 10px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 20px;
        }

        h1, h2, h3 {
            margin: 0 0 10px 0;
        }

        .invoice-title {
            font-size: 24px;
            color: #4e73df;
            margin-bottom: 10px;
        }

        .company-name {
            font-size: 18px;
            color: #4e73df;
            font-weight: bold;
            margin-bottom: 5px;
        }

        .payment-instructions {
            margin-top: 15px;
            padding: 10px;
            background-color: #f8f9fc;
            border: 1px solid #dee2e6;
            border-radius: 3px;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header clearfix">
        <div class="company-info">
            <img src="{{asset('images/Logo.jpg')}}" width="30%" alt="Melati Hotel">
            <div>Jl. Contoh No. 123</div>
            <div>Samarinda, East Kalimantan</div>
            <div>Telepon: (021) 123-4567</div>
            <div>Email: info@hotel.com</div>
        </div>
        <div class="invoice-info">
            <h2 class="invoice-title">INVOICE</h2>
            <table style="border: none; margin: 0;">
                <tr>
                    <td style="border: none; font-weight: bold;">No. Invoice:</td>
                    <td style="border: none; color: #4e73df; font-weight: bold;">{{ $invoice->invoice_number }}</td>
                </tr>
                <tr>
                    <td style="border: none; font-weight: bold;">Tanggal:</td>
                    <td style="border: none;">{{ $invoice->invoice_date_formatted }}</td>
                </tr>
                <tr>
                    <td style="border: none; font-weight: bold;">Jatuh Tempo:</td>
                    <td style="border: none;">{{ $invoice->due_date_formatted }}</td>
                </tr>
                <tr>
                    <td style="border: none; font-weight: bold;">Status:</td>
                    <td style="border: none;">
                        <span class="badge badge-{{ $invoice->status_color }}">
                            {{ ucfirst($invoice->status) }}
                        </span>
                    </td>
                </tr>
            </table>
        </div>
    </div>

    <!-- Bill To -->
    <div class="bill-to clearfix">
        <div class="bill-to-left">
            <h3>Bill To:</h3>
            <div style="border-left: 3px solid #4e73df; padding-left: 15px;">
                <strong>{{ $invoice->booking->guest->name }}</strong><br>
                {{ $invoice->booking->guest->phone ?? 'No phone' }}<br>
                {{ $invoice->booking->guest->email ?? 'No email' }}<br>
                @if($invoice->booking->guest->address)
                {{ $invoice->booking->guest->address }}
                @endif
            </div>
        </div>
        <div class="bill-to-right">
            <h3>Booking Details:</h3>
            <table style="border: none; margin: 0;">
                <tr>
                    <td style="border: none; font-weight: bold;">Booking ID:</td>
                    <td style="border: none;">#{{ $invoice->booking->id }}</td>
                </tr>
                <tr>
                    <td style="border: none; font-weight: bold;">Check-in:</td>
                    <td style="border: none;">{{ $invoice->booking->check_in_date_formatted }}</td>
                </tr>
                <tr>
                    <td style="border: none; font-weight: bold;">Check-out:</td>
                    <td style="border: none;">{{ $invoice->booking->check_out_date_formatted }}</td>
                </tr>
                <tr>
                    <td style="border: none; font-weight: bold;">Total Malam:</td>
                    <td style="border: none;">{{ $invoice->booking->nights }} Hari</td>
                </tr>
            </table>
        </div>
    </div>

    <!-- Room Details -->
    @if($invoice->booking->bookingDetails->count() > 0)
    <h3>Detail Kamar:</h3>
    <table>
        <thead>
            <tr>
                <th>Kamar</th>
                <th>Tipe Kamar</th>
                <th class="text-center">Malam</th>
                <th class="text-right">Harga/Malam</th>
                <th class="text-right">Total</th>
            </tr>
        </thead>
        <tbody>
            @foreach($invoice->booking->bookingDetails as $detail)
            <tr>
                <td>Kamar {{ $detail->room->room_number }}</td>
                <td>{{ $detail->room->typeRoom->name }}</td>
                <td class="text-center">{{ $detail->nights }}</td>
                <td class="text-right">Rp {{ number_format($detail->room_price, 0, ',', '.') }}</td>
                <td class="text-right">Rp {{ number_format($detail->total_price, 0, ',', '.') }}</td>
            </tr>
            @endforeach
            <tr style="background-color: #f8f9fc;">
                <td colspan="4" class="text-right"><strong>Subtotal Kamar:</strong></td>
                <td class="text-right"><strong>{{ $invoice->formatted_room_total }}</strong></td>
            </tr>
        </tbody>
    </table>
    @endif

    <!-- Services Details -->
    @if($invoice->booking->bookingServices->count() > 0)
    <h3>Detail Layanan:</h3>
    <table>
        <thead>
            <tr>
                <th>Layanan</th>
                <th>Kategori</th>
                <th class="text-center">Qty</th>
                <th class="text-right">Harga/Unit</th>
                <th class="text-right">Total</th>
            </tr>
        </thead>
        <tbody>
            @foreach($invoice->booking->bookingServices as $service)
            <tr>
                <td>{{ $service->service->name }}</td>
                <td>
                    <span class="badge badge-{{ $service->service->category_color }}">
                        {{ $service->service->category->name }}
                    </span>
                </td>
                <td class="text-center">{{ $service->quantity }}</td>
                <td class="text-right">Rp {{ number_format($service->unit_price, 0, ',', '.') }}</td>
                <td class="text-right">Rp {{ number_format($service->total_amount, 0, ',', '.') }}</td>
            </tr>
            @endforeach
            <tr style="background-color: #f8f9fc;">
                <td colspan="4" class="text-right"><strong>Subtotal Layanan:</strong></td>
                <td class="text-right"><strong>{{ $invoice->formatted_services_total }}</strong></td>
            </tr>
        </tbody>
    </table>
    @endif

    <!-- Invoice Summary -->
    <div class="clearfix">
        @if($invoice->notes)
        <div class="notes" style="width: 45%; float: left;">
            <h4>Catatan:</h4>
            <p>{{ $invoice->notes }}</p>
        </div>
        @endif

        <div class="total-section">
            <table>
                <tr>
                    <td class="text-right"><strong>Subtotal:</strong></td>
                    <td class="text-right">{{ $invoice->formatted_subtotal }}</td>
                </tr>
                @if($invoice->discount_amount > 0)
                <tr>
                    <td class="text-right"><strong>Diskon:</strong></td>
                    <td class="text-right" style="color: #dc3545;">- {{ $invoice->formatted_discount_amount }}</td>
                </tr>
                @endif
                <tr>
                    <td class="text-right"><strong>Pajak ({{ $invoice->tax_rate }}%):</strong></td>
                    <td class="text-right">{{ $invoice->formatted_tax_amount }}</td>
                </tr>
                @if($invoice->metodePembayaran && $invoice->metodePembayaran->biaya_admin > 0)
                <tr>
                    <td class="text-right"><strong>Biaya Admin:</strong></td>
                    <td class="text-right">Rp {{ number_format($invoice->metodePembayaran->biaya_admin, 0, ',', '.') }}</td>
                </tr>
                @endif
                <tr class="grand-total">
                    <td class="text-right"><strong>Grand Total:</strong></td>
                    <td class="text-right"><strong>{{ $invoice->formatted_grand_total }}</strong></td>
                </tr>
            </table>
        </div>
    </div>

    <!-- Payment Method Information -->
    @if($invoice->metodePembayaran)
    <div class="clearfix payment-method-info">
        <h4 style="margin-bottom: 10px; color: #856404;">Metode Pembayaran:</h4>
        <div style="display: flex; align-items: center; margin-bottom: 10px;">
            <div style="margin-right: 15px;">
                <span class="badge badge-primary">{{ $invoice->metodePembayaran->nama }}</span>
            </div>
            @if($invoice->metodePembayaran->deskripsi)
            <div style="font-size: 11px; color: #666;">
                {{ $invoice->metodePembayaran->deskripsi }}
            </div>
            @endif
        </div>

        @if($invoice->metodePembayaran->biaya_admin > 0)
        <div style="font-size: 11px; color: #856404; margin-bottom: 10px;">
            <strong>Catatan:</strong> Biaya admin Rp {{ number_format($invoice->metodePembayaran->biaya_admin, 0, ',', '.') }} sudah termasuk dalam grand total.
        </div>
        @endif

        @if($invoice->status === 'pending')
        <div class="payment-instructions">
            <strong>Instruksi Pembayaran:</strong>
            @if(strtolower($invoice->metodePembayaran->nama) == 'cash' || strpos(strtolower($invoice->metodePembayaran->nama), 'tunai') !== false)
                <p style="margin: 5px 0; font-size: 11px;">
                    • Lakukan pembayaran tunai di front desk hotel<br>
                    • Bawa invoice ini sebagai bukti<br>
                    • Jam operasional: 24 jam
                </p>
            @elseif(strtolower($invoice->metodePembayaran->nama) == 'bank transfer' || strpos(strtolower($invoice->metodePembayaran->nama), 'transfer') !== false)
                <p style="margin: 5px 0; font-size: 11px;">
                    • Transfer ke rekening hotel yang telah ditentukan<br>
                    • Kirimkan bukti transfer ke front desk<br>
                    • Cantumkan nomor invoice sebagai keterangan
                </p>
            @elseif(strtolower($invoice->metodePembayaran->nama) == 'credit card' || strpos(strtolower($invoice->metodePembayaran->nama), 'kartu') !== false)
                <p style="margin: 5px 0; font-size: 11px;">
                    • Pembayaran dapat dilakukan di front desk<br>
                    • Bawa kartu kredit yang valid<br>
                    • Tunjukkan invoice ini kepada petugas
                </p>
            @else
                <p style="margin: 5px 0; font-size: 11px;">
                    • Hubungi front desk untuk informasi pembayaran<br>
                    {{-- • Telepon: (021) 123-4567<br>
                    • Email: info@hotel.com --}}
                </p>
            @endif
        </div>
        @endif
    </div>
    @endif

    <!-- Payment Status -->
    <div class="clearfix" style="margin-top: 30px;">
        @if($invoice->status === 'paid')
        <div style="background-color: #d4edda; border: 1px solid #c3e6cb; padding: 15px; border-radius: 5px;">
            <strong>✓ Invoice Lunas!</strong>
            @if($invoice->paid_at)
                Dibayar pada {{ $invoice->paid_at->format('d/m/Y H:i') }}
            @endif
            @if($invoice->metodePembayaran)
                via {{ $invoice->metodePembayaran->nama }}
            @endif
        </div>
        @elseif($invoice->status === 'pending')
        <div style="background-color: #fff3cd; border: 1px solid #ffeaa7; padding: 15px; border-radius: 5px;">
            <strong>⏰ Menunggu Pembayaran</strong>
            @if($invoice->getDaysUntilDue() !== null)
                @if($invoice->getDaysUntilDue() > 0)
                    - Jatuh tempo dalam {{ $invoice->getDaysUntilDue() }} hari
                @elseif($invoice->getDaysUntilDue() == 0)
                    - Jatuh tempo hari ini
                @else
                    - Terlambat {{ abs($invoice->getDaysUntilDue()) }} hari
                @endif
            @endif
        </div>
        @elseif($invoice->status === 'overdue')
        <div style="background-color: #f8d7da; border: 1px solid #f5c6cb; padding: 15px; border-radius: 5px;">
            <strong>⚠ Invoice Terlambat</strong>
            @if($invoice->getDaysUntilDue() !== null)
                - Terlambat {{ abs($invoice->getDaysUntilDue()) }} hari
            @endif
            <br><small>Segera lakukan pembayaran untuk menghindari denda keterlambatan</small>
        </div>
        @elseif($invoice->status === 'cancelled')
        <div style="background-color: #f8d7da; border: 1px solid #f5c6cb; padding: 15px; border-radius: 5px;">
            <strong>✗ Invoice Dibatalkan</strong>
            @if($invoice->cancelled_at)
                pada {{ $invoice->cancelled_at->format('d/m/Y H:i') }}
            @endif
        </div>
        @endif
    </div>

    <!-- Footer -->
    <div class="footer">
        <p>Terima kasih atas kepercayaan Anda. Semoga pengalaman menginap Anda menyenangkan!</p>
        <p>Invoice ini dibuat secara otomatis pada {{ $invoice->created_at->format('d/m/Y H:i') }}</p>
        @if($invoice->metodePembayaran)
        <p>Metode pembayaran: {{ $invoice->metodePembayaran->nama }}</p>
        @endif
    </div>
</body>
</html>
