{{-- resources/views/housekeeping/modals/room-status.blade.php --}}
<!-- Room Status Modal -->
<div class="modal fade" id="roomStatusModal" tabindex="-1" aria-labelledby="roomStatusModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="roomStatusModalLabel">
                    <i class="fas fa-bed me-2"></i>Room Status Management
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            
            <div class="modal-body">
                <!-- Status Filter -->
                <div class="row mb-3">
                    <div class="col-md-6">
                        <div class="btn-group btn-group-sm" role="group">
                            <button type="button" class="btn btn-outline-secondary active" onclick="filterRooms('all')">
                                All Rooms
                            </button>
                            <button type="button" class="btn btn-outline-success" onclick="filterRooms('clean')">
                                Clean
                            </button>
                            <button type="button" class="btn btn-outline-danger" onclick="filterRooms('dirty')">
                                Dirty
                            </button>
                            <button type="button" class="btn btn-outline-info" onclick="filterRooms('maintenance')">
                                Maintenance
                            </button>
                            <button type="button" class="btn btn-outline-secondary" onclick="filterRooms('ooo')">
                                Out of Order
                            </button>
                        </div>
                    </div>
                    <div class="col-md-6 text-end">
                        <button class="btn btn-primary btn-sm" onclick="bulkUpdateStatus()">
                            <i class="fas fa-edit me-1"></i> Bulk Update
                        </button>
                    </div>
                </div>

                <!-- Rooms Grid -->
                <div class="row" id="roomsGrid">
                    @foreach($rooms ?? [] as $room)
                    <div class="col-md-3 col-sm-4 col-6 mb-3 room-card" data-status="{{ $room->status ?? 'clean' }}">
                        <div class="card room-status-card">
                            <div class="card-body text-center p-3">
                                <div class="room-number mb-2">
                                    <h5 class="mb-0">{{ $room->room_number }}</h5>
                                    @if($room->typeRoom)
                                        <small class="text-muted">{{ $room->typeRoom->name }}</small>
                                    @endif
                                </div>
                                
                                <!-- Current Status Badge -->
                                <div class="mb-2">
                                    <span class="badge status-badge status-{{ $room->status ?? 'clean' }}">
                                        {{ ucfirst($room->status ?? 'Clean') }}
                                    </span>
                                </div>
                                
                                <!-- Status Update Buttons -->
                                <div class="btn-group-vertical d-grid gap-1">
                                    <button class="btn btn-success btn-sm {{ ($room->status ?? 'clean') == 'clean' ? 'active' : '' }}" 
                                            onclick="updateRoomStatus('{{ $room->room_number }}', 'clean')">
                                        <i class="fas fa-check"></i> Clean
                                    </button>
                                    <button class="btn btn-danger btn-sm {{ ($room->status ?? '') == 'dirty' ? 'active' : '' }}" 
                                            onclick="updateRoomStatus('{{ $room->room_number }}', 'dirty')">
                                        <i class="fas fa-times"></i> Dirty
                                    </button>
                                    <button class="btn btn-info btn-sm {{ ($room->status ?? '') == 'maintenance' ? 'active' : '' }}" 
                                            onclick="updateRoomStatus('{{ $room->room_number }}', 'maintenance')">
                                        <i class="fas fa-wrench"></i> Maintenance
                                    </button>
                                    <button class="btn btn-secondary btn-sm {{ ($room->status ?? '') == 'ooo' ? 'active' : '' }}" 
                                            onclick="updateRoomStatus('{{ $room->room_number }}', 'ooo')">
                                        <i class="fas fa-ban"></i> Out of Order
                                    </button>
                                </div>
                                
                                <!-- Last Updated -->
                                @if($room->updated_at)
                                <div class="mt-2">
                                    <small class="text-muted">
                                        Updated: {{ $room->updated_at->format('H:i') }}
                                    </small>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
                
                @if(($rooms ?? collect())->isEmpty())
                <div class="text-center py-5">
                    <i class="fas fa-bed fa-3x text-muted mb-3"></i>
                    <p class="text-muted">No rooms found</p>
                </div>
                @endif
            </div>

            <div class="modal-footer">
                <div class="me-auto">
                    <small class="text-muted">
                        Total: {{ ($rooms ?? collect())->count() }} rooms | 
                        Clean: <span class="text-success">{{ ($rooms ?? collect())->where('status', 'clean')->count() }}</span> | 
                        Dirty: <span class="text-danger">{{ ($rooms ?? collect())->where('status', 'dirty')->count() }}</span> | 
                        Maintenance: <span class="text-info">{{ ($rooms ?? collect())->where('status', 'maintenance')->count() }}</span> | 
                        OOO: <span class="text-secondary">{{ ($rooms ?? collect())->where('status', 'ooo')->count() }}</span>
                    </small>
                </div>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<style>
.room-status-card {
    border: 2px solid #e9ecef;
    transition: all 0.3s ease;
}

.room-status-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}

.status-badge {
    font-size: 0.75rem;
    padding: 0.25rem 0.75rem;
}

.status-clean {
    background-color: #d4edda;
    color: #155724;
    border-color: #c3e6cb;
}

.status-dirty {
    background-color: #f8d7da;
    color: #721c24;
    border-color: #f5c6cb;
}

.status-maintenance {
    background-color: #d1ecf1;
    color: #0c5460;
    border-color: #bee5eb;
}

.status-ooo {
    background-color: #e2e3e5;
    color: #383d41;
    border-color: #d6d8db;
}

.room-card[data-status="clean"] .room-status-card {
    border-color: #28a745;
}

.room-card[data-status="dirty"] .room-status-card {
    border-color: #dc3545;
}

.room-card[data-status="maintenance"] .room-status-card {
    border-color: #17a2b8;
}

.room-card[data-status="ooo"] .room-status-card {
    border-color: #6c757d;
}

.btn-group-vertical .btn.active {
    box-shadow: 0 0 0 0.2rem rgba(0,123,255,0.25);
}
</style>

<script>
function filterRooms(status) {
    // Update active button
    document.querySelectorAll('#roomStatusModal .btn-group button').forEach(btn => {
        btn.classList.remove('active');
    });
    event.target.classList.add('active');
    
    // Filter room cards
    const roomCards = document.querySelectorAll('.room-card');
    roomCards.forEach(card => {
        if (status === 'all' || card.dataset.status === status) {
            card.style.display = 'block';
        } else {
            card.style.display = 'none';
        }
    });
}

function updateRoomStatus(roomNumber, newStatus) {
    if (!confirm(`Change room ${roomNumber} status to ${newStatus}?`)) {
        return;
    }

    // Show loading
    const roomCard = document.querySelector(`[data-room="${roomNumber}"]`);
    
    // Make AJAX request
    fetch(`/housekeeping/rooms/${roomNumber}/status`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify({ status: newStatus })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Update UI
            const roomCard = document.querySelector(`.room-card[data-status="${roomNumber}"]`) || 
                            [...document.querySelectorAll('.room-card')].find(card => 
                                card.querySelector('.room-number h5').textContent.trim() === roomNumber);
            
            if (roomCard) {
                // Update status badge
                const statusBadge = roomCard.querySelector('.status-badge');
                statusBadge.className = `badge status-badge status-${newStatus}`;
                statusBadge.textContent = newStatus.charAt(0).toUpperCase() + newStatus.slice(1);
                
                // Update card border
                roomCard.dataset.status = newStatus;
                
                // Update active buttons
                roomCard.querySelectorAll('.btn').forEach(btn => btn.classList.remove('active'));
                roomCard.querySelector(`.btn[onclick*="'${newStatus}'"]`).classList.add('active');
                
                // Update timestamp
                const timestamp = roomCard.querySelector('small.text-muted');
                if (timestamp) {
                    timestamp.textContent = `Updated: ${new Date().toLocaleTimeString('en-GB', {hour: '2-digit', minute:'2-digit'})}`;
                }
            }
            
            // Show success message
            showToast('Room status updated successfully', 'success');
        } else {
            throw new Error(data.message || 'Failed to update room status');
        }
    })
    .catch(error => {
        showToast('Error: ' + error.message, 'error');
    });
}

function bulkUpdateStatus() {
    // This would open another modal for bulk operations
    alert('Bulk update functionality - to be implemented');
}

function showToast(message, type = 'info') {
    // Simple toast notification (you can replace with your preferred toast library)
    const toast = document.createElement('div');
    toast.className = `alert alert-${type === 'error' ? 'danger' : type} position-fixed`;
    toast.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
    toast.innerHTML = `
        ${message}
        <button type="button" class="btn-close" onclick="this.parentElement.remove()"></button>
    `;
    document.body.appendChild(toast);
    
    // Auto remove after 3 seconds
    setTimeout(() => {
        if (toast.parentNode) {
            toast.remove();
        }
    }, 3000);
}
</script>