{{-- resources/views/housekeeping/modals/create-task.blade.php --}}
<!-- Create Task Modal -->
<div class="modal fade" id="createTaskModal" tabindex="-1" aria-labelledby="createTaskModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="createTaskModalLabel">
                    <i class="fas fa-plus me-2"></i>Create New Task
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            
            <form id="createTaskForm" action="{{ route('housekeeping.tasks.store') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <!-- Room Selection -->
                        <div class="col-md-6 mb-3">
                            <label for="room_id" class="form-label">Room <span class="text-danger">*</span></label>
                            <select class="form-select" id="room_id" name="room_id" required>
                                <option value="">Select Room</option>
                                @foreach($rooms ?? [] as $room)
                                    <option value="{{ $room->id }}">
                                        Room {{ $room->room_number }} 
                                        @if($room->type_room_id && $room->typeRoom)
                                            - {{ $room->typeRoom->name }}
                                        @endif
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Task Type -->
                        <div class="col-md-6 mb-3">
                            <label for="task_type" class="form-label">Task Type <span class="text-danger">*</span></label>
                            <select class="form-select" id="task_type" name="task_type" required>
                                <option value="">Select Task Type</option>
                                <option value="checkout_cleaning">Checkout Cleaning</option>
                                <option value="maintenance">Maintenance</option>
                                <option value="deep_cleaning">Deep Cleaning</option>
                                <option value="inspection">Inspection</option>
                            </select>
                        </div>

                        <!-- Priority -->
                        <div class="col-md-6 mb-3">
                            <label for="priority" class="form-label">Priority <span class="text-danger">*</span></label>
                            <select class="form-select" id="priority" name="priority" required>
                                <option value="">Select Priority</option>
                                <option value="low">Low</option>
                                <option value="normal" selected>Normal</option>
                                <option value="high">High</option>
                                <option value="urgent">Urgent</option>
                            </select>
                        </div>

                        <!-- Estimated Duration -->
                        <div class="col-md-6 mb-3">
                            <label for="estimated_duration" class="form-label">Duration (minutes) <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="estimated_duration" name="estimated_duration" 
                                   min="1" max="480" value="30" required>
                            <div class="form-text">Estimated time to complete this task</div>
                        </div>

                        <!-- Due Date & Time -->
                        <div class="col-md-6 mb-3">
                            <label for="due_date" class="form-label">Due Date <span class="text-danger">*</span></label>
                            <input type="date" class="form-control" id="due_date" name="due_date" 
                                   value="{{ date('Y-m-d') }}" required>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="due_time" class="form-label">Due Time <span class="text-danger">*</span></label>
                            <input type="time" class="form-control" id="due_time" name="due_time" 
                                   value="{{ date('H:i', strtotime('+2 hours')) }}" required>
                        </div>

                        <!-- Assign To -->
                        <div class="col-md-12 mb-3">
                            <label for="assigned_to" class="form-label">Assign To</label>
                            <select class="form-select" id="assigned_to" name="assigned_to">
                                <option value="">Assign Later</option>
                                @foreach($staff ?? [] as $user)
                                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                                @endforeach
                            </select>
                            <div class="form-text">Leave empty to assign later</div>
                        </div>

                        <!-- Description -->
                        <div class="col-md-12 mb-3">
                            <label for="description" class="form-label">Description <span class="text-danger">*</span></label>
                            <textarea class="form-control" id="description" name="description" rows="3" 
                                      placeholder="Describe the task details..." required></textarea>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-1"></i> Create Task
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Auto-fill duration based on task type
    const taskTypeSelect = document.getElementById('task_type');
    const durationInput = document.getElementById('estimated_duration');
    
    taskTypeSelect?.addEventListener('change', function() {
        const durations = {
            'checkout_cleaning': 45,
            'maintenance': 90,
            'deep_cleaning': 120,
            'inspection': 30
        };
        
        if (durations[this.value]) {
            durationInput.value = durations[this.value];
        }
    });

    // Form submission
    const createTaskForm = document.getElementById('createTaskForm');
    createTaskForm?.addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        
        // Combine date and time for due_time
        const dueDate = formData.get('due_date');
        const dueTime = formData.get('due_time');
        formData.set('due_time', `${dueDate} ${dueTime}`);
        
        // Show loading
        const submitBtn = this.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-1"></i> Creating...';
        submitBtn.disabled = true;
        
        // Submit form
        fetch(this.action, {
            method: 'POST',
            body: formData,
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Close modal and reload page
                bootstrap.Modal.getInstance(document.getElementById('createTaskModal')).hide();
                location.reload();
            } else {
                throw new Error(data.message || 'Failed to create task');
            }
        })
        .catch(error => {
            alert('Error: ' + error.message);
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });
});
</script>