@extends('admin-layouts.master')
@section('title', 'Tambah Housekeeping Task')
<style>
/* Minimal Styling */
.card {
    border: none;
    border-radius: 8px;
}

.card-header {
    border-radius: 8px 8px 0 0 !important;
    font-weight: 600;
}

.form-control:focus, .form-select:focus {
    border-color: #0d6efd;
    box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
}

.btn {
    border-radius: 6px;
    font-weight: 500;
}

.badge {
    font-size: 0.7rem;
}

.alert {
    border-radius: 6px;
}

.shadow-sm {
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075) !important;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .card-body {
        padding: 1rem;
    }
}
</style>
@section('content')
<div class="container-fluid">
    <!-- Simple Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="mb-1">Tambah Housekeeping Task</h4>
            <p class="text-muted mb-0 small">Buat task baru untuk tim housekeeping</p>
        </div>
        <a href="{{ route('housekeeping.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Kembali
        </a>
    </div>

    <div class="row">
        <!-- Main Form - Simplified -->
        <div class="col-lg-8">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h6 class="mb-0"><i class="fas fa-plus-circle"></i> Form Tambah Task</h6>
                </div>
                <div class="card-body">
                    <form action="{{ route('housekeeping.store') }}" method="POST" id="taskForm">
                        @csrf
                        
                        <!-- Room & Booking - Simplified -->
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Room <span class="text-danger">*</span></label>
                                <select class="form-select form-control @error('room_id') is-invalid @enderror" 
                                        name="room_id" required>
                                    <option value="">Pilih Room...</option>
                                    @foreach($rooms as $room)
                                        <option value="{{ $room->id }}" {{ old('room_id') == $room->id ? 'selected' : '' }}>
                                            {{ $room->room_number }}
                                            @if($room->typeRoom) - {{ $room->typeRoom->name }} @endif
                                        </option>
                                    @endforeach
                                </select>
                                @error('room_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Booking <span class="text-muted">(Opsional)</span></label>
                                <select class="form-select form-control @error('booking_id') is-invalid @enderror" 
                                        name="booking_id">
                                    <option value="">Pilih Booking...</option>
                                    @foreach($bookings as $booking)
                                        <option value="{{ $booking->id }}" {{ old('booking_id') == $booking->id ? 'selected' : '' }}>
                                            #{{ $booking->id }} - {{ $booking->guest->name ?? 'Unknown Guest' }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('booking_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Task Type & Priority - Simplified -->
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Jenis Task <span class="text-danger">*</span></label>
                                <select class="form-select form-control @error('task_type') is-invalid @enderror" 
                                        name="task_type" id="task_type" required>
                                    <option value="">Pilih Jenis Task...</option>
                                    <option value="checkout_cleaning" {{ old('task_type') == 'checkout_cleaning' ? 'selected' : '' }}>
                                        Pembersihan Checkout
                                    </option>
                                    <option value="maintenance" {{ old('task_type') == 'maintenance' ? 'selected' : '' }}>
                                        Maintenance
                                    </option>
                                    <option value="deep_cleaning" {{ old('task_type') == 'deep_cleaning' ? 'selected' : '' }}>
                                        Deep Cleaning
                                    </option>
                                    <option value="inspection" {{ old('task_type') == 'inspection' ? 'selected' : '' }}>
                                        Inspeksi
                                    </option>
                                </select>
                                @error('task_type')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Priority <span class="text-danger">*</span></label>
                                <select class="form-select form-control @error('priority') is-invalid @enderror" 
                                        name="priority" id="priority" required>
                                    <option value="">Pilih Priority...</option>
                                    <option value="low" {{ old('priority') == 'low' ? 'selected' : '' }}>Low</option>
                                    <option value="normal" {{ old('priority') == 'normal' ? 'selected' : '' }}>Normal</option>
                                    <option value="high" {{ old('priority') == 'high' ? 'selected' : '' }}>High</option>
                                    <option value="urgent" {{ old('priority') == 'urgent' ? 'selected' : '' }}>Urgent</option>
                                </select>
                                @error('priority')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <!-- Duration & Due Time - Simplified -->
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Estimasi Durasi (menit)</label>
                                <input type="number" class="form-control @error('estimated_duration') is-invalid @enderror" 
                                       name="estimated_duration" id="estimated_duration" min="1" 
                                       value="{{ old('estimated_duration', 60) }}" placeholder="60">
                                <small class="text-muted">Estimasi waktu pengerjaan</small>
                                @error('estimated_duration')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Target Selesai</label>
                                <input type="datetime-local" class="form-control @error('due_time') is-invalid @enderror" 
                                       name="due_time" id="due_time" value="{{ old('due_time') }}">
                                <small class="text-muted">Kapan task harus selesai</small>
                                @error('due_time')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Staff Assignment - Simplified -->
                        <div class="mb-4">
                            <label class="form-label fw-bold">Assign ke Staff</label>
                            <select class="form-select form-control @error('assigned_to') is-invalid @enderror" 
                                    name="assigned_to">
                                <option value="">Assign nanti...</option>
                                @foreach($users as $user)
                                    <option value="{{ $user->id }}" {{ old('assigned_to') == $user->id ? 'selected' : '' }}>
                                        {{ $user->name }}
                                    </option>
                                @endforeach
                            </select>
                            <small class="text-muted">Staff yang akan mengerjakan task ini</small>
                            @error('assigned_to')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Description - Simplified -->
                        <div class="mb-4">
                            <label class="form-label fw-bold">Deskripsi Task</label>
                            <textarea class="form-control @error('description') is-invalid @enderror" 
                                      name="description" id="description" rows="3" 
                                      placeholder="Jelaskan detail pekerjaan yang harus dilakukan...">{{ old('description') }}</textarea>
                            @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Action Buttons - Simplified -->
                        <div class="d-flex gap-2 justify-content-end">
                            <a href="{{ route('housekeeping.index') }}" class="btn btn-outline-secondary mr-2">
                                <i class="fas fa-times"></i> Batal
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Simpan Task
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!-- Sidebar - Simplified -->
        <div class="col-lg-4">
            <!-- Quick Actions - Minimal -->
            <div class="card shadow-sm mb-3">
                <div class="card-header bg-success text-white">
                    <h6 class="mb-0"><i class="fas fa-bolt"></i> Quick Actions</h6>
                </div>
                <div class="card-body p-3">
                    <div class="d-grid gap-2">
                        <button type="button" class="btn btn-outline-primary mr-2" onclick="setQuickTask('checkout')">
                            <i class="fas fa-broom"></i> Quick Checkout
                        </button>
                        <button type="button" class="btn btn-outline-warning mr-2" onclick="setQuickTask('maintenance')">
                            <i class="fas fa-tools"></i> Quick Maintenance
                        </button>
                        <button type="button" class="btn btn-outline-info mt-2" onclick="setQuickTask('inspection')">
                            <i class="fas fa-search"></i> Quick Inspection
                        </button>
                    </div>
                </div>
            </div>

            <!-- Tips - Minimal -->
            <div class="card shadow-sm mb-3">
                <div class="card-header bg-info text-white">
                    <h6 class="mb-0"><i class="fas fa-lightbulb"></i> Tips</h6>
                </div>
                <div class="card-body p-3">
                    <div class="mb-3">
                        <h6 class="fw-bold mb-2">Jenis Task:</h6>
                        <ul class="list-unstyled small">
                            <li><span class="badge bg-primary me-1">🧹</span> Checkout: Pembersihan standar</li>
                            <li><span class="badge bg-warning me-1">🔧</span> Maintenance: Perbaikan fasilitas</li>
                            <li><span class="badge bg-success me-1">✨</span> Deep Clean: Pembersihan menyeluruh</li>
                            <li><span class="badge bg-info me-1">🔍</span> Inspeksi: Pemeriksaan kondisi</li>
                        </ul>
                    </div>

                    <div class="mb-3">
                        <h6 class="fw-bold mb-2">Priority:</h6>
                        <div class="d-flex flex-wrap gap-1">
                            <span class="badge bg-light text-dark mr-1">Low</span>
                            <span class="badge bg-primary text-white mr-1">Normal</span>
                            <span class="badge bg-warning mr-1">High</span>
                            <span class="badge bg-danger text-white">Urgent</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Info - Minimal -->
            <div class="card shadow-sm">
                <div class="card-body p-3">
                    <div class="alert alert-info border-0 p-2 mb-2">
                        <small><i class="fas fa-info-circle"></i> <strong>Auto-Create:</strong> Task checkout otomatis dibuat saat guest checkout.</small>
                    </div>
                    <div class="alert alert-warning border-0 p-2 mb-0">
                        <small><i class="fas fa-bell"></i> <strong>Notifications:</strong> Task urgent muncul notifikasi di navbar.</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@push('scripts')

<script>
$(document).ready(function() {
    // Set default due time to 2 hours from now
    if (!$('#due_time').val()) {
        const now = new Date();
        now.setHours(now.getHours() + 2);
        const formatted = now.toISOString().slice(0, 16);
        $('#due_time').val(formatted);
    }
});

// Simple Quick task presets
function setQuickTask(type) {
    const button = event.target;
    const originalText = button.innerHTML;
    
    // Show loading
    button.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Loading...';
    button.disabled = true;
    
    setTimeout(() => {
        switch(type) {
            case 'checkout':
                $('#task_type').val('checkout_cleaning');
                $('#priority').val('normal');
                $('#estimated_duration').val(60);
                $('#description').val('Pembersihan standar room setelah guest checkout:\n- Ganti bed sheet dan towel\n- Bersihkan kamar mandi\n- Vacuum carpet\n- Periksa fasilitas room');
                break;
            case 'maintenance':
                $('#task_type').val('maintenance');
                $('#priority').val('high');
                $('#estimated_duration').val(90);
                $('#description').val('Pemeriksaan dan perbaikan:\n- Periksa AC dan lampu\n- Cek fasilitas kamar mandi\n- Test TV dan WiFi\n- Perbaiki jika ada kerusakan');
                break;
            case 'inspection':
                $('#task_type').val('inspection');
                $('#priority').val('normal');
                $('#estimated_duration').val(30);
                $('#description').val('Inspeksi kondisi room:\n- Periksa kebersihan\n- Cek kelengkapan amenities\n- Dokumentasi kondisi\n- Laporkan jika ada masalah');
                break;
        }
        
        // Update due time
        updateDueTime();
        
        // Restore button
        button.innerHTML = originalText;
        button.disabled = false;
        
        // Show notification
        showNotification('Template applied successfully!', 'success');
        
    }, 500);
}

// Update due time based on priority
function updateDueTime() {
    const priority = $('#priority').val();
    const now = new Date();
    
    switch(priority) {
        case 'urgent':
            now.setHours(now.getHours() + 1);
            break;
        case 'high':
            now.setHours(now.getHours() + 2);
            break;
        case 'normal':
            now.setHours(now.getHours() + 4);
            break;
        case 'low':
            now.setHours(now.getHours() + 8);
            break;
    }
    
    const formatted = now.toISOString().slice(0, 16);
    $('#due_time').val(formatted);
}

// Auto-adjust due time when priority changes
$('#priority').on('change', updateDueTime);

// Auto-set estimated duration based on task type
$('#task_type').on('change', function() {
    const taskType = $(this).val();
    let duration;
    
    switch(taskType) {
        case 'checkout_cleaning':
            duration = 60;
            break;
        case 'maintenance':
            duration = 90;
            break;
        case 'deep_cleaning':
            duration = 120;
            break;
        case 'inspection':
            duration = 30;
            break;
        default:
            duration = 60;
    }
    
    $('#estimated_duration').val(duration);
});

// Simple form validation
$('#taskForm').on('submit', function(e) {
    let isValid = true;
    const requiredFields = ['room_id', 'task_type', 'priority'];
    
    requiredFields.forEach(function(field) {
        const element = $(`[name="${field}"]`);
        if (!element.val()) {
            isValid = false;
            element.addClass('is-invalid');
        } else {
            element.removeClass('is-invalid');
        }
    });
    
    if (!isValid) {
        e.preventDefault();
        showNotification('Mohon lengkapi semua field yang wajib diisi!', 'error');
    }
});

// Simple notification system
function showNotification(message, type = 'info') {
    const alertClass = type === 'success' ? 'alert-success' : 
                      type === 'error' ? 'alert-danger' : 'alert-info';
    
    const notification = $(`
        <div class="alert ${alertClass} alert-dismissible fade show position-fixed" 
             style="top: 20px; right: 20px; z-index: 9999; min-width: 300px;">
            ${message}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    `);
    
    $('body').append(notification);
    
    setTimeout(() => notification.alert('close'), 3000);
}

// Real-time validation feedback
$('.form-control, .form-select').on('change', function() {
    const field = $(this);
    if (field.prop('required') && !field.val()) {
        field.addClass('is-invalid');
    } else {
        field.removeClass('is-invalid');
    }
});
</script>
@endpush

