@extends('admin-layouts.master')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Check-in Tamu</h1>
        <a href="{{ route('bookings.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Kembali
        </a>
    </div>

    @if($booking)
    <!-- Booking Information -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Informasi Booking #{{ $booking->id }}</h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-borderless">
                        <tr>
                            <td><strong>Nama Tamu:</strong></td>
                            <td>{{ $booking->guest->name }}</td>
                        </tr>
                        <tr>
                            <td><strong>Telepon:</strong></td>
                            <td>{{ $booking->guest->phone }}</td>
                        </tr>
                        <tr>
                            <td><strong>Email:</strong></td>
                            <td>{{ $booking->guest->email ?? '-' }}</td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-borderless">
                        <tr>
                            <td><strong>Tanggal Check-in:</strong></td>
                            <td>{{ $booking->check_in_date_formatted }}</td>
                        </tr>
                        <tr>
                            <td><strong>Tanggal Check-out:</strong></td>
                            <td>{{ $booking->check_out_date_formatted }}</td>
                        </tr>
                        <tr>
                            <td><strong>Kamar:</strong></td>
                            <td>
                                @foreach($booking->bookingDetails as $detail)
                                    <span class="badge badge-info mr-1">
                                        {{ $detail->room->room_number }} - {{ $detail->room->typeRoom->name }}
                                    </span>
                                @endforeach
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Check-in Form -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-success">Form Check-in</h6>
        </div>
        <div class="card-body">
            <form action="{{ route('checkins.store') }}" method="POST">
                @csrf
                <input type="hidden" name="booking_id" value="{{ $booking->id }}">
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="check_in_time">Waktu Check-in <span class="text-danger">*</span></label>
                            <input type="datetime-local" 
                                   class="form-control @error('check_in_time') is-invalid @enderror" 
                                   id="check_in_time" 
                                   name="check_in_time" 
                                   value="{{ old('check_in_time', now()->format('Y-m-d\TH:i')) }}" 
                                   required>
                            @error('check_in_time')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="notes">Catatan</label>
                            <textarea class="form-control @error('notes') is-invalid @enderror" 
                                      id="notes" 
                                      name="notes" 
                                      rows="3" 
                                      placeholder="">{{ old('notes') }}</textarea>
                            @error('notes')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-sign-in-alt"></i> Lakukan Check-in
                    </button>
                    <a href="{{ route('bookings.index') }}" class="btn btn-secondary">
                        <i class="fas fa-times"></i> Batal
                    </a>
                </div>
            </form>
        </div>
    </div>
    @else
    <!-- No Booking Selected -->
    <div class="card shadow mb-4">
        <div class="card-body text-center py-5">
            <i class="fas fa-exclamation-triangle fa-3x text-warning mb-3"></i>
            <h5>Booking tidak ditemukan</h5>
            <p class="text-muted">Silakan pilih booking yang valid untuk melakukan check-in</p>
            <a href="{{ route('bookings.index') }}" class="btn btn-primary">
                <i class="fas fa-list"></i> Lihat Daftar Booking
            </a>
        </div>
    </div>
    @endif
</div>
@endsection