@extends('admin-layouts.master')

@section('title', 'Daftar Log Aktivitas')

@section('content')
<div class="row">
    <div class="col-12">
        <!-- Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h2 class="h4 mb-1">Log Aktivitas Sistem</h2>
                <p class="text-muted mb-0">Monitoring dan tracking seluruh aktivitas WebGIS BIDUK</p>
            </div>
            <button type="button" class="btn btn-success" id="export-btn">
                <i class="fas fa-download"></i> Export
            </button>
        </div>

        <!-- Stats Cards -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card border-left-primary shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                    Total Aktivitas</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $activities->total() }}</div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-list fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-left-success shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                    Berhasil</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                    {{ $activities->where('status', 'Berhasil')->count() }}
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-left-danger shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                    Gagal</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                    {{ $activities->where('status', 'Gagal')->count() }}
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-times-circle fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-left-warning shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                    Peringatan</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                    {{ $activities->where('status', 'Peringatan')->count() }}
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-exclamation-triangle fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filter & Search -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Filter & Pencarian</h6>
            </div>
            <div class="card-body">
                <form method="GET" action="{{ route('activity-logs.index') }}" class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="user_name">Pencarian User</label>
                            <input type="text" class="form-control form-control-sm" 
                                   id="user_name" name="user_name" 
                                   placeholder="Nama user atau aktivitas"
                                   value="{{ request('user_name') }}">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select class="form-control form-control-sm" id="status" name="status">
                                <option value="">Semua Status</option>
                                <option value="Berhasil" {{ request('status') == 'Berhasil' ? 'selected' : '' }}>Berhasil</option>
                                <option value="Gagal" {{ request('status') == 'Gagal' ? 'selected' : '' }}>Gagal</option>
                                <option value="Peringatan" {{ request('status') == 'Peringatan' ? 'selected' : '' }}>Peringatan</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="module">Module</label>
                            <select class="form-control form-control-sm" id="module" name="module">
                                <option value="">Semua Module</option>
                                <option value="Authentication" {{ request('module') == 'Authentication' ? 'selected' : '' }}>Authentication</option>
                                <option value="SKPT" {{ request('module') == 'SKPT' ? 'selected' : '' }}>SKPT</option>
                                <option value="Approval" {{ request('module') == 'Approval' ? 'selected' : '' }}>Approval</option>
                                <option value="User Management" {{ request('module') == 'User Management' ? 'selected' : '' }}>User Management</option>
                                <option value="Master Data" {{ request('module') == 'Master Data' ? 'selected' : '' }}>Master Data</option>
                                <option value="SP-MPT" {{ request('module') == 'SP-MPT' ? 'selected' : '' }}>SP-MPT</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="date_from">Dari Tanggal</label>
                            <input type="date" class="form-control form-control-sm" 
                                   id="date_from" name="date_from" 
                                   value="{{ request('date_from') }}">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="date_to">Sampai Tanggal</label>
                            <input type="date" class="form-control form-control-sm" 
                                   id="date_to" name="date_to" 
                                   value="{{ request('date_to') }}">
                        </div>
                    </div>
                    <div class="col-md-1">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div>
                                <button type="submit" class="btn btn-primary btn-sm">
                                    <i class="fas fa-search"></i>
                                </button>
                                <a href="{{ route('activity-logs.index') }}" class="btn btn-secondary btn-sm ml-1">
                                    <i class="fas fa-times"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Success/Error Messages -->
        @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle mr-2"></i>
            {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert">
                <span>&times;</span>
            </button>
        </div>
        @endif

        @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle mr-2"></i>
            {{ session('error') }}
            <button type="button" class="close" data-dismiss="alert">
                <span>&times;</span>
            </button>
        </div>
        @endif

        <!-- Data Table -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Log Aktivitas</h6>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th width="15%">Waktu</th>
                                <th width="15%">User</th>
                                <th width="20%">Aktivitas</th>
                                <th width="25%">Deskripsi</th>
                                <th width="10%">Module</th>
                                <th width="10%">Status</th>
                                <th width="5%">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($activities as $activity)
                            <tr>
                                <td>
                                    <div class="font-weight-bold">{{ $activity->waktu->format('d/m/Y') }}</div>
                                    <small class="text-muted">{{ $activity->waktu->format('H:i:s') }}</small>
                                </td>
                                <td>
                                    <div class="font-weight-bold">{{ $activity->user_name }}</div>
                                    <small class="text-muted">{{ $activity->user_role ?? 'User' }}</small>
                                </td>
                                <td>
                                    <div class="font-weight-bold text-dark">{{ $activity->aktivitas }}</div>
                                </td>
                                <td>
                                    <div class="text-dark">{{ Str::limit($activity->deskripsi, 50) }}</div>
                                    <small class="text-muted">IP: {{ $activity->ip_address }}</small>
                                </td>
                                <td>
                                    <span class="badge badge-info text-white">{{ $activity->module }}</span>
                                </td>
                                <td>
                                    @if($activity->status == 'Berhasil')
                                        <span class="badge badge-success">
                                            <i class="fas fa-check"></i> Berhasil
                                        </span>
                                    @elseif($activity->status == 'Gagal')
                                        <span class="badge badge-danger">
                                            <i class="fas fa-times"></i> Gagal
                                        </span>
                                    @else
                                        <span class="badge badge-warning">
                                            <i class="fas fa-exclamation-triangle"></i> Peringatan
                                        </span>
                                    @endif
                                </td>
                                <td>
                                    <button type="button" 
                                            class="btn btn-sm btn-outline-primary detail-btn" 
                                            data-toggle="tooltip" title="Lihat Detail"
                                            data-id="{{ $activity->id }}">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="7" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-inbox fa-3x mb-3"></i>
                                        <h5>Tidak ada data</h5>
                                        <p>Belum ada aktivitas yang tercatat untuk filter yang dipilih</p>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                @if($activities->hasPages())
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="showing-info">
                        <small class="text-muted">
                            Menampilkan {{ $activities->firstItem() }} - {{ $activities->lastItem() }} 
                            dari {{ $activities->total() }} data
                        </small>
                    </div>
                    {{ $activities->appends(request()->query())->links() }}
                </div>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Detail Modal -->
<div class="modal fade" id="detailModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Detail Aktivitas</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" id="detail-content">
                <div class="text-center py-4">
                    <div class="spinner-border text-primary" role="status">
                        <span class="sr-only">Loading...</span>
                    </div>
                    <p class="mt-2 text-muted">Memuat detail aktivitas...</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
// Initialize tooltips
$(function () {
    $('[data-toggle="tooltip"]').tooltip();
});

// Export functionality
$('#export-btn').on('click', function() {
    const form = $('form');
    const formData = new FormData(form[0]);
    const params = new URLSearchParams(formData);
    window.location.href = `{{ route('activity-logs.export') }}?${params.toString()}`;
});

// Detail modal
$('.detail-btn').on('click', function() {
    const activityId = $(this).data('id');
    
    $('#detailModal').modal('show');
    
    $.ajax({
        url: `/activity-logs/${activityId}`,
        method: 'GET',
        success: function(response) {
            if (response.success) {
                const activity = response.data;
                $('#detail-content').html(`
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="font-weight-bold">Waktu</label>
                                <div>${new Date(activity.waktu).toLocaleString('id-ID')}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="font-weight-bold">Status</label>
                                <div>
                                    <span class="badge badge-${activity.status === 'Berhasil' ? 'success' : activity.status === 'Gagal' ? 'danger' : 'warning'}">
                                        ${activity.status}
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="font-weight-bold">User</label>
                                <div>${activity.user_name} (${activity.user_role || 'User'})</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="font-weight-bold">Module</label>
                                <div><span class="badge badge-info text-white">${activity.module}</span></div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label class="font-weight-bold">Aktivitas</label>
                                <div>${activity.aktivitas}</div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label class="font-weight-bold">Deskripsi</label>
                                <div>${activity.deskripsi}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="font-weight-bold">IP Address</label>
                                <div>${activity.ip_address}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="font-weight-bold">Device</label>
                                <div>${activity.device || 'Unknown'}</div>
                            </div>
                        </div>
                        ${activity.additional_data ? `
                        <div class="col-12">
                            <div class="form-group">
                                <label class="font-weight-bold">Data Tambahan</label>
                                <pre class="bg-light p-3 rounded">${JSON.stringify(activity.additional_data, null, 2)}</pre>
                            </div>
                        </div>
                        ` : ''}
                    </div>
                `);
            }
        },
        error: function() {
            $('#detail-content').html(`
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-triangle"></i>
                    Terjadi kesalahan saat memuat detail aktivitas.
                </div>
            `);
        }
    });
});

// Auto-hide alerts
setTimeout(function() {
    $('.alert').each(function() {
        $(this).alert('close');
    });
}, 5000);

// Success/Error Messages with SweetAlert
@if(session('success'))
    $(document).ready(function() {
        Swal.fire({
            icon: 'success',
            title: 'Sukses!',
            text: '{{ session('success') }}',
            confirmButtonText: 'OK',
            confirmButtonColor: '#1cc88a',
        });
    });
@endif

@if(session('error'))
    $(document).ready(function() {
        Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: '{{ session('error') }}',
            confirmButtonText: 'OK',
            confirmButtonColor: '#e74a3b',
        });
    });
@endif
</script>
@endpush

@push('styles')
<style>
.border-left-primary {
    border-left: 0.25rem solid #4e73df !important;
}
.border-left-success {
    border-left: 0.25rem solid #1cc88a !important;
}
.border-left-danger {
    border-left: 0.25rem solid #e74a3b !important;
}
.border-left-warning {
    border-left: 0.25rem solid #f6c23e !important;
}

.table-hover tbody tr:hover {
    background-color: rgba(0,0,0,.02);
}

.btn-group .btn {
    margin: 0 1px;
}

.card {
    box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15) !important;
}

.text-gray-800 {
    color: #5a5c69 !important;
}

.text-gray-300 {
    color: #dddfeb !important;
}

.badge {
    font-size: 0.75rem;
}

.modal-content {
    border-radius: 10px;
}

.badge-info {
    background-color: #36b9cc;
}

pre {
    font-size: 0.8rem;
    max-height: 200px;
    overflow-y: auto;
}
</style>
@endpush