<script>
    $(document).ready(function() {
        // Navigation dropdown functionality
        $('.nav-item.dropdown').on('show.bs.dropdown', function() {
            $(this).find('.fa-chevron-down').addClass('rotate');
        });
        
        $('.nav-item.dropdown').on('hide.bs.dropdown', function() {
            $(this).find('.fa-chevron-down').removeClass('rotate');
        });
        
        // Mobile menu toggle functionality
        $('.mobile-menu-toggle').on('click', function() {
            var isExpanded = $(this).attr('aria-expanded') === 'true';
            $(this).attr('aria-expanded', !isExpanded);
        });
        
        // Mobile submenu toggle functionality
        $('.mobile-nav-header[data-toggle="collapse"]').on('click', function() {
            var target = $(this).data('target');
            var isExpanded = $(this).attr('aria-expanded') === 'true';
            
            // Close other open submenus
            $('.mobile-submenu.show').not(target).removeClass('show');
            $('.mobile-nav-header[aria-expanded="true"]').not(this).attr('aria-expanded', 'false');
            
            // Toggle current submenu
            $(this).attr('aria-expanded', !isExpanded);
        });
        
        // Handle mobile submenu collapse events
        $('.mobile-submenu').on('show.bs.collapse', function() {
            var header = $('[data-target="#' + this.id + '"]');
            header.attr('aria-expanded', 'true');
        });
        
        $('.mobile-submenu').on('hide.bs.collapse', function() {
            var header = $('[data-target="#' + this.id + '"]');
            header.attr('aria-expanded', 'false');
        });
        
        // Close mobile menu when clicking on a link
        $('.mobile-nav-item').on('click', function() {
            $('#mobileNav').collapse('hide');
            $('.mobile-menu-toggle').attr('aria-expanded', 'false');
        });
        
        // Global AJAX setup
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        
        // Table row hover effects
        $('.table tbody tr').hover(
            function() {
                $(this).find('.action-buttons').addClass('show');
            },
            function() {
                $(this).find('.action-buttons').removeClass('show');
            }
        );
        $(document).ready(function() {
            $('.select2').select2();
        });
        // Auto-hide alerts
        setTimeout(function() {
            $('.alert').fadeOut();
        }, 5000);
    });
    
    // Global notification system
    function showNotification(message, type = 'info') {
        var alertClass = 'alert-' + type;
        var iconClass = getIconClass(type);
        
        var notification = $(`
            <div class="alert ${alertClass} alert-dismissible fade show" role="alert" style="position: fixed; top: 20px; right: 20px; z-index: 9999; min-width: 300px;">
                <i class="${iconClass} me-2"></i>
                ${message}
                <button type="button" class="close" data-dismiss="alert">
                    <span>&times;</span>
                </button>
            </div>
        `);
        
        $('body').append(notification);
        
        setTimeout(function() {
            notification.fadeOut(function() {
                $(this).remove();
            });
        }, 3000);
    }
    
    function getIconClass(type) {
        switch(type) {
            case 'success': return 'fas fa-check-circle';
            case 'danger': return 'fas fa-exclamation-circle';
            case 'warning': return 'fas fa-exclamation-triangle';
            case 'info': 
            default: return 'fas fa-info-circle';
        }
    }
    
    // Global loading state for buttons
    function setButtonLoading(button, loading = true) {
        var $btn = $(button);
        if (loading) {
            $btn.data('original-text', $btn.html());
            $btn.addClass('btn-loading').prop('disabled', true);
        } else {
            $btn.removeClass('btn-loading').prop('disabled', false);
            if ($btn.data('original-text')) {
                $btn.html($btn.data('original-text'));
            }
        }
    }
    
    // Global confirmation dialog
    function confirmAction(message, callback) {
        if (confirm(message)) {
            callback();
        }
    }
    
    // Mobile menu toggle
    function toggleMobileMenu() {
        $('#mobileNav').collapse('toggle');
    }
    
    // Format number with thousand separator
    function formatNumber(num) {
        return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
    }
    
    // Format date to Indonesian format
    function formatDate(dateString) {
        const date = new Date(dateString);
        const options = { 
            year: 'numeric', 
            month: '2-digit', 
            day: '2-digit' 
        };
        return date.toLocaleDateString('id-ID', options);
    }
    
    // Debounce function for search inputs
    function debounce(func, wait, immediate) {
        var timeout;
        return function() {
            var context = this, args = arguments;
            var later = function() {
                timeout = null;
                if (!immediate) func.apply(context, args);
            };
            var callNow = immediate && !timeout;
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
            if (callNow) func.apply(context, args);
        };
    }
    
    // Initialize tooltips if Bootstrap tooltips are available
    if (typeof $().tooltip === 'function') {
        $('[data-toggle="tooltip"]').tooltip();
    }
    
    // Initialize popovers if Bootstrap popovers are available
    if (typeof $().popover === 'function') {
        $('[data-toggle="popover"]').popover();
    }
    
    // Handle responsive table scroll
    $('.table-responsive').on('scroll', function() {
        var scrollLeft = $(this).scrollLeft();
        if (scrollLeft > 0) {
            $(this).addClass('scrolled');
        } else {
            $(this).removeClass('scrolled');
        }
    });
    
    // Back to top button functionality
    function addBackToTopButton() {
        if ($('#backToTop').length === 0) {
            $('body').append('<button id="backToTop" class="btn btn-primary" style="position: fixed; bottom: 20px; right: 20px; z-index: 999; display: none; border-radius: 50%; width: 50px; height: 50px;"><i class="fas fa-chevron-up"></i></button>');
        }
        
        $(window).scroll(function() {
            if ($(this).scrollTop() > 100) {
                $('#backToTop').fadeIn();
            } else {
                $('#backToTop').fadeOut();
            }
        });
        
        $('#backToTop').click(function() {
            $('html, body').animate({scrollTop: 0}, 800);
            return false;
        });
    }
    
    // Initialize back to top button
    addBackToTopButton();
</script><script>
    $(document).ready(function() {
        // Navigation dropdown functionality
        $('.nav-item.dropdown').on('show.bs.dropdown', function() {
            $(this).find('.fa-chevron-down').addClass('rotate');
        });
        
        $('.nav-item.dropdown').on('hide.bs.dropdown', function() {
            $(this).find('.fa-chevron-down').removeClass('rotate');
        });
        
        // Global AJAX setup
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        
        // Table row hover effects
        $('.table tbody tr').hover(
            function() {
                $(this).find('.action-buttons').addClass('show');
            },
            function() {
                $(this).find('.action-buttons').removeClass('show');
            }
        );
        
        // Auto-hide alerts
        setTimeout(function() {
            $('.alert').fadeOut();
        }, 5000);
    });
    
    // Global notification system
    function showNotification(message, type = 'info') {
        var alertClass = 'alert-' + type;
        var iconClass = getIconClass(type);
        
        var notification = $(`
            <div class="alert ${alertClass} alert-dismissible fade show" role="alert" style="position: fixed; top: 20px; right: 20px; z-index: 9999; min-width: 300px;">
                <i class="${iconClass} me-2"></i>
                ${message}
                <button type="button" class="close" data-dismiss="alert">
                    <span>&times;</span>
                </button>
            </div>
        `);
        
        $('body').append(notification);
        
        setTimeout(function() {
            notification.fadeOut(function() {
                $(this).remove();
            });
        }, 3000);
    }
    
    function getIconClass(type) {
        switch(type) {
            case 'success': return 'fas fa-check-circle';
            case 'danger': return 'fas fa-exclamation-circle';
            case 'warning': return 'fas fa-exclamation-triangle';
            case 'info': 
            default: return 'fas fa-info-circle';
        }
    }
    
    // Global loading state for buttons
    function setButtonLoading(button, loading = true) {
        var $btn = $(button);
        if (loading) {
            $btn.data('original-text', $btn.html());
            $btn.addClass('btn-loading').prop('disabled', true);
        } else {
            $btn.removeClass('btn-loading').prop('disabled', false);
            if ($btn.data('original-text')) {
                $btn.html($btn.data('original-text'));
            }
        }
    }
    
    // Global confirmation dialog
    function confirmAction(message, callback) {
        if (confirm(message)) {
            callback();
        }
    }
    
    // Mobile menu toggle
    function toggleMobileMenu() {
        $('#mobileNav').collapse('toggle');
    }
    
    // Format number with thousand separator
    function formatNumber(num) {
        return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
    }
    
    // Format date to Indonesian format
    function formatDate(dateString) {
        const date = new Date(dateString);
        const options = { 
            year: 'numeric', 
            month: '2-digit', 
            day: '2-digit' 
        };
        return date.toLocaleDateString('id-ID', options);
    }
    
    // Debounce function for search inputs
    function debounce(func, wait, immediate) {
        var timeout;
        return function() {
            var context = this, args = arguments;
            var later = function() {
                timeout = null;
                if (!immediate) func.apply(context, args);
            };
            var callNow = immediate && !timeout;
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
            if (callNow) func.apply(context, args);
        };
    }
</script>