<nav class="top-navbar">
    <div class="container-fluid">
        <div class="d-flex justify-content-between align-items-center">
            <!-- Brand -->
            <a href="{{ route('home') }}" class="navbar-brand">
                <div class="brand-logo">
                    <i class="fas fa-building"></i>
                </div>
                <span class="brand-text">Kecamatan Biduk-Biduk</span>
            </a>

            <!-- Desktop Navigation Menu -->
            <div class="nav-menu d-lg-flex">
                <!-- MAP Menu -->
                <div class="nav-item dropdown">
                    <a href="#" class="nav-link dropdown-toggle {{ request()->routeIs('home') ? 'active' : '' }}" id="mapDropdown" role="button"
                       data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        MAP <i class="fas fa-chevron-down"></i>
                    </a>
                    <div class="dropdown-menu" aria-labelledby="mapDropdown">
                        <a href="{{ route('home') }}" class="dropdown-item {{ request()->routeIs('home') ? 'active' : '' }}">
                            <i class="fas fa-map"></i>
                            Peta Wilayah
                        </a>
                    </div>
                </div>

                <!-- SKPT Menu -->
                @canany(['skpt.view', 'skpt.create', 'penerbitan-skpt.view'])
                <div class="nav-item dropdown">
                    <a href="#" class="nav-link dropdown-toggle {{ request()->routeIs('skpt.*') || request()->routeIs('penerbitan-skpt.*') ? 'active' : '' }}" id="skptDropdown" role="button"
                       data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        SKPT <i class="fas fa-chevron-down"></i>
                    </a>
                    <div class="dropdown-menu" aria-labelledby="skptDropdown">
                        @can('skpt.view')
                        <a href="{{ route('skpt.index') }}" class="dropdown-item {{ request()->routeIs('skpt.index') || request()->routeIs('skpt.show') || request()->routeIs('skpt.edit') ? 'active' : '' }}">
                            <i class="fas fa-list"></i>
                            Daftar Permohonan SKPT
                        </a>
                        @endcan

                        @can('skpt.create')
                        <a href="{{ route('skpt.create') }}" class="dropdown-item {{ request()->routeIs('skpt.create') ? 'active' : '' }}">
                            <i class="fas fa-plus-circle"></i>
                            SKPT Baru
                        </a>
                        @endcan

                        @can('penerbitan-skpt.view')
                        <div class="dropdown-divider"></div>
                        <a href="{{ route('penerbitan-skpt.index') }}" class="dropdown-item {{ request()->routeIs('penerbitan-skpt.*') ? 'active' : '' }}">
                            <i class="fas fa-check-circle"></i>
                            Penerbitan SKPT
                        </a>
                        @endcan
                    </div>
                </div>
                @endcanany

                <!-- PENINJAUAN Menu -->
                @can('peninjauan.view')
                <div class="nav-item">
                    <a href="{{ route('peninjauan.index') }}" class="nav-link {{ request()->routeIs('peninjauan.*') ? 'active' : '' }}">
                        PENINJAUAN
                    </a>
                </div>
                @endcan

                <!-- SP-SIPT Menu -->
                @canany(['sp-sipt.view', 'sp-sipt.create', 'penerbitan-spmpt.view'])
                <div class="nav-item dropdown">
                    <a href="#" class="nav-link dropdown-toggle {{ request()->routeIs('sp-sipt.*') || request()->routeIs('penerbitan-spmpt.*') ? 'active' : '' }}" id="spmptDropdown" role="button"
                       data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        SP-MPT <i class="fas fa-chevron-down"></i>
                    </a>
                    <div class="dropdown-menu" aria-labelledby="spmptDropdown">
                        @can('sp-sipt.view')
                        <a href="{{ route('sp-sipt.index') }}" class="dropdown-item {{ request()->routeIs('sp-sipt.index') || request()->routeIs('sp-sipt.show') || request()->routeIs('sp-sipt.edit') ? 'active' : '' }}">
                            <i class="fas fa-list"></i>
                            Daftar SP-MPT
                        </a>
                        @endcan


                        @can('penerbitan-spmpt.view')
                        <div class="dropdown-divider"></div>
                        <a href="{{ route('penerbitan-spmpt.index') }}" class="dropdown-item {{ request()->routeIs('penerbitan-spmpt.*') ? 'active' : '' }}">
                            <i class="fas fa-check-circle"></i>
                            Penerbitan SP-MPT
                        </a>
                        @endcan
                    </div>
                </div>
                @endcanany

                <!-- MASTER Menu -->
                @canany(['user.view', 'kecamatan.view', 'kampung.view', 'rtrw.view', 'activity-log.view', 'role.view'])
                <div class="nav-item dropdown">
                    <a href="#" class="nav-link dropdown-toggle {{ request()->routeIs('users.*') || request()->routeIs('kecamatan.*') || request()->routeIs('kampung.*') || request()->routeIs('rtrw.*') || request()->routeIs('activity-logs.*') || request()->routeIs('roles.*') ? 'active' : '' }}" id="masterDropdown" role="button"
                       data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        MASTER <i class="fas fa-chevron-down"></i>
                    </a>
                    <div class="dropdown-menu" aria-labelledby="masterDropdown">
                        @can('user.view')
                        <h6 class="dropdown-header">User Management</h6>
                        <a href="{{ route('users.index') }}" class="dropdown-item {{ request()->routeIs('users.*') ? 'active' : '' }}">
                            <i class="fas fa-users"></i>
                            Data Pengguna
                        </a>
                        @endcan

                        @canany(['kecamatan.view', 'kampung.view', 'rtrw.view'])
                        <div class="dropdown-divider"></div>
                        <h6 class="dropdown-header">Master Data</h6>
                        @endcanany

                        @can('kecamatan.view')
                        <a href="{{ route('kecamatan.index') }}" class="dropdown-item {{ request()->routeIs('kecamatan.*') ? 'active' : '' }}">
                            <i class="fas fa-map-marked-alt"></i>
                            Data Kecamatan
                        </a>
                        @endcan

                        @can('kampung.view')
                        <a href="{{ route('kampung.index') }}" class="dropdown-item {{ request()->routeIs('kampung.*') ? 'active' : '' }}">
                            <i class="fas fa-home"></i>
                            Data Kampung
                        </a>
                        @endcan

                        @can('rtrw.view')
                        <a href="{{ route('rtrw.index') }}" class="dropdown-item {{ request()->routeIs('rtrw.*') ? 'active' : '' }}">
                            <i class="fas fa-layer-group"></i>
                            Data RTRW
                        </a>
                        @endcan

                        @can('activity-log.view')
                        <div class="dropdown-divider"></div>
                        <h6 class="dropdown-header">System</h6>
                        <a href="{{ route('activity-logs.index') }}" class="dropdown-item {{ request()->routeIs('activity-logs.*') ? 'active' : '' }}">
                            <i class="fas fa-history"></i>
                            Activity Logs
                        </a>
                        @endcan

                        @can('role.view')
                        <div class="dropdown-divider"></div>
                        <a href="{{ route('roles.index') }}" class="dropdown-item {{ request()->routeIs('roles.*') ? 'active' : '' }}">
                            <i class="fas fa-user-shield"></i>
                            Role & Permission
                        </a>
                        @endcan
                    </div>
                </div>
                @endcanany
                <div class="nav-item">

                    <a href="{{ route('logout') }}"
                           class="btn btn-outline-danger btn-sm"
                           onclick="event.preventDefault(); document.getElementById('logout-form-desktop').submit();"
                           data-toggle="tooltip"
                           title="Keluar dari sistem">
                            <i class="fas fa-sign-out-alt mr-1"></i>
                            Logout
                        </a>
                        <form id="logout-form-desktop" action="{{ route('logout') }}" method="POST" class="d-none">
                            @csrf
                        </form>
                </div>
            </div>

            <!-- Right Side: User Menu & Logout -->
            <div class="d-flex align-items-center gap-2">
                <!-- Logout Button (Desktop - visible on large screens) -->
                <div class="d-none d-xl-block">
                    <a href="{{ route('logout') }}"
                       class="btn btn-outline-danger btn-sm"
                       onclick="event.preventDefault(); document.getElementById('logout-form-desktop').submit();"
                       data-toggle="tooltip"
                       title="Keluar dari sistem">
                        <i class="fas fa-sign-out-alt mr-1"></i>
                        <span class="d-none d-xxl-inline">Keluar</span>
                    </a>
                    <form id="logout-form-desktop" action="{{ route('logout') }}" method="POST" class="d-none">
                        @csrf
                    </form>
                </div>

                <!-- User Menu with Profile Photo -->
                <div class="dropdown d-none d-md-block">
                    <button class="user-menu-btn dropdown-toggle" type="button" id="userDropdown"
                            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <div class="user-profile-wrapper">
                            <div class="user-avatar">
                                @if(Auth::user()->profile_photo && Storage::disk('public')->exists(Auth::user()->profile_photo))
                                    <img src="{{ asset('storage/' . Auth::user()->profile_photo) }}" alt="{{ Auth::user()->name }}">
                                @else
                                    <img src="https://ui-avatars.com/api/?name={{ urlencode(Auth::user()->name) }}&background=0D8ABC&color=fff" alt="{{ Auth::user()->name }}">
                                @endif
                            </div>
                            <div class="user-info d-none d-lg-block">
                                <span class="user-name">{{ Auth::user()->name }}</span>
                                <span class="user-role">
                                    @if(Auth::user()->primaryRole)
                                        {{ Auth::user()->primaryRole->name }}
                                    @elseif(Auth::user()->roles->isNotEmpty())
                                        {{ Auth::user()->roles->first()->name }}
                                    @else
                                        User
                                    @endif
                                </span>
                            </div>
                            <i class="fas fa-chevron-down ms-2"></i>
                        </div>
                    </button>
                    <div class="dropdown-menu dropdown-menu-right user-dropdown" aria-labelledby="userDropdown">
                        <div class="dropdown-header">
                            <div class="user-avatar-large">
                                @if(Auth::user()->profile_photo && Storage::disk('public')->exists(Auth::user()->profile_photo))
                                    <img src="{{ asset('storage/' . Auth::user()->profile_photo) }}" alt="{{ Auth::user()->name }}">
                                @else
                                    <img src="https://ui-avatars.com/api/?name={{ urlencode(Auth::user()->name) }}&background=0D8ABC&color=fff&size=128" alt="{{ Auth::user()->name }}">
                                @endif
                            </div>
                            <div class="user-details">
                                <strong>{{ Auth::user()->name }}</strong>
                                <small>{{ Auth::user()->email }}</small>
                                <span class="badge badge-primary mt-1">
                                    @if(Auth::user()->primaryRole)
                                        {{ Auth::user()->primaryRole->name }}
                                    @elseif(Auth::user()->roles->isNotEmpty())
                                        {{ Auth::user()->roles->first()->name }}
                                    @else
                                        User
                                    @endif
                                </span>
                            </div>
                        </div>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item" href="{{ route('user.profile', Auth::id()) }}">
                            <i class="fas fa-user"></i> Profile Saya
                        </a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item logout-btn" href="{{ route('logout') }}"
                           onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                            <i class="fas fa-sign-out-alt"></i> Keluar
                        </a>
                        <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                            @csrf
                        </form>
                    </div>
                </div>

                <!-- Mobile Menu Toggle -->
                <button class="mobile-menu-toggle d-lg-none btn btn-secondary" type="button"
                        data-toggle="collapse" data-target="#mobileNav" aria-controls="mobileNav"
                        aria-expanded="false" aria-label="Toggle navigation">
                    <span class="hamburger-line"></span>
                    <span class="hamburger-line"></span>
                    <span class="hamburger-line"></span>
                </button>
            </div>
        </div>

        <!-- Mobile Navigation -->
        <div class="collapse navbar-collapse" id="mobileNav">
            <div class="mobile-nav-menu">
                <!-- MAP Section -->
                <div class="mobile-nav-section">
                    <div class="mobile-nav-header" data-toggle="collapse" data-target="#mobileMapMenu"
                         aria-expanded="false" aria-controls="mobileMapMenu">
                        <i class="fas fa-map"></i>
                        <span>MAP</span>
                        <i class="fas fa-chevron-down mobile-chevron"></i>
                    </div>
                    <div class="collapse mobile-submenu" id="mobileMapMenu">
                        <a href="{{ route('home') }}" class="mobile-nav-item {{ request()->routeIs('home') ? 'active' : '' }}">
                            <i class="fas fa-map"></i>
                            Peta Wilayah
                        </a>
                    </div>
                </div>

                <!-- SKPT Section -->
                @canany(['skpt.view', 'skpt.create', 'penerbitan-skpt.view'])
                <div class="mobile-nav-section">
                    <div class="mobile-nav-header" data-toggle="collapse" data-target="#mobileSkptMenu"
                         aria-expanded="false" aria-controls="mobileSkptMenu">
                        <i class="fas fa-file-contract"></i>
                        <span>SKPT</span>
                        <i class="fas fa-chevron-down mobile-chevron"></i>
                    </div>
                    <div class="collapse mobile-submenu" id="mobileSkptMenu">
                        @can('skpt.view')
                        <a href="{{ route('skpt.index') }}" class="mobile-nav-item {{ request()->routeIs('skpt.index') || request()->routeIs('skpt.show') || request()->routeIs('skpt.edit') ? 'active' : '' }}">
                            <i class="fas fa-list"></i>
                            Daftar Permohonan SKPT
                        </a>
                        @endcan

                        @can('skpt.create')
                        <a href="{{ route('skpt.create') }}" class="mobile-nav-item {{ request()->routeIs('skpt.create') ? 'active' : '' }}">
                            <i class="fas fa-plus-circle"></i>
                            SKPT Baru
                        </a>
                        @endcan

                        @can('penerbitan-skpt.view')
                        <a href="{{ route('penerbitan-skpt.index') }}" class="mobile-nav-item {{ request()->routeIs('penerbitan-skpt.*') ? 'active' : '' }}">
                            <i class="fas fa-check-circle"></i>
                            Penerbitan SKPT
                        </a>
                        @endcan
                    </div>
                </div>
                @endcanany

                <!-- PENINJAUAN Section -->
                @can('peninjauan.view')
                <div class="mobile-nav-section">
                    <a href="{{ route('peninjauan.index') }}" class="mobile-nav-header single {{ request()->routeIs('peninjauan.*') ? 'active' : '' }}">
                        <i class="fas fa-search"></i>
                        <span>PENINJAUAN</span>
                    </a>
                </div>
                @endcan

                <!-- SP-SIPT Section -->
                @canany(['sp-sipt.view', 'sp-sipt.create', 'penerbitan-spmpt.view'])
                <div class="mobile-nav-section">
                    <div class="mobile-nav-header" data-toggle="collapse" data-target="#mobileSpmptMenu"
                         aria-expanded="false" aria-controls="mobileSpmptMenu">
                        <i class="fas fa-file-alt"></i>
                        <span>SP-SIPT</span>
                        <i class="fas fa-chevron-down mobile-chevron"></i>
                    </div>
                    <div class="collapse mobile-submenu" id="mobileSpmptMenu">
                        @can('sp-sipt.view')
                        <a href="{{ route('sp-sipt.index') }}" class="mobile-nav-item {{ request()->routeIs('sp-sipt.index') || request()->routeIs('sp-sipt.show') || request()->routeIs('sp-sipt.edit') ? 'active' : '' }}">
                            <i class="fas fa-list"></i>
                            Daftar SP-SIPT
                        </a>
                        @endcan

                        @can('sp-sipt.create')
                        <a href="{{ route('sp-sipt.create') }}" class="mobile-nav-item {{ request()->routeIs('sp-sipt.create') ? 'active' : '' }}">
                            <i class="fas fa-plus-circle"></i>
                            SP-SIPT Baru
                        </a>
                        @endcan

                        @can('sp-sipt.view')
                        <a href="{{ route('sp-sipt.dashboard') }}" class="mobile-nav-item {{ request()->routeIs('sp-sipt.dashboard') ? 'active' : '' }}">
                            <i class="fas fa-chart-line"></i>
                            Dashboard
                        </a>
                        @endcan

                        @can('penerbitan-spmpt.view')
                        <a href="{{ route('penerbitan-spmpt.index') }}" class="mobile-nav-item {{ request()->routeIs('penerbitan-spmpt.*') ? 'active' : '' }}">
                            <i class="fas fa-check-circle"></i>
                            Penerbitan SP-MPT
                        </a>
                        @endcan
                    </div>
                </div>
                @endcanany

                <!-- MASTER Section -->
                @canany(['user.view', 'kecamatan.view', 'kampung.view', 'rtrw.view', 'activity-log.view', 'role.view'])
                <div class="mobile-nav-section">
                    <div class="mobile-nav-header" data-toggle="collapse" data-target="#mobileMasterMenu"
                         aria-expanded="false" aria-controls="mobileMasterMenu">
                        <i class="fas fa-cogs"></i>
                        <span>MASTER</span>
                        <i class="fas fa-chevron-down mobile-chevron"></i>
                    </div>
                    <div class="collapse mobile-submenu" id="mobileMasterMenu">
                        @can('user.view')
                        <a href="{{ route('users.index') }}" class="mobile-nav-item {{ request()->routeIs('users.*') ? 'active' : '' }}">
                            <i class="fas fa-users"></i>
                            Data Pengguna
                        </a>
                        @endcan

                        @can('kecamatan.view')
                        <a href="{{ route('kecamatan.index') }}" class="mobile-nav-item {{ request()->routeIs('kecamatan.*') ? 'active' : '' }}">
                            <i class="fas fa-map-marked-alt"></i>
                            Data Kecamatan
                        </a>
                        @endcan

                        @can('kampung.view')
                        <a href="{{ route('kampung.index') }}" class="mobile-nav-item {{ request()->routeIs('kampung.*') ? 'active' : '' }}">
                            <i class="fas fa-home"></i>
                            Data Kampung
                        </a>
                        @endcan

                        @can('rtrw.view')
                        <a href="{{ route('rtrw.index') }}" class="mobile-nav-item {{ request()->routeIs('rtrw.*') ? 'active' : '' }}">
                            <i class="fas fa-layer-group"></i>
                            Data RTRW
                        </a>
                        @endcan

                        @can('activity-log.view')
                        <a href="{{ route('activity-logs.index') }}" class="mobile-nav-item {{ request()->routeIs('activity-logs.*') ? 'active' : '' }}">
                            <i class="fas fa-history"></i>
                            Activity Logs
                        </a>
                        @endcan

                        @can('role.view')
                        <a href="{{ route('roles.index') }}" class="mobile-nav-item {{ request()->routeIs('roles.*') ? 'active' : '' }}">
                            <i class="fas fa-user-shield"></i>
                            Role & Permission
                        </a>
                        @endcan
                    </div>
                </div>
                @endcanany

                <!-- Mobile User Menu -->
                <div class="mobile-user-menu mt-3">
                    <div class="mobile-user-header-profile">
                        <div class="user-avatar-mobile">
                            @if(Auth::user()->profile_photo && Storage::disk('public')->exists(Auth::user()->profile_photo))
                                <img src="{{ asset('storage/' . Auth::user()->profile_photo) }}" alt="{{ Auth::user()->name }}">
                            @else
                                <img src="https://ui-avatars.com/api/?name={{ urlencode(Auth::user()->name) }}&background=0D8ABC&color=fff&size=128" alt="{{ Auth::user()->name }}">
                            @endif
                        </div>
                        <div class="mobile-user-info">
                            <strong>{{ Auth::user()->name }}</strong>
                            <small>{{ Auth::user()->email }}</small>
                            <span class="badge badge-primary badge-sm mt-1">
                                @if(Auth::user()->primaryRole)
                                    {{ Auth::user()->primaryRole->name }}
                                @elseif(Auth::user()->roles->isNotEmpty())
                                    {{ Auth::user()->roles->first()->name }}
                                @else
                                    User
                                @endif
                            </span>
                        </div>
                    </div>
                    <a href="{{ route('user.profile', Auth::id()) }}" class="mobile-nav-item">
                        <i class="fas fa-user"></i>
                        Profile Saya
                    </a>
                    <a href="{{ route('logout') }}" class="mobile-nav-item logout-mobile"
                       onclick="event.preventDefault(); document.getElementById('logout-form-mobile').submit();">
                        <i class="fas fa-sign-out-alt"></i>
                        Keluar
                    </a>
                    <form id="logout-form-mobile" action="{{ route('logout') }}" method="POST" class="d-none">
                        @csrf
                    </form>
                </div>
            </div>
        </div>
    </div>
</nav>

<style>
/* Base Navbar Styles */
.top-navbar {
    background: #ffffff;
    box-shadow: 0 2px 4px rgba(0,0,0,0.08);
    padding: 0.5rem 0;
    position: sticky;
    top: 0;
    z-index: 1000;
}

.navbar-brand {
    display: flex;
    align-items: center;
    text-decoration: none;
    padding: 0.5rem 1rem;
}

.brand-logo {
    width: 40px;
    height: 40px;
    background: linear-gradient(135deg, #0D8ABC 0%, #0a6d94 100%);
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 0.75rem;
    color: white;
    font-size: 1.2rem;
}

.brand-text {
    font-size: 1.1rem;
    font-weight: 600;
    color: #212529;
}

/* Navigation Menu */
.nav-menu {
    display: flex;
    align-items: center;
    gap: 0.25rem;
}

.nav-item {
    position: relative;
}

.nav-link {
    display: flex;
    align-items: center;
    padding: 0.75rem 1rem;
    color: #495057;
    text-decoration: none;
    font-weight: 500;
    font-size: 0.9rem;
    transition: all 0.3s ease;
    border-radius: 6px;
    position: relative;
}

.nav-link:hover {
    background: #f8f9fa;
    color: #0D8ABC;
}

.nav-link.active {
    color: #0D8ABC !important;
    font-weight: 600;
    background: rgba(13, 138, 188, 0.08);
}

.nav-link.active::after {
    content: '';
    position: absolute;
    bottom: 0;
    left: 1rem;
    right: 1rem;
    height: 3px;
    background: #0D8ABC;
    border-radius: 3px 3px 0 0;
}

.nav-link i.fa-chevron-down {
    margin-left: 0.5rem;
    font-size: 0.7rem;
}

/* Dropdown Menu */
.dropdown-menu {
    border: none;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.12);
    border-radius: 8px;
    margin-top: 0.5rem;
    min-width: 240px;
    padding: 0.5rem 0;
}

.dropdown-header {
    padding: 0.5rem 1.25rem;
    font-size: 0.75rem;
    font-weight: 600;
    color: #6c757d;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.dropdown-item {
    padding: 0.75rem 1.25rem;
    transition: all 0.2s ease;
    display: flex;
    align-items: center;
    gap: 0.75rem;
    color: #495057;
    font-size: 0.9rem;
}

.dropdown-item i {
    width: 18px;
    text-align: center;
    font-size: 0.95rem;
}

.dropdown-item:hover {
    background: #f8f9fa;
    color: #0D8ABC;
    padding-left: 1.5rem;
}

.dropdown-item.active {
    background: linear-gradient(90deg, #e3f2fd 0%, #bbdefb 50%, #e3f2fd 100%) !important;
    color: #0D8ABC !important;
    font-weight: 600;
    border-left: 3px solid #0D8ABC;
    padding-left: calc(1.25rem - 3px) !important;
}

.dropdown-item.active:hover {
    padding-left: calc(1.5rem - 3px) !important;
}

.dropdown-divider {
    margin: 0.5rem 0;
}

/* User Menu Button */
.user-menu-btn {
    background: transparent;
    border: none;
    padding: 0.5rem 1rem;
    cursor: pointer;
    transition: all 0.3s ease;
    border-radius: 50px;
    display: flex;
    align-items: center;
}

.user-menu-btn:hover {
    background: #f8f9fa;
}

.user-profile-wrapper {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.user-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    overflow: hidden;
    border: 2px solid #0D8ABC;
}

.user-avatar img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.user-info {
    display: flex;
    flex-direction: column;
    align-items: flex-start;
}

.user-name {
    font-weight: 600;
    color: #212529;
    font-size: 0.9rem;
    line-height: 1.2;
}

.user-role {
    font-size: 0.75rem;
    color: #6c757d;
    line-height: 1.2;
}

/* User Dropdown */
.user-dropdown {
    min-width: 280px;
    padding: 0;
}

.user-dropdown .dropdown-header {
    padding: 1.5rem;
    background: linear-gradient(135deg, #0D8ABC 0%, #0a6d94 100%);
    color: white;
    display: flex;
    align-items: center;
    gap: 1rem;
    border-radius: 8px 8px 0 0;
}

.user-avatar-large {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    overflow: hidden;
    border: 3px solid rgba(255, 255, 255, 0.3);
}

.user-avatar-large img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.user-details {
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
}

.user-details strong {
    font-size: 1rem;
    font-weight: 600;
}

.user-details small {
    font-size: 0.8rem;
    opacity: 0.9;
}

.logout-btn {
    color: #dc3545 !important;
    font-weight: 500;
}

.logout-btn:hover {
    background: #fff5f5 !important;
    color: #c82333 !important;
}

.logout-btn i {
    color: #dc3545;
}

/* Mobile Menu Toggle */
.mobile-menu-toggle {
    background: transparent;
    border: 1px solid #dee2e6;
    padding: 0.5rem;
    cursor: pointer;
    display: flex;
    flex-direction: column;
    justify-content: space-around;
    width: 2.5rem;
    height: 2.5rem;
    border-radius: 6px;
}

.mobile-menu-toggle:hover {
    background: #f8f9fa;
    border-color: #0D8ABC;
}

.hamburger-line {
    width: 100%;
    height: 2px;
    background: #495057;
    border-radius: 2px;
    transition: all 0.3s ease;
}

.mobile-menu-toggle:hover .hamburger-line {
    background: #0D8ABC;
}

/* Mobile Navigation */
.mobile-nav-menu {
    max-height: 70vh;
    overflow-y: auto;
    padding: 0.5rem 0;
}

.mobile-nav-section {
    border-bottom: 1px solid #e9ecef;
}

.mobile-nav-header {
    display: flex;
    align-items: center;
    padding: 1rem;
    cursor: pointer;
    transition: all 0.2s ease;
    text-decoration: none;
    color: #495057;
    font-weight: 500;
}

.mobile-nav-header:hover {
    background: #f8f9fa;
    color: #0D8ABC;
    text-decoration: none;
}

.mobile-nav-header.single {
    border-bottom: none;
}

.mobile-nav-header.active {
    background: rgba(13, 138, 188, 0.08);
    color: #0D8ABC !important;
    font-weight: 600;
    border-left: 4px solid #0D8ABC;
    padding-left: calc(1rem - 4px);
}

.mobile-nav-header i:first-child {
    width: 20px;
    margin-right: 0.75rem;
}

.mobile-nav-header span {
    flex: 1;
}

.mobile-chevron {
    transition: transform 0.3s ease;
    font-size: 0.8rem;
}

.mobile-nav-header[aria-expanded="true"] .mobile-chevron {
    transform: rotate(180deg);
}

.mobile-submenu {
    background: #f8f9fa;
}

.mobile-nav-item {
    display: flex;
    align-items: center;
    padding: 0.75rem 1rem 0.75rem 3rem;
    color: #6c757d;
    text-decoration: none;
    transition: all 0.2s ease;
    font-size: 0.9rem;
}

.mobile-nav-item:hover {
    background: #e9ecef;
    color: #0D8ABC;
    text-decoration: none;
}

.mobile-nav-item.active {
    background: linear-gradient(90deg, #e3f2fd 0%, #bbdefb 100%);
    color: #0D8ABC !important;
    font-weight: 600;
    border-left: 4px solid #0D8ABC;
    padding-left: calc(3rem - 4px);
}

.mobile-nav-item i {
    width: 20px;
    margin-right: 0.75rem;
}

/* Mobile User Menu */
.mobile-user-menu {
    border-top: 2px solid #0D8ABC;
    background: #f8f9fa;
    margin-top: 0.5rem;
}

.mobile-user-header-profile {
    display: flex;
    align-items: center;
    padding: 1.5rem 1rem;
    background: linear-gradient(135deg, #0D8ABC 0%, #0a6d94 100%);
    color: white;
    gap: 1rem;
}

.user-avatar-mobile {
    width: 56px;
    height: 56px;
    border-radius: 50%;
    overflow: hidden;
    border: 3px solid rgba(255, 255, 255, 0.3);
    flex-shrink: 0;
}

.user-avatar-mobile img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.mobile-user-info {
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
}

.mobile-user-info strong {
    font-size: 1rem;
    font-weight: 600;
}

.mobile-user-info small {
    font-size: 0.8rem;
    opacity: 0.9;
}

.logout-mobile {
    color: #dc3545 !important;
    font-weight: 500;
}

.logout-mobile:hover {
    background: #fff5f5 !important;
    color: #c82333 !important;
}

/* Badge */
.badge {
    font-size: 0.75rem;
    font-weight: 500;
    padding: 0.25rem 0.5rem;
    border-radius: 4px;
}

.badge-sm {
    font-size: 0.7rem;
    padding: 0.2rem 0.5rem;
}

/* Responsive */
@media (max-width: 991.98px) {
    .nav-menu {
        display: none !important;
    }
}

@media (max-width: 767.98px) {
    .user-dropdown {
        display: none !important;
    }
}

@media (max-width: 575.98px) {
    .navbar-brand .brand-text {
        display: none;
    }

    .brand-logo {
        margin-right: 0;
    }
}

/* Scrollbar for mobile menu */
.mobile-nav-menu::-webkit-scrollbar {
    width: 4px;
}

.mobile-nav-menu::-webkit-scrollbar-track {
    background: #f1f1f1;
}

.mobile-nav-menu::-webkit-scrollbar-thumb {
    background: #0D8ABC;
    border-radius: 4px;
}

.mobile-nav-menu::-webkit-scrollbar-thumb:hover {
    background: #0a6d94;
}
</style>

<script>
$(document).ready(function() {
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();

    // Enhanced dropdown functionality
    $('.dropdown-toggle').dropdown();

    // Mobile menu toggle animation
    $('.mobile-menu-toggle').click(function() {
        $(this).toggleClass('active');

        const lines = $(this).find('.hamburger-line');
        if ($(this).hasClass('active')) {
            lines.eq(0).css('transform', 'rotate(45deg) translate(5px, 5px)');
            lines.eq(1).css('opacity', '0');
            lines.eq(2).css('transform', 'rotate(-45deg) translate(7px, -6px)');
        } else {
            lines.css('transform', 'none');
            lines.eq(1).css('opacity', '1');
        }
    });

    // Mobile submenu toggle
    $('.mobile-nav-header[data-toggle="collapse"]').click(function() {
        const target = $($(this).data('target'));
        const chevron = $(this).find('.mobile-chevron');

        if (target.hasClass('show')) {
            target.collapse('hide');
            chevron.removeClass('rotate');
        } else {
            $('.mobile-submenu.show').collapse('hide');
            $('.mobile-chevron').removeClass('rotate');
            target.collapse('show');
            chevron.addClass('rotate');
        }
    });

    // Close mobile menu when clicking outside
    $(document).click(function(e) {
        if (!$(e.target).closest('.top-navbar').length) {
            $('#mobileNav').collapse('hide');
            $('.mobile-menu-toggle').removeClass('active');
            $('.hamburger-line').css('transform', 'none').eq(1).css('opacity', '1');
        }
    });

    // Prevent dropdown from closing when clicking inside
    $('.dropdown-menu').on('click', function(e) {
        e.stopPropagation();
    });

    // Auto-hide mobile menu on nav link click
    $('.mobile-nav-item').on('click', function() {
        if (!$(this).hasClass('logout-mobile')) {
            setTimeout(function() {
                $('#mobileNav').collapse('hide');
                $('.mobile-menu-toggle').removeClass('active');
                $('.hamburger-line').css('transform', 'none').eq(1).css('opacity', '1');
            }, 300);
        }
    });
});
</script>
