<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\SKPTApplication;
use Carbon\Carbon;

class SKPTApplicationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $applications = [
            [
                'no_registrasi' => '001-025-111',
                'nik' => '6403050811227665',
                'tgl_penerimaan' => Carbon::create(2025, 1, 11),
                'tgl_permohonan' => Carbon::create(2025, 1, 11),
                'nama_pemohon' => 'Jaunidin Anwar Raskin',
                'tempat_lahir' => 'Berau',
                'tanggal_lahir' => Carbon::create(1985, 5, 15),
                'no_ktp' => '6403050811227665',
                'email' => 'jaunidin@email.com',
                'telepon' => '081234567890',
                'pekerjaan' => 'Petani',
                'alamat_rt' => '01',
                'alamat_rw' => '008',
                'alamat_kode_pos' => '002',
                'letak_tanah' => 'Jl Biduk Selatan Yunua',
                'tanah_rt' => '01',
                'tanah_rw' => '008',
                'tanah_kode_pos' => '002',
                'dusun' => 'Meranjun',
                'kelurahan_kampung' => 'Biduk-biduk',
                'peruntukan' => 'Perkebunan',
                'luas' => 1000.00,
                'penanda_tanah' => 'Batas Pagar',
                'utara' => 'Tanah Kosong',
                'timur' => 'Sungai',
                'selatan' => 'Jalan Kampung',
                'barat' => 'Tanah Hasan',
                'status_kelengkapan_dokumen' => 'BELUM LENGKAP',
                'status_permohonan' => 'BELUM SELESAI'
            ],
            [
                'no_registrasi' => '002-025-112',
                'nik' => '6403050811227666',
                'tgl_penerimaan' => Carbon::create(2025, 2, 11),
                'tgl_permohonan' => Carbon::create(2025, 2, 11),
                'nama_pemohon' => 'Ahmad Budiman',
                'tempat_lahir' => 'Samarinda',
                'tanggal_lahir' => Carbon::create(1980, 8, 20),
                'no_ktp' => '6403050811227666',
                'email' => 'ahmad.budiman@email.com',
                'telepon' => '081234567891',
                'pekerjaan' => 'Wiraswasta',
                'alamat_rt' => '02',
                'alamat_rw' => '005',
                'alamat_kode_pos' => '001',
                'letak_tanah' => 'Jl Sutoyo S No 15',
                'tanah_rt' => '02',
                'tanah_rw' => '005', 
                'tanah_kode_pos' => '001',
                'dusun' => 'Tengah',
                'kelurahan_kampung' => 'Sutoyo',
                'peruntukan' => 'Perumahan',
                'luas' => 800.00,
                'penanda_tanah' => 'Batas Bangunan',
                'utara' => 'Rumah',
                'timur' => 'Jalan',
                'selatan' => 'Rumah',
                'barat' => 'Kebun',
                'status_kelengkapan_dokumen' => 'LENGKAP',
                'status_permohonan' => 'SELESAI'
            ],
            [
                'no_registrasi' => '003-025-113',
                'nik' => '6403050811227667',
                'tgl_penerimaan' => Carbon::create(2025, 3, 11),
                'tgl_permohonan' => Carbon::create(2025, 3, 11),
                'nama_pemohon' => 'Siti Nurhaliza',
                'tempat_lahir' => 'Berau',
                'tanggal_lahir' => Carbon::create(1990, 12, 5),
                'no_ktp' => '6403050811227667',
                'email' => 'siti.nurhaliza@email.com',
                'telepon' => '081234567892',
                'pekerjaan' => 'Guru',
                'alamat_rt' => '03',
                'alamat_rw' => '007',
                'alamat_kode_pos' => '003',
                'letak_tanah' => 'Jl Pangeran Antasari No 22',
                'tanah_rt' => '03',
                'tanah_rw' => '007',
                'tanah_kode_pos' => '003',
                'dusun' => 'Utara',
                'kelurahan_kampung' => 'Pangeran',
                'peruntukan' => 'Pertanian',
                'luas' => 1500.00,
                'penanda_tanah' => 'Batas Alam',
                'utara' => 'Sungai',
                'timur' => 'Kebun',
                'selatan' => 'Tanah Kosong',
                'barat' => 'Jalan',
                'status_kelengkapan_dokumen' => 'BELUM LENGKAP',
                'status_permohonan' => 'BELUM SELESAI'
            ],
            [
                'no_registrasi' => '004-025-114',
                'nik' => '6403050811227668',
                'tgl_penerimaan' => Carbon::create(2025, 4, 11),
                'tgl_permohonan' => Carbon::create(2025, 4, 11),
                'nama_pemohon' => 'Muhammad Rizki',
                'tempat_lahir' => 'Balikpapan',
                'tanggal_lahir' => Carbon::create(1988, 3, 10),
                'no_ktp' => '6403050811227668',
                'email' => 'muhammad.rizki@email.com',
                'telepon' => '081234567893',
                'pekerjaan' => 'Pegawai Swasta',
                'alamat_rt' => '04',
                'alamat_rw' => '009',
                'alamat_kode_pos' => '004',
                'letak_tanah' => 'Jl Ahmad Yani Km 5',
                'tanah_rt' => '04',
                'tanah_rw' => '009',
                'tanah_kode_pos' => '004',
                'dusun' => 'Selatan',
                'kelurahan_kampung' => 'Ahmad Yani',
                'peruntukan' => 'Industri',
                'luas' => 2000.00,
                'penanda_tanah' => 'Batas Pagar',
                'utara' => 'Jalan',
                'timur' => 'Rumah',
                'selatan' => 'Kebun',
                'barat' => 'Sungai',
                'status_kelengkapan_dokumen' => 'BELUM LENGKAP',
                'status_permohonan' => 'BELUM SELESAI'
            ],
            [
                'no_registrasi' => '005-025-115',
                'nik' => '6403050811227669',
                'tgl_penerimaan' => Carbon::create(2025, 5, 11),
                'tgl_permohonan' => Carbon::create(2025, 5, 11),
                'nama_pemohon' => 'Diana Sari',
                'tempat_lahir' => 'Tenggarong',
                'tanggal_lahir' => Carbon::create(1992, 7, 25),
                'no_ktp' => '6403050811227669',
                'email' => 'diana.sari@email.com',
                'telepon' => '081234567894',
                'pekerjaan' => 'Bidan',
                'alamat_rt' => '05',
                'alamat_rw' => '010',
                'alamat_kode_pos' => '005',
                'letak_tanah' => 'Jl Veteran No 128',
                'tanah_rt' => '05',
                'tanah_rw' => '010',
                'tanah_kode_pos' => '005',
                'dusun' => 'Tengah',
                'kelurahan_kampung' => 'Veteran',
                'peruntukan' => 'Perumahan',
                'luas' => 600.00,
                'penanda_tanah' => 'Batas Bangunan',
                'utara' => 'Rumah',
                'timur' => 'Jalan',
                'selatan' => 'Rumah',
                'barat' => 'Tanah Kosong',
                'status_kelengkapan_dokumen' => 'LENGKAP',
                'status_permohonan' => 'SELESAI'
            ]
        ];

        foreach ($applications as $appData) {
            SKPTApplication::create($appData);
        }

        $this->command->info('SKPT Applications seeded successfully!');
    }
}