<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\SKPTApplication;
use App\Models\SKPTAdditionalDocument;

class SKPTAdditionalDocumentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Data dokumen tambahan untuk beberapa aplikasi
        $additionalDocuments = [
            // Aplikasi ID 1
            [
                'skpt_application_id' => 1,
                'document_name' => 'Kwitansi Pembelian Tanah 2',
                'document_description' => 'Kwitansi pembelian tanah tahap kedua dari pemilik sebelumnya',
                'file_path' => 'skpt_additional_documents/1/kwitansi_pembelian_tanah_2.pdf',
                'original_filename' => 'kwitansi_pembelian_tanah_2.pdf',
                'file_size' => '856432',
                'file_extension' => 'pdf',
                'verification_status' => 'SUDAH',
                'verification_notes' => 'Dokumen lengkap dan sesuai',
                'verified_at' => now(),
                'verified_by' => 1,
            ],
            [
                'skpt_application_id' => 1,
                'document_name' => 'Kwitansi Pembelian Tanah 3',
                'document_description' => 'Kwitansi pembelian tanah tahap ketiga',
                'file_path' => 'skpt_additional_documents/1/kwitansi_pembelian_tanah_3.pdf', 
                'original_filename' => 'kwitansi_pembelian_tanah_3.pdf',
                'file_size' => '924567',
                'file_extension' => 'pdf',
                'verification_status' => 'PENDING',
                'verification_notes' => null,
                'verified_at' => null,
                'verified_by' => null,
            ],
            
            // Aplikasi ID 2
            [
                'skpt_application_id' => 2,
                'document_name' => 'Surat Keterangan Waris Adat',
                'document_description' => 'Surat keterangan pembagian waris menurut adat setempat',
                'file_path' => 'skpt_additional_documents/2/surat_waris_adat.pdf',
                'original_filename' => 'surat_waris_adat.pdf',
                'file_size' => '1234567',
                'file_extension' => 'pdf',
                'verification_status' => 'SUDAH',
                'verification_notes' => 'Dokumen valid dan sesuai dengan ketentuan adat',
                'verified_at' => now()->subDays(2),
                'verified_by' => 1,
            ],
            [
                'skpt_application_id' => 2,
                'document_name' => 'Foto Lokasi Tanah',
                'document_description' => 'Dokumentasi foto lokasi tanah dari berbagai sudut',
                'file_path' => 'skpt_additional_documents/2/foto_lokasi_tanah.jpg',
                'original_filename' => 'foto_lokasi_tanah.jpg',
                'file_size' => '2567890',
                'file_extension' => 'jpg',
                'verification_status' => 'SUDAH',
                'verification_notes' => 'Foto jelas dan menunjukkan kondisi tanah',
                'verified_at' => now()->subDays(1),
                'verified_by' => 1,
            ],
            
            // Aplikasi ID 3
            [
                'skpt_application_id' => 3,
                'document_name' => 'Surat Pernyataan Tidak Sengketa',
                'document_description' => 'Surat pernyataan bahwa tanah tidak dalam kondisi sengketa',
                'file_path' => 'skpt_additional_documents/3/surat_tidak_sengketa.pdf',
                'original_filename' => 'surat_tidak_sengketa.pdf',
                'file_size' => '678901',
                'file_extension' => 'pdf',
                'verification_status' => 'DITOLAK',
                'verification_notes' => 'Format surat tidak sesuai, perlu diperbaiki dengan format yang benar',
                'verified_at' => now()->subDays(3),
                'verified_by' => 1,
            ],
            
            // Aplikasi ID 4
            [
                'skpt_application_id' => 4,
                'document_name' => 'Peta Sketsa Lokasi',
                'document_description' => 'Sketsa peta lokasi tanah dengan batas-batas yang jelas',
                'file_path' => 'skpt_additional_documents/4/peta_sketsa.pdf',
                'original_filename' => 'peta_sketsa.pdf',
                'file_size' => '1456789',
                'file_extension' => 'pdf',
                'verification_status' => 'PENDING',
                'verification_notes' => null,
                'verified_at' => null,
                'verified_by' => null,
            ],
            [
                'skpt_application_id' => 4,
                'document_name' => 'Surat Keterangan Kepala Desa',
                'document_description' => 'Surat keterangan dari kepala desa tentang kepemilikan tanah',
                'file_path' => 'skpt_additional_documents/4/surat_kepala_desa.pdf',
                'original_filename' => 'surat_kepala_desa.pdf',
                'file_size' => '987654',
                'file_extension' => 'pdf',
                'verification_status' => 'SUDAH',
                'verification_notes' => 'Surat valid dan memenuhi syarat',
                'verified_at' => now()->subDays(4),
                'verified_by' => 1,
            ],
            
            // Aplikasi ID 5
            [
                'skpt_application_id' => 5,
                'document_name' => 'Akta Jual Beli Tanah',
                'document_description' => 'Akta jual beli tanah yang telah dinotariskan',
                'file_path' => 'skpt_additional_documents/5/akta_jual_beli.pdf',
                'original_filename' => 'akta_jual_beli.pdf',
                'file_size' => '2345678',
                'file_extension' => 'pdf',
                'verification_status' => 'SUDAH',
                'verification_notes' => 'Akta lengkap dan sah secara hukum',
                'verified_at' => now()->subDays(1),
                'verified_by' => 1,
            ],
        ];

        foreach ($additionalDocuments as $docData) {
            SKPTAdditionalDocument::create($docData);
        }

        $this->command->info('Additional documents seeded successfully!');
    }
}