<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RolePermissionSeeder extends Seeder
{
    public function run()
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Permissions untuk SKPT
        $skptPermissions = [
            'skpt.view',
            'skpt.create',
            'skpt.edit',
            'skpt.delete',
            'skpt.upload-document',
            'skpt.verify-document',
            'skpt.update-status',
            'skpt.preview',
            'skpt.print',
        ];

        // Permissions untuk SP-SIPT
        $spSiptPermissions = [
            'sp-sipt.view',
            'sp-sipt.create',
            'sp-sipt.edit',
            'sp-sipt.delete',
            'sp-sipt.upload-document',
            'sp-sipt.update-status',
            'sp-sipt.preview',
            'sp-sipt.print',
        ];

        // Permissions untuk Peninjauan
        $peninjauanPermissions = [
            'peninjauan.view',
            'peninjauan.create',
            'peninjauan.edit',
            'peninjauan.delete',
            'peninjauan.update-status',
            'peninjauan.preview',
            'peninjauan.print',
        ];

        // Permissions untuk Penerbitan SKPT & SPMPT
        $penerbitanPermissions = [
            'penerbitan-skpt.view',
            'penerbitan-skpt.verify',
            'penerbitan-skpt.finalize',
            'penerbitan-skpt.print',
            'penerbitan-spmpt.view',
            'penerbitan-spmpt.verify',
            'penerbitan-spmpt.finalize',
            'penerbitan-spmpt.print',
        ];

        // Permissions untuk Master Data
        $masterDataPermissions = [
            'kecamatan.view',
            'kecamatan.create',
            'kecamatan.edit',
            'kecamatan.delete',
            'kampung.view',
            'kampung.create',
            'kampung.edit',
            'kampung.delete',
            'rtrw.view',
            'rtrw.create',
            'rtrw.edit',
            'rtrw.delete',
        ];

        // Permissions untuk User Management
        $userPermissions = [
            'user.view',
            'user.create',
            'user.edit',
            'user.delete',
        ];

        // Permissions untuk Activity Log
        $activityPermissions = [
            'activity-log.view',
            'activity-log.export',
            'activity-log.clear',
        ];
        $roleManagementPermissions = [
            'role.view',
            'role.create',
            'role.edit',
            'role.delete',
            'role.assign-permissions',
        ];
        // Gabungkan semua permissions
        $allPermissions = array_merge(
            $skptPermissions,
            $spSiptPermissions,
            $peninjauanPermissions,
            $penerbitanPermissions,
            $masterDataPermissions,
            $userPermissions,
            $activityPermissions,
           $roleManagementPermissions, // Tambahkan ini
            ['clear_cache']
        );

        // Create permissions
        foreach ($allPermissions as $permission) {
            Permission::create(['name' => $permission]);
        }

        // Create roles and assign permissions

        // 1. SUPERADMIN - Full Access
        $superadmin = Role::create(['name' => 'superadmin']);
        $superadmin->givePermissionTo(Permission::all());

        // 2. SUPERVISOR - View, Preview, Update Status
        $supervisor = Role::create(['name' => 'supervisor']);
        $supervisor->givePermissionTo([
            // SKPT
            'skpt.view',
            'skpt.preview',
            'skpt.print',
            'skpt.update-status',
            'skpt.verify-document',

            // SP-SIPT
            'sp-sipt.view',
            'sp-sipt.preview',
            'sp-sipt.print',
            'sp-sipt.update-status',

            // Peninjauan
            'peninjauan.view',
            'peninjauan.preview',
            'peninjauan.print',
            'peninjauan.update-status',

            // Penerbitan
            'penerbitan-skpt.view',
            'penerbitan-skpt.verify',
            'penerbitan-skpt.finalize',
            'penerbitan-skpt.print',
            'penerbitan-spmpt.view',
            'penerbitan-spmpt.verify',
            'penerbitan-spmpt.finalize',
            'penerbitan-spmpt.print',

            // Master Data - View only
            'kecamatan.view',
            'kampung.view',
            'rtrw.view',

            // Activity Log
            'activity-log.view',
        ]);

        // 3. STAFF - View, Create, Upload
        $staff = Role::create(['name' => 'staff']);
        $staff->givePermissionTo([
            // SKPT
            'skpt.view',
            'skpt.create',
            'skpt.edit',
            'skpt.upload-document',
            'skpt.preview',

            // SP-SIPT
            'sp-sipt.view',
            'sp-sipt.create',
            'sp-sipt.edit',
            'sp-sipt.upload-document',
            'sp-sipt.preview',

            // Peninjauan
            'peninjauan.view',
            'peninjauan.create',
            'peninjauan.edit',
            'peninjauan.preview',

            // Master Data - View only
            'kecamatan.view',
            'kampung.view',
            'rtrw.view',
        ]);

        // 4. ADMINISTRATOR - View, Create, Upload
        $administrator = Role::create(['name' => 'administrator']);
        $administrator->givePermissionTo([
            // SKPT
            'skpt.view',
            'skpt.create',
            'skpt.edit',
            'skpt.upload-document',
            'skpt.preview',
            'skpt.print',

            // SP-SIPT
            'sp-sipt.view',
            'sp-sipt.create',
            'sp-sipt.edit',
            'sp-sipt.upload-document',
            'sp-sipt.preview',
            'sp-sipt.print',

            // Peninjauan
            'peninjauan.view',
            'peninjauan.create',
            'peninjauan.edit',
            'peninjauan.preview',
            'peninjauan.print',

            // Penerbitan - View only
            'penerbitan-skpt.view',
            'penerbitan-spmpt.view',

            // Master Data - Full access
            'kecamatan.view',
            'kecamatan.create',
            'kecamatan.edit',
            'kecamatan.delete',
            'kampung.view',
            'kampung.create',
            'kampung.edit',
            'kampung.delete',
            'rtrw.view',
            'rtrw.create',
            'rtrw.edit',
            'rtrw.delete',

            // Activity Log
            'activity-log.view',
            'activity-log.export',
        ]);

        // 5. GUEST - View, Create, Upload
        $guest = Role::create(['name' => 'guest']);
        $guest->givePermissionTo([
            // SKPT
            'skpt.view',
            'skpt.create',
            'skpt.upload-document',

            // SP-SIPT
            'sp-sipt.view',
            'sp-sipt.create',
            'sp-sipt.upload-document',

            // Master Data - View only
            'kecamatan.view',
            'kampung.view',
            'rtrw.view',
        ]);
    }
}
