<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Pengeluaran;
use Carbon\Carbon;

class PengeluaranSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $pengeluarans = [
            [
                'tanggal' => Carbon::now()->subDays(30),
                'deskripsi' => 'Belanja kebutuhan rumah tangga',
                'jumlah_pengeluaran' => 250000
            ],
            [
                'tanggal' => Carbon::now()->subDays(28),
                'deskripsi' => 'Bayar tagihan listrik',
                'jumlah_pengeluaran' => 150000
            ],
            [
                'tanggal' => Carbon::now()->subDays(25),
                'deskripsi' => 'Isi bensin motor',
                'jumlah_pengeluaran' => 50000
            ],
            [
                'tanggal' => Carbon::now()->subDays(22),
                'deskripsi' => 'Makan di restoran',
                'jumlah_pengeluaran' => 120000
            ],
            [
                'tanggal' => Carbon::now()->subDays(20),
                'deskripsi' => 'Bayar internet',
                'jumlah_pengeluaran' => 300000
            ],
            [
                'tanggal' => Carbon::now()->subDays(18),
                'deskripsi' => 'Beli obat di apotek',
                'jumlah_pengeluaran' => 75000
            ],
            [
                'tanggal' => Carbon::now()->subDays(15),
                'deskripsi' => 'Belanja di supermarket',
                'jumlah_pengeluaran' => 180000
            ],
            [
                'tanggal' => Carbon::now()->subDays(12),
                'deskripsi' => 'Bayar asuransi kesehatan',
                'jumlah_pengeluaran' => 200000
            ],
            [
                'tanggal' => Carbon::now()->subDays(10),
                'deskripsi' => 'Service kendaraan',
                'jumlah_pengeluaran' => 350000
            ],
            [
                'tanggal' => Carbon::now()->subDays(8),
                'deskripsi' => 'Belanja pakaian',
                'jumlah_pengeluaran' => 450000
            ],
            [
                'tanggal' => Carbon::now()->subDays(5),
                'deskripsi' => 'Bayar tagihan air',
                'jumlah_pengeluaran' => 85000
            ],
            [
                'tanggal' => Carbon::now()->subDays(3),
                'deskripsi' => 'Beli buku dan alat tulis',
                'jumlah_pengeluaran' => 95000
            ],
            [
                'tanggal' => Carbon::now()->subDays(1),
                'deskripsi' => 'Makan siang di kantor',
                'jumlah_pengeluaran' => 25000
            ],
            [
                'tanggal' => Carbon::now(),
                'deskripsi' => 'Transport online',
                'jumlah_pengeluaran' => 35000
            ],
            // Data bulan sebelumnya
            [
                'tanggal' => Carbon::now()->subMonth()->subDays(10),
                'deskripsi' => 'Bayar tagihan telepon',
                'jumlah_pengeluaran' => 100000
            ],
            [
                'tanggal' => Carbon::now()->subMonth()->subDays(15),
                'deskripsi' => 'Belanja bulanan di pasar',
                'jumlah_pengeluaran' => 500000
            ],
            [
                'tanggal' => Carbon::now()->subMonth()->subDays(20),
                'deskripsi' => 'Bayar sewa rumah',
                'jumlah_pengeluaran' => 2000000
            ],
            // Data tahun lalu
            [
                'tanggal' => Carbon::now()->subYear()->addDays(5),
                'deskripsi' => 'Liburan keluarga',
                'jumlah_pengeluaran' => 1500000
            ],
            [
                'tanggal' => Carbon::now()->subYear()->addDays(10),
                'deskripsi' => 'Beli laptop baru',
                'jumlah_pengeluaran' => 8000000
            ],
            [
                'tanggal' => Carbon::now()->subYear()->addDays(20),
                'deskripsi' => 'Renovasi rumah',
                'jumlah_pengeluaran' => 5000000
            ]
        ];

        foreach ($pengeluarans as $pengeluaran) {
            Pengeluaran::create($pengeluaran);
        }

        // Generate random data untuk testing
        for ($i = 0; $i < 20; $i++) {
            $deskripsiRandom = [
                'Belanja kebutuhan sehari-hari',
                'Isi bensin kendaraan',
                'Makan di warung',
                'Bayar parkir',
                'Beli snack',
                'Transport umum',
                'Fotocopy dokumen',
                'Beli air mineral',
                'Bayar tol',
                'Beli pulsa',
                'Cuci kendaraan',
                'Beli kopi',
                'Bayar ojek online',
                'Belanja online',
                'Beli peralatan rumah',
            ];

            Pengeluaran::create([
                'tanggal' => Carbon::now()->subDays(rand(1, 365)),
                'deskripsi' => $deskripsiRandom[array_rand($deskripsiRandom)],
                'jumlah_pengeluaran' => rand(10000, 500000)
            ]);
        }
    }
}