<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\MsService;

class MsServicesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $services = [
            // Food Category
            [
                'name' => 'Nasi Goreng Special',
                'category' => 'Food',
                'description' => 'Nasi goreng dengan telur, ayam, dan sayuran',
                'price' => 35000,
                'is_active' => true
            ],
            [
                'name' => 'Mie Ayam',
                'category' => 'Food',
                'description' => 'Mie ayam dengan bakso dan pangsit',
                'price' => 25000,
                'is_active' => true
            ],
            [
                'name' => 'Gado-gado',
                'category' => 'Food',
                'description' => 'Sayuran segar dengan bumbu kacang',
                'price' => 20000,
                'is_active' => true
            ],
            [
                'name' => 'Sate Ayam',
                'category' => 'Food',
                'description' => 'Sate ayam dengan bumbu kacang dan lontong',
                'price' => 30000,
                'is_active' => true
            ],
            [
                'name' => 'Rendang Daging',
                'category' => 'Food',
                'description' => 'Rendang daging sapi dengan nasi putih',
                'price' => 45000,
                'is_active' => true
            ],

            // Beverage Category
            [
                'name' => 'Es Teh Manis',
                'category' => 'Beverage',
                'description' => 'Teh manis dingin segar',
                'price' => 8000,
                'is_active' => true
            ],
            [
                'name' => 'Es Jeruk',
                'category' => 'Beverage',
                'description' => 'Jus jeruk segar dengan es',
                'price' => 12000,
                'is_active' => true
            ],
            [
                'name' => 'Kopi Hitam',
                'category' => 'Beverage',
                'description' => 'Kopi hitam tanpa gula',
                'price' => 10000,
                'is_active' => true
            ],
            [
                'name' => 'Cappuccino',
                'category' => 'Beverage',
                'description' => 'Kopi dengan susu dan foam',
                'price' => 18000,
                'is_active' => true
            ],
            [
                'name' => 'Jus Alpukat',
                'category' => 'Beverage',
                'description' => 'Jus alpukat segar dengan susu',
                'price' => 15000,
                'is_active' => true
            ],
            [
                'name' => 'Air Mineral',
                'category' => 'Beverage',
                'description' => 'Air mineral kemasan 600ml',
                'price' => 5000,
                'is_active' => true
            ],

            // Laundry Category
            [
                'name' => 'Cuci Setrika Reguler',
                'category' => 'Laundry',
                'description' => 'Layanan cuci dan setrika reguler per kg',
                'price' => 8000,
                'is_active' => true
            ],
            [
                'name' => 'Cuci Setrika Express',
                'category' => 'Laundry',
                'description' => 'Layanan cuci dan setrika cepat per kg (6 jam)',
                'price' => 12000,
                'is_active' => true
            ],
            [
                'name' => 'Dry Cleaning',
                'category' => 'Laundry',
                'description' => 'Layanan dry cleaning untuk pakaian formal',
                'price' => 25000,
                'is_active' => true
            ],

            // Spa Category
            [
                'name' => 'Massage Relaxation',
                'category' => 'Spa',
                'description' => 'Pijat relaksasi 60 menit',
                'price' => 150000,
                'is_active' => true
            ],
            [
                'name' => 'Facial Treatment',
                'category' => 'Spa',
                'description' => 'Perawatan wajah basic 45 menit',
                'price' => 120000,
                'is_active' => true
            ],
            [
                'name' => 'Body Scrub',
                'category' => 'Spa',
                'description' => 'Lulur tubuh dengan bahan alami',
                'price' => 100000,
                'is_active' => true
            ],

            // Transport Category
            [
                'name' => 'Airport Transfer',
                'category' => 'Transport',
                'description' => 'Antar jemput ke bandara dengan mobil',
                'price' => 200000,
                'is_active' => true
            ],
            [
                'name' => 'City Tour',
                'category' => 'Transport',
                'description' => 'Tour keliling kota 4 jam dengan guide',
                'price' => 350000,
                'is_active' => true
            ],
            [
                'name' => 'Rental Motor',
                'category' => 'Transport',
                'description' => 'Sewa motor per hari (termasuk bensin)',
                'price' => 75000,
                'is_active' => true
            ],

            // Other Category
            [
                'name' => 'Meeting Room',
                'category' => 'Other',
                'description' => 'Sewa ruang meeting per jam (kapasitas 10 orang)',
                'price' => 100000,
                'is_active' => true
            ],
            [
                'name' => 'WiFi Premium',
                'category' => 'Other',
                'description' => 'Akses internet premium high speed per hari',
                'price' => 25000,
                'is_active' => true
            ],
            [
                'name' => 'Extra Towel',
                'category' => 'Other',
                'description' => 'Handuk tambahan untuk kamar',
                'price' => 15000,
                'is_active' => true
            ]
        ];

        foreach ($services as $service) {
            MsService::create($service);
        }
    }
}