<?php
// database/seeders/ActivityLogSeeder.php - Sample data seeder

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ActivityLog;
use App\Models\User;
use Carbon\Carbon;

class ActivityLogSeeder extends Seeder
{
    public function run()
    {
        $users = User::all();
        $activities = [
            'Login', 'Logout', 'Create SKPT', 'Edit SKPT', 'Delete Data',
            'Approve Document', 'Upload Document', 'Print Document', 'Create User'
        ];
        
        $modules = [
            'Authentication', 'SKPT', 'Approval', 'Document Management', 'User Management', 'Master Data'
        ];
        
        $statuses = ['Berhasil', 'Gagal', 'Peringatan'];
        $descriptions = [
            'User berhasil login ke sistem',
            'Membuat permohonan SKPT baru dengan NIK 1234567890123456',
            'Mengedit data SKPT dengan NIK 1234567890123456',
            'Menghapus data KTRW dengan ID RTW001',
            'Menyetujui persetujuan SKPT dengan nomor SKPT/2024/001',
            'Mengupload dokumen pendukung untuk permohonan SP-MPT',
            'Percobaan login gagal - password salah',
            'Mencetak dokumen SKPT dengan nomor SKPT/2024/001',
            'Membuat user baru dengan role Staff Kecamatan'
        ];
        
        // Generate sample data for the last 30 days
        for ($i = 0; $i < 500; $i++) {
            $user = $users->random();
            $activity = $activities[array_rand($activities)];
            $module = $modules[array_rand($modules)];
            $status = $statuses[array_rand($statuses)];
            $description = $descriptions[array_rand($descriptions)];
            
            ActivityLog::create([
                'waktu' => Carbon::now()->subDays(rand(0, 30))->subHours(rand(0, 23))->subMinutes(rand(0, 59)),
                'user_name' => $user->name,
                'user_role' => 'User',
                'aktivitas' => $activity,
                'deskripsi' => $description,
                'module' => $module,
                'status' => $status,
                'ip_address' => '192.168.1.' . rand(100, 250),
                'user_id' => $user->id,
                'browser' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36',
                'device' => ['Desktop', 'Mobile', 'Tablet'][array_rand(['Desktop', 'Mobile', 'Tablet'])],
                'additional_data' => $activity === 'Create SKPT' ? ['nik' => '1234567890123456'] : null,
            ]);
        }
        
        $this->command->info('Activity logs seeded successfully!');
    }
}