<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('skpt_anak', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('skpt_id');
            $table->string('nama_anak', 255);
            $table->integer('usia')->nullable();
            $table->timestamps();
            $table->foreign('skpt_id')->references('id')->on('skpt_applications')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('skpt_anak');
    }
};
