<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Create coordinates table
        Schema::create('sp_sipt_coordinates', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sp_sipt_id')->constrained('sp_sipt')->onDelete('cascade');
            $table->integer('point_order')->default(0); // Order of the point in polygon
            $table->decimal('latitude', 10, 8);
            $table->decimal('longitude', 11, 8);
            $table->timestamps();
            
            // Index for faster queries
            $table->index(['sp_sipt_id', 'point_order']);
        });

        // Add polygon-related fields to sp_sipt table if not exists
        Schema::table('sp_sipt', function (Blueprint $table) {
            if (!Schema::hasColumn('sp_sipt', 'luas_terukur')) {
                $table->decimal('luas_terukur', 15, 2)->nullable()->after('polygon_coordinates')
                    ->comment('Luas area terukur dalam m²');
            }
            
            if (!Schema::hasColumn('sp_sipt', 'map_image')) {
                $table->text('map_image')->nullable()->after('luas_terukur')
                    ->comment('Base64 encoded map image or path');
            }
            
            if (!Schema::hasColumn('sp_sipt', 'polygon_bounds')) {
                $table->json('polygon_bounds')->nullable()->after('map_image')
                    ->comment('Polygon boundary box');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sp_sipt_coordinates');
        
        Schema::table('sp_sipt', function (Blueprint $table) {
            $table->dropColumn(['luas_terukur', 'map_image', 'polygon_bounds']);
        });
    }
};