<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('activity_logs', function (Blueprint $table) {
            $table->id();
            $table->timestamp('waktu')->useCurrent(); // Waktu aktivitas
            $table->string('user_name'); // Nama user
            $table->string('user_role'); // Role user (Administrator, Staff, Guest, dll)
            $table->string('aktivitas'); // Jenis aktivitas
            $table->text('deskripsi'); // Deskripsi detail aktivitas
            $table->string('module'); // Module yang digunakan
            $table->enum('status', ['Berhasil', 'Gagal', 'Peringatan'])->default('Berhasil'); // Status aktivitas
            $table->ipAddress('ip_address'); // IP Address user
            $table->unsignedBigInteger('user_id')->nullable(); // Foreign key ke tabel users
            $table->string('browser')->nullable(); // Info browser
            $table->string('device')->nullable(); // Info device
            $table->json('additional_data')->nullable(); // Data tambahan dalam format JSON
            $table->timestamps();
            
            // Index untuk optimasi query
            $table->index(['waktu']);
            $table->index(['user_id']);
            $table->index(['aktivitas']);
            $table->index(['module']);
            $table->index(['status']);
            $table->index(['ip_address']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('activity_logs');
    }
};
