<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('rtrw', function (Blueprint $table) {
            //
            $table->json('geojson')->nullable()->change(); // Pastikan kolom geojson ada dan tipe json
            $table->string('geojson_file')->nullable()->after('geojson'); // Tambahkan kolom untuk nama file
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('rtrw', function (Blueprint $table) {
            $table->dropColumn('geojson_file');
            $table->text('geojson')->nullable()->change(); // Kembali ke tipe text jika perlu rollback
        });
    }
};
