<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('kampung', function (Blueprint $table) {
            $table->id();
            $table->string('kode_kampung')->unique(); // Kode Kampung
            $table->string('nama_kampung'); // Nama Kampung
            $table->unsignedBigInteger('kecamatan_id'); // Foreign key ke tabel kecamatan
            $table->string('alamat_kantor_kampung'); // Alamat Lengkap Kantor Kampung
            $table->string('kode_pos'); // Kode Pos
            $table->string('nama_kepala_kampung'); // Nama Kepala Kampung
            $table->string('nip')->nullable(); // NIP (bisa null jika belum diisi)
            $table->string('golongan')->nullable(); // Golongan
            $table->string('pangkat')->nullable(); // Pangkat
            $table->float('luas_wilayah', 8, 2)->default(0.00); // Luas Wilayah (km²)
            $table->integer('jumlah_rt')->default(0); // Jumlah RT
            $table->integer('jumlah_rw')->default(0); // Jumlah RW
            $table->integer('jumlah_penduduk')->default(0); // Jumlah Penduduk
            $table->enum('status', ['Aktif', 'Nonaktif'])->default('Aktif'); // Status
            $table->string('warna')->default('#000000'); // Warna
            $table->json('geojson')->nullable(); // GeoJSON (file opsional)
            $table->timestamps();

            // Foreign key constraint
            $table->foreign('kecamatan_id')->references('id')->on('kecamatan')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('kampung');
    }
};
