<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('peninjauan_documents', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('peninjauan_id');
            $table->string('document_type'); // photo_dokumentasi, kwitansi, etc
            $table->string('file_name');
            $table->string('file_path');
            $table->string('file_size');
            $table->string('file_extension', 10);
            $table->text('description')->nullable();
            $table->timestamps();
            
            // $table->foreign('peninjauan_id')->references('id')->on('peninjauan')->onDelete('cascade');
            $table->index(['peninjauan_id', 'document_type']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('peninjauan_documents');
    }
};
