<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('peninjauan_coordinates', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('peninjauan_id');
            $table->integer('point_number');
            $table->decimal('latitude', 10, 8);
            $table->decimal('longitude', 11, 8);
            $table->integer('sequence');
            $table->timestamps();
            
            // $table->foreign('peninjauan_id')->references('id')->on('peninjauan')->onDelete('cascade');
            $table->index(['peninjauan_id', 'sequence']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('peninjauan_coordinates');
    }
};
